@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>

.dropdown-toggle .clear{
  display: none;
}
</style>
@stop
@section('content')
@include("layouts.Cmodal")

<div class="row" >
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul> 
            </div>
        @endif 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.BillReturns') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => ['billReturn.update',$returnBack->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'purchase-form'])}}

                {{ csrf_field() }}

                    <div class="form-body">
                      <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                          <!-- begin inputs -->
                          <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Vendor')</label>
                                      <input type="text" class="form-control" value="{{$returnBack->vendor}}" disabled>
                                      <input type="hidden" name="vendor_id" value="{{$returnBack->member_id}}">
                                  </div>
                              </div> 
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  <div class="col-md-12">
                                  <label class="control-label col-md-12"><br></label>
                                      <input type="text" value="{{$returnBack->purchases_date}}"  name="date"  class="form-control date" autocomplete="off" readonly>
                                       
                                  </div>
                              </div> 
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.BillNumber')</label>
        
                                       <input type="number" name="number" value="{{$returnBack->purchase_number}}" class="form-control" readonly>
                                  </div>
                              </div> 
                            </div>
                          
                          </div>

                        <div class="row">
                          
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Currency')</label>
        
                                    
                                      <v-select  label="code" @input="selectedRate" :options="currency" v-model="selected_currency" disabled></v-select>
                                      <input type="hidden" name="currency" :value="selected_currency.code">

                                  </div>
                              </div> 
                          </div>

                           <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Rate')</label>
        
                                       <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}" readonly>
                                  </div>
                              </div> 
                          </div>
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                               <div class="form-group">
                                    <div class="col-md-12">
                                      <label class="control-label">@lang('layout.Description')</label>
                                          <textarea  name="description" class="form-control" rows="1" readonly>{{$returnBack->purchase_description}}</textarea>
                                    </div>
                                </div> 
                          </div>
                        </div> 
                        <div class="row"> 
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                      <label class="control-label">@lang('layout.Description')</label> 
                                          <textarea  name="reDescription" class="form-control" rows="1">{{$returnBack->description}}</textarea>
                                    </div>
                                </div> 
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                      <label class="control-label">@lang('layout.ReturnDate')</label> 
                                      <input type="text" name="returnDate"  class="form-control date" value="{{$returnBack->date}}" autocomplete="off">
                                           
                                    </div>
                                </div> 
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                      <label class="control-label">@lang('layout.ReturnNo')</label> 
                                      <input type="number" name="returnNo" value="{{$returnBack->number}}"  class="form-control">
                                           
                                    </div>
                                </div> 
                            </div>
                            
                        </div>
                          <!-- end inputs -->
                      </div>
                       <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                        <!-- begin total -->
                           <div class="dashboard-stat2 ">
                            <table class="dashboard-tabel" width="100%">
                              <tr>
                                  <td>
                                      <small>@lang('layout.Total') :</small>
                                  </td>
                                  <td class="text-right"><span data-counter="counterup"
                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                     <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                 </td>
                             </tr>

                             <tr>
                              <td>
                                  <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)</small>
                              </td>
                              <td class="text-right">
                               <span class="text-right" data-counter="counterup"
                               data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                               <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                           </td>
                       </tr>

                       <tr>
                          <td>
                              <small>@lang('layout.Payment'):</small>
                          </td>
                          <td class="text-right">
                              <small class="font-green-sharp">
                                  <span class="text-right" data-counter="counterup"
                                  data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                              </small>
                          </td>
                      </tr>


                      <tr>
                          <td>
                              <small>@lang('layout.Sub-Total'):</small>
                          </td>
                          <td class="text-right">
                              <span class="text-right" data-counter="counterup"
                              data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                              <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                          </td>
                      </tr> 
                  </table>

                           </div>

                        <!-- end total -->
                       </div>

                      </div>

                     <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                         <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                          <thead>
                              <tr>
                                  <th>#</th>
                                  <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                  <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                  <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                  <th style="min-width: 50px">@lang('layout.Quantity') </th>
                                  <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1')</th>
                                  <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2')</th>
                                  <th style="min-width: 50px">@lang('layout.OnHand') </th>
                                  <th style="min-width: 100px">@lang('layout.Measure') </th>
                                  <th style="min-width: 50px">@lang('layout.NewCost') </th>
                                  <th style="min-width: 50px">@lang('layout.Total') </th>
                                  <th></th>
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(item,index) in inventories">
                                  <td>@{{index+1}}</td>
                                  <td class="highlight">
                                      <v-select label="name" v-model="item.item" :options="temp_items"  @search="onItemSearch"></v-select>
                                      <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                      <input type="hidden" name="PurchaseInfoId[]" :value="(!item.item)?null:item.item.PurchaseInfoId">
                                  </td>
                                   <td class="highlight">
                                      <select v-model="(item.item==null)?null:item.item.site" class="form-control" disabled> 
                                         <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site" >
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                      </select>
                                     
                                      <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                  </td>
                                 <td v-show="showWhat('sale_description')=='yes'">
                                     <input type="text" v-model="(item.item==null)?null:item.item.description" placeholder="@lang('layout.Description')" name="inventory_description[]"
                                     oninput = "autowidths(event)"
                                     class="form-control chan_length">
                                  </td>
                                   <td>
                                     <input type="number" name="quantity[]" v-model.number="(item.item==null)?null:item.item.quantity"
                                     oninput = "autowidths(event)" class="form-control input-style input-number chan_length"  placeholder="@lang('layout.Quantity')">
                                  </td>
                                  <td v-show="showWhat('other_measure')=='yes'">
                                    <div class="input-group"> 
                                      <input type="number" name="other_measure_amount[]" v-model.number="(item.item==null)?null:item.item.other_measure" oninput = "autowidths(event)"
                                      class="form-control input-style input-number chan_length"  placeholder="@lang('layout.OMeasureValue1')">
                                      <span class="input-group-addon">
                                        @{{(item.item==null)?null:item.item.other_measure}}
                                      </span>
                                    </div>
                                 </td>
                                 <td v-show="showWhat('other_measure2')=='yes'">
                                   <div class="input-group"> 
                                    <input type="number" name="other_measure_amount2[]" v-model.number="(item.item==null)?null:item.item.other_measure2"
                                    oninput = "autowidths(event)" class="form-control input-style input-number chan_length"  placeholder="@lang('layout.OMeasureValue2')">
                                      <span class="input-group-addon">
                                        @{{(item.item==null)?null:item.item.other_measure2}}
                                      </span>
                                    </div>
                                  </td>

                                  <td>
                                  <!--    <input type="text" :value="(item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                     @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,0,item.item.quantity))}}
                                  </td>
                                  <td class="highlight">
                                      <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                          <option value="null">@lang('layout.Select')</option>
                                          <span v-if="(item.item ==null)?false:true">
                                              <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                      </select>
                                     
                                      <input type="hidden" name="measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                  </td>
                                  <td>
                                    <div class="input-group">
                                      <input type="number" name="inventory_price[]"  placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate(index)"
                                      oninput = "autowidths(event)" class="form-control chan_length">
                                      <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                     
                                  </td>
                                  <td>
                                     <div>
                                         <div class="input-group">
                                            <input type="number" class="form-control inner_input chan_length" oninput = "autowidths(event)" :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate).result" placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon" >
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                         </div>
                                     </div>
                                  </td>
                                  <td>
                                       <span  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                  </td>
                              </tr>
                          </tbody>
                      </table>
                     <hr>
                     <!-- begin payments -->
                     <table style="display: none;" id="table_content" class="table table-striped table-bordered table-advance table-hover">
                          <thead>
                              <tr>
                                  <th class="text-center" style="min-width: 8px;"> # </th>
                                  <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                  <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
                                  <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                  <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                   <th class="text-center" style="min-width: 60px;"> @lang('layout.OldAmount')</th>
                                  <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
                                  <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                  <th></th>
                            
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(payment,index) in payments">
                                  <td>@{{index+1}}</td>
                                  <td class="highlight">
                                      <v-select label="name" v-model="payment.item"  :options="(payment.items)"   @input="checkExistingPayment(index)">
                                        
                                      </v-select>
                                      <input type="hidden" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                                  </td>
                              
                                 <td>
                                 
                                      <span v-if="payment.item !=null">
                                         @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                      </span>
                                 </td>
                                 <td>
                                     <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number"   v-model.number="(payment.item==null)?null:payment.item.rate "
                                      class="form-control"
                                      placeholder="@lang('layout.Rate')" required/>
                                      <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                      v-bind:value="payment.item.rate">
                                 </td>
                                 <td>
                                     <input type="text" name="payment_currency[]" class="form-control"
                                      v-model="(payment.item==null)?null:payment.item.code"
                                      placeholder="@lang('layout.Currency')" required disabled/>

                                      <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                      v-bind:value="payment.item.code"/>
                                 </td>
                                  <td>
                                    <div class="input-group">
                                      <input type="number" class="form-control"
                                      v-model.number="(payment.item==null)?null:payment.item.old_amount"
                                      placeholder="999" readonly />


                                  </div>
                                 </td>
                                 <td>
                                    <div class="input-group">
                                      <input type="number" class="form-control"
                                      v-model.number="(payment.item==null)?null:payment.item.amount "
                                      placeholder="@lang('layout.PayAmount')" required/>

                                      <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                      v-bind:value="payment.item.amount">

                                      <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                  </div>
                                 </td>
                                 <td>
                                     <div class="input-group">
                                      <input type="number" class="form-control"
                                      :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate)"
                                      placeholder="@lang('layout.Total')" style="min-width: 100px" required />
                                      <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                  </div>
                                 </td>
                                  <td>
                                       <span  v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                  </td>
                              </tr>
                          </tbody>
                      </table>
                     <!-- end payments -->
                     </div> 
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" v-if="!isError" @click="submitForm" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">
                  
                </cmodal>
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">
Vue.use(VueInputAutowidth);
  Vue.component('v-select', VueSelect.VueSelect);
  Vue.component("cmodal",{
    template:'#cmodal-template',

    props: ['show'],
    data(){
        return {
            types: [],
            receivables: [],
            payables: [],
            code: null,
            selectType: null,
            selectPay: null,
            selectReceive: null,
            classes:[],
            selectedClass: null,

        }
    },
    created(){
      
      axios.get('{{route("customer.create")}}').then(
        response=>{
          this.types = response.data.types;
          if(this.types)
          {
            for(var i=0;i<this.types.length;i++)
            {
              if(this.types[i].type=="Vendor")
              {
                 this.selectType=this.types[i];
              }
            }
          }
          this.receivables = response.data.receivable;
          this.payables = response.data.payable;
          this.code = response.data.code;
           this.classes = response.data.member_class;

        }).catch(error=> console.log(error));
    },
    methods:{
      onSubmit(){

        v.showModal = false;
        //this.member.type = this.member.type.id;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers:{'X-CSRF-TOKEN':"{{csrf_token()}}"},
          url:'{{route("customer.store")}}',
          method:'post',
          data: {"name":datas[0]['value'],'email':datas[1]['value'],'phone':datas[2]['value'],'address1':datas[3]['value'],'type':this.selectType.id,'receivable':this.selectReceive.id,'payable':this.selectPay.id,'class':(this.selectedClass)?this.selectedClass.id:null},
          dataType: 'json',

        }).done(function(response){
          axios.get('{{route("bill.create")}}').then(response=>{
            
            v.vendor =response.data.customer;
            document.getElementById("modalForm").reset();

          }).catch(error=> console.log(error));

        }).fail(function(error){
          console.log('error',error);
        });
        
      }
    }
  });

  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var selectedBank = {!! $selectedBank !!}; 
  var returnBack={!! json_encode($returnBack) !!};
  var v = new Vue({
    el: '#app',
    data: {
       showModal: false,
       vendor: [],
       selected_vendor:{!! $selectedVendor !!},
       contract:[],
       selected_contract:null,
       banks:banks,
       selected_banks:selectedBank,
       currency:{!! $currency !!},
       selected_currency:{!! $selectedCurrency !!},
       selected_item:{!! $selectedItem !!},
       returnBack:returnBack,
       rate:0,
       inventory_quantity:[],
       discountFiled: 0,
       discountIsAmount:false,
       temp_items:[],
       totalAmountes: [],
       newCost:[
       null,
       null,
       null,
       null],
       inventories:[
       ],
        payments: [
        ],
    },


    computed:{
      selectedRate()
      {            
         this.rate= (this.selected_currency)?this.selected_currency.rate:0;
      },
        discount()
        {
          if(this.discountIsAmount){

              if(this.subtotal>0 && this.discountFiled) {
                  return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
              }else {
                  return 0;
              }
              }else {

                  return this.discountFiled
              }

          },

          // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item !=null)
                    {  

                        var quantity=this.inventories[i]['item']['quantity'];
                        var rate=this.inventories[i]['item']['rate'];
                        var new_rate=this.inventories[i]['item']['new_rate'];
                        var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.inventories[i]['item']['measure_unit'];
                        if(new_rate !=rate && quantity>0)
                        {
                           sum +=new_rate*quantity*this.selected_currency.rate;
                        }
                        else
                        {
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                        }
                        
                    }

                }
                // for (var i = 0; i < this.services.length; i++) {
                //     if (this.services[i].item)
                //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                // }
                return sum;
          },

          // check payed amount
          payeds: function ()
           {
              var sum = 0;
              for (var i = 0; i < this.payments.length; i++)
               {

                  if(this.payments[i].item !=null && this.payments[i].item)
                  {
                     if (this.payments[i].item !=null && this.payments[i]['item']['rate']>0)
                     {
                      //
                      sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']) ;
                    }
                  }
                }
                return sum;
            },

            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
                 for (var i = 0; i < this.inventories.length; i++)
                 {
                    if (this.inventories[i].item)
                    {
                     
                    } 
                 }
                 for(var x=0; x<this.inventories.length;x++)
                 {
                  if(this.inventories[x].item)
                  {
                    if(this.inventories[x]['item']['quantity'] > this.inventory_quantity[x])
                    {
                      //isError=true;
                    }
                  }

                 }
                return isError;
              

            },
    },
    mounted:function()
    {
      // initialize the selected item
      for(var i=0;i<this.selected_item.length;i++)
      {
        this.inventories.push({item:this.selected_item[i]});
        this.inventory_quantity.push(this.selected_item[i].quantity);

      }
      
      // initialize payments
      for(var k=0;k<this.selected_banks.length;k++)
      {
        var foundFlag=false;
        var tempBank=null;
        for(var j=0;j<this.banks.length;j++)
        {
            if(this.banks[j].id==this.selected_banks[k].Account_id)
            {
               foundFlag=true;
               tempBank=this.banks[j];
               tempBank.old_amount=this.selected_banks[k].Amount;
               //tempBank.amount=this.selected_banks[k].Amount;
               tempBank.rate=this.selected_banks[k].Rate;
            }
        }
        if(foundFlag)
        {

          this.payments.push({item:tempBank,items:this.banks});
        }

      }

      for(var w=1;w>this.selected_banks.length;w--)
      {
         this.payments.push({item:null,items:banks});
      }
      // end payment

      if(this.returnBack)
      {
         this.discountFiled=this.returnBack.discount; 
         if(this.returnBack.discount_type)
         {
            if(this.returnBack.discount_type=='percent')
            {
               this.discountIsAmount=false;
            }
            else
            {
               this.discountIsAmount=true;
            }
         } 
      }
    },
    methods:
    {
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       // detect member change and searh
       memberChange()
       {
           if(this.selected_vendor)
           {
            // get member contract
               // get member contract
            this.contract=[];
             axios.get("{{route('callMethod.search')}}",{
              params:{
                method_name:'member_contract',
                member_id:this.selected_vendor.id
              }
             })
             .then(function (response)
             {
               if(response.data.length>0)
               {
                  v.contract=response.data;
                  if(v.contract)
                  {
                    for(var m=0;m<v.contract.length;m++)
                    {

                      if(v.contract[m].id == purchaseContract.contract_id)
                      {
                       v.selected_contract = v.contract[m];
                      }
                    }
                  }

               }
             })
             .catch(function (error)
             {
                console.log(error);
             });
           }
       },
       // set new price
       setNewRate(index)
       {
           if(this.inventories[index].item){
            this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            }

       },
      // begin item search


       onItemSearch:_.debounce((search,loading) =>{
          loading(true);
          axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:"itemSearchPurchase",
              keyword:search,
            }
          })
          .then(function(response){
            v.temp_items = [];
            if(response.data.length >0)
            {
              v.temp_items = response.data;

            }
            loading(false);
          })
          .catch(function(error){
            console.log(error);
          })
       },getDebounceTime()),

       // end item search

       // contract search


      
       // end contract search

       // generic function for adding item to list
       addNew(type=null,index)
       {
          
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null});
                }
             }
             if(type=='payment')
             {
                if(this.payments[index+1]==undefined)
                {
                  this.checkExistingPayment(index,'');
                  this.payments.push({
                    items: this.banks,
                    item: null,
                });
                }
             }
          }
          
       },

       // in here you can check and decide to allow duplicate bank for payment or not
       checkExistingPayment(index=null,name='')
       {      
              var bank_temp=this.banks.slice();
              var bank_temp1=[];
              for(var i=0;i<this.payments.length;i++)
              {
                  if(this.payments[i].item !=null)
                  {
                      var fined=bank_temp.findIndex((item)=> item.name == this.payments[i].item.name);
                      if(fined !=-1)
                      {
                        var o=bank_temp.splice(bank_temp.findIndex((item)=>item.name == this.payments[i].item.name),1);
                      }
                  }
              }
              this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 


       },
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
              if(type=='payment')
             {
                this.payments.splice(index, 1);
             }
         }
          
       },
       // submit the form
       submitForm() 
       {

          if(this.isError==true) {
            alert('there is no item');
            return false;
          }
          swal({
                title:"@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    document.getElementById("purchase-form").submit()

                } else {

                }
            });

        },
    },
    created:function()
    {
         
    }

  });

</script>


@endpush