@extends('layouts.factor-master')

@section('content')
<table  class="main-table">
 @if($info && $info !=[])

 <tr>
  <td>
    <span>@lang('layout.BillNumber')</span>:&nbsp;&nbsp;
    <span>{{$info->number}}</span>
  </td>
  <td>
    <span>@lang('layout.Vendor')</span>:&nbsp;&nbsp;
    <span>{{$info->vendor}}</span>
  </td>

  <td>
    <span>@lang('layout.Amount')</span>:&nbsp;&nbsp;
    <span>{{$info->amount}}</span>
  </td>
  <td>
    <span>@lang('layout.Currency')</span>:&nbsp;&nbsp;
    <span>{{$info->currency}}</span>
  </td>
   <td>
    <span>@lang('layout.Rate')</span>:&nbsp;&nbsp;
    <span>{{$info->rate}}</span>
  </td>
  <td>
    <span>@lang('layout.Type')</span>:&nbsp;&nbsp;
    <span>{{$info->type}}</span>
  </td>
</tr>

@endif
</table>


<h3 class="table-caption" style="text-align: center;">@lang('layout.RefundInfo')</h3>
<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center" style="width: 5%;"><div > @lang('layout.Record') </div></td>
 <td class="center"  style="width: 20%;"><div > @lang('layout.ItemName')</div></td>
 <td class="center"  style="width: 10%;"><div > @lang('layout.Code')</div></td>
 <td class="center"  style="width: 10%;"><div > @lang('layout.Location')</div></td>
 <td class="center"  style="width: 10%;"><div > @lang('layout.Quantity')</div></td>
 <td class="center"  style="width: 10%;"><div > @lang('layout.Measure')</div></td>
 <td class="center"  style="width: 10%;"><div > @lang('layout.Price')</div></td>
 @if(getOtherMeasure()=="true")
<th style="width: 15%;">@lang('layout.OMeasureValue1')</th>
@endif
 @if(getOtherMeasure2()=="true")
<th style="width: 10%;">@lang('layout.OMeasureValue2')</th>
@endif 
 <td class="center" style="width: 10%;" ><div > @lang('layout.Total')</div></td>

</tr>
</thead>
<tbody>
<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
<td class="center">{{$record->itemName}}</td>
<td class="center">{{$record->code}}</td>
<td class="center">{{$record->location}}</td>
<td class="center">{{$record->qty}}</td>
<td class="center">{{$record->measure}}</td>
<td class="center">{{round($record->price,2)}}</td>
@if(getOtherMeasure()=="true")
<td class="center">{{$record->other_measure}}</td>
@endif
@if(getOtherMeasure2()=="true")
<td class="center">{{$record->other_measure2}}</td>
@endif
<td class="center">{{round($record->price*$record->qty,2)}}</td>

</tr>
@endforeach  
</tbody>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection