@extends('layouts.factor-master')

@section('content')




<h3 class="table-caption" style="text-align: center;">@lang('layout.ReturnsReport'): {{__('layout.'.$category)}}</h3>
<table class="main-table">
  <tr>
    @if($from_date)
    <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center"><div > @lang('layout.Record') </div></td>
 <td class="center"><div > @lang('layout.Number')</div></td>
 <td class="center"><div > @lang('layout.PurchaseNumber')</div></td>
 <td class="center"><div > @lang('layout.Date')</div></td>
 <td class="center"><div > @lang('layout.Description')</div></td>
 <td class="center"><div > @lang('layout.Vendor')</div></td>
 <td class="center"><div > @lang('layout.Currency')</div></td>
 <td class="center"><div > @lang('layout.Rate')</div></td>
 <td class="center"><div > @lang('layout.Amount')</div></td>
 <td class="center"><div > @lang('layout.User')</div></td>

</tr>
</thead>
<tbody>
<?php
$count = 0;
$totalBase = 0;
?>
@foreach($data AS $record)
<?php

  if(systemConfig()[30] == 1){
    $totalBase += ($record->amount / $record->static_rate * $record->rate);
  }else{
    $totalBase += ($record->amount / $record->rate);
  }

?>
<tr>
<td class="center">{{++$count}}</td>
<td class="center">{{$record->number}}</td>
<td class="center">{{$record->purchase_number}}</td>
<td class="center">{{convertDate($record->date)}}</td>
<td class="center" width="15%">{{$record->description}}</td>
<td class="center">{{$record->member_name}}</td>
<td class="center">{{$record->currency}}</td>
<td class="center">{{$record->rate}}</td>
<td class="center">{{$record->amount}}</td>
<td class="center">{{$record->user}}</td>

</tr>
@endforeach   
@if($totalBase)
<tr class="bg">
<td class="center" colspan="4">@lang('layout.Total')</td>
<td class="center" colspan="5">{{myRound($totalBase)}} {{getHomeCurrency()[getCurrencyType()]}} </td>
</tr>
@endif

</tbody>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection