@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>
.dropdown-toggle .clear{
	display: none;
}

</style>
@stop
@section('content') 

<div class="row" >
          @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul> 
            </div>
        @endif 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateWriteChecks') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->  
                {{Form::model($purchase,['route' => ['return.purchase',$purchase->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}


                    <div class="form-body">
                      <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                          <!-- begin inputs -->
                          <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Vendor')</label>
          							   <input type="text" disabled class="form-control" value="{{$purchaseInfo->vendor}}">                                        
                            <input type="hidden" name="vendor" value="{{$purchaseInfo->vendor_id}}" required>
                                  </div>
                              </div> 
                            </div> 
                           <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Currency')</label> 
                                      <input type="text" value="{{$purchaseInfo->currency}}" class="form-control" disabled>
                                      <input type="hidden" name="currency" :value="selected_currency.code">
                                  </div>
                              </div> 
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Rate')</label>
        
                                       <input type="number" name="currency_rate" readonly name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                  </div>
                              </div> 
                            </div>
                          </div>

                        <div class="row">
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                        <textarea disabled  class="form-control" rows="1">{{$purchase->description}}</textarea>
                                  </div>
                              </div> 
                          </div> 
                          

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Account')</label>
         							<input type="text" disabled class="form-control" value="{{$purchaseInfo->account}}" name="">
                                       <input type="hidden" name="bank_account" value="{{$purchaseInfo->Account_id}}">
                                  </div>
                              </div> 
                          </div>
                        
                        </div>

                        <div class="row"> 
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="form-group">
                                 
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.ReturnDate')</label>
                                       <input type="text" name="date"  class="form-control date">
                                  </div>
                                </div> 
                              </div>
                         
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" name="returnNo" class="form-control">
                                  </div>
                              </div> 
                          </div> 
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control" rows="1"></textarea> 
                                  </div>
                                  
                              </div> 
                          </div>
                        </div>
                        <div class="row">
                          
                        </div>
                          <!-- end inputs -->
                      </div>
                       <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                        <!-- begin total -->
                           <div class="dashboard-stat2 ">
                            <table class="dashboard-tabel" width="100%">
                              <tr>
                                  <td>
                                      <small>@lang('layout.Total') :</small>
                                  </td>
                                  <td class="text-right"><span data-counter="counterup"
                                     data-value="7800">@{{ Number.parseFloat((subtotal)-payeds).toFixed(precision())}}</span>
                                     <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                 </td>
                              </tr> 
                              <tr>
                                  <td>
                                      <small>@lang('layout.Sub-Total'):</small>
                                  </td>
                                  <td class="text-right">
                                      <span class="text-right" data-counter="counterup"
                                      data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                  </td>
                              </tr> 
                          </table>

                       </div>

                        <!-- end total -->
                       </div>

                      </div>

                     <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                         <table id="table_content" class="table table-bordered table-advance table-hover">
                          <thead>
                              <tr>
                                  <th>#</th>
                                  <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                  <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                  <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                  <th style="min-width: 100px">@lang('layout.OldQuantity') </th>
                                  <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                  <th v-show="showWhat('other_measure')=='yes'" style="min-width: 80px">@lang('layout.OMeasureValue') 1</th>
                                  <th v-show="showWhat('other_measure')=='yes'" style="min-width: 80px">@lang('layout.OMeasureValue') 2</th>
                                  <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                  <th style="min-width: 100px">@lang('layout.Measure') </th>
                                  <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                  <th style="min-width: 100px">@lang('layout.Total') </th>
                                  <th></th>
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(item,index) in inventories">
                                  <td>@{{index+1}}</td>
                                  <td class="highlight">
                                      <v-select label="name" v-model="item.item" :options="temp_items" ></v-select>
                                      <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                  </td>
                                   <td class="highlight">
                                      <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                         <option value="null">@lang('layout.Select')</option>
                                         <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                      </select>
                                     
                                      <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                  </td>
                                 <td v-show="showWhat('sale_description')=='yes'">
                                     <input type="text" v-model="(item.item==null)?null:item.item.description" placeholder="@lang('layout.Description')" name="inventory_description[]" class="form-control">
                                  </td>
                              
                                   <td>
                                     <input type="number" :value="(item.item==null)?null:item.item.old_quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
                                  </td>
                                  <td>
                                     <input type="number" name="quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
                                  </td>

                                   <td v-show="showWhat('other_measure')=='yes'">
                                     <input type="number" name="other_measure_amount[]"  class="form-control input-style input-number"  placeholder="@lang('layout.OMeasureValue') 1">
                                   </td>
                                   <td v-show="showWhat('other_measure')=='yes'">
                                     <input type="number" name="other_measure_amount2[]"  class="form-control input-style input-number"  placeholder="@lang('layout.OMeasureValue') 2">
                                   </td>

                                  <td>
                                  <!--    <input type="text" :value="(item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                     @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity)-Number(item.item.old_quantity))}}
                                  </td>
                                  <td class="highlight">
                                      <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                          <option value="null">@lang('layout.Select')</option>
                                          <span v-if="(item.item ==null)?false:true">
                                              <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                          
                                         
                                      </select>
                                     
                                      <input type="hidden" name="measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                  </td>
                                  <td>
                                    <div class="input-group">
                                      <input type="text" name="inventory_price[]"  placeholder="@lang('layout.Cost')"   :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate(index)" class="form-control">
                                      <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                     
                                  </td>
                                  <td>
                                     <div>
                                         <div class="input-group">
                                            <input type="number" class="form-control inner_input"   :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate)" placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon" >
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                         </div>
                                     </div>
                                  </td>
                                  <td>
                                       <span  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                  </td>
                              </tr>
                          </tbody>
                      </table>
                     <hr>
                    
                     </div>
                                        
                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" v-if="!isError" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">
                  
                </cmodal>
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">
  Vue.component('v-select', VueSelect.VueSelect);
  
  var vendor={!! $vendor !!};
  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var purchase={!! $purchase !!};
  var purchaseInfo = {!! $purchaseInfo !!};
  var v = new Vue({
    el: '#app',
    data: {
      showModal: false,
       vendor:{!! $vendor !!},
       selected_vendor:{!! $selectedVendor !!},
       banks:banks,
       selected_banks:null,
       currency:{!! $currency !!},
       selected_currency:{!! $selectedCurrency !!},
       selected_item:{!! $selectedItem !!},
       purchase:purchase,
       purchase_info:purchaseInfo,
       rate:0, 
       temp_items:[],
       inventory_quantity:[],
       totalAmountes: [],
       newCost:[
       null,
       null,
       null,
       null],
       inventories:[
       ],
        payments: [
        ],
    },


    computed:{
      selectedRate()
      {            
         this.rate= (this.selected_currency)?this.selected_currency.rate:0;
      },
        
          // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item !=null)
                    {  

                        var quantity=this.inventories[i]['item']['quantity'];
                        var rate=this.inventories[i]['item']['rate'];
                        var new_rate=this.inventories[i]['item']['new_rate'];
                        var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.inventories[i]['item']['measure_unit'];
                        if(new_rate !=rate && quantity>0)
                        {
                           sum +=new_rate*quantity*this.selected_currency.rate;
                        }
                        else
                        {
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                        }
                        
                    }

                }
                // for (var i = 0; i < this.services.length; i++) {
                //     if (this.services[i].item)
                //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                // }
                return sum;
          },

          // check payed amount
          payeds: function ()
           {
              var sum = 0;
              for (var i = 0; i < this.payments.length; i++)
               {

                  if(this.payments[i].item !=null && this.payments[i].item)
                  {
                     if (this.payments[i].item !=null && this.payments[i]['item']['rate']>0)
                     {
                      //
                      sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']) ;
                    }
                  }
                }
                return sum;
            },

            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
                 for (var i = 0; i < this.inventories.length; i++)
                 {
                    if (this.inventories[i].item)
                    {
                    
                      
                    } 
                 }
                 for(var x=0; x<this.inventories.length;x++)
                 {
                 	if(this.inventories[x].item)
                 	{
                 		if(this.inventories[x]['item']['quantity'] > this.inventory_quantity[x])
                 		{
                 			//isError=true;
                 		}
                 	}

                 }
                 
                return isError;
              

            },
            // filter the banks according to selected currency
            
    },
    mounted:function()
    {
      // initialize the selected item
      for(var i=0;i<this.selected_item.length;i++)
      {
        this.inventories.push({item:this.selected_item[i]});
        this.inventory_quantity.push(this.selected_item[i].quantity);
      }
      
      // initialize payments
   
      
  
      // end payment

    },
    methods:
    {
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       // detect member change and searh
       memberChange()
       {
           if(this.selected_vendor)
           {
            // get member contract
           }
       },
       // set new price
       setNewRate(index)
       {
           if(this.inventories[index].item){
            this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            }

       },
      // begin item search
       
       // end item search

     

       // generic function for adding item to list
       
       // in here you can check and decide to allow duplicate bank for payment or not
        
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
              if(type=='payment')
             {
                this.payments.splice(index, 1);
             }
         }
          
       },
       // submit the form
        
    },
     

  });

</script>


@endpush