@extends('layouts.app')

@section('content')

    <!-- END PAGE HEADER-->
    <div id="print-modal-bill">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'returnList'"
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="category" value="BillRoll"/>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.BillReturnList')</span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                    @permission('return-export')
                    <span id="bill-modal">
                                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                     </a>
                                 </span>
                    @endpermission

                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="bill_return">
                    <thead>
                        <tr>
                            <th>@lang('layout.PurchaseNumber')</th>
                            <th>@lang('layout.ReturnNo')</th>
                            <th>@lang('layout.Vendor')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY
<div id="factor-obj" >
    @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

    @endif
            </div> -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let bill_return;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            bill_return = $('#bill_return').DataTable({
                ajax: {
                    url: '{{route("returnRoll.index")}}',
                    data: function (d) {
                        d.type = 'Bill';
                    }
                },
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?1:6}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'purchase_number', name: 'purchase_number', searchable: false, orderable: false},
                    {data: 'number', name: 'return_backs.number'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'currency', name: 'return_backs.currency'},
                    {data: 'rate', name: 'currency', searchable: false, orderable: false},
                    {data: 'amount', name: 'amount', searchable: false, orderable: false},
                    {data: 'date', name: 'date'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'action', searchable: false, orderable: false},

                ]
            });

        });

        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });

        // for new modal

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal

        // for new modal bill return tub

        var vm1 = new Vue({
            el: '#print-modal-bill',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#bill-modal',
            methods: {
                showModal: function () {
                    console.log('bill modal')
                    vm1.$data.is_show = true;

                }
            }
        });
        // /for new modal

        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#appp',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {

                    this.member ={!!$member!!}
                        //Your other code that launches the modal
                        this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#print_pdf').on('click', function (e) {
            $('#show-modal1').click();
            e.preventDefault();
        })


        new Vue({
            el: '#app4',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample4: function () {
                    this.member ={!!$member!!}

                        //Your other code that launches the modal
                        this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#excell_all4').on('click', function (e) {
            $('#show-modal4').click();
            e.preventDefault();
        })


        new Vue({
            el: '#rr',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExamplerr: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#addNewRefundd').on('click', function (e) {
            $('#show-modalrr').click();
            e.preventDefault();
        })

        new Vue({
            el: '#ww',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExampleww: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#addNewRefundpp').on('click', function (e) {
            $('#show-modalww').click();
            e.preventDefault();
        })

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof bill_return == 'object') {
                        bill_return.clear();
                        bill_return.ajax.reload();
                    }
                }
            }
        });
    </script>


@endpush
