@extends('layouts.factor-master')

@section('content')
<table  class="main-table">
 @if($info && $info !=[])

 <tr>
  <td>
    <span>@lang('layout.BillNumber')</span>:&nbsp;&nbsp;
    <span>{{$info->number}}</span>
  </td>
  <td>
    <span>@lang('layout.Vendor')</span>:&nbsp;&nbsp;
    <span>{{$info->vendor}}</span>
  </td>

  <td>
    <span>@lang('layout.Amount')</span>:&nbsp;&nbsp;
    <span>{{$info->amount}}</span>
  </td>
  <td>
    <span>@lang('layout.Currency')</span>:&nbsp;&nbsp;
    <span>{{$info->currency}}</span>
  </td>
   <td>
    <span>@lang('layout.Rate')</span>:&nbsp;&nbsp;
    <span>{{$info->rate}}</span>
  </td>
  <td>
    <span>@lang('layout.Type')</span>:&nbsp;&nbsp;
    <span>{{$info->type}}</span>
  </td>
</tr>

@endif
</table>


<h3 class="table-caption" style="text-align: center;">@lang('layout.RefundInfo')</h3>
<table class="main-table">

<thead>
  <tr class="bg">
 <td><div class="center"> @lang('layout.Record') </div></td>
 <td><div class="center"> @lang('layout.ItemName')</div></td>
 <td><div class="center"> @lang('layout.Quantity')</div></td>
 <td><div class="center"> @lang('layout.Measure')</div></td>
 <td><div class="center"> @lang('layout.Price')</div></td>
 <td><div class="center"> @lang('layout.Total')</div></td>

</tr>
</thead>
<tbody>
<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
<td class="center">{{$record->itemName}}</td>
<td class="center">{{$record->qty}}</td>
<td class="center">{{$record->measure}}</td>
<td class="center">{{round($record->price,2)}}</td>
<td class="center">{{round($record->price*$record->qty,2)}}</td>

</tr>
@endforeach  
</tbody>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection