@extends('layouts.app')

@section('content')

    <div class="portlet" id="showAccount">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ReturnExpenseInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance ">
                    <tr style="background-color: rgb(80, 129, 141) !important;color: white;"> 
                        <th class="text-center">
                            <i class="fa  fa-bars"></i> @lang('layout.ExpenseNumber') 
                        </th> 
                        <th class="text-center">
                            <i class="fa  fa-bars"></i> @lang('layout.ReferenceNumber') 
                        </th> 
                        <th class="text-center">
                            <i class="fa  fa-bars"></i> @lang('layout.Type') 
                        </th>
                        <th class="text-center">
                            <i class="fa  fa-user"></i> @lang('layout.Vendor') 
                        </th>
                        <th class="text-center">
                            <i class="fa fa-briefcase"></i> @lang('layout.Account') 
                        </th>
                        
                        <th class="text-center">
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th> 
                        
                        <th class="text-center">
                            <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                        </th>
                        @if(systemConfig()[5] != 0 )
                        <th class="text-center">
                            <i class="fa  "></i> @lang('layout.Status')
                        </th> 
                        @endif 
                      
                        <th class="text-center">
                            <i ></i> @lang('layout.Description')
                        </th>
						
                    </tr>
                    <tr>  
                        <td class=""> {{ $expenseInfo->expense_number}}  </td>
                        <td class=""> {{ $expenseInfo->expense_ref}}  </td>
                        <td class=""> {{ $expenseInfo->type}}  </td>
                        <td class=""> {{ $expenseInfo->vendor}}  </td>
                        <td class=""> {{ $expenseInfo->account}}  </td>
                        <td class=""> {{convertDate($expenseInfo->date)}}  </td>
                        <td class=""> {{ $expenseInfo->hour}}  </td>
                        @if(systemConfig()[5] != 0 )
                        <td class=""> @if($expenseInfo->status){{__('type.'.$expenseInfo->status)}} @endif </td>
                        @endif
                         
                        <td class=""> 
                        <?php
                            $des = wordwrap($expenseInfo->description,80,"<br/>\n",false);
                            echo $des;
                        ?>
                        </td>
                    </tr>

                </table>
                <table class="table table-striped table-bordered table-advance ">
                    <tr style="background-color: rgb(80, 129, 141) !important; color: white;"> 
                        @if(systemConfig()[20] == 1)
                        <th class="text-center">@lang('menu.Contract')</th>
                        @endif
                        <th class="text-center"> <i class="fa  "></i> @lang('layout.Currency')</th>
                        <th class="text-center"><i class="fa  "></i> @lang('layout.Rate')</th>
						<th class="text-center"> <i class="fa  "></i> @lang('layout.Total')</th>
                        <th class="text-center"> <i class="fa  "></i> @lang('layout.Total') {{getHomeCurrency()["code"]}}</th>
                        @if($expenseInfo->type == 'BillExpense' && $total_payment)
                        <th class="text-center"> <i class="fa  "></i> @lang('layout.Recipt')</th>
                        <th class="text-center"> <i class="fa  "></i> @lang('layout.Remain')</th>
                        @endif
                        <th class="text-center"><i class=" fa fa-text-width"></i> @lang('layout.Memo')</th>
                    </tr>

                    <tr>
                        @if(systemConfig()[20] == 1)  
                        <td>{{ $expenseInfo->contract}}</td>
                        @endif
                        <td class=""> {{ $expenseInfo->currency}}  </td>
                        <td class=""> {{ $expenseInfo->rate}}  </td>
                        <td class=""> {{ myRound($expenseInfo->Total_currency)}} </td>
                        <td class=""> {{ myRound($expenseInfo->Total)}}</td>
                        @if($expenseInfo->type == 'BillExpense' && $total_payment)
                        <td class=""> {{ myRound($total_payment)}} </td>
                        <td class="" > {{ myRound($expenseInfo->Total_currency-$total_payment)}} </td>
                        @endif
                        <td class="" > {{ $expenseInfo->memo}} </td>

                    </tr>

                </table>
            </div>

        </div>
    </div>
    <div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.ReturnExpenseDetails') </span>
        </div>
        <div class="tools"></div>
            <div class="actions">
                {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="Return_Expense_Details"/>
                <input type="hidden" name="id" value="{{$expenseInfo->p_id}}"/> 
                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
            {{Form::close()}} 

                {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="Return_Expense_Details"/>
                <input type="hidden" name="id" value="{{$expenseInfo->p_id}}"/> 
                <button type="submit" class="btn btn-success" > <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
            {{Form::close()}}  
        </div>
    </div>
    <div class="portlet-body">  
         <div class="tabbable tabbable-tabdrop"> 
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.ReturnExpenseDetails')</a>
                </li>
                @if($expenseInfo->type == 'BillExpense' && $total_payment)
                <li class="">
                    <a href="#tab3" data-toggle="tab" id="tab_sale">@lang('layout.Payment')</a>
                </li>
                @endif
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
            <div class="tab-pane active" id="tab1">
                <div class="col-md-12">
                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                    <br>
                    <table class="table table-striped table-bordered table-hover" id="invoices">
                        <thead>
                        <tr>
                            <th>@lang('layout.Account') </th>
                            <th>@lang('layout.Type') </th>
                            <th>@lang('layout.Description') </th>
                            <th>@lang('layout.Amount') </th> 
                        </tr>
                        </thead>
                    </table>
                    <!-- END EXAMPLE TABLE PORTLET-->
                </div>

            </div>            
            @if($expenseInfo->type == 'BillExpense' && $total_payment)
            <div class="tab-pane" id="tab3">
                <div class="col-md-12">
                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                    <br>
                    <table class="table table-striped table-bordered table-hover" id="payment">
                        <thead>
                        <tr>
                            <th>@lang('layout.Account') </th>
                            <th>@lang('layout.Currency') </th>
                            <th>@lang('layout.Rate') </th>
                            <th>@lang('layout.Amount') </th> 
                        </tr>
                        </thead>
                    </table>
                    <!-- END EXAMPLE TABLE PORTLET-->
                </div>

            </div>
            @endif
             <div class="tab-pane" id="tab2"> 
                    <div class="tab-pane" id="tab2"> 
                    <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="portlet light bordered">
                        <div class="portlet-body">
                            <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="redirect_route" value="returnExpense.show">
                                <input type="hidden" name="foreign_data_id" value="{{$expenseInfo->p_id}}">
                                <input type="hidden" name="path" value="uploads/ReturnExpense">
                                <input type="hidden" name="table_name" value="return_expense">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                            <input type="text" name="title" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" rows="7" style="resize: none" class="form-control"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-6" style="margin-top: 5px;">
                                            <div class="form-group">
                                            <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                <div>
                                                    <span class="btn default btn-file">
                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                        <input type="hidden" value="" name=""><input type="file" name="photo"> </span>    
                                                    <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                </div>
                                                <div class="fileinput-new thumbnail" style="width: 100%; height: 146px;">
                                                    <img src="" alt=""> </div>
                                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 150px; line-height: 10px;"> </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="margin-top-10 text-center">
                                    <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                    <a href="{{route('expense.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                </div>
                            </form>
                        </div>
                    </div>
                    <table class="table table-striped table-bordered table-hover" id="attachment">
                        <thead>
                            <tr>  
                                <th>@lang('layout.AttachmentTitle')</th>
                                <th>@lang('layout.Description')</th>
                                <th>@lang('layout.Action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            </div>
            </div>
        </div>
        </div>
        </div>
    </div>
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#invoices').DataTable({
            // ajax:'{{route("expense.show",$expenseInfo->p_id)}}', 

             ajax:{
                url:'{{route("returnExpense.show",$expenseInfo->p_id)}}',
                data:{type:'expense'}
            },
            
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [  
                { data: 'account', name: 'account', orderable:false,searchable:false },
                { data: 'type', name: 'type', orderable:false,searchable:false },
                { data: 'description', name: 'expenses.description' },
                { data: 'amount', name: 'amount', orderable:false,searchable:false },
                  ]
        });       
        
         $('#payment').DataTable({
            // ajax:'{{route("expense.show",$expenseInfo->p_id)}}', 

             ajax:{
                url:'{{route("returnExpense.show",$expenseInfo->p_id)}}',
                data:{type:'payment'}
            },
            
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [  
                { data: 'account_name', name: 'account_name', orderable:false,searchable:false },
                { data: 'unit', name: 'unit', orderable:false,searchable:false },
                { data: 'rate', name: 'rate', orderable:false,searchable:false },
                { data: 'amount', name: 'amount', orderable:false,searchable:false }
                ]
        });

          $('#attachment').DataTable({
                ajax:{
                    url:'{{route("returnExpense.show",$expenseInfo->p_id)}}',
                    data:{type:'attachment'}
                  },
                
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    { data: 'title', name: 'attachments.title'},
                    { data: 'description', name: 'attachments.description'},
                    { data: 'actions',         name: 'actions', orderable:false,searchable:false},
            ]
        });



    });
</script>
<script>
    new Vue({
        el: '#showAccount',
        data:{
            
        }
    });
</script>


@endpush
