@extends('layouts.factor-master')

<style type="text/css">
  #expense{
    border: 2px solid black;
  }
</style>
@section('content')
<?php
$report = customeReport('expense');
$_number=in_array('number', $report);
$_date=in_array('date', $report);
$_description=in_array('description', $report);
$_amount=in_array('amount', $report);
$_currency=in_array('currency', $report);
$_account=in_array('account', $report);
$_vendor=in_array('vendor', $report);
$_category=in_array('category',$report);
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ReturnExpenseReport')</h3>
@if($from_date || $to_date)
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
@endif
@if($ClassName || $bank_account_name || $expense_ref)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif
      @if($bank_account_name)
      <td>
        <span>@lang('layout.BankAccount')</span>: {{$bank_account_name}}
      </td>
      @endif
      @if($expense_ref)
      <td>
        <span>@lang('layout.ReferenceNumber')</span>: {{$expense_ref}}
      </td>
      @endif
    </tr>
</table>
@endif

@foreach($data AS $data)
<div id="expense">
<table class="main-table">
<thead>
  <tr class="bg" >

 <td class="center" style="font-weight: bold;"><div > @lang('layout.Number')</div></td>
 @if(!$expense_ref)<td class="center" style="font-weight: bold;"><div > @lang('layout.ReferenceNumber') </div></td> @endif
 <td class="center" style="font-weight: bold;"><div > @lang('layout.Type')</div></td>
 <td class="center" style="font-weight: bold;"><div > @lang('layout.Account')</div></td>
 <td class="center" style="font-weight: bold;"><div > @lang('layout.Total')</div></td> 
 <td class="center" style="font-weight: bold;"><div > @lang('layout.Rate')</div></td>
 <td class="center" style="font-weight: bold;"><div > @lang('layout.Vendor')</div></td> 
 <td class="center" style="font-weight: bold;"><div > @lang('layout.Date')</div></td>
 <td class="center" style="font-weight: bold;"><div > @lang('layout.User')</div></td>

</tr>
</thead>


<tr>

<td  class="center">{{$data['number']}}</td>
@if(!$expense_ref)<td class="center">{{$data['expense_ref']}}</td> @endif
<td  class="center">{{__('type.' . $data['type'])}}</td>
<td  class="center">{{$data['account']}}</td>
<td  class="center">{{$data['amount']}} {{$data['currency']}}</td>
<td  class="center">{{$data['rate']}}</td>
<td  class="center">{{$data['vendor']}}</td>
<td  class="center">{{convertDate($data['date'])}}</td>
<td  class="center">{{$data['user']}}</td>

</tr>
@if($data['description'])
<tr>

  <td  colspan="8">{{$data['description']}}</td>

</tr>
@endif
</table>
<br>

  <table class="main-table">
    <thead>
      <tr >
     <td class="center" style="font-weight: bold"><div > @lang('layout.Description')</div></td>
     <td class="center" style="font-weight: bold"><div > @lang('layout.Account')</div></td>
     <td class="center" style="font-weight: bold"><div > @lang('layout.Amount')</div></td> 




    </tr>
    </thead>
    @foreach($data['expense_details'] as $details)
    <tr>
      <td  class="center">{{$details['description']}}</td>
      <td  class="center">{{$details['account']}}</td>
      <td  class="center">{{$details['amount']}}</td>
    </tr>
    @endforeach
  </table>
  </div>
<br>
@endforeach


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection 