@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('expense');
$_number=in_array('number', $report);
$_date=in_array('date', $report);
$_description=in_array('description', $report);
$_amount=in_array('amount', $report);
$_currency=in_array('currency', $report);
$_account=in_array('account', $report);
$_vendor=in_array('vendor', $report);
$_category=in_array('category',$report);
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ReturnExpenseReport')</h3>
@if($from_date || $to_date)
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
@endif

@if($ClassName || $expense_account_name || $bank_account_name || $expense_category_name)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif
      @if($expense_account_name)
      <td>
        <span>@lang('layout.ExpenseAccount')</span>: {{$expense_account_name}}
      </td>
      @endif
      @if($bank_account_name)
      <td>
        <span>@lang('layout.BankAccount')</span>: {{$bank_account_name}}
      </td>
      @endif
      @if($expense_category_name)
      <td>
        <span>@lang('menu.ExpenseCategory')</span>: {{$expense_category_name}}
      </td>
      @endif
    </tr>
</table>
@endif

<table class="main-table">
<thead>
  <tr class="bg">

 <!-- <td><div class="center"> #</div></td> -->
  @if($_date)<td class="center" ><div > @lang('layout.Date')</div></td>@endif
  @if(!$expense_category_name) @if($_category)<td class="center" ><div > @lang('layout.Category') </div></td>@endif @endif
 @if($_description)<td class="center" ><div > @lang('layout.Description')</div></td>@endif
 @if($_amount)<td class="center" ><div > @lang('layout.Amount')</div></td> @endif
 @if($_currency) <td class="center" ><div > @lang('layout.Unit')</div></td>@endif
 <td class="center" ><div > @lang('layout.Rate')</div></td>
 <td class="center" ><div > @lang('layout.User')</div></td>

</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
  $currencies=[];
?>
@foreach($data AS $data)
<tr>
  <?php

   if(systemConfig()[30] != 0 ){
     $total_home_currency+=$data->amount/$data->static_rate * $data->rate;
   }else{
     $total_home_currency+=$data->amount/$data->rate;
   } 
   if(array_key_exists($data->currency, $currencies))
   {

    $currencies[$data->currency]=$currencies[$data->currency]+$data->amount;
  }
  else
  {
    
    $currencies[$data->currency]=$data->amount;
  }
  ?>
<!-- <td  class="center">{{++$count}}</td> -->

@if($_date)<td  class="center">{{convertDate($data->date)}}</td>@endif
@if(!$expense_category_name)  @if($_category)<td  class="center">{{$data->category}}</td>@endif @endif
@if($_description)<td class="center">{{$data->description}}</td>@endif
@if($_amount)<td  class="center">{{$data->amount}}</td>@endif
@if($_currency)<td  class="center">{{$data->currency}}</td>@endif

<td  class="center">{{$data->rate}}</td>
<td  class="center">{{$data->user}}</td>

</tr>
@endforeach
</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> #</div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;

foreach($currencies As $key=>$currency )
{

  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection