@extends('layouts.factor-master')

@section('content')
<?php
$report =customeReportNew('expense_index');
$_number=!in_array('number', $report);
$_expense_number=!in_array('expense_number', $report);
$_reference_number=!in_array('reference_number', $report);
$_date=!in_array('date', $report);
$_description=!in_array('description', $report);
$_amount=!in_array('amount', $report);
$_currency=!in_array('currency', $report);
$_account=!in_array('account', $report);
$_vendor=!in_array('vendor', $report); 
$_invoice=!in_array('invoice', $report);
$_user=!in_array('user', $report);
$_per_currency=!in_array('per_currency', $report);
$_home_currency_total=!in_array('home_currency_total', $report);


?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ReturnExpenseReport') - ({{__('layout.'.$expense_type)}})</h3>
@if($from_date || $to_date)
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
@endif

@if($ClassName || $expense_account_name || $bank_account_name)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif
      @if($expense_account_name)
      <td>
        <span>@lang('layout.ExpenseAccount')</span>: {{$expense_account_name}}
      </td>
      @endif
      @if($bank_account_name)
      <td>
        <span>@lang('layout.BankAccount')</span>: {{$bank_account_name}}
      </td>
      @endif
    </tr>
</table>
@endif

<table class="main-table">
<thead>
  <tr class="bg">

 @if($_number)<td class="center"><div > @lang('layout.Record') </div></td>@endif
 @if($_expense_number)<td class="center"><div > @lang('layout.ExpenseNumber') </div></td>@endif
 @if($_reference_number)<td class="center"><div > @lang('layout.ReferenceNumber') </div></td>@endif
 @if($_date)<td class="center" ><div > @lang('layout.Date')</div></td>@endif
 @if($_description)<td class="center" ><div > @lang('layout.Description')</div></td>@endif
 @if($_amount)<td class="center" ><div > @lang('layout.Amount')</div></td> @endif
 @if($_currency) <td class="center" ><div > @lang('layout.Currency')</div></td>@endif
 @if($_account)<td class="center"><div > @lang('layout.Account')</div></td>@endif
 @if($_vendor)<td class="center"><div > @lang('layout.Vendor')</div></td>@endif
 @if($_invoice)<td class="center"><div > @lang('layout.Invoice')</div></td>@endif
 @if(systemConfig()[5] != 0 )
  <td class="center"><div > @lang('layout.Project')</div></td>
  <td class="center"><div > @lang('layout.Status')</div></td>
  @endif
  @if($_user)<td class="center"><div > @lang('layout.User')</div></td>@endif
 

 
</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
  $currencies=[];
?>
@foreach($expense AS $data)
<tr>
  <?php

    if(systemConfig()[30] != 0 ){
      $total_home_currency+=$data->amount/$data->static_rate * $data->rate;
    }
   else{
     $total_home_currency+=$data->amount/$data->rate;
   } 
   if(array_key_exists($data->currency, $currencies))
   {

    $currencies[$data->currency]=$currencies[$data->currency]+$data->amount;
  }
  else
  {
    
    $currencies[$data->currency]=$data->amount;

  }
  ?>
@if($_number)<td  class="center">{{++$count}}</td>@endif
@if($_expense_number)<td  class="center">{{$data->expense_number}}</td>@endif
@if($_reference_number)<td  class="center">{{$data->expense_ref}}</td>@endif
@if($_date)<td  class="center">{{convertDate($data->date)}}</td>@endif
@if($_description)<td class="center">

    @if(isset($report_format))
    {{$data->description}}
    @else
    {!! wordwrap($data->description,40,"<br/>\n",false) !!}
    @endif


</td>@endif
@if($_amount)<td  class="center">{{$data->amount}}</td>@endif
@if($_currency)<td  class="center">{{$data->currency}}</td>@endif
@if($_account)<td class="center">{{$data->account}}</td>@endif
@if($_vendor)<td  class="center">{{$data->vendor}}</td>@endif
@if($_invoice)<td  class="center">{{$data->sale}}</td>@endif
@if(systemConfig()[5] != 0 )
<td  class="center">{{$data->project}}</td>
<td  class="center">
@if($data->status){{__('type.'.$data->status)}} @endif
</td>
@endif
@if($_user)<td  class="center">{{$data->user}}</td>@endif
  
</tr>
@endforeach  
</table>

<table class="main-table">
  

@if($_per_currency)
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record')</div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;

foreach($currencies As $key=>$currency )
{

  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
@endif
@if($_home_currency_total)
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}}   {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
@endif
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection