@extends('layouts.app')
@section('style')
    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">
    <link rel="stylesheet" href="{{url('/vue/style.css')}}">
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
    <style>
        .dashboard-stat2 {
            padding: 0;
        }
        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        }
        th, td {
            text-align: left;
            padding-bottom: 0px;
        }
        tr {
            border-bottom: 1px solid #ddd;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2
        }
        [v-cloak] {
            display: none;
        }
        .row-height {
            height: 55px;
        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }
        .v-autocomplete-list {
            z-index: 1000 !important;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            height: 22px;
            font-size: 16px;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .dashboard-stat2 {
            padding-bottom: 0;
        }
        .dashboard-tabel td {
            padding: 0 4px;
        }
        .badge3 {
            ext-align: center;
            width: 100%;
            font-size: 18px !important;
            line-height: 34px;
            height: 34px;
            color: #fff;
            padding: 3px 6px;
        }
        .paddint-both {
            padding: 5px;
        }
        .paddint-both:hover {
            color: red;
        }
    </style>
    <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }
        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }
        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;
        }
        .input_style {
            min-width: 110px;
        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }
        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }
        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }
        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
        .select_style{
            outline:1px solid #c2cad8 !important
        }
    </style>
@stop


@section('content')
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditReturnExpense')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
                <div class="tools">
                </div>
            </div>
            <div class="portlet-body form"  id="salse">
                {{Form::model($expenseInfo,['route' => ['returnExpense.update',$expenseInfo->p_id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'expense-form'])}}
                <div v-cloak>
                    <div class="row" style="margin-bottom: 20px; padding: 10px;">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;">
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">  
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseType') </label>
                                            {{Form::select('type',['writeCheck' => __('layout.Writecheck'),'bill' => __('layout.Bill')],'Accounts Receivable',[ 'v-model'=>'expenseType','class'=>'form-control select_style',"v-validate"=>"'required'","data-vv-as"=>__('layout.ExpenseType')])}}
                                            <span class="required">@{{errors.first('type')}}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseNumber')</label>

                                            <input type="number" name="expense_number"  value="{{$expenseInfo->number}}" class="form-control">

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                            <input type="text" name="expense_ref"  class="form-control" value="{{$expenseInfo->expense_ref}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">   
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency') </label>
                                            <select class="form-control select_style " v-model="selectedCurrency" @keyup="editKey = true" @click="editKey = true" @input="(editKey)?set_avg_rate_by_currency():''" required="required">
                                                <option v-for="optionCurrency in currencyList" :value="optionCurrency">
                                                    @{{optionCurrency.code}}
                                                </option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                        </div>
                                    </div>
                                </div>
                                <span v-if="expenseType == 'writeCheck'">
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">    
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Account') </label>
                                                <select class="form-control select_style" name="bank_account" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                    <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </span>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                            <input type="hidden" name="vendor" v-validate="(expenseType == 'bill')?'required':''" data-vv-as="@lang('layout.Vendor')" :value="!selected_vendor?null:selected_vendor.id">
                                             <span class="required">@{{errors.first('vendor')}}</span>
                                        </div>
                                            {{--<div class="col-md-8 ">--}}
                                            {{--<div class="input-group" :class="{'has-error':discount<0 || discount>100 }">--}}
                                                {{--<input  v-model="discountFiled" class="form-control"--}}
                                                        {{--type="number" min="0"--}}
                                                        {{--max="100">--}}
                                                {{--<span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selectedCurrency.symbol}}</span>--}}
                                                {{--<span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%</span>--}}
                                                {{--<input type="hidden" name="discount" :value="discount">--}}
                                            {{--</div>--}}
                                        {{--</div>--}}
                                    </div>
                                </div>
                                <span v-if="expenseType == 'writeCheck'">
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Balance') </label>
                                                <span v-show="false">@{{defaultAmount=(selectedBank.balance-(subtotal - defaultTotal))}}</span>
                                                <input type="number" class="form-control" :value="defaultAmount.toFixed(precision())" disabled>
                                            </div>
                                        </div>
                                    </div>
                                </span>
                                <div  class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">   
                                        <div class="col-md-12 " :class="{'has-error':selectedCurrency.rate < 0}">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div class="input-group">
                                                <input  v-model="selectedCurrency.rate"  class="form-control" type="number" min="0" >
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            <span v-if="differentRate" style="background: #efefef; font-size: 14px;" class="required">@lang('message.DifferentRateMsg')</span>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.rate">
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                            <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date') </label>
                                            {{Form::text('date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Description') </label>
                                                <textarea  name="description" class="form-control" rows="1">{{$expenseInfo->description}}</textarea>
                                        </div>
                                    </div>
                                </div>
								@if(systemConfig()[5] != 0 )
									<div class="col-md-4">
										<label class="control-label">@lang('layout.Project')</label>
										<v-select class="vue-select2" label="name" @search="ProjectSearch" :options="project_list" v-model="selectedProject">
										</v-select>
										<input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
									</div>
								@endif
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                @if(systemConfig()[20] == 1)
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.ContractName')</label>
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                v-model="selectedContract" label="company_name"
                                                :options="{{$contract}}">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                @endif
                               
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Hour')</label>
                                            <div class="input-group">
                                                @if(getHourType() == 24)
                                                <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$expenseInfo->hour}}">
                                                @else
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$expenseInfo->hour}}" >
                                                @endif
                                                <span class="input-group-btn">
                                                    <button class="btn default" type="button">
                                                        <i class="fa fa-clock-o"></i>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="1">{{$expenseInfo->memo}}</textarea>
                                        </div>
                                    </div>
                                </div>
                               
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="dashboard-stat2" style="margin-top: 20px;">
                                    <table class="dashboard-tabel" width="100%">
                                        <tr v-if="expenseType !== 'bill'">
                                            <td>
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">@{{ Number.parseFloat(subtotal).toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr v-if="expenseType == 'bill'">
                                            <td>
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">@{{ Number.parseFloat(subtotal-payeds).toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr v-if="expenseType == 'bill'">
                                            <td>
                                                <small>@lang('layout.Pyments') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">@{{ Number.parseFloat(payeds).toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr v-if="expenseType == 'bill'">
                                            <td>
                                                <small>@lang('layout.Sub-Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">@{{ Number.parseFloat(subtotal).toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                        {{--<tr>--}}
                                            {{--<td>--}}
                                                {{--<small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(2) }}%)</small>--}}
                                            {{--</td>--}}
                                            {{--<td class="text-right">--}}
                                                    {{--<span class="text-right" data-counter="counterup"--}}
                                                            {{--data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(2) }}</span>--}}
                                                {{--<small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>--}}
                                            {{--</td>--}}
                                        {{--</tr>--}}
                                        {{--<tr>--}}
                                        {{--<td>--}}
                                        {{--<small>@lang('layout.Payment'):</small>--}}
                                        {{--</td>--}}
                                        {{--<td class="text-right">--}}
                                        {{--<small class="font-green-sharp">--}}
                                        {{--<span class="text-right" data-counter="counterup"--}}
                                        {{--data-value="7800">@{{ payeds.toFixed(2)}}</span>--}}
                                        {{--<small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>--}}
                                        {{--</small>--}}
                                        {{--</td>--}}
                                        {{--</tr>--}}
                                        {{--<tr>--}}
                                            {{--<td>--}}
                                                {{--<small>Sub-Total:</small>--}}
                                            {{--</td>--}}
                                            {{--<td class="text-right">--}}
                                                        {{--<span class="text-right" data-counter="counterup"--}}
                                                            {{--data-value="7800">@{{ subtotal.toFixed(2)}}</span>--}}
                                                {{--<small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>--}}
                                            {{--</td>--}}
                                        {{--</tr>--}}
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="overflow-x: scroll;">

                        <table id="table_content" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th style="min-width: 130px">@lang('layout.SelectBank')</th>
                                    <th style="min-width: 100px">@lang('layout.ExpenseCategory')</th>
                                    <th style="min-width: 100px">@lang('layout.Description')</th>
                                    <th style="min-width: 100px">@lang('layout.Amount')</th>
                                    <th> </th>
                                </tr>
                            </thead>

                            <tr v-for="(row, itemIndex) in expense" class="even">
                                <td class="td_one"> <span class="badge badge3 badge-roundless" style="background: transparent !important; color: black;"> @{{itemIndex+1}} </span></td>

                                <td class="td_one">
                                    <v-autocomplete :items="row.items" v-model="row.item"
                                                    :get-label='getLabel'
                                                    :min-len='0'
                                                    :component-item='tpl' v-on:update-items='expenseUpdate'
                                                    :input-attrs="{}"
                                                    @focus="expenseIndex(itemIndex)"
                                                    placeholder="@lang('layout.SelectBank')"
                                                    style="min-width: 220px  ;">
                                    </v-autocomplete>

                                        <input v-if="row.item" type="hidden" name="expense[]" :value="row.item.id">
                                        <input v-if="row.item" type="hidden" name="expense_id[]" :value="expenseIds[itemIndex].ex_id">

                                </td> 
                                 <td>
                                   
                                    <select  v-model="!row.item?null:categories[itemIndex].name" class="form-control">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option v-for="obj in category" :value="obj.id">@{{obj.name}}</option>
                                    </select>
                                      <input v-if="row.item" type="hidden" name="expense_category_id[]" :value="categories[itemIndex].name">

                                </td>
                                <td>
                                    <input name='expense_description[]' type="text" class="form-control" autocomplete="off"
                                           placeholder="@lang('layout.Description')" v-model="!row.item?null:descriptions[itemIndex].description" required/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <vue-numeric
                                            class="form-control"
                                            v-model="row.amount"
                                            :max="99999999999999"
                                            :currency="selectedCurrency.code"
                                            :precision="precision()"
                                            >
                                        </vue-numeric>
                                        <input name='expense_amount[]' type="hidden" class="form-control" v-model="row.amount" placeholder="@lang('layout.Amount')" required />
                                        <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <a roll="button" v-on:click="deleteExpense(itemIndex,expenseIds[itemIndex].ex_id)">
                                        <i style="padding: 0px;" class="paddint-both glyphicon glyphicon-trash"></i></a>

                                </td>


                            </tr>

                        </table>

                    </div>
                    <span v-if="expenseType == 'bill'">
                        <div v-if="payments.length >0  " class="row" style="overflow-x: scroll;">
                        <div class="table-responsive333">
                            <table id="table_content" class="table table-bordered table-striped">
                                <thead>
                                <tr>


                                    <th class="text-center" style="min-width: 8px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                    <th class="text-center" style="min-width: 100px;">@lang('layout.Currency')</th>
                                    <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>

                                    <th style="min-width: 20px;"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(payment,Index) in payments" class="even">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{Index+1}} </span>
                                    </td>
                                    <td class="td_one">
                                        <v-autocomplete :items="payment.items" v-model="payment.item" :get-label='getLabel'
                                                        :min-len='0'
                                                        :component-item='tpl' v-on:update-items='updatePayment'
                                                        :input-attrs="{}"
                                                        @focus="setPaymentIndex(Index)"
                                                        placeholder="@lang('layout.SelectBank')">
                                        </v-autocomplete>

                                        <input type="hidden" name="payment_id[]" :value="!payment.item?null:payment.item.id">
                                        <input type="hidden" name="oldPayment_id[]" :value="paymentIds[Index].pId">
                                        

                                    </td>

                                    <td>
                                        <input v-bind:disabled="!payment.item?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                            type="number" v-model.number="!payment.item?null:payment.item.rate "
                                            class="form-control"
                                            placeholder="@lang('layout.Rate')" required/>
                                        <input v-if="payment.item" type="hidden" name="payment_rate[]"
                                            v-bind:value="payment.item.rate">
                                        <input v-if="payment.item" type="hidden" name="payment_rate_hq[]"
                                            v-bind:value="payment.item.hq_rate">
                                    </td>
                                    <td>

                                        <input type="text" name="payment_Currency[]" class="form-control"
                                               v-model="!payment.item?null:payment.item.code"
                                               placeholder="@lang('layout.Currency')" required disabled/>

                                        <input v-if="payment.item" type="hidden" name="payment_currency[]"
                                               v-bind:value="payment.item.code"/>

                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <vue-numeric
                                                class="form-control"
                                                v-model="payment.amount"
                                                :max="99999999999999"
                                                :currency="(!payment.item)?null:payment.item.code"
                                                :precision="precision()"
                                                >
                                            </vue-numeric>
                                            <input v-if="payment.item" type="hidden" name="payment_amount[]" v-bind:value="payment.amount">
                                            <span class="input-group-addon">@{{(!payment.item)?null:payment.item.code}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            @if(systemConfig()[30] == 1)
                                            <input type="number" class="form-control"
                                            :value="!payment.item?null:((payment.amount / payment.item.static_rate * payment.item.rate )*selectedCurrency.static_rate/selectedCurrency.rate).toFixed(3)"
                                                   placeholder="@lang('layout.Total')" style="min-width: 100px" required disabled/>
                                            <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            @else 
                                                :value="!payment.item?null:(payment.amount*selectedCurrency.rate/payment.item.rate).toFixed(precision())"
                                                placeholder="@lang('layout.Total')" style="min-width: 100px" required disabled/>
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            @endif
                                        </div>
                                    </td>

                                    <td>
                                        <span  v-on:click="deletePayment(Index,paymentIds[Index].pId)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                    </td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    </span>
                    <div class="row" style="text-align: center;">

                            {{--<button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addInventory">@lang('layout.AddItem')--}}
                            {{--</button>--}}
                            {{--<button v-if="services.length <= 0 " type="button" class="btn default" @click="addService">@lang('layout.Addservice')--}}
                            {{--</button>--}}
                            <button   type="button" class="btn green" @click="handleSubmit($event)">@lang('layout.Submit')</button>
                            <span>
                                <a href="{{route('returnExpense.index')}}"  class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </span>
                            <input type="hidden" v-for="pd in paymentDelete" name="paymentDelete[]" :value="pd.pIdDelete">
                            <input type="hidden" v-for="ed in expenseDelete" name="expenseDelete[]" :value="ed.eIdDelete">

                    </div>

                </div>

            </div>

                {{Form::close()}}
            </div>

        </div>
    </div>


    <script type="text/x-template" id="checkbox-template">

        <div>
            <b>#@{{item.id}}</b>
            <span>@{{ item.name }}</span>
            {{--<span>@{{item.qty }}</span>--}}
            {{--<span>@{{item.description}}</span>--}}
        </div>
    </script>
@endsection

@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>
    <script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    Vue.component('v-select', VueSelect.VueSelect);
    Vue.use(VueNumeric.default);
  
        var Currency     = {!! $currency!!}
        var Category     = {!! $category !!};
        var AllAccounts  = {!! $all_accounts!!};
        var Banks        = {!! $banks!!}
        var project        = {!! $project!!}
        var contract        = {!! $contract!!}
        var InventoryAll = null;
        var serviceAll   = null;
        var Account      = {!! $allBank !!};
        Vue.use(VAutocomplete.default)
        Vue.use(VeeValidate);

        var temp = Vue.component('my-checkbox', {
            template: '#checkbox-template',
            props: {
                item: {required: true},
                searchText: {required: true}
            } 
        });
        
        var sales = new Vue({
            el:'#salse',
            data:{
                currencyRate:1,
                vendor: [],
                selected_vendor: {!! $selectedVendor !!},
                selectedCurrency: {
                    id: parseInt('{{getHomeCurrency()["id"]}}'),
                    code: '{{getHomeCurrency()["code"]}}',
                    symbol: '{{getHomeCurrency()["code"]}}',
                    rate: '{!!$expenseInfo->rate!!}',
                    exchange_rate: '{!!$expenseInfo->rate!!}'
                },
                show_build_expense_confirm_checked: "{{$expenseInfo->build_expense_confirm == 'On'}}",
                discountFiled: 0,
                discountIsAmount:false,
                averageRate:false,
                differentRate:false,
                editKey:false,
                selectedProject: project,
                project_list: [],
                selectedSale: {!! $sale !!},
                sales_list: [], 
                currencyList: Currency,
                listAccounts:[],
                amounts: [],
                expense: [],
                categories:[],
                payments: [],
                expenseIds: [],
                paymentIds: [],
                paymentDelete: [],
                expenseDelete: [],
                descriptions: [],
                paymentIndex:0,
                eindex: 0,
                expenseType:null,
                category:Category,
                account: {},
                tpl: temp,
                bankes: {!! $bankes !!},
                selectedBank: null,
                contract: contract,
                selectedContract: null,
                defaultValue: 0,
                defaultAmount:0,
                defaultAccount: 0,
                amount:null,
                accountslist: AllAccounts,
                findPurchase: {!! $findPurchase !!},
                purchasePayment: {!! $purchasePayment !!},
                Account:Account,
                defaultTotal:0,
            },
            created:function(){
                this.expenseType = ("{!!$expenseInfo->type!!}" == 'BillExpense')?'bill':'writeCheck';
                for(var x = 0; x<this.currencyList.length; x++){
                    if("{!!$expenseInfo->currency!!}" == this.currencyList[x].code){
                        this.selectedCurrency = this.currencyList[x];
                    }
                }

                this.selectedCurrency.rate = {!!$expenseInfo->rate!!};
                this.selectedCurrency.exchange_rate = {!!$expenseInfo->rate!!};
                
                for(var a = 0; a<this.accountslist.length; a++){
                    for(var b = 0; b<this.findPurchase.length; b++){
                        if(this.accountslist[a].id == this.findPurchase[b].account_id){
                            var item = this.accountslist[a];
                            item.amount = myRound(this.findPurchase[b].amount);
                            this.expenseIds.push({ex_id: this.findPurchase[b].ex_id});
                            this.descriptions.push({description:this.findPurchase[b].description});
                            // console.log(312,item.amount);
                            this.expense.push({
                                items: [],
                                item: item,
                                amount:item.amount
                            });
                            // console.log(this.expense);
                            this.categories.push({name:this.findPurchase[b].expense_category_id});
                        }
                    }
                }
                for(var m = 0; m<this.Account.length; m++){
                    for(var n = 0; n<this.purchasePayment.length; n++){
                        if(this.Account[m].id == this.purchasePayment[n].account_id){
                            var item = this.Account[m];
                            item.amount = this.purchasePayment[n].amount;
                            if (this.selectedCurrency.code == item.code) {
                                item.rate = this.selectedCurrency.rate;
                            } else {
                                item.rate = this.purchasePayment[n].rate;
                            }
                            // console.log(3992,this.purchasePayment[n].amount);
                            this.paymentIds.push({pId: this.purchasePayment[n].id});
                            this.payments.push({
                                items: [],
                                item: item,
                                amount: this.purchasePayment[n].amount
                            });
                        }
                    }
                }
                // console.log(333, this.payments);
                var sum = 0;
                for (var i = 0; i < this.expense.length; i++) {
                    if (this.expense[i].item)
                        // sum +=parseFloat(Number(this.expense[i]['item']['amount']));
                        sum -=parseFloat(Number(this.expense[i].amount));

                }
                this.defaultTotal = sum;
                this.expenseIds.push({ex_id: -1});
                this.paymentIds.push({pId: -1});
                this.descriptions.push({description:null});
                this.expense.push({
                                items: [],
                                item: null,
                                amount: 0
                            });
                this.payments.push({
                        items: [],
                        item: null,
                        amount: 0,

                    });

                this.defaultValue = {{$expenseInfo->account_id}};
                for(var x in this.bankes){
                    for(z in this.bankes[x]){
                        if(this.bankes[x][z] == this.defaultValue && z == 'id'){
                            this.selectedBank = this.bankes[x];
                            this.defaultAccount = this.defaultValue;                                    
                            break;
                        }
                    }

                }
                @if($expenseInfo->contract_id != null)    
                this.selectedContract = _.find(this.contract, (e) => e.id == {{$expenseInfo->contract_id}});
                @endif

            },
            computed:{
                discount(){
                    if(this.discountIsAmount){

                        if(this.subtotal>0 && this.discountFiled) {
                           return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        }else {
                           return 0;
                        }
                    }else {

                        return this.discountFiled
                    }

                },
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (test[0]) {
                        this.defaultValue = test[0].id;
                        var defaultB = true;
                        for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if (this.bankes[x][z] == this.defaultAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];      
                                    var defaultB = false;                          
                                    break;
                                }
                            }

                        }
                        if (defaultB) {
                        for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.bankes[x][z] == this.defaultValue && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;                                    
                                    break;
                                }
                            }
   
                        }
                        }
                    }
                    return test;
                },
                subtotal: function () { 
                    var sum = 0;
                    // console.log('amounts',this.expense);
                    for (var i = 0; i < this.expense.length; i++) {
                        if (this.expense[i].item)
                            // sum +=parseFloat(Number(this.expense[i]['item']['amount']));
                            sum -=parseFloat(Number(this.expense[i].amount)); 
                    } 
                    return sum;
                },
                payeds: function () {
                    this.differentRate = false;
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item && this.payments[i]['item']['rate']>0) {
                            // sum += parseFloat(this.payments[i]['amount'] * this.selectedCurrency.rate / this.payments[i]['item']['rate']);

                            @if(systemConfig()[30] == 1)
                            sum += parseFloat((this.payments[i]['amount'] /this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selectedCurrency.static_rate / this.selectedCurrency.rate );
                            @else 
                            sum += parseFloat(this.payments[i]['amount'] * this.selectedCurrency.rate / this.payments[i]['item']['rate']);
                            @endif

                            if (this.selectedCurrency.code == this.payments[i]['item']['code'] && this.payments[i]['amount']) {
                                if (this.selectedCurrency.rate != this.payments[i]['item']['rate']) {
                                    this.differentRate = true;
                                }
                            }
                        }
                    }
                    return sum;
                },

            },
            methods:{
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // console.log(e);
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                itemSelected (item) {
                    alert('selected');
                    console.log('Selected item!', item)
                },
                itemClicked (item) {
                    console.log('You clicked an item!', item)
                    alert('clicked');
                },
                getLabel (item) {
                    if (item) {
                        return item.name
                    }
                    return ''
                },
                updatePayment (text) {
                    var Animals1 = Account.slice();

                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            if (Animals1.findIndex((item) => item.name == this.payments[i].item.name) != -1)
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.payments[i].item.name), 1)

                        }

                    }

                    this.payments[this.paymentIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
                    })
                    if (this.paymentIndex == this.payments.length - 1)
                        this.newPayment()
                    if (this.payments[this.paymentIndex].item != null)
                        this.payeds;

                },


                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            sales.vendor = [];
                            sales.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                
				// Search Project

				ProjectSearch:_.debounce((search,loading)=>{
				   sales.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						sales.project_list=response.data;
						// console.log('test 22',sales.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                // Search sale
				saleSearch:_.debounce((search,loading)=>{
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchSales',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
                    sales.sales_list=[];
					 if(response.data.length>0)
					 {
						sales.sales_list=response.data;
						// console.log('test 22',response.data);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),

                setPaymentIndex(index){
                    this.paymentIndex = index;
                    this.updatePayment('')
                },
                newPayment(){
                    this.paymentIds.push({pId: -1});
                    this.payments.push({
                            items: [],
                            item: null,
                            amount: 0,
                        }
                    )
                },
                deletePayment(index, pId){
                    var check = true;
                    for(var s = 0; s<this.paymentDelete.length; s++){
                        if(this.paymentDelete[s].pIdDelete == pId){
                            check = false;
                        }
                    }
                    if(check){

                        this.paymentDelete.push({pIdDelete:pId});
                    }
                    this.payments.splice(index, 1);
                    this.paymentIds.splice(index, 1);
                },

                bankUpdate(text) {
                    var b = _.clone(this.accounts)

                    this.listAccounts = b.filter((account) => {
                        return (new RegExp(text.toLowerCase())).test(account.name.toLowerCase())
                    })

                },

                newExpense() {
                    this.expense.push({
                        items: [],
                        item: null
                    });
                    this.amounts.push({amount:null});
                    this.categories.push({name:[]});
                    this.expenseIds.push({ex_id: -1});
                    this.descriptions.push({description:null});
                },


                deleteExpense(index, eId) {
                    // alert('yes');
                    var check = true;
                    for(var s = 0; s<this.expenseDelete.length; s++){
                        if(this.expenseDelete[s].eIdDelete == eId){
                            check = false;
                        }
                    }
                    if(check){

                        this.expenseDelete.push({eIdDelete:eId});
                    }
                    this.expense.splice(index, 1);
                    this.categories.splice(index,1);
                    this.amounts.splice(index,1);
                    this.expenseIds.splice(index,1);
                    this.descriptions.splice(index,1);

                },

                expenseUpdate (text) {
                    var Animals1 = AllAccounts.slice();

                    

                    this.expense[this.eindex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
                    })
                    if (this.eindex == this.expense.length - 1)
                        this.newExpense()
                    // if (this.expense[this.eindex].item != null)
                    //     this.priceUpdate(this.eindex);

                },
                expenseIndex (text) {
                    this.eindex = text
                    this.expenseUpdate('')
                },
                submitForm() {

                    swal({
                        title:"@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("expense-form").submit()

                            } else {

                            }
                        });

                },
                test(defaultAccount){
                    for(var x in this.bankes){
                        for(z in this.bankes[x]){
                            if(this.bankes[x][z] == defaultAccount && z == 'id'){
                                this.selectedBank = this.bankes[x];
                                
                                break;
                            }
                        }
                    }
                },

                set_avg_rate(avg_rate) {
                    let vv = this;
                    setTimeout(() => {
                        // vv.averageRate = true;
                        vv.selectedCurrency.rate = avg_rate;
                    }, 300);
                },

                set_avg_rate_by_currency() {
                    // console.log(32);
                    this.averageRate = false;
                    
                },




            }
        });


    </script>
@endpush