@extends('layouts.app')
@section('style')
<style>
  .btn-gray{
    color: white;
    background-color:green;
  }
  .mt-icon.report
  {
    {{(session()->get("system_direction") == "rtl")?'right':'left'}}: 0px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
  }
  .report_list{
    padding: 8px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 70px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
  }
  .report_a{
    color: #393a3d;
  }
  a.report_a:hover{
    color: #393a3d;
    text-decoration: none;
  } 
  .report_a_title{
    color: #393a3d;
  }
  a.report_a_title:hover{
    color: #393a3d;
    text-decoration: none;
  }
  .mt-widget-1 .mt-img {
    display: inline-block;
    /* border-radius: 50% !important; */
    border: 0px !important;
    margin: 25px 0 20px 0;
  }
  .mt-body{
    display:none ;
  }
  .v-select .selected-tag{
      height: 26px !important;
      margin: 4px 1px 0 3px !important;
  }
  .v-select .selected-tag > button >span{
      display: none !important;
  }
</style>
@stop
@section('content')
@include('reports.modal_general') 
<div id="app" v-cloak> 
  <!-- use the modal component, pass in the prop -->
  <modal v-if="showModal" @close="showModal = false">
    <div slot="body">
      <div class="tabbable tabbable-tabdrop">
        <ul class="nav nav-tabs">
          <li class="active">
              <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
          </li>
          @if(systemConfig()[2] != 0 )
          @permission(['customreport-list'])
          <li class="" v-if="customReportData.length>0">
              <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
          </li>
          @endpermission
          @endif
        </ul>
        <div class="tab-content">
          <div class="tab-pane active" id="tab1"> 
            <form id="d_form" action="{{route('export.PDFAll')}}" method="POST">
              <input type="hidden" name="_method" value="DELETE">
              {!! Form::token() !!}
              <button id="show-modal" style="display: none" type="button">Show Modal</button>
              <div class="portlet light bordered">
                <div class="portlet-body">
                  <!------Begain Discount ----->
                  <div class="row" v-if="(showDiv['discount_account_tocustomer'])">
                    <div class="form-group">

                      <div class="col-md-12">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                        </v-select>
                        <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                      </div>

                    </div>
                  </div>
                  <!------ End Discount ----->
                  <!------Begain Discount ----->
                  <div class="row" v-if="(showDiv['discount_account_from_vendor'])">
                    <div class="form-group">
                      <div class="col-md-12">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                        </v-select>
                        <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                      </div>

                    </div>
                  </div>
                  <!------ End Discount ----->
                  <!------ Begain Inventory ----->
                  <div class="row" v-if="(showDiv['allInventoryReport'])">
                    <div class="form-group"> 
                      <div class="col-md-4">
                        <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                        <select name="inventory_category_id" id="" class="form-control">
                          <option value="">@lang('layout.SelectInventoryCategory')</option>
                          @foreach($inventoryCategory as $cat)
                          <option value="{{$cat->id}}">{{$cat->name}}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="col-md-4">
                        <label class="control-label ">@lang('layout.SelectInventorySite') </label>
                        <select name="inventory_site_id" id="" class="form-control">
                          <option value="">@lang('layout.SelectInventorySite')</option>
                          @foreach($inventorySite as $site)
                          <option value="{{$site->id}}">{{$site->name}}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="col-md-4">
                        <label class="control-label ">@lang('layout.SelectItem') </label>
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist">
                        </v-select>
                        <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                      </div>

                    </div>
                  </div>
                  <!------ End Inventory ----->
                  <!------ Begain Inventory general report ----->
                  <div class="row" v-if="(showDiv['inventory_general_report'])">
                    <div class="form-group">
                      <!--<div  class="col-md-4">
                        <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                        <select name="inventory_category_id" id="" class="form-control">
                          <option  value="">@lang('layout.SelectInventoryCategory')</option>
                          @foreach($inventoryCategory as  $cat)
                            <option  value="{{$cat->id}}">{{$cat->name}}</option>
                          @endforeach
                        </select>
                      </div> -->
                      <div class="col-md-4">
                        <label class="control-label ">@lang('layout.SelectInventorySite') </label>
                        <select name="inventory_site_id" id="" class="form-control">
                          <option value="">@lang('layout.SelectInventorySite')</option>
                          @foreach($inventorySite as $site)
                          <option value="{{$site->id}}">{{$site->name}}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="col-md-4">
                        <label class="control-label ">@lang('layout.SelectItem') </label>
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist">
                        </v-select>
                        <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                      </div>
                      <div class="col-md-4">
                        <label class="control-label ">@lang('layout.Limit') </label>
                        <input type="number" name="limit" class="form-control">
                      </div>

                    </div>
                  </div>
                  <!------ End Inventory general report ----->
                  <!------ Begain Inventory general report code ----->
                  <div class="row" v-if="(showDiv['inventory_general_report_code'])">
                    <div class="form-group">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                        <select name="inventory_category_id" id="" class="form-control">
                          <option value="">@lang('layout.SelectInventoryCategory')</option>
                          @foreach($inventoryCategory as $cat)
                          <option value="{{$cat->id}}">{{$cat->name}}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="col-md-6">
                          <label class="control-label ">@lang('menu.InventoryBrand') </label>
                          <select name="inventory_brand_id" id="" class="form-control">
                            <option value="">@lang('layout.Select')</option>
                            @foreach($inventoryBrand as  $brand)
                            <option value="{{$brand->id}}">{{$brand->name}}</option>
                            @endforeach
                          </select>
                      </div>
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectInventorySite') </label>
                        <select name="inventory_site_id" id="" class="form-control">
                          <option value="">@lang('layout.SelectInventorySite')</option>
                          @foreach($inventorySite as $site)
                          <option value="{{$site->id}}">{{$site->name}}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectItem') </label>
                        <!-- <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist">
                        </v-select>
                        <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id"> -->
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true">
                        </v-select>
                        <input type="hidden" name="item_id" :value="item_id.length > 0 ? item_id:null">
                      </div>
                    </div>
                  </div>
                  <!------ End Inventory general report  code ----->
                  <!------ begain Build ----->
                  <div class="row" v-if="(showDiv['build_report'])">
                    <div class="form-group">
                      <div class="col-md-12">
                        <label class="control-label ">@lang('layout.SelectItem') </label>
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true">
                        </v-select>
                        <!-- <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id"> --> 
                        <!-- Saeed -->
                        <input type="hidden" name="item_id" :value="item_id.length > 0 ? item_id:null">
                      </div>
                    </div>
                  </div>
                  <!------ End Build ----->
                  <!------ begain Build ----->
                  <div class="row" v-if="(showDiv['general_build_report'])">
                    <div class="form-group">
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.BuildItems') </label>
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true">
                        </v-select>
                        <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                      </div>
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.UsedItems') </label>
                        <v-select class="vue-select2" v-model="selectedItem1" label="name" @search="onItemSearch" :options="itemlist">
                        </v-select>
                        <input type="hidden" name="item1_id" v-model.number="(!selectedItem1)?null:selectedItem1.id">
                      </div>
                    </div>
                    <div class="form-group">
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Unit')</label>
                        <select name="measure_id" class="form-control">
                          <option value="">@lang('layout.SelectU/M')</option>
                          @foreach($measures as $measure)
                          <option value="{{$measure->id}}">{{$measure->name}}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label class="control-label" style="color: blue">@lang('layout.ByEveryBuild')
                            <input type="checkbox" class="form-control" name="by_every_build" value="on">
                          </label>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label class="control-label" style="color: blue">@lang('layout.ComparisonPossibleBuildQuentity')
                            <input type="checkbox" class="form-control" name="com_poss_build_qty" value="on">
                          </label>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label class="control-label" style="color: blue">@lang('layout.SimpleExpense')
                            <input type="checkbox" class="form-control" name="simple_expense" value="on">
                          </label>
                        </div>
                      </div>
                    </div>
                  </div>
                  <!------ End Build ----->
                  <!------ begain Build ----->
                  <div class="row" v-if="(showDiv['general_package_build_report'])">
                    <!-- <div class="form-group">
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.BuildItems') </label>
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true">
                        </v-select>
                        <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                      </div>
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.UsedItems') </label>
                        <v-select class="vue-select2" v-model="selectedItem1" label="name" @search="onItemSearch" :options="itemlist">
                        </v-select>
                        <input type="hidden" name="item1_id" v-model.number="(!selectedItem1)?null:selectedItem1.id">
                      </div>
                    </div> -->
                    <div class="form-group">
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Unit')</label>
                        <select name="measure_id" class="form-control">
                          <option value="">@lang('layout.SelectU/M')</option>
                          @foreach($measures as $measure)
                          <option value="{{$measure->id}}">{{$measure->name}}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="col-md-6">
                        <label class="control-label ">@lang('layout.PackageNumber') </label>
                        <input type="number"  class="form-control" name="package_number" />
                      </div>
                    </div>
                  </div>
                  <!------ End Build ----->
                  <!------ begain Sale ----->
                  <div class="row" v-if="(showDiv['SaleList'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>
                  </div>
                  <!------ End Sale ----->
                  <!------ begain Sale ----->
                  <div class="row" v-if="(showDiv['invoicelist'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>
                  </div>
                  <!------ End Sale ----->
                  <!------ begain Purchase ----->
                  <div class="row" v-if="(showDiv['purchaselist'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>
                  </div>
                  <!------ End Purchase ----->
                  <!------ begain Bill ----->
                  <div class="row" v-if="(showDiv['builllist'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div>
                  </div>
                  <!------ End Bill ----->
                  <!------ begain PurchaseOrder ----->
                  <div class="row" v-if="(showDiv['purchaseorderlist'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedVendor" label="name" @search="onVendorSearch" :options="vendorList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedVendor)?null:selectedVendor.id">
                    </div>
                  </div>
                  <!------ End PurchaseOrder ----->
                  <!------ begain Bill ----->
                  <div class="row" v-if="(showDiv['builllistRoll'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div>
                  </div>
                  <!------ End Bill ----->
                  <!------ begain DailyExpense ----->
                  <div class="row" v-if="(showDiv['dailyExpenses'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectCategory') </label>
                      <v-select class="vue-select2" v-model="selected_expense_category" label="name"  :options="expenseCategory">
                      </v-select>
                      <input type="hidden" name="category_id" v-model.number="(!selected_expense_category)?null:selected_expense_category.id">
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End DailyExpense ----->
                  <!------ begain ExpenseList ----->
                  <div class="row" v-if="(showDiv['ExpenseList'])">
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End ExpenseList ----->
                  <!------ begain Payment ----->
                  <div class="row" v-if="(showDiv['all_pay'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div>
                    <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select name="type_name" id="" class="form-control">
                            <option  value="">@lang('layout.SelectType')</option>
                            @if($paymentTypes != null)
                            @foreach($paymentTypes as  $type)
                            <option  value="{{$type->type}}">{{$type->type}}</option>
                            @endforeach
                            @endif
                        </select>
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End Payment ----->
                  <!------ begain Receive ----->
                  <div class="row" v-if="(showDiv['receive'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div>
                    <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select class="form-control" name="type_name">
                          <option value="">@lang('layout.SelectType')</option>
                          <option value="invoice">@lang('layout.Invoice')</option>
                          <option value="bill">@lang('layout.Bill')</option>
                          <option value="receive">@lang('layout.Receive')</option>
                          <option value="salary">@lang('layout.Salary')</option>
                          <option value="loan">@lang('layout.Loan')</option>
                          <option value="prepaid">@lang('layout.Prepaid')</option>
                          @if(systemConfig()[5] != 0 )
                              <option value="project">@lang('layout.Project')</option>
                          @endif
                          <option value="bankCheck">@lang('layout.BankCheck')</option>
                          <option value="branchTransfer">@lang('layout.BranchTransfer')</option>
                        </select>
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End Receive ----->
                  <!------ begain Loan ----->
                  <div class="row" v-if="(showDiv['allLoanReports'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End Loan ----->
                  <!------ begain Employee ----->
                  <div class="row" v-if="(showDiv['Employee'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedEmployee" label="name" @search="onEmployeeSearch" :options="employeeList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                    </div>
                  </div>
                  <!------ End Employee ----->
                  <!------ begain Salarydetails ----->
                  <div class="row" v-if="(showDiv['SalaryDetailsList'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedEmployee" label="name" @search="onEmployeeSearch" :options="employeeList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                    </div>
                  </div>
                  <!------ End Salarydetails ----->
                  <!------ begain Salarydetails ----->
                  <div class="row" v-if="(showDiv['all_payrolls'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedEmployee" label="name" @search="onEmployeeSearch" :options="employeeList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                    </div>
                  </div>
                  <!------ End Salarydetails ----->
                  <!------ begain Sale ----->
                  <div class="row" v-if="(showDiv['invoicelistRoll'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>
                  </div>
                  <!------ End Sale ----->
                  <!------ begain PaySalary ----->
                  <div class="row" v-if="(showDiv['all_payments'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedEmployee" label="name" @search="onEmployeeSearch" :options="employeeList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                    </div>
                  </div>
                  <!------ End PaySalary ----->
                  <!------ begain GeneralSaleReport ----->
                  <div class="row" v-if="(showDiv['GeneralSaleReport'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectReportType') </label>
                      <select class="form-control" name="report_type">
                        <option value="">@lang('layout.SelectReportType')</option>
                        <option value="summary">@lang('layout.Summary')</option>
                        <option value="detail">@lang('layout.Details')</option>
                        <option value="all_items">@lang('layout.AllItemReport')</option>
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.Site') </label>
                      <select class="form-control" name="inventory_site">
                        <option value="">@lang('layout.Select')</option>
                        @foreach($inventorySite AS $site)
                        <option value="{{$site->id}}">{{$site->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SaleArea') </label>
                      <select name="sale_area_id" id="" class="form-control">
                        <option value="">@lang('layout.Select')</option>
                        @foreach($saleArea as $area)
                        <option value="{{$area->id}}">{{$area->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End GeneralSaleReport ----->
                  <!------ begain allFactorPrint ----->
                  <div class="row" v-if="(showDiv['allFactorPrint'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.Number')</label>
                      <div class="input-group">
                        <input class="form-control" autocomplete="off" name="from_sale">
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input class="form-control" autocomplete="off" name="to_sale">
                      </div>
                    </div>
                  </div>
                  <!------ End allFactorPrint ----->
                  <!------ begain AllGRNReport ----->
                  <div class="row" v-if="(showDiv['allGrnReport'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.Number')</label>
                      <div class="input-group">
                        <input class="form-control" autocomplete="off" name="from_sale">

                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input class="form-control" autocomplete="off" name="to_sale">
                      </div>
                    </div>
                  </div>
                  <!------ End AllGRNReport ----->
                  <!------ begain GeneralSaleReportCustomer ----->
                  <div class="row" v-if="(showDiv['GeneralSaleReportCustomer'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.Site') </label>
                      <select class="form-control" name="inventory_site">
                        <option value="">@lang('layout.Select')</option>
                        @foreach($inventorySite AS $site)
                        <option value="{{$site->id}}">{{$site->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectItem') </label>
                      <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true" >
                      </v-select>
                      <!-- <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id"> -->
                      <input type="hidden" name="item_id" :value="item_id.length > 0 ? item_id:null">
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SaleArea') </label>
                      <select name="sale_area_id" id="" class="form-control">
                        <option value="">@lang('layout.Select')</option>
                        @foreach($saleArea as $area)
                        <option value="{{$area->id}}">{{$area->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-4">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                    <div class="form-group">
                      <label class="control-label" >@lang('layout.SalesReportInDetails')
                        <input type="checkbox" class="form-control" name="sales_report_in_details" v-model="sales_report_in_details">
                      </label>
                    </div>
                    <div class="row" v-if="sales_report_in_details">
                      <div class="col-md-3">
                        <label class="control-label ">@lang('layout.Type') </label>
                        <select class="form-control" name="all_general_sale_report">
                          <option value="">@lang('layout.SelectType')</option>
                          <option value="all">@lang('layout.All')</option>
                        </select>
                      </div>

                      <!--Begin Measure-->

                      <div class="col-md-3">
                        <label class="control-label ">@lang('layout.Unit')(1) </label>
                        <select name="measure_id" class="form-control">
                          <option value="">@lang('layout.SelectU/M')</option>
                          @foreach($measures as $measure)
                          <option value="{{$measure->id}}">{{$measure->name}}</option>
                          @endforeach
                        </select>
                      </div>

                      <div class="col-md-3">
                        <label class="control-label ">@lang('layout.Unit')(2) </label>
                        <select name="measure_id2" class="form-control">
                          <option value="">@lang('layout.SelectU/M')</option>
                          @foreach($measures as $measure)
                          <option value="{{$measure->id}}">{{$measure->name}}</option>
                          @endforeach
                        </select>
                      </div>

                      <div class="col-md-3">
                        <label class="control-label ">@lang('layout.Unit')(3) </label>
                        <select name="measure_id3" class="form-control">
                          <option value="">@lang('layout.SelectU/M')</option>
                          @foreach($measures as $measure)
                          <option value="{{$measure->id}}">{{$measure->name}}</option>
                          @endforeach
                        </select>
                      </div>
                      <br>
                      <div class="col-md-12">
                        <span style="color: red">@lang('message.SameMeasuresMsg')</span>
                      </div>

                    </div>
                    <!--End Measure-->

                    <div class="">
                      <div class="col-md-4">
                        <label class="control-label">@lang('layout.Currency') </label>
                        <select class="form-control" v-model="selected_currency" >
                          <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                        </select>
                        <input type="hidden" name="currency" v-bind:value="(selected_currency)?selected_currency.code:null"/>
                      </div>
                      <div class="col-md-4">
                        <span v-if="selected_currency">
                            <span v-if="selected_currency.code != code">
                              <label class="control-label">@lang('layout.Rate') </label>
                              <div class="input-group">
                                  <input v-model="selected_currency.rate" class="form-control" name="currency_rate"
                                      type="number" step="any" min="0"  >
                                  <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                              </div>
                            </span>
                        </span>
                      </div>
                      <div class="col-md-2">
                      <div class="form-group">
                        <label class="control-label" >@lang('layout.TotalByClass')
                          <input type="checkbox" class="form-control" name="total_by_class" value="on">
                        </label>
                      </div>
                      </div>

                      <div class="col-md-2">
                        <div class="form-group">
                          <label class="control-label" >@lang('layout.ReportWithDiscountDetails')
                            <input type="checkbox" class="form-control" name="discount_details" value="on">
                          </label>
                        </div>
                      </div>
                    </div>

                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.Number')</label>
                      <div class="input-group">
                        <input class="form-control" autocomplete="off" name="from_sale">

                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input class="form-control" autocomplete="off" name="to_sale">
                      </div>
                    </div>

                  </div>
                  <!------ End GeneralSaleReportCustomer ----->

                  <!------ begain GeneralSaleReportCustomerReceive ----->
                  <div class="row" v-if="(showDiv['GeneralSaleReportCustomerReceive'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>
                    <div class="col-md-4">
                      <label class="control-label ">@lang('layout.SaleArea') </label>
                      <select name="sale_area_id" id="" class="form-control">
                        <option value="">@lang('layout.Select')</option>
                        @foreach($saleArea as $area)
                        <option value="{{$area->id}}">{{$area->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label class="control-label" style="color: red">@lang('layout.Remained'):
                          <input type="checkbox" class="form-control" name="remian" value="true">
                        </label>
                      </div>
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-4">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                    <div class="col-md-2">
                      <div class="form-group">
                        <label class="control-label" >@lang('layout.TotalItemQty'):
                          <input type="checkbox" class="form-control" name="totalQty" value="true">
                        </label>
                      </div>
                    </div>
                    
                  
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.Number')</label>
                      <div class="input-group">
                        <input class="form-control" autocomplete="off" name="from_sale">

                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input class="form-control" autocomplete="off" name="to_sale">
                      </div>
                    </div>

                  </div>
                  <!------ End GeneralSaleReportCustomerReceive ----->

                  <!------ begain Tatation ----->
                  <div class="row" v-if="(showDiv['taxation'])">

                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedCustomer" label="name" @search="onCustomerSearch" :options="customerList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedCustomer)?null:selectedCustomer.id">
                    </div>

                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectTaxation') </label>
                      <v-select class="vue-select2" v-model="selected_taxation" label="name" :options="taxations">
                      </v-select>
                      <input type="hidden" name="taxation_id" v-model.number="(!selected_taxation)?null:selected_taxation.id">
                    </div>

                  </div>

                  <!------ End Tatation ----->

                  <!------ begain chartofaccountlist ----->
                  <div class="row" v-if="(showDiv['chartofaccountlist'])">

                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-4">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif

                  </div>
                  <!------ End chartofaccountlist ----->

                  <!------ begain ItemProfitAndLostReport ----->
                  <div class="row" v-if="(showDiv['ItemProfitAndLostReport'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-4">
                      <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                      <select name="inventory_category_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectInventoryCategory')</option>
                        @foreach($inventoryCategory as $cat)
                        <option value="{{$cat->id}}">{{$cat->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-2">
                      <label class="control-label ">@lang('layout.Sales') </label>
                      <div class="col-md-12">
                        <input type="checkbox" name="sales" value="on">
                      </div>
                    </div>

                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.Site') </label>
                      <select class="form-control" name="inventory_site">
                        <option value="">@lang('layout.Select')</option>
                        @foreach($inventorySite AS $site)
                        <option value="{{$site->id}}">{{$site->name}}</option>

                        @endforeach

                      </select>
                    </div>

                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectItem') </label>
                      <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist">
                      </v-select>
                      <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                    </div>
                  </div>
                  <!------ End ItemProfitAndLostReport ----->
                  <!------ begain SaleComparisonReportForCustomeres ----->
                  <div class="row" v-if="(showDiv['SaleComparisonReportForCustomeres'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>

                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectItem') </label>
                      <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true">
                      </v-select>
                      <!-- <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id"> -->
                      <input type="hidden" name="item_id" :value="item_id.length > 0 ? item_id:null"> 
                    </div>

                    <!-- div class="form-group">
                      <label class="control-label" style="color: red">@lang('layout.SalesReportInDetails'): 
                        <input type="checkbox" class="form-control" name="sales_report_in_details" v-model="sales_report_in_details"> 
                      </label>
                    </div>
                      <div class="row" v-if="sales_report_in_details">

                      <div class="col-md-3">
                      <label class="control-label ">@lang('layout.Type') </label>
                      <select class="form-control" name="all_general_sale_report">
                        <option value="">@lang('layout.SelectType')</option>
                        <option value="all">@lang('layout.All')</option>
                      </select>
                      </div>

                            <div class="col-md-3">
                                <label class="control-label ">@lang('layout.Unit')(1) </label>
                                <select name="measure_id"  class="form-control">
                                    <option value="">@lang('layout.SelectU/M')</option>
                                    @foreach($measures as  $measure)
                                        <option value="{{$measure->id}}">{{$measure->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Unit')(2) </label>
                                    <select name="measure_id2"  class="form-control">
                                        <option value="">@lang('layout.SelectU/M')</option>
                                        @foreach($measures as  $measure)
                                            <option value="{{$measure->id}}">{{$measure->name}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Unit')(3) </label>
                                    <select name="measure_id3"  class="form-control">
                                        <option value="">@lang('layout.SelectU/M')</option>
                                        @foreach($measures as  $measure)
                                            <option value="{{$measure->id}}">{{$measure->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <br>
                                <div class="col-md-12">
                                  <span style="color: red">@lang('message.SameMeasuresMsg')</span>
                                </div>
                                      
                              </div -->
                    <!--End Measure-->

                  </div>
                  <!------ End SaleComparisonReportForCustomeres ----->   
                  <!------ begain SaleComparisonReport ----->
                  <div class="row" v-if="(showDiv['SaleComparisonReport'])"> 
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.Type') @lang('layout.Report') </label>
                        <select name="type_report" id="" class="form-control">
                        <option value="daily"> @lang('layout.Daily') </option>
                        <option value="weekly"> @lang('layout.Weekly') </option>
                        <option value="monthly"> @lang('layout.Montly') </option>
                        <option value="yearly"> @lang('layout.Yearly') </option>
                        </select>
                    </div>
                    <!-- div class="form-group">
                      <label class="control-label" style="color: red">@lang('layout.SalesReportInDetails'): 
                        <input type="checkbox" class="form-control" name="sales_report_in_details" v-model="sales_report_in_details"> 
                      </label>
                    </div>
                      <div class="row" v-if="sales_report_in_details">

                      <div class="col-md-3">
                      <label class="control-label ">@lang('layout.Type') </label>
                      <select class="form-control" name="all_general_sale_report">
                        <option value="">@lang('layout.SelectType')</option>
                        <option value="all">@lang('layout.All')</option>
                      </select>
                      </div>

                            <div class="col-md-3">
                                <label class="control-label ">@lang('layout.Unit')(1) </label>
                                <select name="measure_id"  class="form-control">
                                    <option value="">@lang('layout.SelectU/M')</option>
                                    @foreach($measures as  $measure)
                                        <option value="{{$measure->id}}">{{$measure->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Unit')(2) </label>
                                    <select name="measure_id2"  class="form-control">
                                        <option value="">@lang('layout.SelectU/M')</option>
                                        @foreach($measures as  $measure)
                                            <option value="{{$measure->id}}">{{$measure->name}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Unit')(3) </label>
                                    <select name="measure_id3"  class="form-control">
                                        <option value="">@lang('layout.SelectU/M')</option>
                                        @foreach($measures as  $measure)
                                            <option value="{{$measure->id}}">{{$measure->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <br>
                                <div class="col-md-12">
                                  <span style="color: red">@lang('message.SameMeasuresMsg')</span>
                                </div>
                                      
                              </div -->
                    <!--End Measure-->

                  </div>
                  <!------ End SaleComparisonReport ----->        
                  <!------ begain CustomerWithoutSales ----->
                  <div class="row" v-if="(showDiv['CustomerWithoutSales'])">
                    <!-- <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div> -->
              

                    <!-- <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectItem') </label>
                      <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true">
                      </v-select> -->
                      <!-- <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id"> -->
                      <!-- <input type="hidden" name="item_id" :value="item_id.length > 0 ? item_id:null">
                    </div> -->
                  </div>
                  <!------ End CustomerWithoutSales ----->
                  <!------ begain GeneralPurchaseReportCustomer ----->
                  <div class="row" v-if="(showDiv['GeneralPurchaseReportCustomer'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedVendor" label="name" @search="onVendorSearch" :options="vendorList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedVendor)?null:selectedVendor.id">
                    </div>

                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.Site') </label>
                      <select class="form-control" name="inventory_site">
                        <option value="">@lang('layout.Select')</option>
                        @foreach($inventorySite AS $site)
                        <option value="{{$site->id}}">{{$site->name}}</option>

                        @endforeach

                      </select>
                    </div>

                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectItem') </label>
                      <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist">
                      </v-select>
                      <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                    </div>
                    @if(systemConfig()[4] != 0 )
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.ContractCode') </label>
                      <v-select class="vue-select2" v-model="selectedContract" label="name" @search="contractSearch" :options="contractlist">
                      </v-select>
                      <input type="hidden" name="order_pur_id" v-model.number="(!selectedContract)?null:selectedContract.id">
                    </div>
                    @endif

                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-4">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                    <div class="col-md-2">
                      <label class="control-label ">@lang('layout.TotalItemQty') </label>
                      <input type="checkbox" name="total_items" value="all">
                      
                    </div>





                  </div>
                  <!------ End GeneralPurchaseReportCustomer ----->
                  <!------ begain GeneralPurchaseVendorPaymentReport ----->
                  <div class="row" v-if="(showDiv['GeneralPurchaseVendorPaymentReport'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as $class)
                        <option value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedVendor" label="name" @search="onVendorSearch" :options="vendorList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedVendor)?null:selectedVendor.id">
                    </div>
                    
                    @if(systemConfig()[4] != 0 )
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.ContractCode') </label>
                      <v-select class="vue-select2" v-model="selectedContract" label="name" @search="contractSearch" :options="contractlist">
                      </v-select>
                      <input type="hidden" name="order_pur_id" v-model.number="(!selectedContract)?null:selectedContract.id">
                    </div>
                    @endif

                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-4">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                    <div class="col-md-2">
                      <div class="form-group">
                        <label class="control-label" style="color: red">@lang('layout.Remained'):
                          <input type="checkbox" class="form-control" name="remian" value="true">
                        </label>
                      </div>
                    </div>

                  </div>
                  <!------ End GeneralPurchaseVendorPaymentReport ----->
                  <!------ begain Customer ----->
                  <div class="row" v-if="(showDiv['Customer'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember')</label>
                      <v-select class="vue-select2" v-model="selectedAllMember" label="name" @search="onAllMemberSearch" :options="allMemberList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedAllMember)?null:selectedAllMember.id">
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                        <option value="">@lang('layout.SelectClass')</option>
                        <option value="Unclassified">Unclassified</option>
                        <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif  
                  </div>
                  <!------ End Customer ----->
                  <!------ begain Customer ----->
                  <div class="row" v-if="(showDiv['summaryAccount'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedAllMember" label="name" @search="onAllMemberSearch" :options="allMemberList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedAllMember)?null:selectedAllMember.id">
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End Customer ----->
                  <!------ begain Member Statement Report By Type ----->
                  <div class="row" v-if="(showDiv['MemberStatementReportByType'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedAllMember" label="name" @search="onAllMemberSearch" :options="allMemberList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedAllMember)?null:selectedAllMember.id">
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End Member Statement Report By Type ----->
                  <!------ begain Employee Statement Report By Type ----->
                  <div class="row" v-if="(showDiv['EmployeeStatementReportByType'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedAllMember" label="name" @search="onAllMemberSearch" :options="allMemberList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedAllMember)?null:selectedAllMember.id">
                    </div>
                    @if(getFinancialClass() =='true') 
                    @permission('financialClass-list')
                    <div class="col-md-6">
                      <label class="control-label"> @lang('menu.FinancialClass')</label>
                      <select name="financial_class_id" class="form-control" >
                          <option value="">@lang('layout.SelectClass')</option>
                          <option value="Unclassified">Unclassified</option>
                          <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                      </select>
                    </div>
                    @endpermission
                    @endif
                  </div>
                  <!------ End Employee Statement Report By Type ----->
                  <!------ begain Customer Report ----->
                  <div class="row" v-if="(showDiv['CustomerReport'])">
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedAllMember" label="name" @search="onAllMemberSearch" :options="allMemberList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedAllMember)?null:selectedAllMember.id">
                    </div>
                    <div  class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                          <option  value="">@lang('layout.SelectClass')</option>
                          @foreach($member_class as  $class)
                          <option  value="{{$class->id}}">{{$class->name}}</option>
                          @endforeach
                      </select>
                    </div>
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectInventorySite') </label>
                      <v-select class="vue-select2" v-model="selectedSite" label="name" :options="{{$inventorySite}}" :multiple="true"> </v-select>
                      <input type="hidden" name="site_id" :value="site_id.length > 0 ? site_id:null">
                    </div>
                    
                  </div>
                  <!------ End Customer Report ----->
                  <!------ begain Vendor ----->
                  <div class="row" v-if="(showDiv['Vendor'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedVendor" label="name" @search="onVendorSearch" :options="vendorList">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedVendor)?null:selectedVendor.id">
                    </div>
                  </div>
                  <!------ End Vendor ----->
                  <!------ begain Drawing ----->
                  <div class="row" v-if="(showDiv['allDrawings'])">
                    <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div>
                  </div>
                  <!------ End Drawing ----->      
                  <!------ begain Flour ----->
                  <div class="row" v-if="(showDiv['allCustoms'])">
                    {{-- <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div> --}}
                  </div>
                  <div class="row" v-if="(showDiv['allLaboratoryTest'])">
                    {{-- <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div> --}}
                  </div>        
                  <div class="row" v-if="(showDiv['allWeighbridge'])">
                    {{-- <div class="col-md-12">
                      <label class="control-label ">@lang('layout.SelectMember') </label>
                      <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                      </v-select>
                      <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div> --}}
                  </div>
                  <!------ End Flour ----->
                  <div class="row">
                    <div class="form-group" id="dynamic_content">
                    </div>
                  </div>
                  <div class="row">
                    <div class="form-group">
                      <div class="col-md-6">
                        <label class="control-label">@lang('layout.Date')</label>
                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                          <option value="CustomDates">@lang('type.CustomDates')</option>
                          <option value="Today">@lang('type.Today')</option>
                          <option value="Yesterday">@lang('type.Yesterday')</option>
                          <option value="ThisWeek">@lang('type.ThisWeek')</option>
                          <option value="LastWeek">@lang('type.LastWeek')</option>
                          <option value="WeekToDate">@lang('type.WeekToDate')</option>
                          <option value="ThisMonth">@lang('type.ThisMonth')</option>
                          <option value="MonthToDate">@lang('type.MonthToDate')</option>
                          <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                          <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                          <option value="ThisYear">@lang('type.ThisYear')</option>
                          <option value="YearToDate">@lang('type.YearToDate')</option>
                        </select>
                      </div>
                      <div class="row" v-if="(showDiv['MemberStatementReportByType'])">
                        <div class="col-md-3">
                          <label class="control-label">@lang('layout.TotalCurrency') </label>
                          <select class="form-control" v-model="selected_currency_total" >
                            <option v-for="curre in currency_total" :value="curre">@{{ curre.code }}</option>
                          </select>
                          <input type="hidden" name="currency_total" v-bind:value="(selected_currency_total)?selected_currency_total.code:null"/>
                          {{-- <label class="control-label">@lang('layout.Currency') </label>
                          <select class="form-control" name="currency" >
                              <option  value="">@lang('layout.Select')</option>
                            @foreach($currency as  $cur)
                              <option  value="{{$cur->code}}">{{$cur->code}}</option>
                            @endforeach
                          </select> --}}
                        </div>
                        <div class="col-md-3">
                          <span v-if="selected_currency_total">
                            <span v-if="selected_currency_total.code != code">
                              <label class="control-label">@lang('layout.Rate') </label>
                              <div class="input-group">
                                <input v-model="selected_currency_total.rate" class="form-control" name="currency_rate" type="number" step="any" min="0"  >
                                <span class="input-group-addon">@{{selected_currency_total.symbol}}</span>
                              </div>
                            </span>
                          </span>
                        </div>
                      </div>
                      <div class="row" v-if="(showDiv['EmployeeStatementReportByType'])">
                        <div class="col-md-3">
                          <label class="control-label">@lang('layout.TotalCurrency') </label>
                          <select class="form-control" v-model="selected_currency_total" >
                            <option v-for="curre in currency_total" :value="curre">@{{ curre.code }}</option>
                          </select>
                          <input type="hidden" name="currency_total" v-bind:value="(selected_currency_total)?selected_currency_total.code:null"/>
                          {{-- <label class="control-label">@lang('layout.Currency') </label>
                          <select class="form-control" name="currency" >
                              <option  value="">@lang('layout.Select')</option>
                            @foreach($currency as  $cur)
                              <option  value="{{$cur->code}}">{{$cur->code}}</option>
                            @endforeach
                          </select> --}}
                        </div>
                        <div class="col-md-3">
                          <span v-if="selected_currency_total">
                            <span v-if="selected_currency_total.code != code">
                              <label class="control-label">@lang('layout.Rate') </label>
                              <div class="input-group">
                                <input v-model="selected_currency_total.rate" class="form-control" name="currency_rate" type="number" step="any" min="0"  >
                                <span class="input-group-addon">@{{selected_currency_total.symbol}}</span>
                              </div>
                            </span>
                          </span>
                        </div>
                      </div>
                      <div class="row" v-if="(showDiv['CustomerReport'])">
                        <div class="col-md-3">
                          <label class="control-label">@lang('layout.TotalCurrency') </label>
                          <select class="form-control" v-model="selected_currency_total" >
                            <option v-for="curre in currency_total" :value="curre">@{{ curre.code }}</option>
                          </select>
                          <input type="hidden" name="currency_total" v-bind:value="(selected_currency_total)?selected_currency_total.code:null"/>
                          {{-- <label class="control-label">@lang('layout.Currency') </label>
                          <select class="form-control" name="currency" >
                              <option  value="">@lang('layout.Select')</option>
                            @foreach($currency as  $cur)
                              <option  value="{{$cur->code}}">{{$cur->code}}</option>
                            @endforeach
                          </select> --}}
                        </div>
                        <div class="col-md-3">
                          <span v-if="selected_currency_total">
                            <span v-if="selected_currency_total.code != code">
                              <label class="control-label">@lang('layout.Rate') </label>
                              <div class="input-group">
                                <input v-model="selected_currency_total.rate" class="form-control" name="currency_rate" type="number" step="any" min="0"  >
                                <span class="input-group-addon">@{{selected_currency_total.symbol}}</span>
                              </div>
                            </span>
                          </span>
                        </div>
                      </div>
                      <div class="col-md-12" v-show="period == 'CustomDates'" >
                        <div class="form-group">
                          <label class="control-label"> @lang('layout.Date')</label>
                          <div class="input-group">
                            <input class="form-control date" id="range-from-example" name="from_date" v-model="from_date" autocomplete="off">

                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example" name="to_date" v-model="to_date" autocomplete="off">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="icheck-list">
                      <label class="col-md-4" >
                        <input type="radio" name="route" :checked="wichType=='pdf'" v-model="wichType" value="pdf" @click="toggleType('pdf')" class="icheck"> @lang('layout.PDF')
                      </label>
                      <label class="col-md-4" >
                        <input type="radio" name="route" value="excell" @click="toggleType('excell')" :checked="wichType!='pdf'" v-model="wichType" class="icheck"> @lang('layout.Excel')
                      </label>
                    </div>
                  </div>
                </div>
              </div>
              <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                  @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                  @lang('layout.Cancel')
                </button>
              </div>
            </form> 
          </div>
          <!--Begin Custome Report-->
          <div class="tab-pane" id="tab2"> 
            <div class="portlet light bordered">
              <div class="portlet-body">
                <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                  @csrf
                  <div v-if="(showDiv['allDrawings'])">
                    <input type="hidden" name="part_name" value="drawing_index">
                  </div>
                  <div v-if="(showDiv['memberTransferList'])">
                    <input type="hidden" name="part_name" value="memberTransfer_index">
                  </div> 
                  <div v-if="(showDiv['SalaryDetailsList'])">
                    <input type="hidden" name="part_name" value="salaryDetails_index">
                  </div>
                  <div v-if="(showDiv['chartofaccountlist'])">
                    <input type="hidden" name="part_name" value="chartofaccount_index">
                  </div>
                  <div v-if="(showDiv['GeneralSaleReport'])">
                    <input type="hidden" name="part_name" value="GeneralSale_index">
                  </div>
                  <div v-if="(showDiv['GeneralSaleReportCustomer'])">
                    <input type="hidden" name="part_name" value="GeneralSaleReportCustomer_index">
                  </div>
                  <div v-if="(showDiv['GeneralSaleReportCustomerReceive'])">
                    <input type="hidden" name="part_name" value="GeneralSaleReportCustomerReceive_index">
                  </div>
                  <div v-if="(showDiv['inventory_general_report'])">
                    <input type="hidden" name="part_name" value="inventory_general_report_index">
                  </div>
                  <div v-if="(showDiv['GeneralPurchaseReportCustomer'])">
                    <input type="hidden" name="part_name" value="GeneralPurchaseReportCustomer_index">
                  </div>

                  <div v-if="(showDiv['MemberStatementReportByType'])">
                    <input type="hidden" name="part_name" value="member_statment_report_by_type">
                  </div>
                  
                  <div v-if="(showDiv['EmployeeStatementReportByType'])">
                    <input type="hidden" name="part_name" value="employee_statment_report_by_type">
                  </div>

                  <div v-if="(showDiv['assemblylist'])">
                    <input type="hidden" name="part_name" value="assemblylist_index">
                  </div>
                  <div v-if="(showDiv['general_build_report'])">
                    <input type="hidden" name="part_name" value="general_build_report_index">
                  </div>
                  <div v-if="(showDiv['GeneralPurchaseVendorPaymentReport'])">
                    <input type="hidden" name="part_name" value="GeneralPurchaseVendorPaymentReport_index">
                  </div>
                  <div v-if="(showDiv['Customer'])">
                    <input type="hidden" name="part_name" value="member_statment">
                  </div>
                  <div v-if="(showDiv['summaryAccount'])">
                    <input type="hidden" name="part_name" value="summaryAccountStatement">
                  </div>
                  <div v-if="(showDiv['SaleComparisonReportForCustomeres'])">
                    <input type="hidden" name="part_name" value="SaleComparisonReportForCustomeres_index">
                  </div>
                  <div v-if="(showDiv['SaleComparisonReport'])">
                    <input type="hidden" name="part_name" value="SaleComparisonReport_index">
                  </div>
                  <div v-if="(showDiv['ItemProfitAndLostReport'])">
                    <input type="hidden" name="part_name" value="ItemProfitAndLostReport_index">
                  </div>
                  <div v-if="(showDiv['CustomerWithoutSales'])">
                    <input type="hidden" name="part_name" value="CustomerWithoutSales_index">
                  </div>
                  <div v-if="(showDiv['adjustmentAndItemNoneCostReport'])">
                    <input type="hidden" name="part_name" value="adjustmentAndItemNoneCostReport_index">
                  </div>
                  <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                        <div class="form-group">
                          <table class="table table-striped table-bordered table-advance table-hover">
                              <tr>
                                  <td style="text-align: center;">@{{ row.Name }}</td>
                              </tr>
                              <tr>
                                  <td style="text-align: center;">
                                      <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                      <label class="switch">
                                          <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                          :checked="row.checkedColumn" >
                                          <span class="slider round"></span>
                                      </label>
                                      <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                          <option value="">@lang('layout.Select')</option>
                                          <option value="2">2 %</option>
                                          <option value="6">6 %</option>
                                          <option value="10">10 %</option>
                                          <option value="15">15 %</option>
                                          <option value="20">20 %</option>
                                          <option value="25">25 %</option>
                                          <option value="30">30 %</option>
                                          <option value="40">40 %</option>
                                          <option value="50">50 %</option>
                                          <option value="60">60 %</option>
                                      </select>
                                  </td>
                              </tr>
                          </table>
                        </div>
                    </div>
                  </div>
                  <div class="margiv-top-10">
                    <button type="button" @click="saveCustomeReport($event)" class="btn blue"> <i class="fa fa-save"></i> @lang('layout.Submit') </button>
                    <button type="button" class="btn btn-danger" @click="close">
                      @lang('layout.Cancel')
                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>
          <!--End Custome Report-->
        </div>
      </div>
    </div>
  </modal>
</div>
<!----- End Modal ------>
<br>
<br>
<!-- BEGIN TAB PORTLET-->
<div class="row">
  <div class="portlet light bordered">
    <!-- BEGIN TAB PORTLET-->
    <div class="portlet light bordered">
      <div class="portlet-title">
        <div class="caption">
          <i class="icon-anchor font-green-sharp"></i>
          <span class="caption-subject font-green-sharp bold uppercase">@lang('menu.Report')</span>
        </div>
        <div class="actions">
        </div>
      </div>
      <div class="portlet-body">
        <div id="company">
          <company @company="setCompany"></company>
        </div>
        <!----------------BEGIN FinancialReport ----------------->
        <div class="row">
          @if(\Entrust::can('financialReport-list') || \Entrust::can('balancesheet-list') )
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('financial')">
                        <a class="report_a_title"><span id="financial_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}} "> </span> @lang('layout.FinancialReport')</a>
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="financial">
                        <table class="table table-striped  table-advance table-hover">
                                @permission(['financialReport-list'])
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="financial_income" class="report_a"> @lang('layout.IncomeStatement')</a>
                                    </td>
                                </tr>
                                @endif
                                @permission(['balancesheet-list'])
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()" id="blanceSheet" class="report_a"> @lang('layout.BalanceSheet')</a>
                                    </td>
                                </tr>
                                @endif
                        </table>
                    </div>
                </div>
            </div>
          @endif     
        </div>
        <br>
        <!----------------END FinancialReport ----------------->        
        <!----------------BEGIN Account ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('account')">
                        <a class="report_a_title"><span id="account_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Account') </a>
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="account">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="chartofaccountlist" class="report_a"> @lang('layout.Account')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()" id="transferAccounts" class="report_a"> @lang('layout.TransferAccount')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="journalEntry" class="report_a"> @lang('layout.JournalEntry')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()" id="discount_account_tocustomer" class="report_a"> @lang('layout.DiscountToCustomer')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="discount_account_from_vendor" class="report_a"> @lang('layout.DiscountFromVendor')</a>
                                    </td>
                                </tr>
                                
                        </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Account ----------------->        
        <!----------------BEGIN Inventory ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('inventory')">
                        <a class="report_a_title"><span id="inventory_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Inventory') </a> 
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="inventory">
                        <table class="table table-striped  table-advance table-hover">
                                @if(!auth()->user()->sites)
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="allInventoryReport" class="report_a"> @lang('layout.Inventory')</a>
                                    </td>
                                </tr>
                                @endif
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()" id="adjustment" class="report_a"> @lang('layout.Adjustment')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="InventorySite" class="report_a"> @lang('layout.InventorySite')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()" id="inventoryCategory" class="report_a"> @lang('layout.InventoryCategory')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="inventory_transfer_detail" class="report_a"> @lang('layout.InventoryTransfer')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="inventory_general_report" class="report_a"> @lang('layout.InventoryGeneralReport')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="procurement" class="report_a"> @lang('layout.Procurement')</a>
                                    </td>
                                </tr>
                                @if(systemConfig()[4] != 0 )
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="adjustmentRoll" class="report_a"> @lang('layout.AdjustmentRoll')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="inventory_transfer_detailRoll" class="report_a"> @lang('menu.InventoryTransferRoll')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="inventory_general_report_code" class="report_a"> @lang('layout.InventoryGeneralReportCode')</a>
                                    </td>
                                </tr>
                                @endif
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()" id="adjustmentAndItemNoneCostReport" class="report_a">@lang('layout.AdjustmentAndItemNoneCostReport')</a>
                                    </td>
                                </tr>

                        </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Inventory ----------------->
        <!----------------BEGIN Service ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('service')">
                        <a class="report_a_title"><span id="service_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Service') </a>
                        
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="service">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="servicelist" class="report_a"> @lang('layout.Service')</a>
                                    </td>
                                </tr>
                                
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Service ----------------->        
        <!----------------BEGIN Assembly ----------------->
        @if(systemConfig()[0] != 0)
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('assembly')">
                        <a class="report_a_title"><span id="assembly_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Assembly') </a>
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="assembly">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="assemblylist" class="report_a"> @lang('layout.Assembly')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="build_report" class="report_a"> @lang('layout.Build')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="all_build_detail" class="report_a"> @lang('layout.AllBuildDetail')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="general_build_report" class="report_a"> @lang('layout.GeneralBuild')</a>
                                    </td>
                                </tr> 
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="general_package_build_report" class="report_a"> @lang('layout.GeneralPackageBuild')</a>
                                    </td>
                                </tr>
                                
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        @endif
        <br>
        <!----------------END Assembly ----------------->
        <!----------------BEGIN Sales ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('sale')">
                        <a class="report_a_title"><span id="sale_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('menu.Sales') </a>
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="sale">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="SaleList" class="report_a"> @lang('layout.Sale')</a>
                                    </td>
                                </tr><tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="invoicelist" class="report_a"> @lang('layout.Invoice')</a>
                                    </td>
                                </tr><tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="saleOrder" class="report_a"> @lang('layout.SaleOrder')</a>
                                    </td>
                                </tr><tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="estimates" class="report_a"> @lang('layout.Estimate')</a>
                                    </td>
                                </tr>
                                @if(systemConfig()[4] != 0 )
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="invoicelistRoll" class="report_a"> @lang('menu.InvoiceRoll')</a>
                                    </td>
                                </tr>
                                @endif
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="GeneralSaleReport" class="report_a"> @lang('layout.GeneralSaleReport')</a>
                                    </td>
                                </tr><tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="GeneralSaleReportCustomer" class="report_a"> @lang('layout.GeneralSaleReportCustomer')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="GeneralSaleReportCustomerReceive" class="report_a"> @lang('layout.GeneralSaleReport') @lang('layout.CustomerReceive')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="allFactorPrint" class="report_a"> @lang('layout.Print') @lang('layout.Factor')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="allGrnReport" class="report_a"> @lang('layout.Print') @lang('layout.GRN')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="SaleComparisonReportForCustomeres" class="report_a"> @lang('layout.SaleComparisonReportForCustomeres')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="SaleComparisonReport" class="report_a"> @lang('layout.SaleComparisonReport')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="ItemProfitAndLostReport" class="report_a"> @lang('layout.ItemProfitAndLostReport')</a>
                                    </td>
                                </tr>
                                @if(getTaxation() == 'true')
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="taxation" class="report_a"> @lang('menu.Taxation')</a>
                                    </td>
                                </tr>
                                @endif
                                @if(getSaleTaxation() == 'true')
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="saleTaxation" class="report_a"> @lang('menu.Taxation')</a>
                                    </td>
                                </tr> 
                                @endif
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="CustomerWithoutSales" class="report_a"> @lang('layout.CustomerWithoutSales')</a>
                                    </td>
                                </tr>

                          </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Sales ----------------->
        <!----------------BEGIN Purchase ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('purchase')">
                        <a class="report_a_title"><span id="purchase_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Purchase') </a>
                        
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="purchase">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="purchaselist" class="report_a"> @lang('layout.WriteChecks')</a>
                                    </td>
                                </tr> <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="builllist" class="report_a"> @lang('layout.EnterBills')</a>
                                    </td>
                                </tr> <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="purchaseorderlist" class="report_a"> @lang('layout.PurchaseOrder')</a>
                                    </td>
                                </tr> 
                                @if(systemConfig()[4] != 0 )
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="builllistRoll" class="report_a"> @lang('menu.EnterBillsRoll')</a>
                                    </td>
                                </tr> 
                                @endif
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="GeneralPurchaseReportCustomer" class="report_a"> @lang('layout.GeneralPurchaseReportCustomer')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="GeneralPurchaseVendorPaymentReport" class="report_a"> @lang('layout.GeneralPurchaseVendorPaymentReport')</a>
                                    </td>
                                </tr>
                                
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Purchase ----------------->            
        <!----------------BEGIN Expense ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('expense')">
                        <a class="report_a_title"><span id="expense_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Expense') </a>
                        
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="expense">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="ExpenseList" class="report_a"> @lang('layout.Expense')</a>
                                    </td>
                                </tr> <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="dailyExpenses" class="report_a"> @lang('layout.DailyExpense')</a>
                                    </td>
                                </tr>
                                
                        </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Expense ----------------->            
        <!----------------BEGIN Contract ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('contract')">
                        <a class="report_a_title"><span id="contract_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Contract') </a>
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="contract">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="contract" class="report_a"> @lang('layout.Contract')</a>
                                    </td>
                                </tr> <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="sendMoney" class="report_a"> @lang('layout.SendMoney')</a>
                                    </td>
                                </tr>
                                
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Contract ----------------->          
        <!----------------BEGIN Pay ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('pay')">
                        <a class="report_a_title"><span id="pay_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Payment') </a> 
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="pay">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="all_pay" class="report_a"> @lang('layout.Payment')</a>
                                    </td>
                                </tr> <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="receive" class="report_a"> @lang('layout.Receive')</a>
                                    </td>
                                </tr>
                                
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Pay ----------------->              
        <!----------------BEGIN Loan ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('loan')">
                        <a class="report_a_title"><span id="loan_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('menu.DepositAndWithdrawal') </a>
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="loan">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="allLoanReports" class="report_a"> @lang('menu.DepositAndWithdrawal')</a>
                                    </td>
                                </tr>
                                
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Loan ----------------->           
        <!----------------BEGIN Employee ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('employee')">
                        <a class="report_a_title"><span id="employee_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Employee') </a>
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="employee">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="SalaryDetailsList" class="report_a"> @lang('layout.SalaryDetails')</a>
                                    </td>
                                </tr> <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="all_payrolls" class="report_a"> @lang('layout.Payroll')</a>
                                    </td>
                                </tr> <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="all_payments" class="report_a"> @lang('layout.PaySalary')</a>
                                    </td>
                                </tr>
                                
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Employee ----------------->          
        <!----------------BEGIN MemberStatement ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('member_statement')">
                      <a class="report_a_title"><span id="member_statement_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.MemberStatement') </a>
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="member_statement">
                        <table class="table table-striped  table-advance table-hover">
                          <tr>
                            <td class="report_list">
                              <a onClick="report_by_type_pdf()"  id="Customer" class="report_a"> @lang('layout.Members')</a>
                            </td>
                          </tr> 
                          <tr>
                            <td class="report_list">
                              <a onClick="report_by_type_pdf()"  id="summaryAccount" class="report_a"> @lang('layout.AccountsSumary')</a>
                            </td>
                          </tr> 
                          <tr>
                            <td class="report_list">
                              <a href="{{route('memberStatement.create')}}"   class="report_a"> @lang('layout.MemberStatement')</a>
                            </td>
                          </tr> 
                          <tr>
                            <td class="report_list">
                              <a onClick="report_by_type_pdf()"  id="CustomerReport" class="report_a"> @lang('layout.Report') @lang('layout.Members') </a>
                            </td>
                          </tr> 
                          <tr>
                            <td class="report_list">
                              <a onClick="report_by_type_pdf()"  id="MemberStatementReportByType" class="report_a"> @lang('layout.MemberStatementReportByType')</a>
                            </td>
                          </tr>
                          <tr>
                            <td class="report_list">
                              <a onClick="report_by_type_pdf()"  id="EmployeeStatementReportByType" class="report_a"> @lang('layout.EmployeeStatementReportByType')</a>
                            </td>
                          </tr>    
                        </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END MemberStatement ----------------->           
        
        <!----------------BEGIN Drawing ----------------->
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('drawing')">
                        <a class="report_a_title"><span id="drawing_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Drawing') </a>
                        
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="drawing">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="allDrawings" class="report_a"> @lang('layout.Drawing')</a>
                                    </td>
                                </tr><tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="memberTransferList" class="report_a"> @lang('layout.MemberTransfer')</a>
                                    </td>
                                </tr>
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        <br>
        <!----------------END Drawing ----------------->            
        
        <!----------------BEGIN Flour----------------->
        @if(getFlour()=="true")
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="mt-widget-1">
                    <div class="mt-icon report" onclick="showBody('flour')">
                        <a class="report_a_title"><span id="flour_fa" class="fa {{(session()->get("system_direction") == "rtl")?'fa-angle-left':'fa-angle-right'}}"> </span> @lang('layout.Weighbridge') - @lang('menu.LaboratoryTest') - @lang('layout.Customs') </a>
                        
                    </div>
                    <div class="mt-img">
                    <i class=""></i></div>
                    <div class="mt-body"  id="flour">
                        <table class="table table-striped  table-advance table-hover">
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="allCustoms" class="report_a"> @lang('layout.Customs')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="allLaboratoryTest" class="report_a"> @lang('menu.LaboratoryTest')</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="report_list">
                                        <a onClick="report_by_type_pdf()"  id="allWeighbridge" class="report_a"> @lang('layout.Weighbridge')</a>
                                    </td>
                                </tr>
                          </table>
                    </div>
                </div>
            </div>  
        </div>
        @endif
        <br>
        <!----------------END Flour ----------------->      

        <div class="tabbable tabbable-tabdrop">
          <!-- <ul class="nav nav-tabs">
              <li class="active">
                  <a href="#tab1" data-toggle="tab">Standard Report</a>
              </li>
          </ul> -->
          <div class="tab-content">
            <!-- </div> -->
          </div>
        </div>
        <p> &nbsp; </p>
        <p> &nbsp; </p>
      </div>
    </div>
    <!-- END TAB PORTLET-->
  </div>
</div>
@stop
@include('groupCompanyFilter.select')
@push('scripts')
<script type="text/javascript">
  Vue.component("v-select", VueSelect.VueSelect);
  var taxations       = {!!$taxations!!};
  var expenseCategory = {!!$expenseCategory!!}; 

  //Begin Custome Report 
  
  var cust_rep_drawing = {!!customeReportNewData('drawing_index')!!};
  var cust_rep_memberTransfer = {!!customeReportNewData('memberTransfer_index')!!};
  var cust_rep_SalaryDetails = {!!customeReportNewData('salaryDetails_index')!!};
  var chartofaccountDetails = {!!customeReportNewData('chartofaccount_index')!!};
  var GeneralSaleDetails = {!!customeReportNewData('GeneralSale_index')!!};
  var GeneralSaleReportCustomerDetails = {!!customeReportNewData('GeneralSaleReportCustomer_index')!!};
  var GeneralSaleReportCustomerReceiveDetails = {!!customeReportNewData('GeneralSaleReportCustomerReceive_index')!!};
  var inventory_general_reportDetails = {!!customeReportNewData('inventory_general_report_index')!!};
  var GeneralPurchaseReportCustomerDetails = {!!customeReportNewData('GeneralPurchaseReportCustomer_index')!!};
  var assemblylistDetails = {!!customeReportNewData('assemblylist_index')!!};
  var general_build_reportDetails = {!!customeReportNewData('general_build_report_index')!!};
  var GeneralPurchaseVendorPaymentReportDetails = {!!customeReportNewData('GeneralPurchaseVendorPaymentReport_index')!!};
  var CustomerDetails = {!!customeReportNewData('member_statment')!!};
  var summaryAccountDetails = {!!customeReportNewData('summaryAccountStatement')!!};
  var memberStatementRepostByTypeDetails = {!!customeReportNewData('member_statment_report_by_type')!!};
  var employeeStatementRepostByTypeDetails = {!!customeReportNewData('employee_statment_report_by_type')!!};
  var SaleComparisonReportForCustomeresDetails = {!!customeReportNewData('SaleComparisonReportForCustomeres_index')!!};
  var SaleComparisonReportDetails = {!!customeReportNewData('SaleComparisonReport_index')!!};
  var ItemProfitAndLostReportDetails = {!!customeReportNewData('ItemProfitAndLostReport_index')!!};
  var CustomerWithoutSalesDetails = {!!customeReportNewData('CustomerWithoutSales_index')!!};
  var adjustmentAndItemNoneCostReportDetails = {!!customeReportNewData('adjustmentAndItemNoneCostReport_index')!!};

  //End Custome Report
 // GeneralSaleReportCustomer
 //
  // register modal component
  var Modal = Vue.component('modal', {
    template: '#modal-template',
    methods: {
      ok: function() {
        this.$emit('ok')
      }
    }
  });

  new Vue({
    el: '#company',
    methods: {
      setCompany: function(event) {
        window.location.reload()
      }
    }
  });

  var currency = {!! json_encode($currency) !!};
  var currency_total = {!! json_encode($currency_total) !!};
  var code = '{!! getHomeCurrency()['code'] !!}';
  var vm = new Vue({
    el: '#app',
    data: {
      period: 'CustomDates',
      from_date: null,
      to_date: null,
      showModal: false,
      selectedMember: null,
      memberlist: [],
      wichType: 'pdf',
      ////inventory
      selectedContract: null,
      selectedItem: null,
      selectedItem1: null,

      selectedSite: null,
      site_id: [],

      contractlist: [],
      itemlist: [],
      item_id: [],

      currency: currency,
      currency_total: currency_total,
      selected_currency: null,
      selected_currency_total: null,
      code: code,

      //////Sale
      selectedCustomer: null,
      customerList: [],

      selectedVendor: null,
      vendorList: [],

      selectedEmployee: null,
      employeeList: [],

      allMemberList:[],
      selectedAllMember: null,

      selectedCategory: null,
      categoryList: [],
      showDiv: [],
      sales_report_in_details: '',

      taxations: taxations,
      selected_taxation: null,

      expenseCategory:expenseCategory,
      selected_expense_category:null,
      financial_classes: {!!getFinancialClassList()!!},

      customReportData:[],
      cust_rep:null
    },
    created: function() {},
    mounted: function() {
      this.showDiv['discount_account_tocustomer'] = false;
      this.showDiv['discount_account_from_vendor'] = false;
      this.showDiv['allInventoryReport'] = false;
      this.showDiv['Vendor'] = false;
      this.showDiv['Customer'] = false;
      this.showDiv['summaryAccount'] = false;
      this.showDiv['GeneralSaleReport'] = false;

    },
    watch: {
      selectedItem: function(newVal, oldVal) {
        let x = [];
        newVal.forEach(function(e) {
          x.push(e.id);
        });

        this.item_id = x;
        console.log('x value');
        console.log(x);
      },
      selectedSite: function(newVal, oldVal) {
        let x = [];
        newVal.forEach(function(e) {
          x.push(e.id);
        });

        this.site_id = x;
      }
    },

    methods: {
      toggleType(type = null) {

        this.wichType = type;
        if (type == 'excell') {
          $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
        } else {
          $('#d_form').attr('action', "{{route('export.PDFAll')}}");
        }


      },
      onMemberSearch(search, loading) {
        loading(true);
        this.searchMember(search, loading, this);
      },

      //ajax call to get items
      searchMember(search, loading, vm) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'anyTable',
              'search_column': 'name',
              'table_name': 'members',
              keyword: search,
            }
          })
          .then(function(response) {
            this.memberlist = [];
            if (response.data.length > 0) {
              vm.memberlist = response.data;
              console.log('data', vm.memberlist);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      //ajax call to get dates
      getDates() {
        setTimeout((function () {
          vm.getDate(vm.period);
            // console.log(12);
        }), 2e2);
      },
      getDate(period) {
        if (period) {
          // console.log(3232, period);
          if (period != 'CustomDates') {
            axios.get("{{route('callMethod.search')}}", {
              params: {
                method_name: 'getDatesByPeriod',
                period: period,
              }
            })
            .then(function(response) {
              vm.from_date = null;
              vm.to_date = null;
              if (response.data) {
                vm.from_date = response.data.start;
                vm.to_date = response.data.end;
                // console.log('data', response.data);
              }
            })
            .catch(function(error) {
              vm.period = 'CustomDates';
              vm.from_date = null;
              vm.to_date = null;
            })
          } else {
            vm.from_date = null;
            vm.to_date = null;
          }
        }
      },
      onItemSearch(search, loading) {
        loading(true);
        this.searchItem(search, loading, this);
      },

      //ajax call to get items
      searchItem(search, loading, vm) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'anyTable',
              'search_column': 'name',
              'table_name': 'items',
              keyword: search,
            }
          })
          .then(function(response) {
            this.itemlist = [];
            if (response.data.length > 0) {
              vm.itemlist = response.data;
              console.log('data', vm.itemlist);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      contractSearch(search, loading) {
        loading(true);
        this.contractSearches(search, loading, this);
      },

      //ajax call to get items
      contractSearches(search, loading, vm) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'purchaseOrderRoll',
              keyword: search,
            }
          })
          .then(function(response) {
            this.contractlist = [];
            if (response.data.length > 0) {
              vm.contractlist = response.data;
              console.log('data', vm.contractlist);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      onCustomerSearch(search, loading) {
        loading(true);
        this.searchCustomer(search, loading, this);
      },

      //ajax call to get items
      searchCustomer(search, loading, vm) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'member',
              type: 'Customer',
              search: search,
            }
          })
          .then(function(response) {
            this.customerList = [];
            if (response.data.length > 0) {
              vm.customerList = response.data;
              console.log('data', vm.customerList);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      onVendorSearch(search, loading) {
        loading(true);
        this.searchVendor(search, loading, this);
      },

      //ajax call to get items
      searchVendor(search, loading, vm) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'member',
              type: 'Vendor',
              search: search,
            }
          })
          .then(function(response) {
            this.vendorList = [];
            if (response.data.length > 0) {
              vm.vendorList = response.data;
              console.log('data', vm.vendorList);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      onCategorySearch(search, loading) {
        loading(true);
        this.searchCategory(search, loading, this);
      },

      //ajax call to get items
      searchCategory(search, loading, vm) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'member',
              type: 'Vendor',
              search: search,
            }
          })
          .then(function(response) {
            this.categoryList = [];
            if (response.data.length > 0) {
              vm.categoryList = response.data;
              console.log('data', vm.categoryList);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      onEmployeeSearch(search, loading) {
        loading(true);
        this.searchEmployee(search, loading, this);
      },

      //ajax call to get items 
      searchEmployee(search, loading, vm) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'member',
              type: 'Employee',
              search: search,
            }
          })
          .then(function(response) {
            this.employeeList = [];
            console.log('nnnnnn',response)
            if (response.data.length > 0) {
              vm.employeeList = response.data;
              console.log('data', vm.employeeList);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      },

      /////////////////////////////////////////////////
      onAllMemberSearch(search, loading) {
        loading(true);
        this.searchAllMember(search, loading, this);
      },

      //ajax call to get items 
      searchAllMember(search, loading, vm) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'member',
              type: null,
              search: search,
            }
          })
          .then(function(response) {
            this.allMemberList = [];
            if (response.data.length > 0) {
              vm.allMemberList = response.data;
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      /////////////////////////////////////////////////
      ok: function() {
        // alert('you clicked me');
        this.showModal = !this.showModal;
        this.toggleType(this.wichType);

      },
      close: function(e) {
        this.showModal = !this.showModal;
        this.wichType = 'pdf';
        this.customReportData = [];
      },
      getModalContent(myData) {
        //Your other code that launches the modal
        this.showModal = true;
        this.$nextTick(function() {
          $(document).ready(function() {

            $(".date").persianDatepicker(modelDate());
            document.getElementById('dynamic_content').innerHTML = myData;

          });
        })
      },
      saveCustomeReport()
      {
        var url = "{{route('customeReport.storeCustomeReport')}}";
            form_id = 'saveCustomeReport';
            var data = $('#' + form_id).serialize();

            toggleBlock(true);
            axios.post(url, data)
                .then(function (response) {
                    toggleBlock(0);
                    console.log('resdss',response)
                    if (response.data.result == 1) {
                        $('#saveCustomeReport').trigger('reset');
                        //$('#success-sound')[0].play();
                        toastr.success('', response.data.message);
                        location.reload();
                        
                    }
                    else {
                        var message = "{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('', message);
                    }
                })
                .catch(function (error) {
                  toggleBlock(0);
                    console.log(error);
                    var message = "{{__('message.Warning')}}";
                    //$('#error-sound')[0].play();
                    toastr.warning('', message);
                });
      }
    },
  });

  function report_by_type_pdf(e) {
    $('#show-modal').click();
    var myid = event.target.id;
    var type_id = myid;
    for (obj in vm.showDiv) {
      vm.showDiv[obj] = false;
    }
    vm.showDiv[type_id] = true;
    ////begain Discount
    if (type_id == 'discount_account_tocustomer') {
      var myhtml = `<input type="hidden" name="type" value="discount_account_tocustomer"/>`;
      vm.getModalContent(myhtml);
    }
    ///////End Discount
    ////begain Discount
    if (type_id == 'discount_account_from_vendor') {
      var myhtml = `<input type="hidden" name="type" value="discount_account_from_vendor"/>`;
      vm.getModalContent(myhtml);
    }
    ///////End Discount
    //////////Begain Account
    if (type_id == 'chartofaccountlist') {
      var myhtml = `<input type="hidden" name="type" value="chartofaccountlist"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(chartofaccountDetails.number)?'checked':'',column_percentage:(chartofaccountDetails.number___percent)?chartofaccountDetails.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(chartofaccountDetails.date)?'checked':'',column_percentage:(chartofaccountDetails.date___percent)?chartofaccountDetails.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(chartofaccountDetails.description)?'checked':'',column_percentage:(chartofaccountDetails.description___percent)?chartofaccountDetails.description___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(chartofaccountDetails.name)?'checked':'',column_percentage:(chartofaccountDetails.name___percent)?chartofaccountDetails.name___percent:''},
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(chartofaccountDetails.account)?'checked':'',column_percentage:(chartofaccountDetails.account___percent)?chartofaccountDetails.account___percent:''},
                 {Name: '@lang("layout.Equity")', column_name: 'equity',checkedColumn:(chartofaccountDetails.equity)?'checked':'',column_percentage:(chartofaccountDetails.equity___percent)?chartofaccountDetails.equity___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(chartofaccountDetails.amount)?'checked':'',column_percentage:(chartofaccountDetails.amount___percent)?chartofaccountDetails.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(chartofaccountDetails.currency)?'checked':'',column_percentage:(chartofaccountDetails.currency___percent)?chartofaccountDetails.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(chartofaccountDetails.rate)?'checked':'',column_percentage:(chartofaccountDetails.rate___percent)?chartofaccountDetails.rate___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(chartofaccountDetails.user)?'checked':'',column_percentage:(chartofaccountDetails.user___percent)?chartofaccountDetails.user___percent:''},
                 
                ];
 
      vm.cust_rep = chartofaccountDetails
    }
    /////////End Account    
    
    //////////Begain account_all_transactions
    if (type_id == 'account_all_transactions') {
      var myhtml = `<input type="hidden" name="type" value="account_all_transactions"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End account_all_transactions



    //////Begain TransferAccount
    if (type_id == 'transferAccounts') {
      var myhtml = `<input type="hidden" name="type" value="transferAccounts"/>`;
      vm.getModalContent(myhtml);
    }
    //////////End TransferAccount


    //////////Begain JOurnalEntry 
    if (type_id == 'journalEntry') {
      var myhtml = `<input type="hidden" name="type" value="journalEntry"/>`;
      vm.getModalContent(myhtml);
    }
    //////////End JournalEntry


    ////////Begain Inventory
    if (type_id == 'allInventoryReport') {
      var myhtml = `<input type="hidden" name="type" value="allInventoryReport"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Inventory   


    ////////Begain Inventory
    if (type_id == 'inventory_general_report') {
      var myhtml = `<input type="hidden" name="type" value="inventory_general_report"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(inventory_general_reportDetails.record)?'checked':'',column_percentage:(inventory_general_reportDetails.record___percent)?inventory_general_reportDetails.record___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(inventory_general_reportDetails.description)?'checked':'',column_percentage:(inventory_general_reportDetails.description___percent)?inventory_general_reportDetails.description___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(inventory_general_reportDetails.name)?'checked':'',column_percentage:(inventory_general_reportDetails.name___percent)?inventory_general_reportDetails.name___percent:''},
                 {Name: '@lang("layout.InitialQuantity")', column_name: 'initial_quantity',checkedColumn:(inventory_general_reportDetails.initial_quantity)?'checked':'',column_percentage:(inventory_general_reportDetails.initial_quantity___percent)?inventory_general_reportDetails.initial_quantity___percent:''},
                 {Name: '@lang("layout.TotalQuantityIn")', column_name: 'total_quantity_in',checkedColumn:(inventory_general_reportDetails.total_quantity_in)?'checked':'',column_percentage:(inventory_general_reportDetails.total_quantity_in___percent)?inventory_general_reportDetails.total_quantity_in___percent:''},
                 {Name: '@lang("layout.TotalQuantityOut")', column_name: 'total_quantity_out',checkedColumn:(inventory_general_reportDetails.total_quantity_out)?'checked':'',column_percentage:(inventory_general_reportDetails.total_quantity_out___percent)?inventory_general_reportDetails.total_quantity_out___percent:''},
                 {Name: '@lang("layout.OnHand")', column_name: 'on_hand',checkedColumn:(inventory_general_reportDetails.on_hand)?'checked':'',column_percentage:(inventory_general_reportDetails.on_hand___percent)?inventory_general_reportDetails.on_hand___percent:''},
                 {Name: '@lang("layout.OnSaleOrder")', column_name: 'on_sale_order',checkedColumn:(inventory_general_reportDetails.on_sale_order)?'checked':'',column_percentage:(inventory_general_reportDetails.on_sale_order___percent)?inventory_general_reportDetails.on_sale_order___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(inventory_general_reportDetails.unit)?'checked':'',column_percentage:(inventory_general_reportDetails.unit___percent)?inventory_general_reportDetails.unit___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(inventory_general_reportDetails.rate)?'checked':'',column_percentage:(inventory_general_reportDetails.rate___percent)?inventory_general_reportDetails.rate___percent:''},
                 {Name: '@lang("layout.AverageCost")', column_name: 'average_cost',checkedColumn:(inventory_general_reportDetails.average_cost)?'checked':'',column_percentage:(inventory_general_reportDetails.average_cost___percent)?inventory_general_reportDetails.average_cost___percent:''},
                 {Name: '@lang("layout.TotalAssetValue")', column_name: 'total_asset_value',checkedColumn:(inventory_general_reportDetails.total_asset_value)?'checked':'',column_percentage:(inventory_general_reportDetails.total_asset_value___percent)?inventory_general_reportDetails.total_asset_value___percent:''},
                 {Name: '@lang("layout.TotalSale")', column_name: 'total_sale',checkedColumn:(inventory_general_reportDetails.total_sale)?'checked':'',column_percentage:(inventory_general_reportDetails.total_sale___percent)?inventory_general_reportDetails.total_sale___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(inventory_general_reportDetails.total)?'checked':'',column_percentage:(inventory_general_reportDetails.total___percent)?inventory_general_reportDetails.total___percent:''},
                 @if(getOtherMeasure()=="true")
                 {Name: '@lang("layout.OMeasureValue1")', column_name: 'o_measure_value_1',checkedColumn:(inventory_general_reportDetails.o_measure_value_1)?'checked':'',column_percentage:(inventory_general_reportDetails.o_measure_value_1___percent)?inventory_general_reportDetails.o_measure_value_1___percent:''},
                 @endif
                 @if(getOtherMeasure2()=="true")
                 {Name: '@lang("layout.OMeasureValue2")', column_name: 'o_measure_value_2',checkedColumn:(inventory_general_reportDetails.o_measure_value_2)?'checked':'',column_percentage:(inventory_general_reportDetails.o_measure_value_2___percent)?inventory_general_reportDetails.o_measure_value_2___percent:''},
                @endif
                
                ];
 
      vm.cust_rep = inventory_general_reportDetails
    }
    /////////End Inventory 

    ////////Begain Inventory code
    if (type_id == 'inventory_general_report_code') {
      var myhtml = `<input type="hidden" name="type" value="inventory_general_report_code"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Inventory code  


    ////////Begain Inventory
    if (type_id == 'adjustment') {
      var myhtml = `<input type="hidden" name="type" value="adjustment"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Inventory 

    ////////Begain Inventory
    if (type_id == 'adjustmentRoll') {
      var myhtml = `<input type="hidden" name="type" value="adjustmentRoll"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Inventory 

    ////////Begain adjustmentAndItemNoneCostReport
    if (type_id == 'adjustmentAndItemNoneCostReport') {
      var myhtml = `<input type="hidden" name="type" value="adjustmentAndItemNoneCostReport"/>`;
      vm.getModalContent(myhtml);

      vm.customReportData =
                [
      {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(adjustmentAndItemNoneCostReportDetails.record)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.record___percent)?adjustmentAndItemNoneCostReportDetails.record___percent:''},
      {Name: '@lang("layout.ID")', column_name: 'id',checkedColumn:(adjustmentAndItemNoneCostReportDetails.id)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.id___percent)?adjustmentAndItemNoneCostReportDetails.id___percent:''},
      {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(adjustmentAndItemNoneCostReportDetails.date)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.date___percent)?adjustmentAndItemNoneCostReportDetails.date___percent:''},
      {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(adjustmentAndItemNoneCostReportDetails.description)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.description___percent)?adjustmentAndItemNoneCostReportDetails.description___percent:''},
      {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(adjustmentAndItemNoneCostReportDetails.reference_number)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.reference_number___percent)?adjustmentAndItemNoneCostReportDetails.reference_number___percent:''},
      {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(adjustmentAndItemNoneCostReportDetails.category)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.category___percent)?adjustmentAndItemNoneCostReportDetails.category___percent:''},
      {Name: '@lang("layout.TotalAmount")', column_name: 'total_amount',checkedColumn:(adjustmentAndItemNoneCostReportDetails.total_amount)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.total_amount___percent)?adjustmentAndItemNoneCostReportDetails.total_amount___percent:''},
      {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(adjustmentAndItemNoneCostReportDetails.user)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.user___percent)?adjustmentAndItemNoneCostReportDetails.user___percent:''},
      {Name: '@lang("layout.ItemNoneCost")', column_name: 'itemNoneCost',checkedColumn:(adjustmentAndItemNoneCostReportDetails.itemNoneCost)?'checked':'',column_percentage:(adjustmentAndItemNoneCostReportDetails.itemNoneCost___percent)?adjustmentAndItemNoneCostReportDetails.itemNoneCost___percent:''},
       
    
    ]
      vm.cust_rep = adjustmentAndItemNoneCostReportDetails
      
    }
    /////////End adjustmentAndItemNoneCostReport 


    ////////Begain procurement
    if (type_id == 'procurement') {
      var myhtml = `<input type="hidden" name="type" value="procurement"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End procurement total_amount


    ////////Begain InventorySite
    if (type_id == 'InventorySite') {
      var myhtml = `<input type="hidden" name="type" value="InventorySite"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End InventorySite



    ////////Begain InventoryCategory
    if (type_id == 'inventoryCategory') {
      var myhtml = `<input type="hidden" name="type" value="inventoryCategory"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End InventoryCategory 


    ////////Begain inventorytransfer
    if (type_id == 'inventory_transfer_detail') {
      var myhtml = `<input type="hidden" name="type" value="inventory_transfer_detail"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End inventorytransfer  

    ////////Begain inventory_transfer_detailRoll
    if (type_id == 'inventory_transfer_detailRoll') {
      var myhtml = `<input type="hidden" name="type" value="inventory_transfer_detailRoll"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End inventory_transfer_detailRoll     


    ////////Begain Service
    if (type_id == 'servicelist') {
      var myhtml = `<input type="hidden" name="type" value="servicelist"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Serviceassemblylist




    ////////Begain Assembly
    if (type_id == 'assemblylist') {
      
      var myhtml = `<input type="hidden" name="type" value="assemblylist"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.No.")', column_name: 'no',checkedColumn:(assemblylistDetails.no)?'checked':'',column_percentage:(assemblylistDetails.no___percent)?assemblylistDetails.no___percent:''},
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(assemblylistDetails.code)?'checked':'',column_percentage:(assemblylistDetails.code___percent)?assemblylistDetails.code___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(assemblylistDetails.description)?'checked':'',column_percentage:(assemblylistDetails.description___percent)?assemblylistDetails.description___percent:''},
                 {Name: '@lang("layout.FormulaName")', column_name: 'formula_name',checkedColumn:(assemblylistDetails.formula_name)?'checked':'',column_percentage:(assemblylistDetails.formula_name___percent)?assemblylistDetails.formula_name___percent:''},
                 {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(assemblylistDetails.item)?'checked':'',column_percentage:(assemblylistDetails.item___percent)?assemblylistDetails.item___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(assemblylistDetails.measure)?'checked':'',column_percentage:(assemblylistDetails.measure___percent)?assemblylistDetails.measure___percent:''},
                  {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(assemblylistDetails.user)?'checked':'',column_percentage:(assemblylistDetails.user___percent)?assemblylistDetails.user___percent:''},
               
                ];
 
      vm.cust_rep = assemblylistDetails
    }
    /////////End Assemblybuild_report



    ////////Begain Build
    if (type_id == 'general_build_report') {
      var myhtml = `<input type="hidden" name="type" value="general_build_report"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
      {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(general_build_reportDetails.record)?'checked':'',column_percentage:(general_build_reportDetails.record___percent)?general_build_reportDetails.record___percent:''},
      {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(general_build_reportDetails.date)?'checked':'',column_percentage:(general_build_reportDetails.date___percent)?general_build_reportDetails.date___percent:''},
      {Name: '@lang("layout.Inventory")', column_name: 'inventory',checkedColumn:(general_build_reportDetails.inventory)?'checked':'',column_percentage:(general_build_reportDetails.inventory___percent)?general_build_reportDetails.inventory___percent:''},
      {Name: '@lang("layout.BuildNumber")', column_name: 'build_number',checkedColumn:(general_build_reportDetails.build_number)?'checked':'',column_percentage:(general_build_reportDetails.build_number___percent)?general_build_reportDetails.build_number___percent:''},
      {Name: '@lang("layout.BuildItem")', column_name: 'build_item',checkedColumn:(general_build_reportDetails.build_item)?'checked':'',column_percentage:(general_build_reportDetails.build_item___percent)?general_build_reportDetails.build_item___percent:''},
      {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(general_build_reportDetails.quantity)?'checked':'',column_percentage:(general_build_reportDetails.quantity___percent)?general_build_reportDetails.quantity___percent:''},
      {Name: '@lang("layout.TotalExpense")', column_name: 'total_expense',checkedColumn:(general_build_reportDetails.total_expense)?'checked':'',column_percentage:(general_build_reportDetails.total_expense___percent)?general_build_reportDetails.total_expense___percent:''},
      {Name: '@lang("layout.Cost")', column_name: 'cost',checkedColumn:(general_build_reportDetails.cost)?'checked':'',column_percentage:(general_build_reportDetails.cost___percent)?general_build_reportDetails.cost___percent:''},
       {Name: '@lang("layout.EvaporatedWater")', column_name: 'evaporate_water',checkedColumn:(general_build_reportDetails.evaporate_water)?'checked':'',column_percentage:(general_build_reportDetails.evaporate_water___percent)?general_build_reportDetails.evaporate_water___percent:''},
       {Name: '@lang("layout.MoiatemPercentage")', column_name: 'moiatem_percentage',checkedColumn:(general_build_reportDetails.moiatem_percentage)?'checked':'',column_percentage:(general_build_reportDetails.moiatem_percentage___percent)?general_build_reportDetails.moiatem_percentage___percent:''},
      {Name: '@lang("layout.Balance")', column_name: 'balance',checkedColumn:(general_build_reportDetails.balance)?'checked':'',column_percentage:(general_build_reportDetails.balance___percent)?general_build_reportDetails.balance___percent:''},
    ]
      vm.cust_rep = general_build_reportDetails
    }

    ////////Begain Build
    if (type_id == 'general_package_build_report') {
      var myhtml = `<input type="hidden" name="type" value="general_package_build_report"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Build




    ////////Begain Build
    if (type_id == 'build_report') {
      var myhtml = `<div  class="col-md-12">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select name="category"  class="form-control">
                            <option  value="">@lang('layout.SelectType')</option>
                            <option  value="summary">@lang('layout.Summary')</option>
                            <option  value="details">@lang('layout.Details')</option>
                        </select>
                    </div>
                    <input type="hidden" name="type" value="build_report"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Build


    ////////Begain Sale
    if (type_id == 'SaleList') {
      var myhtml = `<input type="hidden" name="type" value="SaleList"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Sale



    ////////Begain Invoice
    if (type_id == 'invoicelist') {
      var myhtml = `<input type="hidden" name="type" value="invoicelist"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Invoice


    ////////Begain SaleOrder
    if (type_id == 'saleOrder') {
      var myhtml = `<input type="hidden" name="type" value="saleOrder"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End SaleOrder




    ////////Begain GeneralSaleReport
    if (type_id == 'GeneralSaleReport') {
      var myhtml = `<input type="hidden" name="type" value="GeneralSaleReport"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(GeneralSaleDetails.record)?'checked':'',column_percentage:(GeneralSaleDetails.record___percent)?GeneralSaleDetails.record___percent:''},
                 {Name: '@lang("layout.SaleNumber")', column_name: 'sale_number',checkedColumn:(GeneralSaleDetails.sale_number)?'checked':'',column_percentage:(GeneralSaleDetails.sale_number___percent)?GeneralSaleDetails.sale_number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(GeneralSaleDetails.date)?'checked':'',column_percentage:(GeneralSaleDetails.date___percent)?GeneralSaleDetails.date___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(GeneralSaleDetails.reference_number)?'checked':'',column_percentage:(GeneralSaleDetails.reference_number___percent)?GeneralSaleDetails.reference_number___percent:''},
                 @if(systemConfig()[27] == 1)
                 {Name: '@lang("layout.PumpNumber")', column_name: 'pump_number',checkedColumn:(GeneralSaleDetails.pump_number)?'checked':'',column_percentage:(GeneralSaleDetails.pump_number___percent)?GeneralSaleDetails.pump_number___percent:''},
                 @endif
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(GeneralSaleDetails.customer)?'checked':'',column_percentage:(GeneralSaleDetails.customer___percent)?GeneralSaleDetails.customer___percent:''},
                 {Name: '@lang("layout.SaleArea")', column_name: 'sale_area',checkedColumn:(GeneralSaleDetails.sale_area)?'checked':'',column_percentage:(GeneralSaleDetails.sale_area___percent)?GeneralSaleDetails.sale_area___percent:''},
                 {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(GeneralSaleDetails.site)?'checked':'',column_percentage:(GeneralSaleDetails.site___percent)?GeneralSaleDetails.site___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(GeneralSaleDetails.item_name)?'checked':'',column_percentage:(GeneralSaleDetails.item_name___percent)?GeneralSaleDetails.item_name___percent:''},
                 @if(systemConfig()[27] == 1)
                 {Name: '@lang("layout.OilQuantity")', column_name: 'oil_quantity',checkedColumn:(GeneralSaleDetails.oil_quantity)?'checked':'',column_percentage:(GeneralSaleDetails.oil_quantity___percent)?GeneralSaleDetails.oil_quantity___percent:''},
                 @endif
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(GeneralSaleDetails.quantity)?'checked':'',column_percentage:(GeneralSaleDetails.quantity___percent)?GeneralSaleDetails.quantity___percent:''},
                //  {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(GeneralSaleDetails.unit)?'checked':'',column_percentage:(GeneralSaleDetails.unit___percent)?GeneralSaleDetails.unit___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit1',checkedColumn:(GeneralSaleDetails.unit1)?'checked':'',column_percentage:(GeneralSaleDetails.unit1___percent)?GeneralSaleDetails.unit1___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(GeneralSaleDetails.amount)?'checked':'',column_percentage:(GeneralSaleDetails.amount___percent)?GeneralSaleDetails.amount___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(GeneralSaleDetails.unit)?'checked':'',column_percentage:(GeneralSaleDetails.unit___percent)?GeneralSaleDetails.unit___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(GeneralSaleDetails.rate)?'checked':'',column_percentage:(GeneralSaleDetails.rate___percent)?GeneralSaleDetails.rate___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(GeneralSaleDetails.total)?'checked':'',column_percentage:(GeneralSaleDetails.total___percent)?GeneralSaleDetails.total___percent:''},

                ];
 
          vm.cust_rep = GeneralSaleDetails
    }
    /////////End GeneralSaleReport       

    ////////Begain GeneralSaleReport
    if (type_id == 'allFactorPrint') {
      var myhtml = `<input type="hidden" name="type" value="allFactorPrint"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End GeneralSaleReport

    ////////Begain GeneralSaleReport
    if (type_id == 'allGrnReport') {
      var myhtml = `<input type="hidden" name="type" value="allGrnReport"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End GeneralSaleReport


    ////////Begain GeneralSaleReportCustomer
    if (type_id == 'GeneralSaleReportCustomer') {
      var myhtml = `<input type="hidden" name="type" value="GeneralSaleReportCustomer"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(GeneralSaleReportCustomerDetails.record)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.record___percent)?GeneralSaleReportCustomerDetails.record___percent:''},
                 {Name: '@lang("layout.SaleNumber")', column_name: 'sale_number',checkedColumn:(GeneralSaleReportCustomerDetails.sale_number)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.sale_number___percent)?GeneralSaleReportCustomerDetails.sale_number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(GeneralSaleReportCustomerDetails.date)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.date___percent)?GeneralSaleReportCustomerDetails.date___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(GeneralSaleReportCustomerDetails.reference_number)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.reference_number___percent)?GeneralSaleReportCustomerDetails.reference_number___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(GeneralSaleReportCustomerDetails.description)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.description___percent)?GeneralSaleReportCustomerDetails.description___percent:''},
                 
                 {Name: '@lang("layout.PumpNumber")', column_name: 'pump_number',checkedColumn:(GeneralSaleReportCustomerDetails.pump_number)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.pump_number___percent)?GeneralSaleReportCustomerDetails.pump_number___percent:''},
                 
                 {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(GeneralSaleReportCustomerDetails.class)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.class___percent)?GeneralSaleReportCustomerDetails.class___percent:''},
                 {Name: '@lang("layout.SaleArea")', column_name: 'sale_area',checkedColumn:(GeneralSaleReportCustomerDetails.sale_area)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.sale_area___percent)?GeneralSaleReportCustomerDetails.sale_area___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(GeneralSaleReportCustomerDetails.customer)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.customer___percent)?GeneralSaleReportCustomerDetails.customer___percent:''},
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(GeneralSaleReportCustomerDetails.code)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.code___percent)?GeneralSaleReportCustomerDetails.code___percent:''},
                 {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(GeneralSaleReportCustomerDetails.site)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.site___percent)?GeneralSaleReportCustomerDetails.site___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(GeneralSaleReportCustomerDetails.item_name)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.item_name___percent)?GeneralSaleReportCustomerDetails.item_name___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit1',checkedColumn:(GeneralSaleReportCustomerDetails.unit1)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.unit1___percent)?GeneralSaleReportCustomerDetails.unit1___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(GeneralSaleReportCustomerDetails.quantity)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.quantity___percent)?GeneralSaleReportCustomerDetails.quantity___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(GeneralSaleReportCustomerDetails.unit)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.unit___percent)?GeneralSaleReportCustomerDetails.unit___percent:''},
                 {Name: '@lang("layout.UnitPrice")', column_name: 'unit_price',checkedColumn:(GeneralSaleReportCustomerDetails.unit_price)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.unit_price___percent)?GeneralSaleReportCustomerDetails.unit_price___percent:''},
                 {Name: '@lang("layout.TotalAmount")', column_name: 'total_amount',checkedColumn:(GeneralSaleReportCustomerDetails.total_amount)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.total_amount___percent)?GeneralSaleReportCustomerDetails.total_amount___percent:''},
                 {Name: '@lang("layout.TotalCostOfSale")', column_name: 'total_cost_of_sale',checkedColumn:(GeneralSaleReportCustomerDetails.total_cost_of_sale)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.total_cost_of_sale___percent)?GeneralSaleReportCustomerDetails.total_cost_of_sale___percent:''},
                 {Name: '@lang("layout.GrossProfitORLost")', column_name: 'gross_profit_or_lost',checkedColumn:(GeneralSaleReportCustomerDetails.gross_profit_or_lost)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.gross_profit_or_lost___percent)?GeneralSaleReportCustomerDetails.gross_profit_or_lost___percent:''},
                  {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(GeneralSaleReportCustomerDetails.rate)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.rate___percent)?GeneralSaleReportCustomerDetails.rate___percent:''},
                  @if(systemConfig()[27] == 1)
                 {Name: '@lang("layout.OldCounter")', column_name: 'old_counter',checkedColumn:(GeneralSaleReportCustomerDetails.old_counter)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.old_counter___percent)?GeneralSaleReportCustomerDetails.old_counter___percent:''},
                 {Name: '@lang("layout.NewCounter")', column_name: 'new_counter',checkedColumn:(GeneralSaleReportCustomerDetails.new_counter)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.new_counter___percent)?GeneralSaleReportCustomerDetails.new_counter___percent:''},
                 @endif
                 {Name: '@lang("layout.Gift")', column_name: 'gift',checkedColumn:(GeneralSaleReportCustomerDetails.gift)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.gift___percent)?GeneralSaleReportCustomerDetails.gift___percent:''},
                 {Name: '@lang("layout.ShowRefund")', column_name: 'showRefund',checkedColumn:(GeneralSaleReportCustomerDetails.showRefund)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.showRefund___percent)?GeneralSaleReportCustomerDetails.showRefund___percent:''},
                 {Name: '@lang("layout.ShowingDiscount")', column_name: 'showingDiscount',checkedColumn:(GeneralSaleReportCustomerDetails.showingDiscount)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.showingDiscount___percent)?GeneralSaleReportCustomerDetails.showingDiscount___percent:''},
                 {Name: '@lang("layout.ShowSale")', column_name: 'showSale',checkedColumn:(GeneralSaleReportCustomerDetails.showSale)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.showSale___percent)?GeneralSaleReportCustomerDetails.showSale___percent:''},
                 {Name: '@lang("layout.LaboratoryPercentage")', column_name: 'laboratoryPercentage',checkedColumn:(GeneralSaleReportCustomerDetails.laboratoryPercentage)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.laboratoryPercentage___percent)?GeneralSaleReportCustomerDetails.laboratoryPercentage___percent:''},
                 @if(getSaleDescription()=="true")   
                 {Name: '@lang("layout.Model")', column_name: 'model',checkedColumn:(GeneralSaleReportCustomerDetails.model)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.model___percent)?GeneralSaleReportCustomerDetails.model___percent:''},
                 {Name: '@lang("layout.Color")', column_name: 'color',checkedColumn:(GeneralSaleReportCustomerDetails.color)?'checked':'',column_percentage:(GeneralSaleReportCustomerDetails.color___percent)?GeneralSaleReportCustomerDetails.color___percent:''},
                 @endif
                ];
 
          vm.cust_rep = GeneralSaleReportCustomerDetails
    }
    /////////End GeneralSaleReportCustomer        

    ////////Begain GeneralSaleReportCustomerReceive
    if (type_id == 'GeneralSaleReportCustomerReceive') {
      var myhtml = `<input type="hidden" name="type" value="GeneralSaleReportCustomerReceive"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.record)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.record___percent)?GeneralSaleReportCustomerReceiveDetails.record___percent:''},
                 {Name: '@lang("layout.InvoiceNumber")', column_name: 'invoice_number',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.invoice_number)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.invoice_number___percent)?GeneralSaleReportCustomerReceiveDetails.invoice_number___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.reference_number)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.reference_number___percent)?GeneralSaleReportCustomerReceiveDetails.reference_number___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.customer)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.customer___percent)?GeneralSaleReportCustomerReceiveDetails.customer___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.date)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.date___percent)?GeneralSaleReportCustomerReceiveDetails.date___percent:''},
                 {Name: '@lang("layout.AccountName")', column_name: 'account_name',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.account_name)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.account_name___percent)?GeneralSaleReportCustomerReceiveDetails.account_name___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.amount)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.amount___percent)?GeneralSaleReportCustomerReceiveDetails.amount___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.unit)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.unit___percent)?GeneralSaleReportCustomerReceiveDetails.unit___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.rate)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.rate___percent)?GeneralSaleReportCustomerReceiveDetails.rate___percent:''},
                 {Name: '@lang("layout.Recipt")', column_name: 'recipt',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.recipt)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.recipt___percent)?GeneralSaleReportCustomerReceiveDetails.recipt___percent:''},
                 {Name: '@lang("layout.Remain")', column_name: 'remain',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.remain)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.remain___percent)?GeneralSaleReportCustomerReceiveDetails.remain___percent:''},
                 {Name: '@lang("layout.Percentage")', column_name: 'percentage',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.percentage)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.percentage___percent)?GeneralSaleReportCustomerReceiveDetails.percentage___percent:''},
                 {Name: '@lang("layout.TotalItemQty")', column_name: 'total_item_quantity',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.total_item_quantity)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.total_item_quantity___percent)?GeneralSaleReportCustomerReceiveDetails.total_item_quantity___percent:''},
                 {Name: '@lang("layout.DiscountType")', column_name: 'discount_type',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.discount_type)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.discount_type___percent)?GeneralSaleReportCustomerReceiveDetails.discount_type___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.discount)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.discount___percent)?GeneralSaleReportCustomerReceiveDetails.discount___percent:''},
                 {Name: '@lang("layout.Expense")', column_name: 'expense',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.expense)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.expense___percent)?GeneralSaleReportCustomerReceiveDetails.expense___percent:''},
                 {Name: '@lang("layout.TotalCostOfSale")', column_name: 'total_cost_of_sale',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.total_cost_of_sale)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.total_cost_of_sale___percent)?GeneralSaleReportCustomerReceiveDetails.total_cost_of_sale___percent:''},
                 {Name: '@lang("layout.GrossProfitORLost")', column_name: 'gross_profit_or_lost',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.gross_profit_or_lost)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.gross_profit_or_lost___percent)?GeneralSaleReportCustomerReceiveDetails.gross_profit_or_lost___percent:''},
                 {Name: '@lang("layout.Tax")', column_name: 'tax',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.tax)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.tax___percent)?GeneralSaleReportCustomerReceiveDetails.tax___percent:''},
                 {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.status)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.status___percent)?GeneralSaleReportCustomerReceiveDetails.status___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.description)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.description___percent)?GeneralSaleReportCustomerReceiveDetails.description___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(GeneralSaleReportCustomerReceiveDetails.user)?'checked':'',column_percentage:(GeneralSaleReportCustomerReceiveDetails.user___percent)?GeneralSaleReportCustomerReceiveDetails.user___percent:''},


                ];
 
          vm.cust_rep = GeneralSaleReportCustomerReceiveDetails
    }
    /////////End GeneralSaleReportCustomerReceive        

    ////////Begain taxation
    if (type_id == 'taxation') {
      var myhtml = `<input type="hidden" name="type" value="taxation_report"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End taxation

    ////////Begain sale Taxation
    if (type_id == 'saleTaxation') {
      var myhtml = `<input type="hidden" name="type" value="sale_taxation_report"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End sale Taxation

    ////////Begain ItemProfitAndLostReport
    if (type_id == 'ItemProfitAndLostReport') {
      var myhtml = `<input type="hidden" name="type" value="ItemProfitAndLostReport"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
          [
            {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(ItemProfitAndLostReportDetails.record)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.record___percent)?ItemProfitAndLostReportDetails.record___percent:''},
            {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(ItemProfitAndLostReportDetails.name)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.name___percent)?ItemProfitAndLostReportDetails.name___percent:''},
            {Name: '@lang("layout.OnHand")', column_name: 'on_hand',checkedColumn:(ItemProfitAndLostReportDetails.on_hand)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.on_hand___percent)?ItemProfitAndLostReportDetails.on_hand___percent:''},
            {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(ItemProfitAndLostReportDetails.unit)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.unit___percent)?ItemProfitAndLostReportDetails.unit___percent:''},
            @if(systemConfig()[4] != 0 )
            {Name: '@lang("layout.TotalCode")', column_name: 'total_code',checkedColumn:(ItemProfitAndLostReportDetails.total_code)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.total_code___percent)?ItemProfitAndLostReportDetails.total_code___percent:''},
            @endif
            @if(systemConfig()[9] != 0 )
            {Name: '@lang("layout.PurchaseAverageCost")', column_name: 'purchase_average_cost',checkedColumn:(ItemProfitAndLostReportDetails.purchase_average_cost)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.purchase_average_cost___percent)?ItemProfitAndLostReportDetails.purchase_average_cost___percent:''},
            {Name: '@lang("layout.PurchaseTotalAssetValue")', column_name: 'purchase_total_asset_value',checkedColumn:(ItemProfitAndLostReportDetails.purchase_total_asset_value)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.purchase_total_asset_value___percent)?ItemProfitAndLostReportDetails.purchase_total_asset_value___percent:''},
            @endif

            {Name: '@lang("layout.AverageCost")', column_name: 'average_cost',checkedColumn:(ItemProfitAndLostReportDetails.average_cost)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.average_cost___percent)?ItemProfitAndLostReportDetails.average_cost___percent:''},
            {Name: '@lang("layout.TotalAssetValue")', column_name: 'total_asset_value',checkedColumn:(ItemProfitAndLostReportDetails.total_asset_value)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.total_asset_value___percent)?ItemProfitAndLostReportDetails.total_asset_value___percent:''},
            @if(systemConfig()[9] != 0 )
            {Name: '@lang("layout.LostTotalAssetValue")', column_name: 'lost_total_asset_value',checkedColumn:(ItemProfitAndLostReportDetails.lost_total_asset_value)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.lost_total_asset_value___percent)?ItemProfitAndLostReportDetails.lost_total_asset_value___percent:''},
            @endif
            {Name: '@lang("layout.SaleQty")', column_name: 'sale_qty',checkedColumn:(ItemProfitAndLostReportDetails.sale_qty)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.sale_qty___percent)?ItemProfitAndLostReportDetails.sale_qty___percent:''},
            {Name: '@lang("layout.TotalSale")', column_name: 'total_sale',checkedColumn:(ItemProfitAndLostReportDetails.total_sale)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.total_sale___percent)?ItemProfitAndLostReportDetails.total_sale___percent:''},
            {Name: '@lang("layout.TotalCostOfSale")', column_name: 'total_cost_of_sale',checkedColumn:(ItemProfitAndLostReportDetails.total_cost_of_sale)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.total_cost_of_sale___percent)?ItemProfitAndLostReportDetails.total_cost_of_sale___percent:''},
            {Name: '@lang("layout.GrossProfitORLost")', column_name: 'gross_profit_or_lost',checkedColumn:(ItemProfitAndLostReportDetails.gross_profit_or_lost)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.gross_profit_or_lost___percent)?ItemProfitAndLostReportDetails.gross_profit_or_lost___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(ItemProfitAndLostReportDetails.total)?'checked':'',column_percentage:(ItemProfitAndLostReportDetails.total___percent)?ItemProfitAndLostReportDetails.total___percent:''},
            
          ];
 
     vm.cust_rep = ItemProfitAndLostReportDetails

      
    }
    /////////End ItemProfitAndLostReport

    ////////Begain SaaleComparisonReportForCustomeres
    if (type_id == 'SaleComparisonReportForCustomeres') {
      var myhtml = `<input type="hidden" name="type" value="SaleComparisonReportForCustomeres"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(SaleComparisonReportForCustomeresDetails.record)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.record___percent)?SaleComparisonReportForCustomeresDetails.record___percent:''},
                 {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(SaleComparisonReportForCustomeresDetails.class)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.class___percent)?SaleComparisonReportForCustomeresDetails.class___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(SaleComparisonReportForCustomeresDetails.customer)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.customer___percent)?SaleComparisonReportForCustomeresDetails.customer___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(SaleComparisonReportForCustomeresDetails.item_name)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.item_name___percent)?SaleComparisonReportForCustomeresDetails.item_name___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(SaleComparisonReportForCustomeresDetails.quantity)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.quantity___percent)?SaleComparisonReportForCustomeresDetails.quantity___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(SaleComparisonReportForCustomeresDetails.unit)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.unit___percent)?SaleComparisonReportForCustomeresDetails.unit___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(SaleComparisonReportForCustomeresDetails.amount)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.amount___percent)?SaleComparisonReportForCustomeresDetails.amount___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit1',checkedColumn:(SaleComparisonReportForCustomeresDetails.unit1)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.unit1___percent)?SaleComparisonReportForCustomeresDetails.unit1___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(SaleComparisonReportForCustomeresDetails.total)?'checked':'',column_percentage:(SaleComparisonReportForCustomeresDetails.total___percent)?SaleComparisonReportForCustomeresDetails.total___percent:''},
                
                ];
          vm.cust_rep = SaleComparisonReportForCustomeresDetails     
    }
    /////////End SaleComparisonReportForCustomeres 
    

     ////////Begain MemberStatementReportByType
     if (type_id == 'MemberStatementReportByType') {
      var myhtml = `<input type="hidden" name="type" value="MemberStatementReportByType"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(memberStatementRepostByTypeDetails.record)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.record___percent)?memberStatementRepostByTypeDetails.record___percent:''},
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(memberStatementRepostByTypeDetails.code)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.code___percent)?memberStatementRepostByTypeDetails.code___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(memberStatementRepostByTypeDetails.name)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.name___percent)?memberStatementRepostByTypeDetails.name___percent:''},
                 {Name: '@lang("layout.Phone")', column_name: 'phone',checkedColumn:(memberStatementRepostByTypeDetails.phone)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.phone___percent)?memberStatementRepostByTypeDetails.phone___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.Salary")', column_name: 'balanceSalary',checkedColumn:(memberStatementRepostByTypeDetails.balanceSalary)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.balanceSalary___percent)?memberStatementRepostByTypeDetails.balanceSalary___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.Loan")', column_name: 'balanceLoan',checkedColumn:(memberStatementRepostByTypeDetails.balanceLoan)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.balanceLoan___percent)?memberStatementRepostByTypeDetails.balanceLoan___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.Prepaid")', column_name: 'balancePrepaid',checkedColumn:(memberStatementRepostByTypeDetails.balancePrepaid)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.balancePrepaid___percent)?memberStatementRepostByTypeDetails.balancePrepaid___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.Reward")', column_name: 'balanceReward',checkedColumn:(memberStatementRepostByTypeDetails.balanceReward)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.balanceReward___percent)?memberStatementRepostByTypeDetails.balanceReward___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.PersonalPayAndReceive")', column_name: 'balancePersonalPayAndReceive',checkedColumn:(memberStatementRepostByTypeDetails.balancePersonalPayAndReceive)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.balancePersonalPayAndReceive___percent)?memberStatementRepostByTypeDetails.balancePersonalPayAndReceive___percent:''},
                 {Name: '@lang("layout.OtherBalances")', column_name: 'otherBalances',checkedColumn:(memberStatementRepostByTypeDetails.otherBalances)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.otherBalances___percent)?memberStatementRepostByTypeDetails.otherBalances___percent:''},
                 {Name: '@lang("layout.TotalPerCurrency")', column_name: 'total_per_currency1',checkedColumn:(memberStatementRepostByTypeDetails.total_per_currency1)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.total_per_currency1___percent)?memberStatementRepostByTypeDetails.total_per_currency1___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(memberStatementRepostByTypeDetails.total)?'checked':'',column_percentage:(memberStatementRepostByTypeDetails.total___percent)?memberStatementRepostByTypeDetails.total___percent:''},
                
                ];
          vm.cust_rep = memberStatementRepostByTypeDetails     
    }
    /////////End EmployeeStatementReportByType 
     ////////Begain EmployeeStatementReportByType
     if (type_id == 'EmployeeStatementReportByType') {
      var myhtml = `<input type="hidden" name="type" value="EmployeeStatementReportByType"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(employeeStatementRepostByTypeDetails.record)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.record___percent)?employeeStatementRepostByTypeDetails.record___percent:''},
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(employeeStatementRepostByTypeDetails.code)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.code___percent)?employeeStatementRepostByTypeDetails.code___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(employeeStatementRepostByTypeDetails.name)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.name___percent)?employeeStatementRepostByTypeDetails.name___percent:''},
                 {Name: '@lang("layout.JobTitle")', column_name: 'jobTitle',checkedColumn:(employeeStatementRepostByTypeDetails.jobTitle)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.jobTitle___percent)?employeeStatementRepostByTypeDetails.jobTitle___percent:''},
                 {Name: '@lang("layout.Counts")', column_name: 'counts',checkedColumn:(employeeStatementRepostByTypeDetails.counts)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.counts___percent)?employeeStatementRepostByTypeDetails.counts___percent:''},
                 {Name: '@lang("layout.MainSalary")', column_name: 'mainSalary',checkedColumn:(employeeStatementRepostByTypeDetails.mainSalary)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.mainSalary___percent)?employeeStatementRepostByTypeDetails.mainSalary___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.Salary")', column_name: 'balanceSalary',checkedColumn:(employeeStatementRepostByTypeDetails.balanceSalary)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.balanceSalary___percent)?employeeStatementRepostByTypeDetails.balanceSalary___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.Loan")', column_name: 'balanceLoan',checkedColumn:(employeeStatementRepostByTypeDetails.balanceLoan)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.balanceLoan___percent)?employeeStatementRepostByTypeDetails.balanceLoan___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.Prepaid")', column_name: 'balancePrepaid',checkedColumn:(employeeStatementRepostByTypeDetails.balancePrepaid)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.balancePrepaid___percent)?employeeStatementRepostByTypeDetails.balancePrepaid___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.Reward")', column_name: 'balanceReward',checkedColumn:(employeeStatementRepostByTypeDetails.balanceReward)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.balanceReward___percent)?employeeStatementRepostByTypeDetails.balanceReward___percent:''},
                 {Name: '@lang("layout.Balance") @lang("layout.PersonalPayAndReceive")', column_name: 'balancePersonalPayAndReceive',checkedColumn:(employeeStatementRepostByTypeDetails.balancePersonalPayAndReceive)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.balancePersonalPayAndReceive___percent)?employeeStatementRepostByTypeDetails.balancePersonalPayAndReceive___percent:''},
                 {Name: '@lang("layout.OtherBalances")', column_name: 'otherBalances',checkedColumn:(employeeStatementRepostByTypeDetails.otherBalances)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.otherBalances___percent)?employeeStatementRepostByTypeDetails.otherBalances___percent:''},
                 {Name: '@lang("layout.Receivable")', column_name: 'receivable',checkedColumn:(employeeStatementRepostByTypeDetails.receivable)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.receivable___percent)?employeeStatementRepostByTypeDetails.receivable___percent:''},
                 {Name: '@lang("layout.Payable")', column_name: 'payable',checkedColumn:(employeeStatementRepostByTypeDetails.payable)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.payable___percent)?employeeStatementRepostByTypeDetails.payable___percent:''},
                 {Name: '@lang("layout.Balance")', column_name: 'balance',checkedColumn:(employeeStatementRepostByTypeDetails.balance)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.balance___percent)?employeeStatementRepostByTypeDetails.balance___percent:''},
                 {Name: '@lang("layout.Receivable") {{getHomeCurrency()[getCurrencyType()]}}', column_name: 'receivable1',checkedColumn:(employeeStatementRepostByTypeDetails.receivable1)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.receivable1___percent)?employeeStatementRepostByTypeDetails.receivable1___percent:''},
                 {Name: '@lang("layout.Payable") {{getHomeCurrency()[getCurrencyType()]}}', column_name: 'payable1',checkedColumn:(employeeStatementRepostByTypeDetails.payable1)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.payable1___percent)?employeeStatementRepostByTypeDetails.payable1___percent:''},
                 {Name: '@lang("layout.Balance") {{getHomeCurrency()[getCurrencyType()]}}', column_name: 'balance1',checkedColumn:(employeeStatementRepostByTypeDetails.balance1)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.balance1___percent)?employeeStatementRepostByTypeDetails.balance1___percent:''},
                 {Name: '@lang("layout.TotalPerCurrency")', column_name: 'total_per_currency',checkedColumn:(employeeStatementRepostByTypeDetails.total_per_currency)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.total_per_currency___percent)?employeeStatementRepostByTypeDetails.total_per_currency___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(employeeStatementRepostByTypeDetails.total)?'checked':'',column_percentage:(employeeStatementRepostByTypeDetails.total___percent)?employeeStatementRepostByTypeDetails.total___percent:''},
                ];
          vm.cust_rep = employeeStatementRepostByTypeDetails     
    }
    /////////End EmployeeStatementReportByType 
    

    
    ////////Begain SaleComparisonReport
    if (type_id == 'SaleComparisonReport') {
      var myhtml = `<input type="hidden" name="type" value="SaleComparisonReport"/>`;
      vm.getModalContent(myhtml);
      // vm.customReportData =
      //           [
      //            {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(SaleComparisonReportDetails.record)?'checked':'',column_percentage:(SaleComparisonReportDetails.record___percent)?SaleComparisonReportDetails.record___percent:''},
      //            {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(SaleComparisonReportDetails.class)?'checked':'',column_percentage:(SaleComparisonReportDetails.class___percent)?SaleComparisonReportDetails.class___percent:''},
      //            {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(SaleComparisonReportDetails.customer)?'checked':'',column_percentage:(SaleComparisonReportDetails.customer___percent)?SaleComparisonReportDetails.customer___percent:''},
      //            {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(SaleComparisonReportDetails.item_name)?'checked':'',column_percentage:(SaleComparisonReportDetails.item_name___percent)?SaleComparisonReportDetails.item_name___percent:''},
      //            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(SaleComparisonReportDetails.quantity)?'checked':'',column_percentage:(SaleComparisonReportDetails.quantity___percent)?SaleComparisonReportDetails.quantity___percent:''},
      //            {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(SaleComparisonReportDetails.unit)?'checked':'',column_percentage:(SaleComparisonReportDetails.unit___percent)?SaleComparisonReportDetails.unit___percent:''},
      //            {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(SaleComparisonReportDetails.amount)?'checked':'',column_percentage:(SaleComparisonReportDetails.amount___percent)?SaleComparisonReportDetails.amount___percent:''},
                 
      //           ];
      //     vm.cust_rep = SaleComparisonReportDetails     
    }   
    /////////End SaleComparisonReport    
    
    ////////Begain CustomerWithoutSales
    if (type_id == 'CustomerWithoutSales') {
      var myhtml = `<input type="hidden" name="type" value="CustomerWithoutSales"/>`;
      vm.getModalContent(myhtml);

      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(CustomerWithoutSalesDetails.record)?'checked':'',column_percentage:(CustomerWithoutSalesDetails.record___percent)?CustomerWithoutSalesDetails.record___percent:''},
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(CustomerWithoutSalesDetails.code)?'checked':'',column_percentage:(CustomerWithoutSalesDetails.code___percent)?CustomerWithoutSalesDetails.code___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(CustomerWithoutSalesDetails.name)?'checked':'',column_percentage:(CustomerWithoutSalesDetails.name___percent)?CustomerWithoutSalesDetails.name___percent:''},
                 {Name: '@lang("layout.Phone")', column_name: 'phone',checkedColumn:(CustomerWithoutSalesDetails.phone)?'checked':'',column_percentage:(CustomerWithoutSalesDetails.phone___percent)?CustomerWithoutSalesDetails.phone___percent:''},
                 {Name: '@lang("layout.Address")', column_name: 'address',checkedColumn:(CustomerWithoutSalesDetails.address)?'checked':'',column_percentage:(CustomerWithoutSalesDetails.address___percent)?CustomerWithoutSalesDetails.address___percent:''},
                  
                
                ];
          vm.cust_rep = CustomerWithoutSalesDetails

      
    }
    /////////End CustomerWithoutSales


    ////////Begain GeneralPurchaseReportCustomer
    if (type_id == 'GeneralPurchaseReportCustomer') {
      var myhtml = `<input type="hidden" name="type" value="GeneralPurchaseReportCustomer"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(GeneralPurchaseReportCustomerDetails.record)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.record___percent)?GeneralPurchaseReportCustomerDetails.record___percent:''},
                 {Name: '@lang("layout.PurchaseNumber")', column_name: 'purchase_number',checkedColumn:(GeneralPurchaseReportCustomerDetails.purchase_number)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.purchase_number___percent)?GeneralPurchaseReportCustomerDetails.purchase_number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(GeneralPurchaseReportCustomerDetails.date)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.date___percent)?GeneralPurchaseReportCustomerDetails.date___percent:''},
                 {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(GeneralPurchaseReportCustomerDetails.class)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.class___percent)?GeneralPurchaseReportCustomerDetails.class___percent:''},
                 @if(systemConfig()[4] != 0 )
                 {Name: '@lang("layout.ContractCode")', column_name: 'contract_code',checkedColumn:(GeneralPurchaseReportCustomerDetails.contract_code)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.contract_code___percent)?GeneralPurchaseReportCustomerDetails.contract_code___percent:''},
                 @endif
                 {Name: '@lang("layout.Vendor")', column_name: 'vendor',checkedColumn:(GeneralPurchaseReportCustomerDetails.vendor)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.vendor___percent)?GeneralPurchaseReportCustomerDetails.vendor___percent:''},
                 {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(GeneralPurchaseReportCustomerDetails.site)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.site___percent)?GeneralPurchaseReportCustomerDetails.site___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(GeneralPurchaseReportCustomerDetails.item_name)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.item_name___percent)?GeneralPurchaseReportCustomerDetails.item_name___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(GeneralPurchaseReportCustomerDetails.quantity)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.quantity___percent)?GeneralPurchaseReportCustomerDetails.quantity___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(GeneralPurchaseReportCustomerDetails.unit)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.unit___percent)?GeneralPurchaseReportCustomerDetails.unit___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(GeneralPurchaseReportCustomerDetails.amount)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.amount___percent)?GeneralPurchaseReportCustomerDetails.amount___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit1',checkedColumn:(GeneralPurchaseReportCustomerDetails.unit1)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.unit1___percent)?GeneralPurchaseReportCustomerDetails.unit1___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(GeneralPurchaseReportCustomerDetails.rate)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.rate___percent)?GeneralPurchaseReportCustomerDetails.rate___percent:''},
                 @if(getSaleDescription()=="true")
                 {Name: '@lang("layout.Model")', column_name: 'model',checkedColumn:(GeneralPurchaseReportCustomerDetails.model)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.model___percent)?GeneralPurchaseReportCustomerDetails.model___percent:''},
                 {Name: '@lang("layout.Color")', column_name: 'color',checkedColumn:(GeneralPurchaseReportCustomerDetails.color)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.color___percent)?GeneralPurchaseReportCustomerDetails.color___percent:''},
                 @endif
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(GeneralPurchaseReportCustomerDetails.total)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.total___percent)?GeneralPurchaseReportCustomerDetails.total___percent:''},
                 {Name: '@lang("layout.Count")', column_name: 'count',checkedColumn:(GeneralPurchaseReportCustomerDetails.count)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.count___percent)?GeneralPurchaseReportCustomerDetails.count___percent:''},
                 {Name: '@lang("layout.StartDate")', column_name: 'startDate',checkedColumn:(GeneralPurchaseReportCustomerDetails.startDate)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.startDate___percent)?GeneralPurchaseReportCustomerDetails.startDate___percent:''},
                 {Name: '@lang("layout.EndDate")', column_name: 'endDate',checkedColumn:(GeneralPurchaseReportCustomerDetails.endDate)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.endDate___percent)?GeneralPurchaseReportCustomerDetails.endDate___percent:''},
                 {Name: '@lang("layout.Amount") $', column_name: 'dollarAmount',checkedColumn:(GeneralPurchaseReportCustomerDetails.dollarAmount)?'checked':'',column_percentage:(GeneralPurchaseReportCustomerDetails.dollarAmount___percent)?GeneralPurchaseReportCustomerDetails.dollarAmount___percent:''},
                 
                ];
 
          vm.cust_rep = GeneralPurchaseReportCustomerDetails

      
      
    }
    /////////End GeneralPurchaseReportCustomer

    ////////Begain GeneralPurchaseVendorPaymentReport
    if (type_id == 'GeneralPurchaseVendorPaymentReport') {
      var myhtml = `<input type="hidden" name="type" value="GeneralPurchaseVendorPaymentReport"/>`;
      vm.getModalContent(myhtml);

      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.record)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.record___percent)?GeneralPurchaseVendorPaymentReportDetails.record___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.reference_number)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.reference_number___percent)?GeneralPurchaseVendorPaymentReportDetails.reference_number___percent:''},
                 {Name: '@lang("layout.BillNumber")', column_name: 'bill_number',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.bill_number)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.bill_number___percent)?GeneralPurchaseVendorPaymentReportDetails.bill_number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.date)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.date___percent)?GeneralPurchaseVendorPaymentReportDetails.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.description)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.description___percent)?GeneralPurchaseVendorPaymentReportDetails.description___percent:''},
                 {Name: '@lang("layout.Vendor")', column_name: 'vendor',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.vendor)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.vendor___percent)?GeneralPurchaseVendorPaymentReportDetails.vendor___percent:''},
                 {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.class)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.class___percent)?GeneralPurchaseVendorPaymentReportDetails.class___percent:''},
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.account)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.account___percent)?GeneralPurchaseVendorPaymentReportDetails.account___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.amount)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.amount___percent)?GeneralPurchaseVendorPaymentReportDetails.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.currency)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.currency___percent)?GeneralPurchaseVendorPaymentReportDetails.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.rate)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.rate___percent)?GeneralPurchaseVendorPaymentReportDetails.rate___percent:''},
                 {Name: '@lang("layout.Payment")', column_name: 'payment',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.payment)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.payment___percent)?GeneralPurchaseVendorPaymentReportDetails.payment___percent:''},
                 {Name: '@lang("layout.Remain")', column_name: 'remain',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.remain)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.remain___percent)?GeneralPurchaseVendorPaymentReportDetails.remain___percent:''},
                 {Name: '@lang("layout.DiscountType")', column_name: 'discount_type',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.discount_type)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.discount_type___percent)?GeneralPurchaseVendorPaymentReportDetails.discount_type___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.discount)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.discount___percent)?GeneralPurchaseVendorPaymentReportDetails.discount___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.user)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.user___percent)?GeneralPurchaseVendorPaymentReportDetails.user___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.total)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.total___percent)?GeneralPurchaseVendorPaymentReportDetails.total___percent:''},
                 @if(getDriverPurchaseReport() =="true")
                 {Name: '@lang("layout.TransferCode")', column_name: 'transfer_code',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.transfer_code)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.transfer_code___percent)?GeneralPurchaseVendorPaymentReportDetails.transfer_code___percent:''},
                 {Name: '@lang("layout.Transporter_name")', column_name: 'transporter_name',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.transporter_name)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.transporter_name___percent)?GeneralPurchaseVendorPaymentReportDetails.transporter_name___percent:''},
                 {Name: '@lang("layout.PlateNumber")', column_name: 'plate_number',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.plate_number)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.plate_number___percent)?GeneralPurchaseVendorPaymentReportDetails.plate_number___percent:''},
                 {Name: '@lang("layout.WayBillNumber")', column_name: 'way_bill_number',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.way_bill_number)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.way_bill_number___percent)?GeneralPurchaseVendorPaymentReportDetails.way_bill_number___percent:''},
                 {Name: '@lang("layout.TotalWeight")', column_name: 'total_weight',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.total_weight)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.total_weight___percent)?GeneralPurchaseVendorPaymentReportDetails.total_weight___percent:''},
                 {Name: '@lang("layout.TotalBori")', column_name: 'total_bori',checkedColumn:(GeneralPurchaseVendorPaymentReportDetails.total_bori)?'checked':'',column_percentage:(GeneralPurchaseVendorPaymentReportDetails.total_bori___percent)?GeneralPurchaseVendorPaymentReportDetails.total_bori___percent:''},
                 @endif
                
                ];
 
      vm.cust_rep = GeneralPurchaseVendorPaymentReportDetails
    }
    /////////End GeneralPurchaseVendorPaymentReport

    ////////Begain Invoice
    if (type_id == 'invoicelistRoll') {
      var myhtml = `<input type="hidden" name="type" value="invoicelistRoll"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Invoice



    ////////Begain Estimate
    if (type_id == 'estimates') {
      var myhtml = `<input type="hidden" name="type" value="estimates"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Estimate



    ////////Begain Purchase
    if (type_id == 'purchaselist') {
      var myhtml = `<input type="hidden" name="type" value="purchaselist"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Purchase


    ////////Begain Bill
    if (type_id == 'builllist') {
      var myhtml = `<input type="hidden" name="type" value="builllist"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Bill



    ////////Begain PurchaseOrder
    if (type_id == 'purchaseorderlist') {
      var myhtml = `<input type="hidden" name="type" value="purchaseorderlist"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End PurchaseOrder

    ////////Begain Bill
    if (type_id == 'builllistRoll') {
      var myhtml = `<input type="hidden" name="type" value="builllistRoll"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Bill 

    ////////Begain Expense
    if (type_id == 'ExpenseList') {
      var myhtml = `<input type="hidden" name="type" value="ExpenseList"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Expense


    ////////Begain Expense
    if (type_id == 'dailyExpenses') {
      var myhtml = `<input type="hidden" name="type" value="dailyExpenses"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Expense
 
    ////////Begain Expense
    if (type_id == 'contract') {
      var myhtml = `<div  class="col-md-12">
                                <label class="control-label ">@lang('layout.ContractNumber') </label>
                                <input type="number" name="number" class="form-control" >
                            </div>
                            <input type="hidden" name="type" value="contract"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Expense



    ////////Begain SendMoney
    if (type_id == 'sendMoney') {
      var myhtml = `<div  class="col-md-12">
                                <label class="control-label ">@lang('layout.ContractNumber') </label>
                                <input type="number" name="number" class="form-control" >
                            </div>
                            <input type="hidden" name="type" value="sendMoney"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End SendMoney



    ////////Begain Payment
    if (type_id == 'all_pay') {
      var myhtml = ` <input type="hidden" name="type" value="all_pay"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Payment







    ////////Begain Receive
    if (type_id == 'receive') {
      var myhtml = ` <input type="hidden" name="type" value="receive"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Receive



    ////////Begain Loan
    if (type_id == 'allLoanReports') {
      var myhtml = `<div  class="col-md-12">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="type_name" id="" class="form-control">
                    <option  value="">@lang('layout.SelectType')</option>
                    @foreach($loan as  $type)
                    <option  value="{{$type->type}}">{{$type->type}}</option>
                    @endforeach
                </select>
            </div><input type="hidden" name="type" value="allLoanReports"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Loan




    ////////Begain Employee
    if (type_id == 'Employee') {
      var myhtml = `<div  class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option  value="" selected="selected">@lang('layout.WithStatment')</option>
                                <option value="2">@lang('layout.WithoutStatment')</option>
                                <option value="3">@lang('layout.MemberWithoutTransaction')</option>
                                <option value="1">@lang('layout.All')</option>
                            </select>
                        </div><input type="hidden" name="type" value="member_statment"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Employee



    ////////Begain SalaryDetails
    if (type_id == 'SalaryDetailsList') {
      var myhtml = `<input type="hidden" name="type" value="SalaryDetailsList"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep_SalaryDetails.record)?'checked':'',column_percentage:(cust_rep_SalaryDetails.record___percent)?cust_rep_SalaryDetails.record___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep_SalaryDetails.date)?'checked':'',column_percentage:(cust_rep_SalaryDetails.date___percent)?cust_rep_SalaryDetails.date___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep_SalaryDetails.name)?'checked':'',column_percentage:(cust_rep_SalaryDetails.name___percent)?cust_rep_SalaryDetails.name___percent:''},
                 {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(cust_rep_SalaryDetails.class)?'checked':'',column_percentage:(cust_rep_SalaryDetails.class___percent)?cust_rep_SalaryDetails.class___percent:''},
                 {Name: '@lang("layout.Phone")', column_name: 'phone',checkedColumn:(cust_rep_SalaryDetails.phone)?'checked':'',column_percentage:(cust_rep_SalaryDetails.phone___percent)?cust_rep_SalaryDetails.phone___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep_SalaryDetails.currency)?'checked':'',column_percentage:(cust_rep_SalaryDetails.currency___percent)?cust_rep_SalaryDetails.currency___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep_SalaryDetails.amount)?'checked':'',column_percentage:(cust_rep_SalaryDetails.amount___percent)?cust_rep_SalaryDetails.amount___percent:''},
                 {Name: '@lang("layout.Rent")', column_name: 'rent',checkedColumn:(cust_rep_SalaryDetails.rent)?'checked':'',column_percentage:(cust_rep_SalaryDetails.rent___percent)?cust_rep_SalaryDetails.rent___percent:''},
                 {Name: '@lang("layout.ExpenseAccount")', column_name: 'expense_account',checkedColumn:(cust_rep_SalaryDetails.expense_account)?'checked':'',column_percentage:(cust_rep_SalaryDetails.expense_account___percent)?cust_rep_SalaryDetails.expense_account___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep_SalaryDetails.user)?'checked':'',column_percentage:(cust_rep_SalaryDetails.user___percent)?cust_rep_SalaryDetails.user___percent:''},

                ];


      vm.cust_rep = cust_rep_SalaryDetails
    }
    /////////End SalaryDetails


    ////////Begain Payroll
    if (type_id == 'all_payrolls') {
      var myhtml = `<div  class="col-md-12">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="category" id="" class="form-control">
                    <option  value="" selected="selected">@lang('layout.WithDetail')</option>
                    <option  value="1">@lang('layout.WithoutDetail')</option>
                </select>
            </div><input type="hidden" name="type" value="all_payrolls"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Payroll



    ////////Begain PaySalary
    if (type_id == 'all_payments') {
      var myhtml = `<input type="hidden" name="type" value="all_payments"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End PaySalary



    ////////Begain Customer
    if (type_id == 'Customer') {
      var myhtml = `<div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select name="category" id="" class="form-control">
                            <option  value="" selected="selected">@lang('layout.WithStatment')</option>
                            <option value="2">@lang('layout.WithoutStatment')</option>
                            <option value="3">@lang('layout.MemberWithoutTransaction')</option>
                            <option value="1">@lang('layout.All')</option>
                        </select>
                    </div>
                    <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectClass') </label>
                        <select name="class_id" id="" class="form-control">
                            <option  value="">@lang('layout.SelectClass')</option>
                            @foreach($member_class as  $class)
                            <option  value="{{$class->id}}">{{$class->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label ">@lang('layout.ReportType') </label>
                      <select name="report_type" id="" class="form-control">
                          <option value="">@lang('layout.SelectReportType')</option>
                          <option value="Receivable">@lang('layout.Payable')</option>
                          <option value="Payable">@lang('layout.Receivable')</option>
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label">@lang('layout.IdentifyType')</label>
                      <select name="identify_type" class="form-control">
                          <option value=""> @lang('layout.Select') </option>
                          <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                          <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                      </select>
                    </div> 
                    <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.Style') </label>
                        <select name="style" class="form-control">
                            <option  value="" selected="selected">@lang('layout.Default')</option>
                            <option  value="1">@lang('layout.Style') 1</option>
                            <option  value="2">@lang('layout.Style') 2</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                      <label class="control-label">@lang('layout.Currency') </label>
                        <select class="form-control" name="currency" >
                            <option  value="">@lang('layout.Select')</option>
                          @foreach($currency as  $cur)
                            <option  value="{{$cur->code}}">{{$cur->code}}</option>
                          @endforeach
                        </select>  
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label class="control-label">@lang('layout.AllStatment')
                        <input type="checkbox" class="form-control" name="all_statment" value="true">
                        </label>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label class="control-label">@lang('layout.PeopleReceive')
                        <input type="checkbox" class="form-control" name="peopleReceive" value="true">
                        </label>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label">@lang('type.FromAmount') </label>
                      <input type="number" name="from_amount" class="form-control" />
                    </div>
                    <div class="col-md-6">
                      <label class="control-label">@lang('type.ToAmount') </label>
                      <input type="number" name="to_amount" class="form-control" />
                    </div>
                    <input type="hidden" name="type" value="member_statment"/>`;
      vm.getModalContent(myhtml);
      vm.customReportData =
      [
        {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(CustomerDetails.number)?'checked':'',column_percentage:(CustomerDetails.number___percent)?CustomerDetails.number___percent:''},
        {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(CustomerDetails.name)?'checked':'',column_percentage:(CustomerDetails.name___percent)?CustomerDetails.name___percent:''},
        {Name: '@lang("layout.Phone")', column_name: 'phone',checkedColumn:(CustomerDetails.phone)?'checked':'',column_percentage:(CustomerDetails.phone___percent)?CustomerDetails.phone___percent:''},
        {Name: '@lang("layout.Class")', column_name: 'member_class',checkedColumn:(CustomerDetails.member_class)?'checked':'',column_percentage:(CustomerDetails.member_class___percent)?CustomerDetails.member_class___percent:''},
        {Name: '@lang("layout.City")', column_name: 'city1',checkedColumn:(CustomerDetails.city1)?'checked':'',column_percentage:(CustomerDetails.city1___percent)?CustomerDetails.city1___percent:''},
        {Name: '@lang("layout.Address")', column_name: 'address1',checkedColumn:(CustomerDetails.address1)?'checked':'',column_percentage:(CustomerDetails.address1___percent)?CustomerDetails.address1___percent:''},
        {Name: '@lang("layout.PayableTotal")', column_name: 'payable_home_currency',checkedColumn:(CustomerDetails.payable_home_currency)?'checked':'',column_percentage:(CustomerDetails.payable_home_currency___percent)?CustomerDetails.payable_home_currency___percent:''},
        {Name: '@lang("layout.ReceivableTotal")', column_name: 'receivable_home_currency',checkedColumn:(CustomerDetails.receivable_home_currency)?'checked':'',column_percentage:(CustomerDetails.receivable_home_currency___percent)?CustomerDetails.receivable_home_currency___percent:''},
        {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(CustomerDetails.currency)?'checked':'',column_percentage:(CustomerDetails.currency___percent)?CustomerDetails.currency___percent:''},
        {Name: '@lang("layout.Receivable")', column_name: 'receivable',checkedColumn:(CustomerDetails.receivable)?'checked':'',column_percentage:(CustomerDetails.receivable___percent)?CustomerDetails.receivable___percent:''},
        {Name: '@lang("layout.Payable")', column_name: 'payable',checkedColumn:(CustomerDetails.payable)?'checked':'',column_percentage:(CustomerDetails.payable___percent)?CustomerDetails.payable___percent:''},
        {Name: '@lang("layout.Balance")', column_name: 'balance',checkedColumn:(CustomerDetails.balance)?'checked':'',column_percentage:(CustomerDetails.balance___percent)?CustomerDetails.balance___percent:''},
        {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(CustomerDetails.total)?'checked':'',column_percentage:(CustomerDetails.total___percent)?CustomerDetails.total___percent:''},
        {Name: '@lang("layout.JobTitle")', column_name: 'job_title',checkedColumn:(CustomerDetails.job_title)?'checked':'',column_percentage:(CustomerDetails.job_title___percent)?CustomerDetails.job_title___percent:''},
        {Name: '@lang("layout.Salary")', column_name: 'salary',checkedColumn:(CustomerDetails.salary)?'checked':'',column_percentage:(CustomerDetails.salary___percent)?CustomerDetails.salary___percent:''},
        {Name: '@lang("layout.FatherName")', column_name: 'father_name',checkedColumn:(CustomerDetails.father_name)?'checked':'',column_percentage:(CustomerDetails.father_name___percent)?CustomerDetails.father_name___percent:''},
        {Name: '@lang("layout.BloodGroup")', column_name: 'blood_group',checkedColumn:(CustomerDetails.blood_group)?'checked':'',column_percentage:(CustomerDetails.blood_group___percent)?CustomerDetails.blood_group___percent:''},
        {Name: '@lang("layout.Email")', column_name: 'email',checkedColumn:(CustomerDetails.email)?'checked':'',column_percentage:(CustomerDetails.email___percent)?CustomerDetails.email___percent:''},
        {Name: '@lang("layout.TotalBalances")', column_name: 'total_balance',checkedColumn:(CustomerDetails.total_balance)?'checked':'',column_percentage:(CustomerDetails.total_balance___percent)?CustomerDetails.total_balance___percent:''},
        {Name: '@lang("layout.TotalPerCurrency")', column_name: 'total_per_currency',checkedColumn:(CustomerDetails.total_per_currency)?'checked':'',column_percentage:(CustomerDetails.total_per_currency___percent)?CustomerDetails.total_per_currency___percent:''},
        {Name: '@lang("layout.LastDate")', column_name: 'lastDate',checkedColumn:(CustomerDetails.lastDate)?'checked':'',column_percentage:(CustomerDetails.lastDate___percent)?CustomerDetails.lastDate___percent:''},
      ];
      vm.cust_rep = CustomerDetails
    }
    /////////End Customer



    ////////Begain Sumary Accounts............................................................
    if (type_id == 'summaryAccount') {
      var myhtml = `
                    <div  class="col-md-6">
                      <label class="control-label ">@lang('layout.SelectClass') </label>
                      <select name="class_id" id="" class="form-control">
                        <option  value="">@lang('layout.SelectClass')</option>
                        @foreach($member_class as  $class)
                        <option  value="{{$class->id}}">{{$class->name}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label">@lang('layout.Currency') </label>
                      <select class="form-control" name="currency" >
                          <option  value="">@lang('layout.Select')</option>
                        @foreach($currency as  $cur)
                          <option  value="{{$cur->code}}">{{$cur->code}}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-md-6">
                      <label class="control-label">@lang('layout.CheckM') </label>
                      <input type="number" name="from_amount" class="form-control" />
                    </div>
                    <div class="col-md-6">
                      <label class="control-label">@lang('layout.PreviousBilance') </label>
                      <input type="number" name="to_amount" class="form-control" />
                    </div>
                    <input type="hidden" name="type" value="summaryAccountStatement"/>`;
      vm.getModalContent(myhtml);
  
      
    }
    /////////End of Sumary Accounts .......................................................

    ////////Begain Member Statement Report By Type
    if (type_id == 'MemberStatementReportByType') {
      var myhtml = `<div  class="col-md-6">
                <label class="control-label ">@lang('layout.SelectType') </label>
                <select name="type_name" id="" class="form-control">
                    <option  value="" selected="selected">@lang('layout.SelectType')</option>
                    <option value="Employee">@lang('layout.Employee')</option>
                    <option value="Customer">@lang('layout.Customer')</option>
                    <option value="Vendor">@lang('layout.Vendor')</option>
                    <option value="Driver">@lang('layout.Driver')</option>
                </select>
            </div>
            <div  class="col-md-6">
                <label class="control-label ">@lang('layout.SelectClass') </label>
                <select name="class_id" id="" class="form-control">
                    <option  value="">@lang('layout.SelectClass')</option>
                    @foreach($member_class as  $class)
                    <option  value="{{$class->id}}">{{$class->name}}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6">
              <label class="control-label">@lang('layout.IdentifyType')</label>
              <select name="identify_type" class="form-control">
                  <option value=""> @lang('layout.Select') </option>
                  <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                  <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
              </select>
            </div> 
            <div class="col-md-6">
              <label class="control-label">@lang('layout.Currency') </label>
              <select class="form-control" name="currency" >
                  <option  value="">@lang('layout.Select')</option>
                @foreach($currency as  $cur)
                  <option  value="{{$cur->code}}">{{$cur->code}}</option>
                @endforeach
              </select>
            </div>
            <input type="hidden" name="type" value="member_statement_report_by_type"/>`;
      vm.getModalContent(myhtml);



      
    }
    /////////End Member Statement Report By Type

    ////////Begain Employee Statement Report By Type
    if (type_id == 'EmployeeStatementReportByType') {
      var myhtml = `
            <input type="hidden" name="type_name" value="Employee"/>
            <div  class="col-md-6">
                <label class="control-label ">@lang('layout.SelectClass') </label>
                <select name="class_id" id="" class="form-control">
                    <option  value="">@lang('layout.SelectClass')</option>
                    @foreach($member_class as  $class)
                    <option  value="{{$class->id}}">{{$class->name}}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6">
              <label class="control-label">@lang('layout.IdentifyType')</label>
              <select name="identify_type" class="form-control">
                  <option value=""> @lang('layout.Select') </option>
                  <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                  <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
              </select>
            </div> 
            <div class="col-md-6">
              <label class="control-label">@lang('layout.Currency') </label>
              <select class="form-control" name="currency" >
                  <option  value="">@lang('layout.Select')</option>
                @foreach($currency as  $cur)
                  <option  value="{{$cur->code}}">{{$cur->code}}</option>
                @endforeach
              </select>
            </div>
            <input type="hidden" name="type" value="employee_statement_report_by_type"/>`; 
      vm.getModalContent(myhtml);
    }
    /////////End Member Statement Report By Type

    ////////Begain Customer Report
    if (type_id == 'CustomerReport') {
      var myhtml = `<input type="hidden" name="type" value="member_statment_report"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Customer Report





    ////////Begain Vendor
    if (type_id == 'Vendor') {
      var myhtml = `<div  class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option  value="" selected="selected">@lang('layout.WithStatment')</option>
                                <option value="2">@lang('layout.WithoutStatment')</option>
                                <option value="3">@lang('layout.MemberWithoutTransaction')</option>
                                <option value="1">@lang('layout.All')</option>
                            </select>
                        </div><input type="hidden" name="type" value="member_statment"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Vendor


    ////////Begain Drawing
    if (type_id == 'allDrawings') {
      var myhtml = `<input type="hidden" name="type" value="allDrawings"/>`;
      vm.customReportData =
                [
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep_drawing.number)?'checked':'',column_percentage:(cust_rep_drawing.number___percent)?cust_rep_drawing.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep_drawing.date)?'checked':'',column_percentage:(cust_rep_drawing.date___percent)?cust_rep_drawing.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep_drawing.description)?'checked':'',column_percentage:(cust_rep_drawing.description___percent)?cust_rep_drawing.description___percent:''},
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep_drawing.name)?'checked':'',column_percentage:(cust_rep_drawing.name___percent)?cust_rep_drawing.name___percent:''},
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep_drawing.account)?'checked':'',column_percentage:(cust_rep_drawing.account___percent)?cust_rep_drawing.account___percent:''},
                 {Name: '@lang("layout.Equity")', column_name: 'equity',checkedColumn:(cust_rep_drawing.equity)?'checked':'',column_percentage:(cust_rep_drawing.equity___percent)?cust_rep_drawing.equity___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep_drawing.amount)?'checked':'',column_percentage:(cust_rep_drawing.amount___percent)?cust_rep_drawing.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep_drawing.currency)?'checked':'',column_percentage:(cust_rep_drawing.currency___percent)?cust_rep_drawing.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep_drawing.rate)?'checked':'',column_percentage:(cust_rep_drawing.rate___percent)?cust_rep_drawing.rate___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep_drawing.user)?'checked':'',column_percentage:(cust_rep_drawing.user___percent)?cust_rep_drawing.user___percent:''},

                ];


      vm.cust_rep = cust_rep_drawing

      vm.getModalContent(myhtml);
    }
    /////////End Drawing   
    
     ////////Begain Flour
    if (type_id == 'allCustoms') {
      var myhtml = `<input type="hidden" name="type" value="allCustoms"/>`;
      vm.getModalContent(myhtml);
    }    
    if (type_id == 'allLaboratoryTest') {
      var myhtml = `<input type="hidden" name="type" value="allLaboratoryTest"/>`;
      vm.getModalContent(myhtml);
    }    
    if (type_id == 'allWeighbridge') {
      var myhtml = `<input type="hidden" name="type" value="allWeighbridge"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End Flour




    ////////Begain Drawing
    if (type_id == 'memberTransferList') {
      var myhtml = `<input type="hidden" name="type" value="memberTransferList"/>`;
      vm.customReportData =
                [
                 
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep_memberTransfer.name)?'checked':'',column_percentage:(cust_rep_memberTransfer.name___percent)?cust_rep_memberTransfer.name___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep_memberTransfer.description)?'checked':'',column_percentage:(cust_rep_memberTransfer.description___percent)?cust_rep_memberTransfer.description___percent:''},
                 {Name: '@lang("layout.Parent")', column_name: 'parent',checkedColumn:(cust_rep_memberTransfer.parent)?'checked':'',column_percentage:(cust_rep_memberTransfer.parent___percent)?cust_rep_memberTransfer.parent___percent:''},
                 {Name: '@lang("layout.CreatedAt")', column_name: 'created_at',checkedColumn:(cust_rep_memberTransfer.created_at)?'checked':'',column_percentage:(cust_rep_memberTransfer.created_at___percent)?cust_rep_memberTransfer.created_at___percent:''},
                 {Name: '@lang("layout.UpdatedAt")', column_name: 'updated_at',checkedColumn:(cust_rep_memberTransfer.updated_at)?'checked':'',column_percentage:(cust_rep_memberTransfer.updated_at___percent)?cust_rep_memberTransfer.updated_at___percent:''},

                  ];

      vm.cust_rep = cust_rep_memberTransfer
      vm.getModalContent(myhtml);
    }
    /////////End Drawing


    ////////Begain BalanceSheet
    if (type_id == 'blanceSheet') {
      var myhtml = `<input type="hidden" name="type" value="blanceSheet"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End BalanceSheet



    ////////Begain IncomeStatement
    if (type_id == 'financial_income') {
      var myhtml = `<input type="hidden" name="type" value="financial_income"/>`;
      vm.getModalContent(myhtml);
    }
    /////////End IncomeStatement

    /// begin   all build detail
    if (type_id == 'all_build_detail') {

      var myhtml = `<input type="hidden" name="type" value="all_build_detail"/>`;
      vm.getModalContent(myhtml);
    }

    /// end all build detail


    // e.preventDefault();
  }
  function toggleCollaps(el) {
    var e = $(el);
    var temp = e.parent;
    // temppp.childrin('.child').css({"display":"block"});

  }

//Begin Toggle div
  function showBody(partName){
    if(partName == "financial")
    {
        $('#financial_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#financial').toggle();
    }
    if(partName == "account")
    {
        $('#account_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#account').toggle();
    }
    if(partName == "inventory")
    {
        $('#inventory_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#inventory').toggle();
    }
    if(partName == "service")
    {
        $('#service_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#service').toggle();
    }
    if(partName == "assembly")
    {
        $('#assembly_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#assembly').toggle();
    }    
    if(partName == "sale")
    {
        $('#sale_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#sale').toggle();
    }    
    if(partName == "purchase")
    {
        $('#purchase_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#purchase').toggle();
    }    
    if(partName == "expense")
    {
        $('#expense_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#expense').toggle();
    }    
    if(partName == "contract")
    {
        $('#contract_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#contract').toggle();
    }     
    if(partName == "pay")
    {
        $('#pay_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#pay').toggle();
    }    
    if(partName == "loan")
    {
        $('#loan_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#loan').toggle();
    } if(partName == "employee")
    {
        $('#employee_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#employee').toggle();
    } if(partName == "member_statement")
    {
        $('#member_statement_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#member_statement').toggle();
    } if(partName == "drawing")
    {
        $('#drawing_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#drawing').toggle();
    } if(partName == "flour")
    {
        $('#flour_fa').toggleClass("fa-angle-left fa-angle-down");
        $('#flour').toggle();
    }
  }
</script>

@endpush