@extends('layouts.app')

@section('style')
<style type="text/css">
    .modal.in .modal-dialog {
        margin: 40px auto;
        width: 80%;
    }
</style>
@stop
@section('content')

<!------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------->
<!--Expense Report Modal-->
<div id="print-modal">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'vehicle_rent_expenses'" @closed="closeModal">

        <div slot="body">
            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!--End Expense Report Modal-->

<!--Locaion Report Modal-->
<div id="print-modal-location">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'vehicle_rent_locations'" @closed="closeModal">

        <div slot="body">
            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!--End Locaion Report Modal-->

<!--Expense Return Report Modal-->
<div id="print-modal-return">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'vehicle_rent_return'" @closed="closeModal">

        <div slot="body">
            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!--End Expense Return Report Modal-->

<!--Expense Return Report Modal-->
<div id="print-modal-receive">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'vehicle_rent_receive'" @closed="closeModal">

        <div slot="body">
            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!--End Expense Return Report Modal-->
<!------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------->


<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.VehicleRentShow')
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
            {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#CustomerDetailss" data-toggle="tab"> @lang('layout.VehicleRentDetail') <i class="fa fa-tasks"></i> </a>
                    </li>
                    <li>
                        <a href="#tab_15_2" data-toggle="tab"> @lang('layout.FinanceDetails') <i class="fa  "></i> </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="CustomerDetailss">
                        <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                            <thead>
                                <tr>
                                    <th class="">
                                        <i class="fa fa-bars"></i> @lang('layout.ReferenceNumber')
                                    </th>
                                    <th class="">
                                        <i class="fa fa-user"></i> @lang('layout.Customer')
                                    </th>
                                    <th class="">
                                        <i class="fa fa-user"></i> @lang('layout.Driver')
                                    </th>
                                    <th class="">
                                        <i class="fa fa-car"></i> @lang('layout.VehicleName')
                                    </th>
                                    <th class="">
                                        <i class="fa fa-car"></i> @lang('layout.PaletNumber')
                                    </th>
                                    <th class="">
                                        <i class="fa fa-car"></i> @lang('layout.Tanker')
                                    </th>
                                    <th class="">
                                        <i class="fa "></i> @lang('layout.Road')
                                    </th>
                                    <th>
                                        <i class="icon-phone"></i> @lang('layout.Phone')
                                    </th>
                                    <th>
                                        <i class="fa fa-clock-o"></i> @lang('layout.Date')
                                    </th>
                                    <th>
                                        <i class="fa"></i> @lang('layout.DischargeDate')
                                    </th>
                                    <th>
                                        <i class="fa "></i> @lang('layout.Description')
                                    </th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class=""> {{ $vehicleM->code}} </td>
                                    <td class=""> {{ $vehicleM->customer_name}} </td>
                                    <td class=""> {{ $vehicleM->driver_name}}</td>
                                    <td class=""> {{ $vehicleM->vehicle_name}}</td>
                                    <td class=""> {{ $vehicleM->palet_number}}</td>
                                    <td class=""> {{ $vehicleM->tanker_name}}</td>
                                    <td class=""> {{ $vehicleM->road}}</td>
                                    <td class=""> {{ $vehicleM->phone1}}</td>
                                    <td class=""> {{ $vehicleM->date}}</td>
                                    <td class=""> {{ $vehicleM->discharge_date}}</td>
                                    <td class=""> {{ $vehicleM->description}}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="tab-pane" id="tab_15_2">
                        <table class="table table-striped table-bordered table-advance table-hover" id="table_payment">
                            <thead>
                                <tr>
                                    <th>
                                        <i class="fa  "></i> @lang('layout.Currency')
                                    </th>
                                    <th>
                                        <i class="fa "></i> @lang('layout.Rate')
                                    </th>

                                    <th class="">
                                        <i class="fa  " style="color:#3FABA4"></i> @lang('layout.Amount')
                                    </th>
                                    <th class="">
                                        <i class="fa fa-get-pocket" style="color: green"></i> @lang('layout.Receive')
                                    </th>
                                    <th>
                                        <i class="fa fa-minus-circle" style="color:#E87E04"></i> @lang('layout.RemainAmount')
                                    </th>
                                    <th>
                                        <i class="fa fa-cart-plus" style="color: #F7CA18; font-size: 16px;"></i> @lang('layout.Expense')
                                    </th>
                                    <th>
                                        <i class="fa fa-cart-plus" style="color: #F7CA18; font-size: 16px;"></i> @lang('layout.ReturnExpense')
                                    </th>
                                    <th>
                                        <i class="fa fa-briefcase" style="color:green;font-size: 15px;"></i> @lang('layout.EarnedAmount')
                                    </th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr>
                                    <td class=""> {{ $vehicleM->currency}} </td>
                                    <td class=""> {{ $vehicleM->rate}} </td>
                                    <td class=""> {{$vehicleM->Amount}} {{$vehicleM->currency}} </td>
                                    <td class="">{{$totalRecevie}} {{$vehicleM->currency}} </td>
                                    <td class="">{{$totalPAmount}} {{$vehicleM->currency}} </td>
                                    <td class="">{{$totalExpensedAmount}} {{$vehicleM->currency}}</td>
                                    <td class="">{{$totalReturnExpensedAmount}} {{$vehicleM->currency}}</td>
                                    <td class="">{{$totalearnedAmount}}{{$vehicleM->currency}} </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- '''''''''''''''''''''''' -->
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleRentDetail')</span>
                </div>

            </div>
            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#expense" data-toggle="tab" id="expensesd"> @lang('layout.Expense') <i class="fa fa-list-alt"></i></a>
                    </li>
                    <li>
                        <a href="#item" data-toggle="tab" id="items"> @lang('layout.Location') <i class="fa fa-list"></i> </a>
                    </li>
                    <li>
                        <a href="#returnExpense" data-toggle="tab" id="returnExpenseTab"> @lang('layout.ReturnExpense') <i class="fa fa-credit-card"></i></a>
                    </li>
                    <!-- li>
                            <a href="#sentmoney" data-toggle="tab" id="money"> @lang('layout.ProjectServices') <i class="fa  "></i></a>
                        </li>
                        <li>
                            <a href="#projectDeliveryService" data-toggle="tab" id="projectDeliveryServiceTab"> @lang('layout.ProjectDeliveryService') <i class="fa fa-building"></i></a>
                        </li -->
                    <li>
                        <a href="#receivablePayment" data-toggle="tab" id="recevie"> @lang('layout.Recevies') <i class="fa fa-credit-card"></i></a>
                    </li>
                    <!-- li>
                            <a href="#usedItems" data-toggle="tab" id="useditem"> @lang('layout.UsedItems') <i class="fa fa-list-ul"></i></a>
                        </li>
                        <li>
                            <a href="#glassDetail" data-toggle="tab" id="glassDetails"> @lang('layout.GlassDetails') <i class="fa fa-square-o"></i></a>
                        </li -->
                    <li>
                        <a href="#attachments_tab" data-toggle="tab" id="attachments"> @lang('layout.Attachments') </a>
                    </li>

                </ul>
                <div class="tab-content">

                    <div class="tab-pane active" id="expense">
                        <div class="">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.Expense')</span>
                                    </div>
                                    <div class="actions">


                                        <span id="anchore-modal">
                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                <i class="fa fa-print"></i>
                                            </a>
                                        </span>

                                    </div>
                                </div>
                                <div class="portlet-body" id="itemsshow">
                                    <table class="table table-striped table-bordered table-hover" id="expense-table">
                                        <thead>
                                            <tr>
                                                <!-- <th>@lang('layout.ProjectName')</th> -->
                                                <th>@lang('layout.Description')</th>
                                                <th>@lang('layout.Date')</th>
                                                <th>@lang('layout.Currency')</th>
                                                <th>@lang('layout.Amount')</th>
                                                <th>@lang('layout.Rate')</th>
                                                <th>@lang('layout.Actions')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>


                    <div class="tab-pane" id="item">
                        <div class="tab-pane" id="tab_15_1">

                            <div class="">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">



                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.Location')</span>
                                        </div>
                                        <div class="actions">
                                            <span id="anchore-modal-location">
                                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="item-table">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.State')</th>
                                                    <th>@lang('layout.Road')</th>
                                                    <th>@lang('layout.Location')</th>
                                                    <th>@lang('layout.Source')</th>
                                                    <th>@lang('layout.Destination')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Actions')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane" id="sentmoney">
                        <div class="tab-pane" id="tab_15_1">

                            <div class="">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.Services')</span>
                                        </div>
                                        <div class="actions">

                                            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                            <input type="hidden" name="type" value="projectShowService" />
                                            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
                                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                            {{Form::close()}}
                                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                            <input type="hidden" name="type" value="projectShowService" />
                                            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
                                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                            {{Form::close()}}
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="sentmoney-table">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Number')</th>
                                                    <th>@lang('layout.Item')</th>
                                                    <th>@lang('layout.Quantity')</th>
                                                    <th>@lang('layout.Measure')</th>
                                                    <th>@lang('layout.Cost')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane" id="receivablePayment">
                        <div class="tab-pane" id="tab_15_1">

                            <div class="">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.Recevies')</span>
                                        </div>
                                        <div class="actions">
                                            <span id="anchore-modal-receive">
                                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </span>

                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="receivablePayment-table">
                                            <thead>
                                                <tr>
                                                    <!-- <th>@lang('layout.Name')</th> -->
                                                    <th>@lang('layout.Account')</th>
                                                    <th>@lang('layout.Currency')</th>
                                                    <th>@lang('layout.Rate')</th>
                                                    <th>@lang('layout.Type')</th>
                                                    <th>@lang('layout.Amount')</th>
                                                    <th>@lang('layout.Date')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>


                    <div id="form_modal2" class="modal fade col-md-12" role="dialog" aria-hidden="true">

                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title">@lang("layout.ExpenseItems")</h2>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                            <div class="portlet light bordered">

                                                <div class="tabbable-line">
                                                    <ul class="nav nav-tabs ">
                                                        <li class="active">
                                                            <a href="#expenseItem" data-toggle="tab" id="expensesd"> @lang('layout.Expense') <i class="fa fa-list-alt"></i></a>
                                                        </li>
                                                        <li>
                                                            <a href="#itemModal" data-toggle="tab" id="items"> @lang('layout.ExpenseDetails') <i class="fa fa-list"></i> </a>
                                                        </li>
                                                    </ul>
                                                    <div class="tab-content">

                                                        <div class="tab-pane active" id="expenseItem">
                                                            <div class="col-md-12">
                                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                                <div class="portlet light bordered">
                                                                    <div class="portlet-title">
                                                                        <div class="caption font-dark">
                                                                            <i class="icon-settings font-dark"></i>
                                                                            <span class="caption-subject bold uppercase">@lang('layout.ExpenseDetails')</span>
                                                                        </div>

                                                                    </div>
                                                                    <div class="portlet-body" id="itemshow">
                                                                        <table class="table table-striped table-bordered table-hover" id="expenseitem-table">
                                                                            <thead>
                                                                                <tr>
                                                                                    <th>@lang('layout.Item')</th>
                                                                                    <th>@lang('layout.Quantity')</th>
                                                                                    <th>@lang('layout.Measure')</th>
                                                                                    <th>@lang('layout.Price')</th>
                                                                                    <th>@lang('layout.Details')</th>
                                                                                    <th>@lang('layout.Amount')</th>
                                                                                </tr>
                                                                            </thead>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <!-- END EXAMPLE TABLE PORTLET-->
                                                            </div>
                                                        </div>


                                                        <div class="tab-pane" id="itemModal">
                                                            <div class="tab-pane" id="tab_15_1">

                                                                <div class="col-md-12">
                                                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                                    <div class="portlet light bordered">
                                                                        <div class="portlet-title">
                                                                            <div class="caption font-dark">
                                                                                <i class="icon-settings font-dark"></i>
                                                                                <span class="caption-subject bold uppercase">@lang('layout.MaintenanceDetails')</span>
                                                                            </div>
                                                                            <div class="actions">
                                                                                {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                                                                <input type="hidden" name="type" value="project_expense_Details" />
                                                                                <input type="hidden" name="id" id="maintain_excel" />
                                                                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                                                                {{Form::close()}}

                                                                                {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                                                                <input type="hidden" name="type" value="project_expense_Details" />
                                                                                <input type="hidden" name="id" id="maintain_pdf" />
                                                                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                                                                {{Form::close()}}
                                                                            </div>

                                                                        </div>
                                                                        <div class="portlet-body">
                                                                            <table class="table table-striped table-bordered table-hover" id="itemshowsmodal-table">
                                                                                <thead>
                                                                                    <tr>
                                                                                        <th>@lang('layout.Details')</th>
                                                                                        <th>@lang('layout.Amount')</th>
                                                                                        <th>@lang('layout.CreatedAt')</th>
                                                                                    </tr>
                                                                                </thead>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                                    <!-- END EXAMPLE TABLE PORTLET-->
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <input type="hidden" id="item_id">
                                    <button class="btn btn-default btn-outline" data-dismiss="modal" aria-hidden="true">@lang("layout.Close")</button>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="tab-pane" id="usedItems">
                        <div class="tab-pane" id="tab_15_1">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.UsedItems')</span>
                                        </div>
                                        <div class="actions">
                                            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                            <input type="hidden" name="type" value="usedItemsShow" />
                                            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
                                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                            {{Form::close()}}
                                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                            <input type="hidden" name="type" value="usedItemsShow" />
                                            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
                                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                            {{Form::close()}}
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="usedItems-table">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Item')</th>
                                                    <th>@lang('layout.Site')</th>
                                                    <th>@lang('layout.Quantity')</th>
                                                    <th>@lang('layout.Measure')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Description')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="glassDetail">
                        <div class="tab-pane" id="tab_15_1">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.GlassDetails')</span>
                                        </div>
                                        <div class="actions">

                                            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                                            <input type="hidden" name="type" value="glassDetails" />
                                            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
                                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                            {{Form::close()}}
                                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                            <input type="hidden" name="type" value="glassDetails" />
                                            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
                                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                            {{Form::close()}}
                                            <button type="button" class="btn btn-success" onclick="ProjectGlassesPrint('{{$vehicleM->id}}')"> <i class="icon-printer"></i> @lang('layout.Print') </button>
                                            <a href="{{route('glassDetail.edit',$vehicleM->id)}}">
                                                <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Edit') </button></a>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="glassDetails_table">
                                            <thead>
                                                <tr>
                                                    <!-- <th>@lang('layout.Name')</th> -->
                                                    <th>@lang('layout.Width')</th>
                                                    <th>@lang('layout.Height')</th>
                                                    <th>@lang('layout.Quantity')</th>
                                                    <th>@lang('layout.Metrazh')</th>
                                                    <th>@lang('layout.GlassType')</th>
                                                    <th>@lang('layout.WindowType')</th>
                                                    <th>@lang('layout.SpeserSize')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Actions')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="projectDeliveryService">
                        <div class="tab-pane" id="tab_15_1">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.ProjectDeliveryService')</span>
                                        </div>
                                        <div class="actions">
                                            {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                            <input type="hidden" name="type" value="ProjectDelivery_service_details" />
                                            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
                                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                            {{Form::close()}}
                                            {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                            <input type="hidden" name="type" value="ProjectDelivery_service_details" />
                                            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
                                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                            {{Form::close()}}
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="projectDeliveryService-table">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.ItemName')</th>
                                                    <th>@lang('layout.MeasureUnit')</th>
                                                    <th>@lang('layout.Quantity')</th>
                                                    <th>@lang('layout.Price')</th>
                                                    <th>@lang('layout.Date')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="returnExpense">
                        <div class="tab-pane" id="tab_15_1">
                            <div class="">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.ReturnExpense')</span>
                                        </div>
                                        <div class="actions">
                                            <span id="anchore-modal-return">
                                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="returnExpense-table">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Currency')</th>
                                                    <th>@lang('layout.Amount')</th>
                                                    <th>@lang('layout.Rate')</th>
                                                    <th>@lang('layout.Actions')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>


                    <div class="tab-pane" id="attachments_tab">
                        <div class="tab-pane" id="tab_15_1">

                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                    </div>

                                </div>
                                <div class="portlet-body">
                                    <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                                @csrf
                                                <input type="hidden" name="redirect_route" value="rentVehicle.show">
                                                <input type="hidden" name="foreign_data_id" value="{{$vehicleM->id}}">
                                                <input type="hidden" name="path" value="uploads/vehicle_managements">
                                                <input type="hidden" name="table_name" value="vehicle_managements">

                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                            <input type="text" name="title" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.Description')</label>
                                                            <textarea name="description" class="form-control"></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-7">
                                                        <div class="form-group">
                                                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                    <img src="" alt=""> </div>
                                                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                                <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input type="file" name="photo"> </span>

                                                                    <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="margiv-top-10">
                                                    <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                    <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <table class="table table-striped table-bordered table-hover" id="attachment">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.AttachmentTitle')</th>
                                                <th>@lang('layout.Description')</th>
                                                <th>@lang('layout.Action')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@include('print.modal')
@push('scripts')
<script>
    function ProjectGlassesPrint(id) {
        @if(!Session('project'))
        var a = document.createElement('a');
        a.href = "{{url('projectGlassPrint')}}/" + id;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        @else

        var u = "{{url('projectGlassPrint')}}/" + id;
        window.location.href = u;
        @endif
    }

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#expense-table').DataTable({
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax: {
                url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                data: {
                    type: 'expenses'
                }
            },
            columns: [{
                    data: 'description',
                    name: 'description'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'unit',
                    name: 'unit'
                },
                {
                    data: 'balance',
                    name: 'balance'
                },
                {
                    data: 'rate',
                    name: 'rate'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    });
    // Contract Date
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#items').on('shown.bs.tab', function(event) {
            $('#item-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                    data: {
                        type: 'location'
                    }
                },
                columns: [{
                        data: 'state',
                        name: 'vehicle_locations.state'
                    },
                    {
                        data: 'road',
                        name: 'vehicle_locations.road'
                    },
                    {
                        data: 'location',
                        name: 'vehicle_locations.location'
                    },
                    {
                        data: 'source',
                        name: 'vehicle_locations.source'
                    },
                    {
                        data: 'destination',
                        name: 'vehicle_locations.destination'
                    },

                    {
                        data: 'Date',
                        name: 'vehicle_locations.date'
                    },
                    {
                        data: 'description',
                        name: 'vehicle_locations.description'
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });
    });
    // Sent Money Table 
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#money').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#sentmoney-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                    data: {
                        type: 'services'
                    }
                },
                columns: [{
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'quantity',
                        name: 'quantity'
                    },
                    {
                        data: 'um',
                        name: 'um'
                    },
                    {
                        data: 'price',
                        name: 'price'
                    },
                ]
            });
        });
    });
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#recevie').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#receivablePayment-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                    data: {
                        type: 'receivablePayment'
                    }
                },
                columns: [
                    // { data: 'name',         name: 'members.name' },
                    {
                        data: 'account',
                        name: 'account',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'currency',
                        name: 'currency',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate',
                        name: 'rate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'type',
                        name: 'type',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'date',
                        name: 'date',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });

        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#useditem').on('shown.bs.tab', function(event) {
                // alert('adads');
                $('#usedItems-table').DataTable({
                    scrollCollapse: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    serverSide: true,
                    paging: true,
                    retrieve: true,
                    ajax: {
                        url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                        data: {
                            type: 'usedItems'
                        }
                    },
                    columns: [
                        // { data: 'name',         name: 'members.name' },
                        {
                            data: 'name',
                            name: 'name',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'site',
                            name: 'site',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'quantity',
                            name: 'quantity',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'measure',
                            name: 'measure',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'date',
                            name: 'date'
                        },
                        {
                            data: 'description',
                            name: 'description'
                        }
                    ]
                });
            });
        });

        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#glassDetails').on('shown.bs.tab', function(event) {
                // alert('adads');
                $('#glassDetails_table').DataTable({
                    scrollCollapse: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    serverSide: true,
                    paging: true,
                    retrieve: true,
                    ajax: {
                        url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                        data: {
                            type: 'glassDetails'
                        }
                    },
                    columns: [{
                            data: 'width',
                            name: 'width',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'height',
                            name: 'height',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'qty',
                            name: 'qty',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'metr',
                            name: 'metr',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'item',
                            name: 'item',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'window_type',
                            name: 'window_type'
                        },
                        {
                            data: 'spencer_size',
                            name: 'spencer_size'
                        },
                        {
                            data: 'description',
                            name: 'description'
                        },
                        {
                            data: 'actions',
                            name: 'actions',
                            orderable: false,
                            searchable: false
                        }
                    ]
                });
            });
        });

        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#returnExpenseTab').on('shown.bs.tab', function(event) {
                // alert('adads');
                $('#returnExpense-table').DataTable({
                    scrollCollapse: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    serverSide: true,
                    paging: true,
                    retrieve: true,
                    ajax: {
                        url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                        data: {
                            type: 'returnExpense'
                        }
                    },
                    columns: [{
                            data: 'description',
                            name: 'description'
                        },
                        {
                            data: 'date',
                            name: 'date'
                        },
                        {
                            data: 'unit',
                            name: 'unit'
                        },
                        {
                            data: 'balance',
                            name: 'balance'
                        },
                        {
                            data: 'rate',
                            name: 'rate'
                        },
                        {
                            data: 'actions',
                            name: 'actions',
                            orderable: false,
                            searchable: false
                        }
                    ]
                });
            });
        });
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#projectDeliveryServiceTab').on('shown.bs.tab', function(event) {
                // alert('adads');
                $('#projectDeliveryService-table').DataTable({

                    retrieve: true,
                    scrollCollapse: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    serverSide: true,
                    paging: true,
                    ajax: {
                        url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                        data: {
                            type: 'deliveryServiceItems'
                        }
                    },
                    columns: [

                        {
                            data: 'item',
                            name: 'item'
                        },
                        {
                            data: 'measure',
                            name: 'measure_unit'
                        },
                        {
                            data: 'qty',
                            name: 'qty'
                        },
                        {
                            data: 'cost',
                            name: 'cost'
                        },
                        {
                            data: 'date',
                            name: 'date'
                        },
                    ]
                });
            });
        });

        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                    data: {
                        type: 'attachment'
                    }
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {
                        data: 'title',
                        name: 'attachments.title'
                    },
                    {
                        data: 'description',
                        name: 'attachments.description'
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    },
                ]
            });



        });

        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            var id = 0;
            var table = $('#expenseitem-table').DataTable({
                scrollCollapse: true,
                serverSide: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                deferLoading: 0,
                ajax: {
                    url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                    data: function(d) {
                        d.type = 'item';
                        d.item_id = $("#item_id").val();
                    }
                },
                columns: [

                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'quantity',
                        name: 'quantity'
                    },
                    {
                        data: 'measure',
                        name: 'measure'
                    },
                    {
                        data: 'price',
                        name: 'price'
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                        orderable: false,
                        searchable: false
                    },
                ]
            });
            $(document).on('click', '#show_btn', function() {

                $("#item_id").val($(this).data('id'));
                $("#maintain_excel").val($(this).data('id'));
                $("#maintain_pdf").val($(this).data('id'));
                table.draw();

                $('#form_modal2').modal('show');
            });
        });

    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        var id = 0;
        var table = $('#itemshowsmodal-table').DataTable({
            scrollCollapse: true,
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            paging: true,
            deferLoading: 0,
            ajax: {
                url: '{{route("rentVehicle.show",$vehicleM->id)}}',
                data: function(d) {
                    d.type = 'itemnotstock';
                    d.item_id = $("#item_id").val();
                }
            },
            columns: [

                {
                    data: 'description',
                    name: 'expense_details.description'
                },
                {
                    data: 'amount',
                    name: 'amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'created_at',
                    name: 'created_at',
                    orderable: false,
                    searchable: false
                },
            ]
        });
        $(document).on('click', '#show_btn', function() {

            $("#item_id").val($(this).data('id'));
            $("#maintain_excel").val($(this).data('id'));
            $("#maintain_pdf").val($(this).data('id'));
            table.draw();

            $('#form_modal2').modal('show');
        });

    });



    //Export Vue

    var vme = new Vue({

        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('rentVehicle.report') !!}',
            excelRoute: '{!! route('rentVehicle.report') !!}',
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vme.$data.is_show = true;
            }
        }
    });
    //Location Report
    var vml = new Vue({

        el: '#print-modal-location',
        data: {
            is_show: false,
            pdfRoute: '{!!route('rentVehicle.report') !!}',
            excelRoute: '{!! route('rentVehicle.report') !!}',
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    new Vue({
        el: '#anchore-modal-location',
        methods: {
            showModal: function() {
                console.log('trr')
                vml.$data.is_show = true;
            }
        }
    });

    //return Report
    var vmr = new Vue({

        el: '#print-modal-return',
        data: {
            is_show: false,
            pdfRoute: '{!!route('rentVehicle.report') !!}',
            excelRoute: '{!! route('rentVehicle.report') !!}',
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    new Vue({
        el: '#anchore-modal-return',
        methods: {
            showModal: function() {
                console.log('trr')
                vmr.$data.is_show = true;
            }
        }
    });

    //receive Report
    var vmre = new Vue({

        el: '#print-modal-receive',
        data: {
            is_show: false,
            pdfRoute: '{!!route('rentVehicle.report') !!}',
            excelRoute: '{!! route('rentVehicle.report') !!}',
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    new Vue({
        el: '#anchore-modal-receive',
        methods: {
            showModal: function() {
                console.log('trr')
                vmre.$data.is_show = true;
            }
        }
    });
</script>


@endpush