@extends('layouts.app')
@section('style')
    <style type="text/css">
        .modal.in .modal-dialog {
            margin: 40px auto;
            width: 32%;
        }
    </style>
@stop
@section('content')
@include('layouts.modal')
    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'vehicle_rents'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                          <div class="col-md-12">
                            <label class="control-label ">@lang('menu.Vehicle') </label>
                            <select name="vehicle_id" id="" class="form-control">
                                <option value="">@lang('menu.Vehicle')</option>
                                @foreach($vehicle as  $v)
                                    <option value="{{$v->id}}">{{$v->vehicle_name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- app -->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="Project_report"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectProject') </label>
                            <v-select class="vue-select2" v-model="selectedproject" label="name"
                                      @search="onProjectSearch" :options="projectList">
                            </v-select>
                            <input type="hidden" name="project_id"
                                   v-model.number="(!selectedproject)?null:selectedproject.id">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off"
                                               name="from_date">
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off"
                                               name="to_date">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>

            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="Project_report"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectProject') </label>
                            <v-select class="vue-select2" v-model="selectedproject" label="name"
                                      @search="onProjectSearch" :options="projectList">
                            </v-select>
                            <input type="hidden" name="project_id"
                                   v-model.number="(!selectedproject)?null:selectedproject.id">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" autocomplete="off"
                                           name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" autocomplete="off"
                                           name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>

            </div>
        </modal>
        {{Form::close()}}
    </div>

    <!-- app -->
    <!-- {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}} -->
    <div id="form_modal2" class="modal fade col-md-12" role="dialog" aria-hidden="true">

        <div class="modal-dialog">
            <div class="modal-content">

                <div class="row">
                    <br><br><br><br>
                    <div class="form-group">
                        <div class="col-md-10 col-md-offset-1">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" autocomplete="off"
                                           name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" autocomplete="off"
                                           name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-8 col-md-offset-3">
                            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline','id'=>'itemForm'])}}
                            <input type="hidden" name="type" value="completedProjectExcel">
                            <input type="hidden" name="from_date" id="excel_sdate">
                            <input type="hidden" name="to_date" id="excel_edate">
                            <button type="submit" class="btn btn-success " id="excel_send">
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                            </button>
                            {{Form::close()}}
                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="completedProjectExcel">
                            <input type="hidden" name="from_date" id="pdf_sdate">
                            <input type="hidden" name="to_date" id="pdf_edate">
                            <button type="submit" class="btn btn-danger" id="pdf_send">
                                <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')
                            </button>
                            {{Form::close()}}
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12 text-right" style="padding:20px; padding-right:40px;">

                            <br>
                            <hr>
                            <br>
                            <button class="btn red btn-outline" data-dismiss="modal"
                                    aria-hidden="true">@lang("layout.Close")</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleRentList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">


                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
           
                    @permission('toRentVehicle-create')
                    <a href="{{route('rentVehicle.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission


                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="project">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Driver')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.VehicleName')</th>
                        <th>@lang('layout.Tanker')</th>
                        <th>@lang('layout.Road')</th>
                        <th>@lang('layout.Price')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <div id="factor-obj">

    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->

    <iframe id="saleFrames" style="display: none;"></iframe>


    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')


    <script>
        @if(Session('manage_id'))
        FactorPrint("{{Session('manage_id')}}")

        @endif

        function FactorPrint(id) {

            var a = document.createElement('a');
            a.href = "{{url('rentVehicleFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);


        }

        @if(Session('project'))
        ProjectGlassesPrint("{{Session('project')}}")

        @endif

        function ProjectGlassesPrint(id) {

            var a = document.createElement('a');
            a.href = "{{url('projectGlassPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);

        }

        Vue.component("v-select", VueSelect.VueSelect);


        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#project').DataTable({
                ajax: '{{route("rentVehicle.index")}}',
                order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'vehicle_managements.id', searchable: false},
                    {data: 'code', name: 'vehicle_managements.code'},
                    {data: 'members_name', name: 'members.name'},
                    {data: 'driver_name', name: 'driver.name'},
                    {data: 'date', name: 'date', searchable: false},
                    {data: 'vehicle_name', name: 'vehicles.palet_number'},
                    {data: 'tanker_name', name: 'vehicles.palet_number'},
                    {data: 'road', name: 'vehicle_locations.road'},
                    {data: 'amount', name: 'amount'},
                    {data: 'currency', name: 'vehicle_managements.currency'},
                    {data: 'phone1', name: 'phone1'},
                    {data: 'description', name: 'description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });


        // register modal component
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });

        new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedproject: null,
                projectList: [],
            },
            methods: {
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example").persianDatepicker(modelDate());
                            from = $("#range-from-example").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })
        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                selectedproject: null,
                projectList: [],
            },
            methods: {
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },

                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })

        new Vue({
            el: '#app3',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
                sdate: null,
                edate: null,
            },
            methods: {
                ok: function () {
                    this.showModal = !this.showModal;

                },
                pdf: function () {
                    alert(this.sdate);
                    alert(this.edate);
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    });


                }
            },
        })

        $(document).ready(function () {
            var to, from;
            to = $("#range-to-example2").persianDatepicker(modelDate());
            from = $("#range-from-example2").persianDatepicker(modelDate());
        });

        $(document).on('click', '#completedProject', function () {

            $('#form_modal2').modal('show');
        });
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        });
        $("#excel_send").on('click', function () {
            $('#excel_sdate').val($("#range-from-example2").val());
            $('#excel_edate').val($("#range-to-example2").val());

        });

        $("#pdf_send").on('click', function () {
            $('#pdf_sdate').val($("#range-from-example2").val());
            $('#pdf_edate').val($("#range-to-example2").val());

        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


        // new for modal
var vm =new Vue({
            el: '#print-modal',
            data:{
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show:false,
                pdfRoute: '{!!route('rentVehicle.report') !!}',
                excelRoute: '{!! route('rentVehicle.report') !!}',


            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

    
            }
        });


new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
            
        }
    }
});
// /new for modal

    </script>
@endpush
