@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css"> 
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
@include("layouts.Drivermodal")
<div class="row">
    <div class="portlet light bordered sale">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.VehicleRentCreate')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="appInvoice" class="portlet-body">  
                <div class="tabbable tabbable-tabdrop"> 
                    <div>
                        {{Form::open(['route' => 'rentVehicle.store','method' => 'POST','class' => 'form-horizontal','id'=>'rentVehicle-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content"> 
                            <div class="tab-pane active" id="tab1"> 
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;"> 
                                    <!-- BEGIN FORM--> 
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div v-show="showWhat('member_class')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.MemberClass')</label>

                                                                <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                                                <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Customer')</label>

                                                                <v-select label="name" :options="customer" v-model="selected_customer"></v-select>
                                                                <input type="hidden" name="customer_id" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                                <span class="required">@{{ errors.first('customer') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label col-md-12"><br></label>

                                                                <button type="button" class="btn blue btn-block" @click="showModal = true">@lang('layout.NewCustomer')</button>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                {{Form::text('ref_number',$code,['class' => 'form-control','placeholder' => __('layout.ReferenceNumber'),'v-validate' =>'"required"','data-vv-as' => __('layout.ReferenceNumber')])}}

                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">


                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Currency')</label>


                                                                <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                                                <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                                                <span class="required">@{{ errors.first('currency') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Rate')</label>

                                                                <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                                <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Discount')</label>

                                                                    <div class="input-group">

                                                                        <input v-model="discountFiled"
                                                                               class="form-control"
                                                                               type="number" min="0" max="100">
                                                                        <span v-if="discountIsAmount"
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">@{{selected_currency.symbol}}
																			  <input type="hidden" class="input-group-addon" name="discount_type"
																					 value="currency">
																		  </span>
																		<span v-else
																			  @click="discountIsAmount = !discountIsAmount"
																			  class="input-group-addon">%
																			  <input type="hidden" name="discount_type" value="percent">
																		  </span>
                                                                        <input type="hidden" name="discountTotal"
                                                                               :value="discount">
                                                                        <input type="hidden" name="discount"
                                                                               :value="discountFiled">
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div -->
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>

                                                                <input type="text" name="date" class="form-control date" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.SelectDriver')</label>

                                                                <v-select label="name" @input="memberChange()" :options="drivers" v-model="selectedMember"></v-select>
                                                                <input type="hidden" name="driver" v-validate="'required'" data-vv-as="@lang('layout.Driver')" :value="!selectedMember?null:selectedMember.id" required>
                                                                <span class="required">@{{ errors.first('driver') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label col-md-12"><br></label>

                                                                <button type="button" class="btn blue btn-block" @click="dShowModal = true">@lang('layout.NewDriver')</button>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="1" v-text="invoiceDescription"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>

                                                <div class="row">

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Phone')</label>

                                                                <input type="text" name="phone1" class="form-control " autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Phone') 1</label>

                                                                <input type="text" name="phone2" class="form-control " autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.DischargeDate')</label>

                                                                <input type="text" name="discharge_date" class="form-control date" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>


                                                <!-- end inputs -->
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                                                <!-- begin total -->
                                                <div class="dashboard-stat2 " v-show="seePrice== true">
                                                    <table class="dashboard-tabel" width="100%">
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Total') :</small>
                                                            </td>
                                                            <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ myRound((subtotal - (discount*subtotal/100))-payeds)}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>

                                                        <!-- tr>
                                                                <td>
                                                                    <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
															   <span class="text-right" data-counter="counterup"
																	 data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr -->

                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Payment'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <small class="font-green-sharp">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </small>
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Sub-Total'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ myRound(subtotal)}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>


                                                    </table>

                                                </div>

                                                <!-- end total -->

                                            </div>

                                        </div>

                                        <div class="row" style="overflow-x: scroll;">

                                            <!-- begin service -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.VehicleName')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Tanker')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Total')</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="selected_vehicle" @input="carChange()" :options="vehicles">

                                                            </v-select>
                                                            <input type="hidden" name="car_id" v-validate="'required'" data-vv-as="@lang('layout.VehicleName')" :value="!selected_vehicle?null:selected_vehicle.id" required />
                                                            <span class="required">@{{ errors.first('car_id') }}</span>
                                                        </td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="selected_tanker" :options="tankers">

                                                            </v-select>
                                                            <input type="hidden" name="tanker_id" :value="(selected_tanker==null)?null:selected_tanker.id">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="qty" placeholder="@lang('layout.Quantity')" v-model="qty" class="form-control" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" required />
                                                                <span class="required">@{{ errors.first('qty') }}</span>

                                                            </div>

                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="amount" placeholder="@lang('layout.Price')" v-model="amount" class="form-control" v-validate="'required'" data-vv-as="@lang('layout.Price')" required />
                                                                <span class="required">@{{ errors.first('amount') }}</span>
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <select name="um_id" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                
                                                                    <option v-for="measure in measureList" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="total" placeholder="@lang('layout.Total')" :value="myRound(amount * qty)" class="form-control" readonly />
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>

                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>
                                            <!-- end service -->

                                            <!--Begin Panels-->
                                            <div class="tab-content">
                                                <!-- GENERAL QUESTION TAB -->
                                                <div class="tab-pane active" id="tab_1_1">
                                                    <div id="accordion1" class="panel-group">

                                                        <div class="panel panel-success">
                                                            <div class="panel-heading">
                                                                <h4 class="panel-title">
                                                                    <a class="accordion-toggle accordion-toggle-styled" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_3"> @lang('layout.Location')</a>
                                                                </h4>
                                                            </div>
                                                            <div id="accordion1_3" class="panel-collapse ">
                                                                <div class="panel-body">

                                                                    <div class="row">
                                                                        <div class="col-md-4">
                                                                            <div class="form-group">
                                                                                <label class="control-label col-md-3">@lang('layout.State')</label>
                                                                                <div class="col-md-9">
                                                                                    <select name="state" class="form-control" style="border: 1px solid #c2cad8 !important; ">
                                                                                        <option value="">@lang('layout.SelectState')</option>
                                                                                        <option value="fill">@lang('layout.Fill')</option>
                                                                                        <option value="empty">@lang('layout.Empty')</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="form-group">
                                                                                <label class="control-label col-md-3">@lang('layout.Road')</label>
                                                                                <div class="col-md-9">
                                                                                    {!! Form::text('road', null, array('placeholder' =>__('layout.Road'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="form-group">
                                                                                <label class="control-label col-md-3">@lang('layout.Location')</label>
                                                                                <div class="col-md-9">
                                                                                    {!! Form::text('location', null, array('placeholder' =>__('layout.Location'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-md-4">
                                                                            <div class="form-group">
                                                                                <label class="control-label col-md-3">@lang('layout.Source')</label>
                                                                                <div class="col-md-9">
                                                                                    {!! Form::text('source', null, array('placeholder' =>__('layout.Source'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="form-group">
                                                                                <label class="control-label col-md-3">@lang('layout.Destination')</label>
                                                                                <div class="col-md-9">
                                                                                    {!! Form::text('destination', null, array('placeholder' =>__('layout.Destination'),'class' => 'form-control')) !!}
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                                <!-- END GENERAL QUESTION TAB -->
                                            </div>
                                            <!--END Panels-->



                                            <!-- begin recevies -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <div class="panel-heading" style="background-color: rgb(80, 129, 141); color: #ffffff;">
                                                    <h4 class="panel-title">
                                                        @lang('layout.Recevies')
                                                    </h4>
                                                </div>
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(recevie,index) in recevies">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="recevie.item" :options="(recevie.items)" @click.native="addNew('recevie',index)" @input="checkExistingRecevie(index)">

                                                            </v-select>
                                                            <input type="hidden" v-if="recevie.item !=null" name="recevie_id[]" :value="(recevie.item==null)?null:recevie.item.id">
                                                        </td>

                                                        <td>

                                                            <span v-if="recevie.item !=null">
                                                                @{{myRound(Number((recevie.item==null)?null:recevie.item.balance)+Number((recevie.item==null)?null:recevie.item.amount))}}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(recevie.item==null)?false:(recevie.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(recevie.item==null)?null:recevie.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                            <input v-if="recevie.item !=null" type="hidden" name="recevie_rate[]" v-bind:value="recevie.item.rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="recevie_currency[]" class="form-control" v-model="(recevie.item==null)?null:recevie.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                            <input v-if="recevie.item !==null" type="hidden" name="recevie_currency[]" v-bind:value="recevie.item.code" />
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" v-model.number="(recevie.item==null)?null:recevie.item.amount " placeholder="@lang('layout.PayAmount')" />

                                                                <input v-if="recevie.item !=null" type="hidden" name="recevie_amount[]" v-bind:value="recevie.item.amount">

                                                                <span class="input-group-addon">@{{(recevie.item==null)?null:recevie.item.code}}</span> 
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" :value="(recevie.item==null)?null:totalPayment(recevie.item,selected_currency.rate, null, selected_currency.static_rate).result" placeholder="@lang('layout.Total')" style="min-width: 100px" />
                                                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('recevie',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>

                                            </table>
                                            <!-- end recevies -->
                                            <hr />
                                            <!-- begin payments -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <div class="panel-heading" style="background-color: rgb(80, 129, 141); color: #ffffff;">
                                                    <h4 class="panel-title">
                                                        @lang('layout.Payment')
                                                    </h4>
                                                </div>
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(payment,index) in payments">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">

                                                            </v-select>
                                                            <input type="hidden" v-if="payment.item !=null" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                                                        </td>

                                                        <td>

                                                            <span v-if="payment.item !=null">
                                                                @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                            <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                            <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code" />
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" v-model.number="(payment.item==null)?null:payment.item.amount " placeholder="@lang('layout.PayAmount')" />

                                                                <input v-if="payment.item !=null" type="hidden" name="payment_amount[]" v-bind:value="payment.item.amount">

                                                                <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate, null, selected_currency.static_rate).result" placeholder="@lang('layout.Total')" style="min-width: 100px" />
                                                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>

                                            </table>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.ExpenseRefNumber')</label>
                                                        <div class="col-md-8">
                                                            {!! Form::text('expense_ref_number', null, array('placeholder' =>__('layout.ExpenseRefNumber'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end payments -->
                                        </div>

                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="isError1 ==false" v-if="!isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                                        <button type="button" v-if="isError1 ==false" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                        <a href="{{route('rentVehicle.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                    </div>
                                    <cmodal :show='showModal' @close="showModal=false">

                                    </cmodal>
                                    <Drivermodal :show='dShowModal' @close="dShowModal=false">

                                    </Drivermodal>
                                </div>


                            </div>


                            {!! Form::close() !!}

                        </div>

                    </div>


                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif



    Vue.component('v-select', VueSelect.VueSelect);

    Vue.component("modal", {
        template: "#modal-template",
        props: ['show'],

    });

    //begin new member
    Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Customer") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }


                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                v.showModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        "code": datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },


                    dataType: 'json',

                }).done(function(response) {
                    axios.get('{{route("invoice.create")}}').then(response => {

                        v.customer = response.data.customer;
                        document.getElementById("modalForm").reset();

                    }).catch(error => console.log(error));

                }).fail(function(error) {
                    console.log('error', error);
                });

            }
        }
    });

    // end new member

    // start new driver
    Vue.component("Drivermodal", {
        template: '#Drivermodal-template',

        props: ['show'],
        data() {
            return {

                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Driver") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;

                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }


                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                v.dShowModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#DriverModalForm").serializeArray();
                console.log('send', datas);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("driver.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        'code': datas[1]['value'],
                        'email': datas[2]['value'],
                        'driver_type': datas[3]['value'],
                        'plate_number': datas[4]['value'],
                        'phone': datas[5]['value'],
                        'address1': datas[6]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },
                    dataType: 'json',

                }).done(function(response) {
                    axios.get('{{route("rentVehicle.create")}}').then(response => {
                        // console.log('123', response.data.customer);
                        v.drivers = response.data.customer;
                        document.getElementById("DriverModalForm").reset();

                    }).catch(error => console.log(error));

                }).fail(function(error) {
                    console.log('error', error);
                });

            }
        }
    });
    // end new driver

    var customer ={!! $customer !!};
    var allDrivers = {!!$allDrivers!!};
    var vehicles = {!!$vehicles!!};
    var seePrice ={!! $seePrice !!};
    var seeCost ={!! $seeCost !!};

    var currency ={!! $currency !!};
    var banks = {!! $banks !!};
    var bank_pay = {!! $banks !!};
    var memberClass = {!! $memberClass !!};
    var saleArea = {!! $saleArea !!};
    
    var v = new Vue({
        el: '#appInvoice',
        data: {
            measureList: {!!$measureList!!},
            showModalSaleOrder: false,
            showModal: false,
            dShowModal: false,
            invoiceDescription: null,
            saleOrderList: [],
            selected_sale_order: null,
            purchase_orders: false,
            setDatas: [],
            drivers: allDrivers,
            vehicles: vehicles,
            selected_vehicle: null,
            tankers: vehicles,
            selected_tanker: null,
            amount: null,
            qty: null,
            customer: customer,
            all_customer: customer,
            seePrice: seePrice,
            seeCost: seeCost,
            selected_customer: null,
            selectedMember: null,
            member_id: null,
            banks: banks,
            bank_pay: bank_pay,
            all_services: null,
            selected_banks: null,
            currency: currency,
            selected_currency: defaultCurrency(),
            rate: 0,
            discountFiled: 0,
            discountIsAmount: false,
            temp_items: [],
            totalAmountes: [],
            types: null,
            inventory_category: null,
            selected_iventory_category: null,
            selected_index: 0,
            newCost: [
                null,
                null
            ],
            inventories: [],
            services: [],
            recevies: [{
                items: banks,
                item: null,
            }],
            payments: [{
                items: bank_pay,
                item: null,
            }],
            CusTypes: null,
            memberClass: memberClass,
            selected_class: null,
            saleArea: saleArea,
            selected_area: null,
            ref_no: '',
            msg: '',
            isError1: false,
        },
        computed: {
            selectedRate() {
                this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

            },
            discount() {
                if (this.discountIsAmount) {

                    if (this.subtotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }

            },

            // calculate subtotal
            subtotal: function() {
                var sum = 0;
                // for (var i = 0; i < this.inventories.length; i++) {
                // if (this.inventories[i].item && this.inventories[i].item != null) {

                // var quantity = this.inventories[i]['item']['quantity'];
                // var rate = this.inventories[i]['item']['rate'];
                // var new_rate = this.inventories[i]['item']['new_rate'];
                // var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                // var measure_unit = this.inventories[i]['item']['measure_unit'];
                // if (new_rate != rate && quantity > 0) {
                // sum += new_rate * quantity * this.selected_currency.rate;
                // }
                // else {
                // sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                // }

                // }

                // }
                // for (var i = 0; i < this.services.length; i++) {
                // if (this.services[i].item && this.services[i].item != null) {

                // var rate = this.services[i]['item']['rate'];
                // var new_rate = this.services[i]['item']['new_rate'];
                // var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                // var measure_unit = this.services[i]['item']['measure_unit'];
                // var quantity = this.services[i]['item']['quantity'];
                // if (new_rate != rate && quantity > 0) {
                // sum += new_rate * quantity * this.selected_currency.rate;
                // }
                // else {
                // sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                // }

                // }
                // }

                sum = myRound(this.amount * this.qty);
                return sum;
            },

            // check receve amount
            payeds: function() {
                var sum = 0;
                for (var i = 0; i < this.recevies.length; i++) {

                    if (this.recevies[i].item != null && this.recevies[i].item) {
                        if (this.recevies[i].item != null && this.recevies[i]['item']['rate'] > 0) { 
                            @if(systemConfig()[30] == 1)
                            sum += ((this.recevies[i]['item']['amount'] / this.recevies[i]['item']['static_rate'] * this.recevies[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += (this.recevies[i]['item']['amount'] * this.selected_currency.rate / this.recevies[i]['item']['rate']);
                            @endif  
                        }
                    }
                }
                return sum;
            },


            // check data validation
            isError: function() {
                var isError = false;
                //var flag=false;
                // for (var i = 0; i < this.inventories.length; i++)
                // {

                //    if (this.inventories[i].item)
                //    {
                //      flag=true;
                //      if(((this.inventories[i]['item']['rate'] <=0) ))
                //      {
                //        rate=this.inventories[i]['item']['rate'];
                //        new_rate=this.inventories[i]['item']['new_rate'];
                //        if(rate <=0 && new_rate <=0)
                //        {
                //             isError = true;
                //        }

                //      }
                //    }
                // }
                if (this.selected_customer == null) {
                    isError = true;
                }
                return isError;


            },
        },
        methods: {
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        //console.log(v.member_chack());
                        if (v.member_chack() == 'true') {
                            var r = confirm("@lang('layout.member_payable_levels')");
                            if (r == true) {
                                v.submitForm(e.target);
                            }
                        } else {
                            v.submitForm(e.target);
                        }
                    }
                });
            },

            // chack_member_payable_levels
            member_chack() {
                var chack = 'false';
                var member_id = v.member_id;
                if (member_id != null) {

                    var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                    var currency = $("input[name=currency]").val();


                    $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async: false,
                        data: {
                            member_id: v.member_id,
                            method_name: 'Search_member_payable_levels',
                            currency: currency,
                        },
                        success: function(data) {
                            var r_amount = Number.parseFloat(data.amount);
                            var r_m_amount = Number.parseFloat(data.m_amount);
                            var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                            //console.log(r_m_amount);
                            //console.log('--');
                            //console.log(totals);
                            if (r_amount != 0 && r_amount < totalss) {
                                chack = 'true';
                            } else {
                                chack = 'false';
                            }


                        }.bind(this),

                        error: function(error) {
                            console.log(error)
                        }
                    });
                    /*
                            axios.get("{{route('callMethod.search')}}",
				   {

					params:{
					  member_id:v.member_id,
					  method_name:'Search_member_payable_levels',
					  currency:currency,
					  
					},
				   })
				   .then(function (response)
				   {
					 
						var r_amount = response.data.amount;
						var r_m_amount = response.data.m_amount;
						if(r_amount < (r_m_amount + totals)){
							chack = 'true';
						}
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
			  */
                }
                return chack;
            },

            memberClassChange() {
                this.customer = this.all_customer;
                if (this.selected_class) {
                    console.log('test22', this.selected_class);
                    this.customer = this.all_customer.filter((member) => {
                        return this.selected_class.id == member.class_id;
                    });

                }
            },

            // detect member change and searh
            memberChange() {
                if (this.selectedMember) {
                    console.log('rrr', this.selectedMember);
                    // get member contract
                    this.vehicleSearch(this.selectedMember.plate, this);
                }
            },
            vehicleSearch(plate, vm) {
                if (plate != null) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                        .then(function(response) {

                            if (response.data.result != null) {
                                console.log('1231', response.data);

                                v.selected_vehicle = response.data.result;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            // detect member change and searh
            carChange() {
                if (this.selected_vehicle) {
                    console.log('rrrnn', this.selected_vehicle);
                    // get member contract
                    this.TankerSearch(this.selected_vehicle.tanker_number, this);
                }
            },
            TankerSearch(plate, vm) {
                if (plate != null) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                        .then(function(response) {

                            if (response.data.result != null) {
                                console.log('1231', response.data);

                                v.selected_tanker = response.data.result;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            // generic function for adding item to list
            addNew(type = null, index) {
                this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null,
                                item_category: this.selected_iventory_category
                            });
                        }
                    }
                    if (type == 'service') {
                        if (this.services[index + 1] == undefined) {
                            this.checkExistingService(index, '');
                            this.services.push({
                                items: this.all_services,
                                item: null,
                            });
                        }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: this.bank_pay,
                                item: null,
                            });
                        }
                    }
                    if (type == 'recevie') {
                        if (this.recevies[index + 1] == undefined) {
                            this.checkExistingRecevie(index, '');
                            this.recevies.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    }
                }

            },

            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.bank_pay.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingRecevie(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.recevies.length; i++) {
                    if (this.recevies[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.recevies[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.recevies[i].item.name), 1);
                        }
                    }
                }
                this.recevies[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.recevies[index].items =bank_temp;
            },

            // in here you can check and decide to allow duplicate service or not
            checkExistingService(index = null, name = '') {
                var service_temp = this.all_services.slice();
                var service_temp1 = [];
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item != null) {
                        var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                        if (fined != -1) {
                            var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                        }
                    }
                }
                this.services[index].items = service_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {

                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }
                    if (type == 'service') {
                        this.services.splice(index, 1);
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                    if (type == 'recevie') {
                        this.recevies.splice(index, 1);
                    }
                }

            },
            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("rentVehicle-form").submit()

                    } else {

                    }
                });

            },
            defaultValue() {
                this.selected_customer = null;
                this.selected_index = 0;

                this.inventories = [{
                    inventory: null,
                    item: null,
                    item_category: this.selected_iventory_category
                }, ];
                this.services = [{
                        items: all_services,
                        item: null,
                    },
                    {
                        items: all_services,
                        item: null,
                    },
                ];
                this.payments = [{
                    items: bank_pay,
                    item: null,
                }];

                this.recevies = [{
                    items: banks,
                    item: null,
                }];

                this.invoiceDescription = null;
                this.saleOrderList = [];
                this.selected_sale_order = null;
                this.member_id = null;
                this.discountFiled = 0;
                this.temp_items = [];
            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {

                            var url = "{{route('rentVehicle.store')}}";
                            form_id = 'rentVehicle-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    console.log('sss11', response.data);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        //$('#success-sound')[0].play();
                                        toastr.success('', response.data.message);
                                        location.reload();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        },


    });
</script>



@endpush