@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleRentReport')</h3>
<table class="main-table">

<thead>
<tr>
   <td class="center" ><div> @lang('layout.Record') </div></td>
   <td class="center" ><div> @lang('layout.ReferenceNumber') </div></td>
   <td class="center" ><div> @lang('layout.Date')</div></td>
   <td class="center" ><div> @lang('layout.Description')</div></td> 
   <td class="center" ><div> @lang('layout.Customer')</div></td>
   <td class="center" ><div> @lang('layout.Driver')</div></td>
   <td class="center" ><div> @lang('layout.VehicleName')</div></td>
   <td class="center" ><div> @lang('layout.Tanker')</div></td>
   <td class="center" ><div> @lang('layout.Road')</div></td>
   <td class="center" ><div> @lang('layout.Price')</div></td>
   <td class="center" ><div> @lang('layout.Currency')</div></td>
   <td class="center" ><div> @lang('layout.Rate')</div></td>
   <td class="center" ><div> @lang('layout.Phone')</div></td>
   <td class="center" ><div> @lang('layout.User')</div></td> 

</tr>
</thead>
 <?php
 $count = 0;
 $total_home_currency=0;
 $currencies=[];
 ?>
 @foreach($data AS $record)
 <tr>

  <?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->currency, $currencies))
   {
    $currencies[$record->currency]=$currencies[$record->currency]+$record->amount;
  }
  else
  {

    $currencies[$record->currency]=$record->amount;
  }
  ?>

<td class="center">{{++$count}}</td>
<td class="center">{{$record->code}}</td>
<td class="center">{{convertDate($record->date)}}</td>
<td class="center">{{$record->description}}</td>
<td class="center">{{$record->members_name}}</td>
<td class="center">{{$record->driver_name}}</td>
<td class="center">{{$record->vehicle_name}}</td>
<td class="center">{{$record->tanker_name}}</td>
<td class="center">{{$record->road}}</td>
<td class="center">{{$record->amount}}</td>
<td class="center">{{$record->currency}}</td>
<td class="center">{{$record->rate}}</td>
<td class="center">{{$record->phone1}}</td>
<td class="center">{{$record->user}}</td>

</tr>
@endforeach

</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency)}}</div></td>

  </tr>
  <?php
}
?>
<tr>

<td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}  </div></td>

</tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection