@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
        .dropdown-toggle .clear {
            display: none;
        }

    </style>
@stop
@section('content')

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('menu.Refund') @lang('layout.InvoiceNumber')
                        <span style="color:red"> {{$refund->sale_number}}   </span></span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::model($refund,['route' => ['refundSaleEdit.update',$refund->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}

                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer')</label>
                                            <input type="text" class="form-control" value="{{$refund->customer}}"
                                                   disabled>
                                            <input type="hidden" name="customer" value="{{$refund->member_id}}"
                                                   required>
                                        </div>
                                        <input type="hidden" name="number" value="{{$refund->sale_number}}">

                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select label="code" disabled :options="currency"
                                                      v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" :value="selected_currency.code">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>
                                            <input type="number" name="currency_rate" name="rate"
                                                   v-model="(!selected_currency)?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <v-select label="name" :options="approperiateBank" v-model="selected_banks"></v-select>
                                            <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>
                                            <div class="input-group">
                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0" max="100" readonly>
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                                      <input type="hidden" class="input-group-addon"
                                                             name="discount_type" value="currency">
                                                  </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">%
                                                      <input type="hidden" name="discount_type" value="percent">
                                                  </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" class="form-control date" value="{{$refund->sale_date}}" autocomplete="off" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1"
                                                      readonly>{{$refund->sale_description}}</textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.RefundDate')</label>
                                    <input type="text" name="date" value="{{$refund->date}}" class="form-control date">
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.RefundNo')</label>
                                            <input type="number" name="refundNo" class="form-control"
                                                   value="{{$refund->number}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="newDescription" class="form-control" rows="1">{{$refund->description}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total')</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup" data-value="7800">
                                            @{{ Number.parseFloat(((subtotal - discountFiledRow) - (discount*(subtotal - discountFiledRow)/100))).toFixed(precision())}}
                                            </span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)
                                            </small>
                                        </td>
                                        <td class="text-right">
                                       <span class="text-right" data-counter="counterup"
                                             data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup"
                                                  data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <!-- end total -->
                        </div>
                    </div>
                    <div class="row" style="overflow-x: scroll;">
                        <table v-if="inventories.length>0" id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                @if(searchByCodeLocation()=="true")
                                <th style="min-width: 100px;">@lang('layout.Location')</th>
                                @endif
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <!-- <th style="min-width: 100px">@lang('layout.OldQuantity') </th> -->
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 120px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 120px">@lang('layout.OMeasureValue2')
                                </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.SalePrice') </th>
                                <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 50px">@lang('layout.Discount') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="item.item" :options="temp_items"
                                              @search="onItemSearch" ></v-select>
                                    <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                    <input type="hidden" name="contract_id[]" :value="(!item.item)?null:((item.item.contract_id)?item.item.contract_id.id:null)">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>
                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                @if(searchByCodeLocation()=="true")
                                <td>
                                    <input type="text" name="inventory_location[]" class="form-control"
                                           v-model="(item.item==null)?null:item.item.location"  placeholder="@lang('layout.Location')">
                                </td>
                                @endif
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Description')"
                                           name="inventory_description[]" class="form-control">
                                </td>

                                <!-- <td>
                                    <input type="number" name="inventory_quantity_old[]"
                                           :value="(item.item==null)?null:item.item.old_quantity-(item.item.quantity)"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')" readonly>

                                </td> -->
                                <td>
                                    <input type="number" name="inventory_quantity[]"
                                           class="form-control input-style input-number"
                                           v-model="(item.item==null)?null:item.item.quantity"
                                           placeholder="@lang('layout.Quantity')">

                                </td>

                                <td v-show="showWhat('other_measure')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="other_measure_amount[]"
                                           class="form-control input-style input-number"
                                           v-model.number="(item.item==null)?null:item.item.other_measure"
                                           placeholder="@lang('layout.OMeasureValue1')">
                                        <span class="input-group-addon">
                                            @{{myRound((item.item==null)?null:item.item.other_measure)}}
                                        </span>
                                    </div>
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="other_measure_amount2[]"
                                           class="form-control input-style input-number"
                                           v-model.number="(item.item==null)?null:item.item.other_measure2"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                        <span class="input-group-addon">
                                            @{{myRound((item.item==null)?null:item.item.other_measure2)}}
                                        </span>
                                    </div>
                                </td>

                                <td>
                                    @{{myRound((item.item==null)?null:refundItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)"
                                               ref="in" @input="setNewRate('inventory',index)" class="form-control">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                </td>
                                <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]" readonly
                                                placeholder="@lang('layout.Discount')"
                                                v-model.number="(item.item==null)?null:item.item.discount"
                                                class="form-control chan_length">
                                        <span v-if="discountIsAmount" class="input-group-addon">
                                            @{{selected_currency.symbol}}
                                        </span>
                                        <span v-if="!discountIsAmount" class="input-group-addon">
                                            %
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate).result"
                                               placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>

                        <hr>
                        <!-- begin service -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                <!-- <th class="text-center" style="min-width: 160px;">@lang('layout.OldQuantity')</th> -->
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>

                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(service,index) in services">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="service.item" :options="(service.items)"
                                              @click.native="addNew('service',index)"
                                              @input="checkExistingService(index)">

                                    </v-select>
                                    <input type="hidden" name="service_id[]"
                                           :value="(service.item==null)?null:service.item.id">
                                </td>

                                <!-- <td>
                                    <input class="form-control"
                                           v-model.number="(!service.item)?null:service.item.old_quantity"
                                           placeholder="@lang('layout.Quantity')" readonly>
                                </td> -->
                                <td>
                                    <input class="form-control" type="number" name="service_quantity[]"
                                           v-model.number="(!service.item)?null:service.item.quantity"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(service.item == null)?null:service.item.measure"
                                            class="form-control" @change="measureChangeservice(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(service.item ==null)?false:true">
                                              <option v-for="measure in (service.item==null)?null:service.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>

                                    </select>

                                    <input type="hidden" name="service_measure[]"
                                           :value="(service.item==null)?null:service.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="text" name="service_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate)"
                                               ref="ser" @input="setNewRate('service',index)" class="form-control">
                                        <span class="input-group-addon">
                                          @{{selected_currency.symbol}}
                                        </span>
                                    </div>

                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate).result"
                                               placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('service',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end service -->
                        <hr>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="!isError" @click="submitForm"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        var currency = {!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var banks = {!! $banks !!};
        var all_services = {!! $all_services !!};
        var selectedService = {!! $selectedService !!};
        var selectedCustomer = {!! $selectedCustomer !!};
        var selectedItem = {!! $selectedItem !!};
        var refund = {!! $refund !!};
        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                refund: refund,
                customer: [],
                selected_customer: selectedCustomer,
                selected_item: selectedItem,
                banks: banks,
                all_services: all_services,
                selected_service: selectedService,
                currency: currency,
                selected_currency: selectedCurrency,
                rate: 0,
                discountFiledRow: 0,
                discountFiled: 0,
                selected_banks: null,
                discountIsAmount: false,
                temp_items: [],
                totalAmountes: [],
                inventory_quantities: [],
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [],
                services: [],
                payments: [],
            },
            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if ((this.subtotal - this.discountFiledRow) > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }
                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var sum_discount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {


                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var discount = this.inventories[i]['item']['discount'];
                            if (new_rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;

                                if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {

									if (discount > 0) {
									sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
									}
								}
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {

									if (discount > 0) {
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
									}
								}
                            }

                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {

                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }

                        }
                    }
                    // console.log(213, sum_discount);
                    this.discountFiledRow = sum_discount;
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }
                    }
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            if (this.inventories[i]['item']['quantity'] > this.inventory_quantities[i]) {
                                //isError=true;
                                console.log('error', this.inventories[i]['item']['quantity']);
                            }

                        }
                    }

                    return isError;
                },

                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                      for (var j = 0; j < tempBank.length; j++) {
                          if (tempBank[j].id == this.refund.account_id) {
                              this.selected_banks = tempBank[j];
                          }
                      }
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                // initialize the selected item

                for (var i = 0; i < this.selected_item.length; i++) {
                    this.inventories.push({item: this.selected_item[i]});
                    this.inventory_quantities.push(this.selected_item[i].quantity);
                }
                // console.log(23332, this.inventories);
                // end item

                // begin service

                for (var r = 0; r < this.selected_service.length; r++) {

                    var flag = false;
                    var tempService;
                    for (var h = 0; h < this.all_services.length; h++) {
                        if (this.all_services[h].id == this.selected_service[r].item_id) {
                            flag = true;
                            var ja = 1000;
                            for (var j = 0; j < ja; j++) {
                                if (this.all_services[h].measure_list[j]) {
                                    if (this.all_services[h].measure_list[j].measure_id == this.selected_service[r].um_id) {
                                        this.all_services[h].measure = this.all_services[h].measure_list[j];
                                        ja = 0;
                                    }
                                }
                            }

                            // measure: Object
                            // measure_list: Object
                            // 0: Object
                            // company_id: 1
                            // measure_id: 1
                            // measure_name: "Kilogram"
                            // measure_symbol: "kg"
                            // measure_unit: "1000"
                            // metric_id: 1

                            // um_id
                            tempService = this.all_services[h];
                            // tempService.old_quantity = this.selected_service[r].qty;
                            tempService.quantity=this.selected_service[r].qty;
                            tempService.rate = this.selected_service[r].price;
                            tempService.new_rate = this.selected_service[r].price;
                        }
                    }
                    if (flag) {
                        this.services.push({item: tempService, items: this.all_services})
                    }
                }
                for (var w = 1; w > this.selected_service.length; w--) {
                    this.services.push({item: null, items: all_services});
                }
                // end service

                if (this.refund) {
                    this.discountFiled = this.refund.discount;
                    if (this.refund.discount_type) {
                        if (this.refund.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }
            },
            methods:
                {
                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_customer) {
                            // get member contract
                            this.contractSearch(this.selected_customer.id, this);
                        }
                    },
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {

                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                            }
                        }


                    },
                    // begin item search
                    onItemSearch(search, loading) {
                        loading(true);
                        this.itemSearch(search, loading, this);
                    },
                    //ajax call to get items
                    itemSearch(search, loading, vm) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchSale',
                                keyword: search,
                            }
                        })
                            .then(function (response) {
                                this.temp_items = [];
                                if (response.data.length > 0) {
                                    vm.temp_items = response.data;
                                    console.log('data', vm.temp_items);
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },

                    // end item search

                    // contract search


                    // end contract search

                    // generic function for adding item to list

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },

        });

    </script>


@endpush