@extends('layouts.factor-master')
@section('style')
<style>
    .ths{
        height: 35px;
        text-align: center;
        font-weight: bold;
    }
</style>
@endsection

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.RefundsInvoiceReport')</h3>

    @if($from_date || $to_date)
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    @endif


    <table class="main-table">
        <thead>
        <tr class="bg">
            <td class="ths">#</td>
            <td class="ths">@lang('layout.Number')</td>
            <td class="ths">@lang('layout.Amount')</td>
            <td class="ths">@lang('layout.Currency')</td>
            <td class="ths">@lang('layout.Rate')</td>
            <td class="ths">@lang('layout.Discount')</td>
            <td class="ths">@lang('layout.Date')</td>
            <td class="ths">@lang('layout.Description')</td>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total_baseCurrency = 0;
        ?>
        @foreach($data AS $record)
            <?php
                $total_baseCurrency += ($record->amount / $record->rate);
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{myRound($record->amount)}}</td>
                <td class="center">{{$record->currency}}</td>
                <td class="center">{{$record->rate}}</td>
                <td class="center">{{$record->discount}}</td>
                <td class="center">{{convertDate($record->date)}}</td>
                <td class="center">
                    <?php
                        $des = wordwrap($record->description,80,"<br/>\n",false);
                        echo $des;
                    ?>
                </td>
            </tr>
        @endforeach
            <tr class="bg">
                <td colspan="3" class="center">@lang('layout.Total')</td>
                {{-- <td colspan="3" class="center"> {{myRound($total_baseCurrency)}} {{getHomeCurrency()[getCurrencyType()]}} </td> --}}
                <td colspan="3" class="center">  {{getHomeCurrency()[getCurrencyType()]}} </td>
                {{-- auth('sanctum')->user() --}}
            </tr>
    </table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection