@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'RefundList'" @closed="closeModal">
            <div slot=body>
                <input type="hidden" name="type" :value="type">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Category')</label>
                                <select class="form-control" name="category">
                                    <option value="">@lang('layout.All')</option>
                                    <option value="refund">@lang('layout.Refund')</option>
                                    <option value="repair">@lang('layout.Repair')</option>
                                    <option value="minorUse">@lang('layout.MinorUse')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="tabbable-line">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab2" data-toggle="tab"
                   style="font-size: 16px; font-style: bold">@lang('layout.ReturnInvoice') <i
                            class="icon-calculator"></i> </a>
            </li>
            <li>
                <a href="#tab1" data-toggle="tab" style="font-size: 16px; font-style: bold">@lang('layout.ReturnSales')
                    <i class="icon-basket-loaded"></i></a>
            </li>

        </ul>
        <div class="tab-content">
            <div class="tab-pane" id="tab1">
                <!-- BEGIN TAB PORTLET-->


                <div class="row">


                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.ListOfRefundSales')</span>
                            </div>
                            <div class="tools"></div>
                            <div class="pull-right">
                                @permission('refund-export')

                                <button type="button" class="btn btn-success" onclick="openModal('RefundList')">
                                    <i class="fa fa-print"></i>
                                </button>

                                @endpermission
                                @permission('refund-create')
                                <a href="{{route('simpleRefundSale.create')}}">
                                    <button id="sample_editable_1_new" class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                    </button>
                                </a>
                                @endpermission

                            </div>
                        </div>
                        <div class="portlet-body">

                            <template v-cloak id="sale_refund_comp">
                                <company @company="setCompany"></company>
                            </template>

                            <table class="table table-striped table-bordered " cellspacing="0" id="sale_refund">
                                <thead>
                                <tr>
                                    <th>@lang('layout.Category')</th>
                                    <th>@lang('layout.SalesNumber')</th>
                                    <th>@lang('layout.RefundNo')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.CustomerName')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Rate')</th>
                                    <th>@lang('layout.Discount')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.User')</th>

                                    <th>@lang('layout.Actions')</th>
                                </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                    <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>

            <div class="tab-pane active" id="tab2">


                <div class="row">

                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.ListOfRefundInvoice')</span>
                            </div>
                            <div class="tools"></div>
                            <div class=" pull-right">
                                @permission('refund-export')

                                <button type="button" class="btn btn-success" onclick="openModal('RefundInvoice')"><i
                                            class="fa fa-print"></i></button>
                                @endpermission
                                @permission('refund-create')
                                <a href="{{route('simpleRefundInvoice.create')}}">
                                    <button id="sample_editable_1_new" class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                    </button>
                                </a>
                                @endpermission

                            </div>
                        </div>
                        <div class="portlet-body">
                            <template v-cloak id="invoice_data_table">
                                <company @company="setCompany"></company>
                            </template>
                            <table class="table table-striped table-bordered table-hover" cellspacing="0"
                                   id="invoice_refund">

                                <thead>
                                    <tr>
                                        <th>@lang('layout.Category')</th>
                                        <th>@lang('layout.InvoiceNumber')</th>
                                        <th>@lang('layout.RefundNo')</th>
                                        <th>@lang('layout.ReferenceNumber')</th>
                                        <th>@lang('layout.CustomerName')</th>
                                        <th>@lang('layout.Amount')</th>
                                        <th>@lang('layout.Currency')</th>
                                        <th>@lang('layout.Rate')</th>
                                        <th>@lang('layout.Discount')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.User')</th>
                                        <th>@lang('layout.Actions')</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                    <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>

        </div>
    </div>

    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY
<div id="factor-obj" >
    @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

    @endif
            </div> -->


@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        function RefundFactorPrint(id) {


            var a = document.createElement('a');
            a.href = "{{url('refundFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }


        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#sale_refund').DataTable({
                ajax: {
                    url: '{{route("refund.index")}}',
                    data: function (d) {
                        d.type = 'SalesReceipt';
                    }
                },
                order: [["{{orderByColumn()=='number'?1:9}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [

                    {data: 'category', name: 'category' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'number', name: 'number'},
                    {data: 'refNo', name: 'refNo'},
                    {data: 'ref_no', name: 'ref_no'},
                    {data: 'member_name', name: 'member_name'},
                    {data: 'refund_amount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'currency', name: 'currency', searchable: false, orderable: false},
                    {data: 'refund_rate', name: 'refund_rate', searchable: false, orderable: false},
                    {data: 'discount', name: 'discount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'date', name: 'date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'description', name: 'description' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'user', name: 'user' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'actions', name: 'action', searchable: false, orderable: false},
                ]
            });

            $('#invoice_refund').DataTable({
                ajax: {
                    url: '{{route("refund.index")}}',
                    data: function (d) {
                        d.type = 'Invoice';
                    }
                },
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?1:9}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'category', name: 'category'},
                    {data: 'number', name: 'number'},
                    {data: 'refNo', name: 'refNo'},
                    {data: 'ref_no', name: 'ref_no'},
                    {data: 'member_name', name: 'member_name'},
                    {data: 'refund_amount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'currency', name: 'refunds.currency'},
                    {data: 'refund_rate', name: 'refund_rate', searchable: false, orderable: false},
                    {data: 'discount', name: 'discount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'date', name: 'date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'description', name: 'description' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'user', name: 'user' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'actions', name: 'action', searchable: false, orderable: false},

                ]
            });


        });


        Vue.component('v-select', VueSelect.VueSelect)


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                type: ''
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });

        function openModal(type) {
            vm.$data.is_show = true;
            vm.$data.type = type;
        }

        new Vue({
            el: '#sale_refund_comp',
            methods: {
                setCompany: function (event) {
                    window.location.reload()
                }
            }
        });


        new Vue({
            el: '#invoice_data_table',
            methods: {
                setCompany: function (event) {
                    window.location.reload()
                }
            }
        });
    </script>


@endpush
