@extends('layouts.factor-master')
@section('style')
<style>

    .ths{
        text-align: center;
        height: 35px;
        font-weight: bold;
    }
</style>
@endsection

@section('content')
<h3 class="table-caption" style="text-align: center;">@lang('layout.RefundReport')</h3>
    <table style="width: 100%; margin-bottom: 10px;" class="main-table">
        @if($info && $info !=[])


            <tr>
                <th class="bg">@lang('layout.RefundNo')</th>
                <th class="bg">@lang('layout.MemberName')</th>
                <th class="bg">@lang('layout.Currency')</th>
                <th class="bg">@lang('layout.Rate')</th>
                <th class="bg">@lang('layout.Total')</th>
            </tr>
            <tr>
                <td class="center">{{$info->number}}</td>
                <td class="center">{{$info->customer}}</td>
                <td class="center">{{$info->currency}}</td>
                <td class="center">{{$info->rate}}</td>
                <td class="center">{{abs($amount->amount)}}</td>
            </tr>

        @endif
    </table>
 
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td class="ths">
                <div class="center">@lang('layout.Record')  </div>
            </td>
            <td class="ths">
                <div class="center"> @lang('layout.Name')</div>
            </td>
            <td class="ths">
                <div class="center"> @lang('layout.Site')</div>
            </td>
            @if(getOtherMeasure()=="true")
            <td class="ths">@lang('layout.OMeasureValue1')</td>
            @endif
            @if(getOtherMeasure2()=="true")
            <td class="ths">@lang('layout.OMeasureValue2')</td>
            @endif
            <td class="ths">
                <div class="center"> @lang('layout.Symbol')</div>
            </td>
            <td class="ths">
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <!-- td>
                <div class="center"> @lang('layout.Price')</div>
            </td -->
            <td class="ths">
                <div class="center"> @lang('layout.SalePrice')</div>
            </td>
            <td class="ths">
                <div class="center"> @lang('layout.Total')</div>
            </td>

        </tr>
        </thead>
        <?php
        $count = 0;
        $Total = 0;
        ?>
        @foreach($items AS $record)
            <tr>
                <td  class="center">{{++$count}}</td>
                <td class="center">{{$record->itemName}}</td>
                <td class="center">{{$record->site}}</td>
                @if(getOtherMeasure()=="true")
                <td class="center">{{$record->other_measure}}</td>
                @endif
                @if(getOtherMeasure2()=="true")
                <td class="center">{{$record->other_measure2}}</td>
                @endif
                <td class="center">{{$record->um}}</td>
                <td class="center">{{$record->qty}}</td>
                <!-- td class="center">{{round($record['price'],2)}}</td -->
                <td class="center">{{round($record['sale_price'],2)}}</td>
                <td class="center">{{$record['qty']*$record['sale_price']}}</td>

            </tr>
        @endforeach
    </table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection