@extends('layouts.factor-master')
@section('style')
<style>
    .ths{
        height: 35px;
        text-align: center;
        font-weight: bold;
    }
</style>
@endsection
@section('content')
    <h3 class="table-caption" style="text-align: center;">@lang('layout.RefundsSaleReport')</h3>
    <p>
        @if($category)
        <span>@lang('layout.Category'): {{__('layout.'.ucfirst($category))}}</span><br>
        @endif
    </p>
    @if($from_date || $to_date)
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    @endif
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td class="ths"> @lang('layout.Record') </td>
            <td class="ths"> @lang('layout.RefundNo')</td>
            <td class="ths">@lang('layout.ReferenceNumber')</td>
            <td class="ths">@lang('layout.Date')</td>
            <td class="ths">@lang('layout.Description')</td>
            <td class="ths">@lang('layout.Category')</td>
            <td class="ths">@lang('layout.SalesNumber')</td>
            <td class="ths">@lang('layout.CustomerName')</td>
            <td class="ths">@lang('layout.Amount')</td>
            <td class="ths">@lang('layout.Currency')</td>
            <td class="ths">@lang('layout.Rate')</td>
            <td class="ths">@lang('layout.Discount')</td>
            <td class="ths">@lang('layout.User')</td>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total_baseCurrency = 0;
        ?>
        @foreach($data AS $record)
            <?php
                if(systemConfig()[30] == 1){
                    $total_baseCurrency += ($record->refund_amount / $record->static_rate * $record->refRate);
                }else{
                    $total_baseCurrency += ($record->refund_amount / $record->refRate);
                }

            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->refNo}}</td>
                <td class="center">{{$record->ref_no}}</td>
                <td class="center">{{convertDate($record->date)}}</td>
                <td style="text-align: justify">

                    {{$record->description}}

                    {{-- @if(isset($report_format))
                    {{$record->description}}
                    @else
                    {!! wordwrap($record->description,40,"<br/>\n",false) !!}
                    @endif --}}

                </td>
                <td class="center">{{($record->category)?__('layout.'.ucfirst($record->category)):''}}</td>
                <td class="center">{{$record->saleNumber}}</td>
                <td class="center">{{$record->member_name}}</td>
                <td class="center">{{myRound($record->refund_amount)}}</td>
                <td class="center">{{$record->currency}}</td>
                <td class="center">{{$record->refRate}}</td>
                <td class="center">{{$record->discount}}</td>
                
                <td class="center">{{$record->user}}</td>
            </tr>
        @endforeach
            <tr class="bg">
                <td colspan="4" class="center">@lang('layout.Total')</td>
                <td colspan="5" class="center"> {{myRound($total_baseCurrency)}} {{getHomeCurrency()[getCurrencyType()]}} </td>
            </tr>
    </table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection