@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
        .dropdown-toggle .clear {
            display: none;
        }
    </style>
@stop
@section('content')

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.SaleNumber') <span
                                style="color: red"> ({{$sale->number}})</span> @lang('menu.Refund')  </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::model($sale,['route' => ['refund.updateSale',$sale->sale_id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}

                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer')</label>
                                            <input type="text" class="form-control" value="{{$sale->member_name}}"
                                                   disabled>
                                            <input type="hidden" name="customer" value="{{$sale->member_id}}" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <input type="text" value="{{$sale->currency}}" disabled
                                                   class="form-control">
                                            <input type="hidden" name="currency" :value="selected_currency.code">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>

                                            <input type="number" name="currency_rate" name="rate"
                                                   v-model="(!selected_currency)?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>
                                            <div class="input-group">
                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0" max="100" disabled>
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                                      <input type="hidden" class="input-group-addon"
                                                             name="discount_type" value="currency">
                                                  </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">%
                                                      <input type="hidden" name="discount_type" value="percent">
                                                  </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <input type="text" class="form-control" value="{{$sale->account_name}}"
                                                   name="" disabled>
                                            <input type="hidden" name="bank_account" value="{{$sale->account_id}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1"
                                                      disabled>{{$sale->description}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-6">
                                            <label class="control-label">@lang('layout.SaleDate')</label>
                                            <input type="text" class="form-control date" value="{{$sale->date}}"
                                                   autocomplete="off" disabled>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="control-label">@lang('layout.RefundDate')</label>
                                            <input type="text" name="date" class="form-control date">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="newDescription" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.RefundNo')</label>
                                            <input type="number" name="refundNo" class="form-control"
                                                   value="{{$number}}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{
                                                Number.parseFloat(discount).toFixed(precision()) }}%)
                                            </small>
                                        </td>
                                        <td class="text-right">
                                           <span class="text-right" data-counter="counterup"
                                                 data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                          <span class="text-right" data-counter="counterup"
                                                data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th style="min-width: 100px">@lang('layout.OldQuantity') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 80px">@lang('layout.OMeasureValue') 1
                                </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 80px">@lang('layout.OMeasureValue') 2
                                </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="item.item" :options="temp_items"></v-select>
                                    <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control"
                                            disabled>
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>

                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Description')"
                                           name="inventory_description[]" class="form-control">
                                </td>
                                <td>
                                    <input type="number" name="inventory_quantity_old[]"
                                           :value="(item.item==null)?null:item.item.old_quantity-(item.item.quantity)"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')" readonly>

                                </td>
                                <td>
                                    <input type="number" name="inventory_quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue') 1">
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue') 2">
                                </td>

                                <td>
                                    @{{myRound((item.item==null)?null:refundItemQuantity(item.item,item.item.quantity,item.item.old_quantity))}}

                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)"
                                               ref="in" @input="setNewRate('inventory',index)" class="form-control">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate)"
                                               placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>

                        <hr>
                        <!-- begin service -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.OldQuantity')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>

                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(service,index) in services">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="service.item" :options="(service.items)"
                                              @click.native="addNew('service',index)">

                                    </v-select>
                                    <input type="hidden" name="service_id[]"
                                           :value="(service.item==null)?null:service.item.id">
                                </td>
                                <td>
                                    <input class="form-control"
                                           v-model.number="(!service.item)?null:service.item.old_quantity"
                                           placeholder="@lang('layout.OldQuantity')" type="number" readonly>
                                </td>

                                <td>
                                    <input class="form-control" name="service_quantity[]"
                                           v-model.number="(!service.item)?null:service.item.quantity"
                                           placeholder="@lang('layout.Quantity')" type="number">
                                </td>
                                <td class="highlight">
                                    <select v-model="(service.item == null)?null:service.item.measure"
                                            class="form-control" @change="measureChangeservice(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(service.item ==null)?false:true">
                                              <option v-for="measure in (service.item==null)?null:service.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>

                                    </select>

                                    <input type="hidden" name="service_measure[]"
                                           :value="(service.item==null)?null:service.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="service_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate)"
                                               ref="ser" @input="setNewRate('service',index)" class="form-control">
                                        <span class="input-group-addon">
                                          @{{selected_currency.symbol}}
                                        </span>
                                    </div>

                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate)"
                                               placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('service',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end service -->
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="!isError" onclick="regForm(this)"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        var currency ={!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var all_services = {!! $all_services !!};
        var selectedService = {!! $selectedService !!};
        var selectedItem = {!! $selectedItem !!};
        var sale = {!! $sale !!};
        var v = new Vue({
            el: '#app',
            data: {
                sale: sale,
                selected_item: selectedItem,
                selected_banks: null,
                all_services: all_services,
                selected_service: selectedService,
                currency: currency,
                selected_currency: selectedCurrency,
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                temp_items: [],
                totalAmountes: [],
                aaa: {},
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [],
                services: [],
                inventory_quantities: [],
                payments: [],
            },
            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }
                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate && quantity > 0) {
                                var price = ((measure_unit * new_rate) / smeasure_unit);
                                var qty = (smeasure_unit * quantity) / measure_unit;
                                sum += price * qty * this.selected_currency.rate;
                                // sum +=new_rate*quantity*this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }


                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {

                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                            }

                        }
                    }
                    console.log('ssss', sum);
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }

                    }
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {

                            if (this.inventories[i]['item']['quantity'] > this.inventory_quantities[i]) {
                                // isError=true;
                                console.log('error', this.inventories[i]['item']['quantity']);
                            }

                        }
                    }

                    return isError;
                },
                // filter the banks according to selected currency

            },
            mounted: function () {
                // initialize the selected item
                for (var i = 0; i < this.selected_item.length; i++) {
                    this.inventories.push({item: this.selected_item[i]});
                    this.inventory_quantities.push(this.selected_item[i].quantity);
                    console.log(this.inventory_quantities);
                }

                // end item

                // initialize payments


                // end payment

                if (this.purchase) {
                    this.discountFiled = this.purchase.discount;
                    if (this.purchase.discount_type) {
                        if (this.purchase.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }
                // begin service

                for (var r = 0; r < this.selected_service.length; r++) {
                    var flag = false;
                    var tempService;
                    for (var h = 0; h < this.all_services.length; h++) {
                        if (this.all_services[h].id == this.selected_service[r].item_id) {
                            flag = true;
                            tempService = this.all_services[h];
                            tempService.old_quantity = this.selected_service[r].qty;
                            //tempService.quantity = this.selected_service[r].qty;
                            tempService.rate = this.selected_service[r].sales_price;
                            tempService.new_rate = this.selected_service[r].sales_price;
                        }
                    }
                    if (flag) {
                        this.services.push({item: tempService, items: this.all_services})
                    }
                }

                // end service

                if (this.sale) {
                    this.discountFiled = this.sale.discount;
                    if (this.sale.discount_type) {
                        if (this.sale.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }
            },
            methods:
                {
                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                        }
                    },
                    // detect member change and searh
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {

                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                            }
                        }


                    },
                    // in here you can check and decide to allow duplicate bank for payment or not

                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form

                },


        });

    </script>


@endpush