@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
        .dropdown-toggle .clear {
            display: none;
        }

    </style>
@stop
@section('content')

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('menu.Refund') @lang('layout.InvoiceNumber')
                        <span style="color:red"> {{$refund->sale_number}}   </span></span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:100%;">
                <!-- BEGIN FORM-->
                {{Form::model($refund,['route' => ['refundRollInvoice.update',$refund->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}

                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer')</label>
                                            <input type="text" class="form-control" value="{{$refund->member_name}}"
                                                   disabled>
                                            <input type="hidden" name="customer" value="{{$refund->member_id}}"
                                                   required>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select label="code" disabled :options="currency"
                                                      v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" :value="selected_currency.code">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>
                                            <input type="number" name="currency_rate" name="rate"
                                                   v-model="(!selected_currency)?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>
                                            <div class="input-group">
                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0" max="100" readonly>
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                                      <input type="hidden" class="input-group-addon"
                                                             name="discount_type" value="currency">
                                                  </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">%
                                                      <input type="hidden" name="discount_type" value="percent">
                                                  </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" class="form-control date" value="{{$refund->date}}"
                                                   autocomplete="off" disabled>
                                            <input type="hidden" name="date" value="{{$refund->date}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1" readonly>{{$refund->sale_description}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="newDescription" class="form-control" rows="1">{{$refund->description}}</textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.RefundNo')</label>
                                            <input type="number" name="refundNo" class="form-control" value="{{$refund->number}}">
                                        </div>
                                    </div>
                                </div>
                                @if(ShowQuantityByWing() == "true")
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="col-md-12 form-group">
                                        <label class=" control-label">@lang('layout.QuantityByWing')</label>
                                        <div>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="quantityByWing" v-model="quantityByWing" @click="totalChangeQuantityByWing()" >
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds))}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{
                                                Number.parseFloat(discount).toFixed(precision()) }}%)
                                            </small>
                                        </td>
                                        <td class="text-right">
                                       <span class="text-right" data-counter="counterup"
                                             data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                                              <span class="text-right" data-counter="counterup"
                                                    data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup"
                                                  data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <!-- end total -->
                        </div>
                    </div>
					
					
					
					
					
                    <div class="row" style="overflow-x: scroll;">
						<h3 v-if="main_inventories.length>0">@lang('layout.MainItem')</h3>
						<table  v-if="main_inventories.length>0" id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue2')
                                </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.SalePrice') </th>
                                <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in main_inventories">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="item.item" :options="temp_items"></v-select>
                                    <input type="hidden" :name="'main_inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>
                                    <input type="hidden" :name="'main_inventory_site['+index+']'"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Description')"
                                          :name="'main_inventory_description['+index+']'" class="form-control">
                                </td>
                                <td>
                                    <input type="number" :name="'main_inventory_quantity['+index+']'"
                                           class="form-control input-style input-number chan_length"
                                           v-model="(item.item==null)?null:item.item.quantity"
                                           oninput = "autowidths(event)"
                                           placeholder="@lang('layout.Quantity')">

                                </td>

                                <td v-show="showWhat('other_measure')=='yes'">
                                    <div class="input-group">
                                        <input type="number" class="form-control input-style input-number chan_length"
                                        oninput = "autowidths(event)"
                                        :name="'main_other_measure_amount['+index+']'"
                                        placeholder="@lang('layout.OMeasureValue1')">
                                        <span class="input-group-addon">
                                            @{{myRound((item.item==null)?null:item.item.other_measure)}}
                                        </span>
                                    </div>
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <div class="input-group">
                                        <input type="number" :name="'main_other_measure_amount2['+index+']'"
                                        oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                        <span class="input-group-addon">
                                            @{{myRound((item.item==null)?null:item.item.other_measure2)}}
                                        </span>
                                    </div>
                                </td>


                                <td>
                                    @{{myRound((item.item==null)?null:refundItemQuantity(item.item,item.item.quantity,item.item.old_quantity))}}
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="mainMeasureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" :name="'main_inventory_measure['+index+']'"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" :name="'main_inventory_price['+index+']'" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               oninput = "autowidths(event)"
                                               ref="main_in" @input="setNewRateMain('inventory',index)" class="form-control chan_length">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" :name="'main_inventory_discount['+index+']'" readonly placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                            @{{selected_currency.symbol}}
                                        </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                            %
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount, null, null, null , selected_currency.static_rate).result}}
                                    @{{selected_currency.symbol}}
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('main_inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>

                        <hr>
						<h3>@lang('layout.ItemByCode')</h3>
                        <table v-if="inventories.length>0" id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th style="min-width: 100px">@lang('layout.Code') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue2')
                                </th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.Width') </th>
                                <th style="min-width: 100px">@lang('layout.Wing') </th>
                                <th style="min-width: 100px">@lang('layout.ApproxWeight') </th>
                                <th style="min-width: 100px">@lang('layout.SalePrice') </th>
                                <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
								<!-- click.native="addNew('inventory',index)" search="onItemSearch" -->
                                    <v-select label="name" v-model="item.item" :options="temp_items" ></v-select>
                                    <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>
                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td>
                                    <input type="text" v-model="(item.item==null)?null:item.item.code" placeholder="@lang('layout.Code')" name="code[]"
                                    oninput = "autowidths(event)"
                                    class="form-control chan_length" readonly>
								   <input type="hidden" name="code_cost[]"  :value="(item.item==null)?null:item.item.code_cost">
                                </td>
                                <td>
                                    <input type="number" name="inventory_quantity[]"
                                    oninput = "autowidths(event)" @input="changeQuantityOfWing(index)"
                                           class="form-control input-style input-number chan_length"
                                           v-model="(item.item==null)?null:item.item.quantity"
                                           placeholder="@lang('layout.Quantity')">

                                </td>

                                <td>
                                    @{{myRound((item.item==null)?null:refundItemQuantity(item.item,item.item.quantity,item.item.old_quantity))}}
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <div class="input-group">
                                        <input type="number" :name="'other_measure['+index+']'" oninput = "autowidths(event)"
                                        class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(item.item==null)?null:item.item.o_measure">
                                        <span class="input-group-addon">
                                            @{{myRound((item.item==null)?null:((item.item==null)?null:item.item.other_measure))}}
                                        </span>
                                    </div>
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <div class="input-group">
                                        <input type="number" :name="'other_measure2['+index+']'" oninput = "autowidths(event)"
                                        class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.o_measure2">
                                        <span class="input-group-addon">
                                            @{{myRound((item.item==null)?null:((item.item==null)?null:item.item.other_measure2))}}
                                        </span>
                                    </div>
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                    </select>
                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
								<td>
                                    <input type="number" v-model="(item.item==null)?null:item.item.widths" placeholder="@lang('layout.Width')" name="widths[]"
                                    oninput = "autowidths(event)" class="form-control chan_length">
								</td>
								<td>
                                    <input type="number" v-model="(item.item==null)?null:item.item.khada" placeholder="@lang('layout.Wing')" name="khada[]" @input="changeQuantityByWing(index)"
                                    oninput = "autowidths(event)" class="form-control chan_length">
								</td>
                                <td>
                                    <input :name="'approx_weight['+index+']'" type="number" step="any"  v-model="(item.item==null)?null:item.item.approx_weight" @input="changeQuantityByWing(index)"
                                    oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.ApproxWeight')">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               oninput = "autowidths(event)"
                                               ref="in" @input="setNewRate('inventory',index)" class="form-control chan_length">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]" readonly placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                            @{{selected_currency.symbol}}
                                        </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                            %
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount, null, null, null , selected_currency.static_rate).result}}
                                    @{{selected_currency.symbol}}
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>

                        <hr>
                        <!-- begin service -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                <!-- <th class="text-center" style="min-width: 160px;">@lang('layout.OldQuantity')</th> -->
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>

                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(service,index) in services">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="service.item" :options="(service.items)"
                                              
                                              @input="checkExistingService(index)">

                                    </v-select>
                                    <input type="hidden" name="service_id[]"
                                           :value="(service.item==null)?null:service.item.id">
                                </td>
                                <td>
                                    <input class="form-control" name="service_quantity[]"
                                           v-model.number="(!service.item)?null:service.item.quantity"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(service.item == null)?null:service.item.measure"
                                            class="form-control" @change="measureChangeservice(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(service.item ==null)?false:true">
                                              <option v-for="measure in (service.item==null)?null:service.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>

                                    </select>

                                    <input type="hidden" name="service_measure[]"
                                           :value="(service.item==null)?null:service.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="text" name="service_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               ref="ser" @input="setNewRate('service',index)" class="form-control">
                                        <span class="input-group-addon">
                                          @{{selected_currency.symbol}}
                                        </span>
                                    </div>

                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate, null, selected_currency.static_rate).result"
                                               placeholder="@lang('layout.Total')" disabled>
                                        <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('service',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end service -->
                        <hr>
                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Balance')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                 
                                      <span v-if="payment.item !=null">
                                        @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                      </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate, null, selected_currency.static_rate).result"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px" required
                                               disabled/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="!isError" @click="submitForm"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueInputAutowidth);

        var currency = {!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var banks = {!! $banks !!};
        var selectedBanks = {!! $selectedBanks !!};
        var all_services = {!! $all_services !!};
        var selectedService = {!! $selectedService !!};
        var selectedItem = {!! $selectedItem !!};
        var refund = {!! $refund !!};
        var selectedMainItem = {!! $selectedMainItem !!};
        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                refund: refund,
                selected_item: selectedItem,
                selectedMainItem: selectedMainItem,
                banks: banks,
                selected_banks: selectedBanks,
                all_services: all_services,
                selected_service: selectedService,
                currency: currency,
                selected_currency: selectedCurrency,
                rate: 0,
                discountFiledRow: 0,
                discountFiled: 0,
                discountIsAmount: false,
                quantityByWing: false,
                temp_items: [],
                totalAmountes: [],
                inventory_quantities: [],
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [],
                main_inventories: [],
                services: [],
                payments: [],
            },
            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }
                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var sum_discount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {


						// {  

                        // var quantity=this.inventories[i]['item']['code']['qut_temp'];
                        // var rate=this.inventories[i]['item']['rate'];
                        // var new_rate=this.inventories[i]['item']['new_rate'];
                        // var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        // var measure_unit=this.inventories[i]['item']['measure_unit'];
                        // if(new_rate !=rate && quantity>0)
                        // {
                           // sum +=new_rate*quantity*this.selected_currency.rate;
                           // sumRoll +=new_rate*quantity*this.selected_currency.rate;
                        // }
                        // else
                        // {
                          // sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                          // sumRoll +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                        // }
                        
                    // }


                            var discount = this.inventories[i]['item']['discount'];
                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate !=rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif

                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                        @endif
                                    }
                                }
                                // sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                        @endif
                                    }
                                }
                                // sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }
							console.log('ppspsps', new_rate, rate,quantity, sum);

                        }

                    }
					
					for (var i = 0; i < this.main_inventories.length; i++) {
                        if (this.main_inventories[i].item && this.main_inventories[i].item != null) {

                            var discount = this.main_inventories[i]['item']['discount'];
                            var quantity = this.main_inventories[i]['item']['quantity'];
                            var rate = this.main_inventories[i]['item']['rate'];
                            var new_rate = this.main_inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.main_inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.main_inventories[i]['item']['measure_unit'];
                            if (new_rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                        @endif
                                    }
                                }
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                        @endif
                                    }
                                }
                            }

                        }

                    }
					
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {

                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }

                        }
                    }
                    this.discountFiledRow = sum_discount;
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }
                    }
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            if (this.inventories[i]['item']['quantity'] > this.inventory_quantities[i]) {
                                //isError=true;
                                console.log('error', this.inventories[i]['item']['quantity']);
                            }

                        }
                    }

                    return isError;
                },
            },
            mounted: function () {
				
                // initialize the selected item

                for (var i = 0; i < this.selected_item.length; i++) {
                    this.inventories.push({item: this.selected_item[i]});
                    this.inventory_quantities.push(this.selected_item[i].quantity);
                }
				
				if (this.selectedMainItem != null) {
				for (var i = 0; i < this.selectedMainItem.length; i++) {
                    this.main_inventories.push({item: this.selectedMainItem[i]});
                    this.inventory_quantities.push(this.selectedMainItem[i].quantity);
                }
                }
				
                // end item

                // begin payment initialization

                for (var t = 0; t < this.selected_banks.length; t++) {
                    var foundFlag = false;
                    var tempBank = null;
                    for (var y = 0; y < this.banks.length; y++) {
                        if (this.selected_banks[t].Account_id == this.banks[y].id) {
                            foundFlag = true;
                            tempBank = this.banks[y];
                            tempBank.old_amount = this.selected_banks[t].Amount;
                            tempBank.amount=this.selected_banks[t].Amount;
                            tempBank.rate = this.selected_banks[t].Rate;
                        }
                    }
                    if (foundFlag) {

                        this.payments.push({item: tempBank, items: this.banks});
                    }
                }
                for (var w = 1; w > this.selected_banks.length; w--) {
                    this.payments.push({item: null, items: banks});
                }
                // end payment initialization

                // begin service

                for (var r = 0; r < this.selected_service.length; r++) {
                    var flag = false;
                    var tempService;
                    for (var h = 0; h < this.all_services.length; h++) {
                        if (this.all_services[h].id == this.selected_service[r].item_id) {
                            flag = true;
                            tempService = this.all_services[h];
                            tempService.old_quantity = this.selected_service[r].qty;
                            tempService.quantity=this.selected_service[r].qty;
                            tempService.rate = this.selected_service[r].price;
                            tempService.new_rate = this.selected_service[r].price;
                        }
                    }
                    if (flag) {
                        this.services.push({item: tempService, items: this.all_services})
                    }
                }
                for (var w = 1; w > this.selected_service.length; w--) {
                    this.services.push({item: null, items: all_services});
                }
                // end service

                if (this.refund) {
                    this.discountFiled = this.refund.discount;
                    if (this.refund.discount_type) {
                        if (this.refund.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }
            },
            methods:
                {

                    changeQuantityOfWing(index) {
                        if (v.quantityByWing) {
                            @if(ShowQuantityByWing() == "true")
                            setTimeout((function() {
                                if (v.inventories[index].item != null) {
                                    if (v.inventories[index].item != null) {
                                        if (Number.parseFloat(v.inventories[index].item.quantity) > 0 && Number.parseFloat(v.inventories[index].item.approx_weight) > 0) {
                                            v.inventories[index].item.khada = myRound(Number.parseFloat(v.inventories[index].item.quantity) / Number.parseFloat(v.inventories[index].item.approx_weight));
                                            // v.changePriceByWing(index);
                                        } else if (Number.parseFloat(v.inventories[index].item.khada) > 0 && Number.parseFloat(v.inventories[index].item.quantity) > 0) {
                                            v.inventories[index].item.approx_weight = myRound(Number.parseFloat(v.inventories[index].item.quantity) / Number.parseFloat(v.inventories[index].item.khada));
                                            // v.changePriceByWing(index);
                                        }
                                    }
                                }
                            }), 500)
                            @endif
                        }
                    },

                    changeQuantityByWing(index) {
                        if (v.quantityByWing) {
                            @if(ShowQuantityByWing() == "true")
                            setTimeout((function() {
                                if (v.inventories[index].item != null) {
                                    if (v.inventories[index].item != null) {
                                        if (Number.parseFloat(v.inventories[index].item.khada) > 0 && Number.parseFloat(v.inventories[index].item.approx_weight) > 0) {
                                            v.inventories[index].item.quantity = myRound(Number.parseFloat(v.inventories[index].item.khada) * Number.parseFloat(v.inventories[index].item.approx_weight));
                                            // v.changePriceByWing(index);
                                            // console.log(v.inventories[index].item.qut_temp);
                                        }
                                    }
                                }
                            }), 500)
                            @endif
                        }
                    },
                    totalChangeQuantityByWing() {
                        setTimeout((function() {
                        if (v.quantityByWing) {
                                for (var index = 0; index < v.inventories.length; index++) {
                                    if (v.inventories[index].item != null) {
                                        if (v.inventories[index].item != null) {
                                            if (Number.parseFloat(v.inventories[index].item.khada) > 0 && Number.parseFloat(v.inventories[index].item.approx_weight) > 0) {
                                                v.inventories[index].item.quantity = myRound(Number.parseFloat(v.inventories[index].item.khada) * Number.parseFloat(v.inventories[index].item.approx_weight));
                                                // v.changePriceByWing(index);
                                                // console.log(v.inventories[index].item.qut_temp);
                                            }
                                        }
                                    }
                                }
                        }
                        }), 500)
                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
							console.log('1231231', item.rate , item.measure.measure_unit , item.measure_unit);
							
                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
					
					// calculate item price based on measure change
                    mainMeasureChange(index) {

                        if (this.main_inventories[index].item != null) {
                            var item = this.main_inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.main_inventories[index].item.new_rate = result;

                            // this.main_inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
					
					// set new price
                    setNewRateMain(type = null, index) {
                        if (type == 'inventory') {
                            if (this.main_inventories[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.main_inventories[index].item.new_rate = this.$refs.main_in[index].value / this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                this.main_inventories[index].item.new_rate = this.$refs.main_in[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }


                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;
                            @if(systemConfig()[30] == 1)
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            @endif
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {
                                @if(systemConfig()[30] == 1)
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                                @endif
                            }
                        }


                    },
                    // begin item search
                    onItemSearch(search, loading) {
                        loading(true);
                        this.itemSearch(search, loading, this);
                    },
                    //ajax call to get items
                    itemSearch(search, loading, vm) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchSale',
                                keyword: search,
                            }
                        })
                            .then(function (response) {
                                this.temp_items = [];
                                if (response.data.length > 0) {
                                    vm.temp_items = response.data;
                                    console.log('data', vm.temp_items);
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },

                    // end item search

                    // contract search


                    // end contract search

                    // generic function for adding item to list

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'main_inventory') {
                                this.main_inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },

        });

    </script>


@endpush