@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
    @include("layouts.Cmodal")
    @include("bills.modal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ReturnInvoice') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>

            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->

                {{Form::open(['route' => ['refundRoll.updateSimple',$refund->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'refund-form'])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer')</label>

                                            <div class="input-group">
                                                <v-select label="name" :options="customer" @search="MemberSearch" v-model="selected_customer"></v-select>
                                                <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                            <span class="required">@{{ errors.first('customer') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.RefundNo')</label>

                                            <input type="number" name="number" v-validate="'required|numeric'"
                                                   data-vv-as="@lang('layout.RefundNo')" value="{{$refund->number}}"
                                                   class="form-control">
                                            <span class="required">@{{ errors.first('RefundNo') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                            <input type="text" name="ref_no" v-model="ref_no"
                                                   class="form-control" @input="checkRefNo()">
                                            <span v-if="isError1 ==true" class="input-has-error"
                                                  style="color: red">@{{msg}}</span>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row">

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select label="code" @input="selectedRate" :options="currency"
                                                      v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Currency')"
                                                   :value="selected_currency.code">
                                            <span class="required">@{{ errors.first('currency') }}</span>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>

                                            <input type="number" name="currency_rate" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Rate')" name="rate"
                                                   v-model="!selected_currency?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}">
                                            <span class="required">@{{ errors.first('currency_rate') }}</span>

                                            <span v-if="differentRate" style="background: #efefef; font-size: 14px;" class="required">@lang('message.DifferentRateMsg')</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" value="{{$refund->date}}"
                                                   class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>


                            </div>

                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>

                                            <textarea name="description" class="form-control"
                                                      rows="1">{{$refund->description}}</textarea>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>

                                            <div class="input-group">

                                                <input v-model="discountFiled" class="form-control"
                                                       type="number" min="0" readonly>
                                                <span v-if="discountIsAmount"
                                                      @click="discountIsAmount = !discountIsAmount"
                                                      class="input-group-addon">@{{selected_currency.symbol}}
                                                        <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                    </span>
                                                                                <span v-else @click="discountIsAmount = !discountIsAmount"
                                                                                    class="input-group-addon">%
                                                        <input type="hidden" name="discount_type" value="percent">
                                                    </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <select class="form-control" v-model="category" name="category">
                                                <option value="refund">@lang('layout.Refund')</option>
                                                <option value="repair">@lang('layout.Repair')</option>
                                                <option value="minorUse">@lang('layout.MinorUse')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>


                            </div>
                            <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">


                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal )-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                    <span class="text-right" data-counter="counterup"
                          data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                  <span class="text-right" data-counter="counterup"
                        data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                </table>

                            </div>

                            <!-- end total -->
                        </div>
                    
                        <input type="hidden" name="edit_sale" value="{{$edit_sale}}" />
                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 100px">@lang('layout.Category') </th>
                                <th style="min-width: 100px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.Code') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th style="min-width: 100px" v-show="showWhat('other_measure')=='yes'" >@lang('layout.OMeasureValue1')</th>
                                <th style="min-width: 100px" v-show="showWhat('other_measure2')=='yes'" >@lang('layout.OMeasureValue2')</th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.Width') </th>
                                <th style="min-width: 100px">@lang('layout.Wing') </th>
                                <th style="min-width: 100px">@lang('layout.ApproxWeight') </th>
                                <th style="min-width: 100px">@lang('layout.SalePrice') </th>
                                <!-- <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th> -->
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
							    <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'" class="highlight">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" @Click.native="onItemLoadCode(index), setIndex(index)" v-model="item.inventory"
											  @keyup.native="onItemLoadCode(index)"
                                              :options="temp_items" @search="onItemSearch"></v-select>
                                    <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''"
                                           data-vv-as="@lang('layout.ItemName')"
                                           :value="(!item.item)?null:item.item.id">
                                    <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>

                                    <input type="hidden" name="purchase_order_detail_id[]"
                                           :value="(!item.item)?null:item.item.purchase_order_detail_id">

                                    <input type="hidden" name="main_stock_id[]" :value="(!item)?null:item.main_stock_id">
                                    <input type="hidden" name="m_stocks_in_id[]" :value="(!item)?null:item.m_stocks_in_id">
                                </td>
								<td>
                                    <input type="text" :name="'code['+index+']'" v-model="(item.item==null)?null:item.item.code" v-validate="''"
                                           data-vv-as="@lang('layout.Code')" class="form-control" placeholder="@lang('layout.Code')" />
                                    <span class="required">@{{ errors.first('code['+index+']') }}</span>
                                </td>
								<td class="highlight">
                                      <v-select label="name" v-model="(item.item==null)?null:item.item.site" :options="(item.item==null)?site_list:item.item.site_list"></v-select>
                                      <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.id)">
                                  </td>
                                <td>
                                    <input type="number" :name="'quantity['+index+']'" v-validate="''" @input="changeApproxWeight(index)"
                                           data-vv-as="@lang('layout.Quantity')"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.Quantity')">
                                    <span class="required">@{{ errors.first('quantity['+index+']') }}</span>

                                </td>

                                <td>
                                    @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <div class="input-group">
                                        <input type="number" :name="'other_measure['+index+']'" oninput = "autowidths(event)"
                                        class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(item.item==null)?null:item.item.other_measure">
                                    </div>
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <div class="input-group">
                                        <input type="number" :name="'other_measure2['+index+']'" oninput = "autowidths(event)"
                                        class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.other_measure2">
                                    </div>
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                          <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                  :value="measure">
                                            @{{measure.measure_name}}
                                          </option>
                                        </span>
                                    </select>

                                    <input type="hidden" name="measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
								<td>
                                    <input type="number" :name="'width['+index+']'" v-model="(item.item==null)?null:item.item.width"
                                    oninput = "autowidths(event)"
                                    class="form-control chan_length" placeholder="@lang('layout.Width')" />
                                </td>
								<td>
                                    <input type="number" :name="'khada['+index+']'" v-model="(item.item==null)?null:item.item.khada" 
                                    oninput = "autowidths(event)" @input="changeApproxWeight(index)"
                                    class="form-control chan_length" placeholder="@lang('layout.Wing')" />
                                </td>
                                <td>
                                    <input :name="'approx_weight['+index+']'" type="number" step="any"  v-model="(item.item==null)?null:item.item.approx_weight"
                                    oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.ApproxWeight')">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               oninput = "autowidths(event)"
                                               ref="in" @input="setNewRate(index)" class="form-control chan_length">
                                        <span class="input-group-addon">
                                          @{{selected_currency.symbol}}
                                        </span>
                                    </div>

                                </td>
                                <!-- <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               oninput = "autowidths(event)"
                                               class="form-control chan_length">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                          @{{selected_currency.symbol}}
                                        </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                             %
                                            </span>
                                    </div>

                                </td> -->
                                <td>
                                    @{{
                                    (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate, null, null, selected_currency.static_rate).result
                                    }}
                                    <b>@{{selected_currency.symbol}}</b>
                                </td>

                                @if(auth()->user()->company()->first()->tag != 1)
                                    <td>
                                        @{{
                                        (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate, null, null, selected_currency.static_rate).resultHQ
                                        }}
                                        <b>@{{selected_currency.symbol}}</b>
                                    </td>
                                @endif

                                <td>
                                @if($edit_sale != 'yes')
                                    <span v-if="index > 0" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                @endif    
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>
                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="payment.items"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
       
                                    <span v-if="payment.item !=null">
                                    @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate, null, selected_currency.static_rate).result"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px" required/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->
                    </div>
                    <!--Begin Draiver-->

                    @if(getDriverInfo()=="true")
                        <br>
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                            </tr>
                            </thead>
                        </table>


                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <!-- begin inputs -->
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TransferCode')</label>
                                            {{Form::text('transfer_code',null,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}

                                        </div>
                                    </div>

                                    <div class="col-md-3">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Transporter_name')</label>
                                            <input type="test" name="transporter_name" class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Transporter_phone')</label>
                                            <input type="test" name="transporter_phone" class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                            {{Form::text('palce_of_weight',null,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                                        </div>
                                    </div>


                                </div>
                                <div class="row">

                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.SourcePlace')</label>
                                            {{Form::text('source_place',null,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.PlateNumber')</label>
                                            <input type="text" name="plate_number"
                                                   placeholder="@lang('layout.PlateNumber')" class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                            <input type="text" name="way_bill_number"
                                                   placeholder="@lang('layout.WayBillNumber')" class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TotalWeight')</label>
                                            <input type="text" name="total_weight"
                                                   placeholder="@lang('layout.TotalWeight')" class="form-control">
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                            <input type="text" name="empty_car_weight"
                                                   placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TotalBori')</label>
                                            <input type="text" name="total_bori" placeholder="@lang('layout.TotalBori')"
                                                   class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Description')</label>
                                            {{Form::textarea('transfer_description',null,['class' => 'form-control','rows' => '3','placeholder' => __('layout.Description')])}}
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                @endif
                <!--End Draiver-->


                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="isError1 ==false" v-if="!isError" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>

                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.use(VueInputAutowidth);

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],

        });
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    classes: [],
                    selectedClass: null,
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_customer = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var inventory_category = {!! $inventory_category !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var refund = {!! $refund !!};
        var selectedBank = {!! $selectedBank !!};
        var selectedItem = {!! $selectedItem !!};
        var v = new Vue({
            el: '#app',
            data: {
                refund: refund,
                showModal: false,
                differentRate: false,
                customer: [],
                selected_customer: {!! $selectedCustomer !!},
                contract: [],
                banks: banks,
                selected_banks: selectedBank,
                currency: currency,
                selected_currency: selectedCurrency,

                inventory_category: inventory_category,
                selected_category: null,
                site_list: null,
                selected_iventory_category: null,
                selected_index: 0,
                selected_item: selectedItem,
                rate: 0,
                temp_items: [],
                totalAmountes: [],

                inventories: [],
                payments: [],
                discountFiled: 0,
                discountIsAmount: false,
                ref_no: '',
                msg: '',
                isError1: false,
                category: 'refund'
            },

            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
							// console.log(123,this.inventories[i].item);

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var item_measure_unit = this.inventories[i]['item']['item_measure_unit'];
							// console.log(99999,new_rate , rate);
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            //    console.log('llllllll',sum, quantity , rate , smeasure_unit , measure_unit , this.selected_currency.rate);
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / item_measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / item_measure_unit) * this.selected_currency.rate);
                                @endif
                            //    console.log('wwwwww',sum, quantity , rate , smeasure_unit , item_measure_unit , this.selected_currency.rate);
                            }

                        }

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    this.differentRate = false;
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                // 
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
 

                                if (this.selected_currency.code == this.payments[i]['item']['code'] && this.payments[i]['item']['amount']) {
                                    if (Number.parseFloat(this.selected_currency.rate) != Number.parseFloat(this.payments[i]['item']['rate'])) {
                                        this.differentRate = true;
                                    }
                                }
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }
                    }
                    if (this.inventories.length == 0 || this.selected_customer == undefined || this.selected_customer == null || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
            },
            methods:
                {

                    changeApproxWeight(index) {
                        @if(getShowWing()!="false")
                        if (this.inventories[index]) {
                            if (this.inventories[index].item && this.inventories[index].item != null) {

                                var khada = this.inventories[index].item.khada;
                                var quantity = this.inventories[index].item.quantity;

                                if (khada != null && quantity != null) {
                                    this.inventories[index].item.approx_weight = Number.parseFloat(quantity / khada).toFixed(10);
                                }
                            }
                        }
                        @endif
                    },

                    checkRefNo() {

                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'refunds'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        // console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;
							// console.log(123,this.inventories[index].item);


                        }
                    },


                    // set new price
                    setNewRate(index) {
                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            @endif
                        }

                    },


                    // begin item search
                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchNameRoll',
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];

                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }, getDebounceTime()),
					
				onItemLoadCode(selectedIndex) {
					// v.selectedIndex = selectedIndex;
					if (v.inventories[selectedIndex].inventory != null) {
						// console.log('klk',v.inventories[selectedIndex].inventory,v.main_inventories);
						var inventory_id = v.inventories[selectedIndex].inventory.id;
						let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

						axios.get("{{route('callMethod.search')}}", {
							params: {
								member_id: v.member_id,
								method_name: 'itemSearchPurchaseRoll',
								inventory_id: inventory_id,
								inventory_category_id: inventory_category_id,
							}
						})
						.then(function (response) {
							v.inventories[selectedIndex].item = null;
							if (response.data.length > 0) {
								v.inventories[selectedIndex].item = response.data[0];
							
							}
						})
						.catch(function (error) {
							console.log(error);
						})
					}
					
				},

                    //ajax call to get items
                    setIndex(e) {
                        // v.temp_items=[];
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchNameRoll',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }

                    },

                    // end item search

                    // contract search


                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, inventory: null, item_category: this.selected_iventory_category, main_stock_id: null, m_stocks_in_id: null});
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            // console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("refund-form").submit()

                            }
                            else {

                            }
                        });

                    },


                },
            mounted: function () {
                if (this.refund) {
                    this.discountFiled = this.refund.discount;
                    this.ref_no = this.refund.ref_no;
                    this.category = this.refund.category;
                    if (this.refund.discount_type) {
                        if (this.refund.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }

                // initialize the selected item
                for (var i = 0; i < this.selected_item.length; i++) {
                    this.inventories.push({
                        item: this.selected_item[i],
                        inventory: this.selected_item[i],
                        item_category: this.selected_item[i].item_category,
                        main_stock_id: this.selected_item[i].main_stock_id, 
                        m_stocks_in_id: this.selected_item[i].m_stocks_in_id
                    });
                }
                for (var m = 2; m > this.selected_item.length; m--) {
                    this.inventories.push({item: null, inventory: null, item_category: null, main_stock_id: null, m_stocks_in_id: null});
                }

                // initialize payments
                for (var k = 0; k < this.selected_banks.length; k++) {
                    var foundFlag = false;
                    var tempBank = null;
                    for (var j = 0; j < this.banks.length; j++) {
                        if (this.banks[j].id == this.selected_banks[k].Account_id) {
                            foundFlag = true;
                            tempBank = this.banks[j];
                            tempBank.amount = this.selected_banks[k].Amount;
                            tempBank.rate = this.selected_banks[k].Rate;
                        }
                    }
                    if (foundFlag) {

                        this.payments.push({item: tempBank, items: this.banks});
                    }

                }

                for (var w = 1; w > this.selected_banks.length; w--) {
                    this.payments.push({item: null, items: banks});
                }
                // end payment
            }

        });

    </script>


@endpush