@extends('layouts.app')

@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'RefundInvoiceRoll'" @closed="closeModal">
            <div slot=body>
                <input type="hidden" name="type" :value="type">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Category')</label>

                                <select class="form-control" name="category">
                                    <option value="">@lang('layout.All')</option>
                                    <option value="refund">@lang('layout.Refund')</option>
                                    <option value="repair">@lang('layout.Repair')</option>
                                    <option value="minorUse">@lang('layout.MinorUse')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ListOfRefundInvoice')</span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                    @permission('refund-export')

                    <button type="button" class="btn btn-success" onclick="openModal('RefundInvoiceRoll')"><i
                                class="fa fa-print"></i></button>
                    @endpermission
                    @permission('refund-create')
                    <a href="{{route('refundRoll.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission

                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_filter_data">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0"
                       id="invoice_refund">
                    <thead>
                    <tr>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.InvoiceNumber')</th>
                        <th>@lang('layout.RefundNo')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.CustomerName')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Discount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY
<div id="factor-obj" >
    @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

    @endif
            </div> -->


@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        function RefundFactorPrint(id) {
            var a = document.createElement('a');
            a.href = "{{url('refundFactorPrintRoll')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);


        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
           data_table =  $('#invoice_refund').DataTable({
                ajax: {
                    url: '{{route("refundRoll.index")}}',
                    data: function (d) {
                        d.type = 'Invoice';
                    }
                },
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?1:8}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'category', name: 'category' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'number', name: 'number'},
                    {data: 'refNo', name: 'refNo'},
                    {data: 'ref_no', name: 'ref_no'},
                    {data: 'member_name', name: 'member_name'},
                    {data: 'refund_amount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'currency', name: 'currency' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'discount', name: 'discount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'date', name: 'date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'description', name: 'description' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'user', name: 'user' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'actions', name: 'action', searchable: false, orderable: false},

                ]
            });


        });

        new Vue({
            el: '#company_filter_data',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object')
                    {
                        data_table.clear();
                        data_table.ajax.reload()
                    }
                }
            }
        });


        Vue.component('v-select', VueSelect.VueSelect)


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                type: ''
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });

        function openModal(type) {
            vm.$data.is_show = true;
            vm.$data.type = type;
        }

    </script>


@endpush
