@extends('layouts.factor-master')

@section('content')
    <table style="width: 100%; margin-bottom: 10px;" class="main-table">
        @if($info && $info !=[])


            <tr>
                <th>@lang('layout.RefundNo')</th>
                <th>@lang('layout.SaleNumber')</th>
                <th>@lang('layout.MemberName')</th>
                <th>@lang('layout.Currency')</th>
                <th>@lang('layout.Rate')</th>
                <th>@lang('layout.Total')</th>
            </tr>
            <tr>
                <td>{{$info->number}}</td>
                <td>{{$info->sale_number}}</td>
                <td>{{$info->customer}}</td>
                <td>{{$info->currency}}</td>
                <td>{{$info->rate}}</td>
                <td>{{abs($amount->amount)}}</td>
            </tr>

        @endif
    </table>

    <br>
    <br>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.RefundReport')</h3>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td  class="center">
                <div >@lang('layout.Record')  </div>
            </td>
            <td  class="center">
                <div > @lang('layout.Name')</div>
            </td>
            <td  class="center">
                <div > @lang('layout.Code')</div>
            </td>

            @if(itemBrand() == 'true')
            <td  class="center">
                <div > @lang('layout.Brand')</div>
            </td>
            @endif

            <td  class="center">
                <div > @lang('layout.Site')</div>
            </td>
            @if(getOtherMeasure()=="true")
            <th>@lang('layout.OMeasureValue') 1</th>
            <th>@lang('layout.OMeasureValue') 2</th>
            @endif
            <td  class="center">
                <div > @lang('layout.Symbol')</div>
            </td>
            <td  class="center">
                <div > @lang('layout.Quantity')</div>
            </td>
            <td  class="center">
                <div > @lang('layout.Price')</div>
            </td>
            <td  class="center">
                <div > @lang('layout.Total')</div>
            </td>

        </tr>
        </thead>
        <?php
        $count = 0;
        $Total = 0;
        ?>
 
        @foreach($items AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->itemName}}</td>
                <td class="center">{{$record->code}}</td>
                @if(itemBrand() == 'true')
                <td class="center">{{$record->brand}}</td>
                @endif

                <td class="center">{{$record->site}}</td>
                @if(getOtherMeasure()=="true")
                <td class="center">{{$record->other_measure}}</td>
                <td class="center">{{$record->other_measure2}}</td>
                @endif
                <td class="center">{{$record->qty}}</td>
                <td class="center">{{round($record['sale_price'], 2)}}</td>
                <td class="center">{{round($record['qty']*$record['sale_price'], 2)}}</td>

            </tr>
        @endforeach
    </table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection