@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.RefundsSaleReport')</h3>
    <p>
        @if($category)
        <span>@lang('layout.Category'): {{__('layout.'.ucfirst($category))}}</span><br>
        @endif
        <span>@lang('layout.FromDate'): {{convertDate($from_date)}}</span>
        <span>@lang('layout.ToDate'): {{convertDate($to_date)}}</span><br>
    </p>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td class="center" >
                <div > @lang('layout.Record') </div>
            </td>
            <td class="center" >
                <div > @lang('layout.RefundNo')</div>
            </td>
            <td class="center" >
                <div > @lang('layout.ReferenceNumber')</div>
            </td>
            <td class="center" >
                <div > @lang('layout.Date')</div>
            </td>
            <td class="center" >
                <div > @lang('layout.Description')</div>
            </td>
            <td class="center" >
                <div > @lang('layout.Category')</div>
            </td>
            <td class="center" >
                <div > @lang('layout.SalesNumber')</div>
            </td>
            <td class="center" >
                <div > @lang('layout.CustomerName')</div>
            </td>
            <td class="center" >
                <div > @lang('layout.Currency')</div>
            </td>
            <td class="center" >
                <div > @lang('layout.Rate')</div>
            </td>
           

        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->refNo}}</td>
                <td class="center">{{$record->ref_no}}</td>
                <td class="center">{{$record->date}}</td>
                <td class="center">{{$record->description}}</td>
                <td class="center">{{__('layout.'.ucfirst($record->category))}}</td>
                <td class="center">{{$record->saleNumber}}</td>
                <td class="center">{{$record->member_name}}</td>
                <td class="center">{{$record->currency}}</td>
                <td class="center">{{$record->refRate}}</td>
                
            </tr>
        @endforeach
    </table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection