@extends('layouts.app')

@section('content')

    <div class="portlet" id="showAccount">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.RecipeInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
           
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr> 
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.Name') 
                        </th>
                        <th>
                            <i class="fa  fa-user"></i> @lang('layout.Customer') 
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Date')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Quantity')
                        </th>
                       
                        <th>
                            <i class="fa fa-briefcase"></i> @lang('layout.Description')
                        </th>
                        
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs">  {{ $recipeInfo->name }} </td>
                        <td class="hidden-xs"> {{ $recipeInfo->customer }}  </td>
                        <td class="hidden-xs"> {{ $recipeInfo->date }}  </td>
                        <td class="hidden-xs"> {{ $recipeInfo->quantity }}  </td>
                        <td class="hidden-xs"> {{ $recipeInfo->description }}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
        <div class="tabbable tabbable-tabdrop">

    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.Item')</a>
        </li>
        <li class="">
            <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Operators')</a>
        </li>
    </ul>
<div class="tab-content">
<div class="tab-pane active" id="tab1">
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Item')</span>
                </div>
                <div class="tools"> </div>
                <!-- <div class="pull-right">
                    @permission('discount-list')

                    <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>

                    <button type="button" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button>

                    @endpermission
                   
                </div> -->
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="item">
                    <thead>
                        <tr>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.Length')</th>
                            <th>@lang('layout.Weight')</th>
                            <th>@lang('layout.Height')</th>
                            <th>@lang('layout.DoorLine')</th>
                            <th>@lang('layout.Quantity')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
    <div class="tab-pane" id="tab2"> 
                <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Operators')</span>
                </div>
                <div class="tools"> </div>
                <!-- <div class="pull-right">
                    @permission('discount-list')

                    <button type="button" id="excell_from_vendor"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>

                    <button type="button" class="btn btn-success" id="pdf_from_vendor"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button>

                    @endpermission
                   
                </div> -->
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="operator">
                    <thead>
                        <tr>
                            <th>@lang('layout.Machine')</th>
                            <th>@lang('layout.Employee')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
    </div>
@endsection
@push('scripts')

<script>

</script>
<script>
    $(document).ready(function(){
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    $('#item').DataTable({
      scrollCollapse: true,
      responsive:'{{responsiveDataTable()}}',
      pagingType:'{{paginationType()}}',
      serverSide: true,
      paging: true,
      retrieve: true,
      ajax:{
        url:'{{route("recipe.show",$recipeInfo->id)}}',
        data:{type:'item'}
      },
    columns: [ 
            { data: 'name',         name: 'name' },
            { data: 'length',       name: 'length' , orderable:false,searchable:false},
            { data: 'width',       name: 'width' , orderable:true,searchable:false},
            { data: 'height',       name: 'height' , orderable:false,searchable:false},
            { data: 'door_line',    name: 'door_line', orderable:false,searchable:false },
            { data: 'quantity',     name: 'quantity', orderable:false,searchable:false },
            ]
    });
 
}); 

$(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
  $('#tab_payment').on('shown.bs.tab', function(event){
    $('#operator').DataTable({
      scrollCollapse: true,
      responsive:'{{responsiveDataTable()}}',
      pagingType:'{{paginationType()}}',
      serverSide: true,
      paging: true,
      retrieve: true,
      ajax:{
        url:'{{route("recipe.show",$recipeInfo->id)}}',
        data:{type:'operator'}
      },
    columns: [ 
            { data: 'name',               name: 'name' },
            { data: 'employee_name',      name: 'employee_name' , orderable:false,searchable:false},
            { data: 'description',        name: 'description' , orderable:true,searchable:false},
            ]
    });
  });
}); 
</script>


@endpush
