@extends('layouts.app')
@section('content')
    <div class="row">
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">  @lang('layout.RecipeList')  </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">

                    @permission('recipe-create')
                    <a href="{{route('recipe.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>

            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="recipeList">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Contract')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@push('scripts')

    <script>


        @if(Session('id'))
        factorPrint("{{Session('id')}}")

        @endif


        function factorPrint(id) {


            var a = document.createElement('a');
            a.href = "{{url('recipeFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);


        }

        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#recipeList').DataTable({
                ajax: '{{route("recipe.index")}}',
                scrollCollapse: true,
                paging: true,
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'Date', name: 'Date'},
                    {data: 'description', name: 'description'},
                    {data: 'name', name: 'name'},
                    {data: 'contract', name: 'contract'},
                    {data: 'quantity', name: 'quantity'},
                    {data: 'customer', name: 'customer'},
                    {data: 'actions', name: 'actions', orderable:false, searchable:false},

                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush