@extends('layouts.app')
 <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewRecipe') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'recipe.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Name')</label>
                                        {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.Name')])}}
                                    </div>
                                  </div> 
                                

                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Number')</label>
                                            {{Form::number('number',$number,['class' => 'form-control','placeholder' => __('layout.Number')])}}
                                        </div>
                                </div> 

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Quantity')</label>
                                            {{Form::number('quantity',null,['class' => 'form-control','placeholder' => __('layout.Quantity')])}}
                                        </div>
                                </div>
                                 <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Length')</label>
                                            {{Form::number('carton_length',null,['class' => 'form-control','placeholder' => __('layout.Length')])}}
                                        </div>
                               </div>
                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Width')</label>
                                            {{Form::number('carton_width',null,['class' => 'form-control','placeholder' => __('layout.Width')])}}
                                        </div>
                               </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                            {{Form::text('date',null,['class' => 'form-control date','placeholder' => __('layout.Date'), 'autocomplete' => 'off'])}}
                                        </div>
                                </div>  
                                 <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      
                                      <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Customer')</label>
              
                                           <v-select label="name" :options="customer_list" @search="onCustomer_search" v-model="selected_customer" ></v-select>
                                           <input type="hidden" name="customer_id" :value="(!selected_customer)?null:selected_customer.id">
                                         
                                                
                                        </div>
                               </div> 

                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                      
                                      <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Contract')</label>
                                            {{Form::number('contract',null,['class' => 'form-control','placeholder' => __('layout.Contract')])}}
                                        </div>
                               </div>





                                     <div class="col-md-12">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Description')</label>
                                            {{Form::textarea('description',null,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                                        </div>
                                       </div> 

                           
                            </div>

                            
                            <div v-if="inventories.length>0" style="margin-top: 20px !important" style="overflow-x: scroll;" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                    <thead>
                                        <tr>
                                            <thead>
                                            <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                            <!-- <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                            <th style="min-width: 100px">@lang('layout.Measure') </th> -->
                                            <th style="min-width: 100px">@lang('layout.Length')</th>
                                            <th style="min-width: 100px">@lang('layout.Width')</th>
                                            <th style="min-width: 100px">@lang('layout.Height')</th>
                                            <th style="min-width: 100px">@lang('layout.DoorLine')</th>
                                            <th style="min-width: 100px">@lang('layout.Quantity')</th>
                                            <th></th>
                                            </thead>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="(item,index) in inventories">
                                            <td class="highlight">
                                                <v-select label="name" v-model="item.item" :options="temp_items" @search="onItemSearch"></v-select>
                                                <input type="hidden" :name="'inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">
                                            </td>
                                           <!--  <td class="highlight">
                                                @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                            </td>
                                            <td class="highlight">
                                                <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                  <option value="null">@lang('layout.Select')</option>
                                                  <span v-if="(item.item ==null)?false:true">
                                                      <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                      @{{measure.measure_name}}
                                                    </option> 
                                                  </span>
                                                  
                                                 
                                              </select>
                                            </td> -->
                                            <td class="highlight">
                                                <input type="number" step="any" placeholder="@lang('layout.Length')"  name="length[]" class="form-control">
                                            </td>
                                            <td class="highlight">
                                                <input type="number" step="any" placeholder="@lang('layout.Width')"  name="width[]" class="form-control">
                                            </td>
                                            <td class="highlight">
                                                <input type="number" step="any" placeholder="@lang('layout.Height')"  name="height[]" class="form-control">
                                            </td>
                                            <td class="highlight">
                                                <input type="text" placeholder="@lang('layout.DoorLine')" name="door_line[]" class="form-control">
                                            </td>
                                            <td class="highlight">
                                                <input type="number" placeholder="@lang('layout.Quantity')" name="item_quantity[]" class="form-control">
                                            </td>
                                            <td>
                                               <span v-if="index > 0" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                            </td>
                                        </tr>
                                        <tr style="background-color: #ffffff;">
                                            <td></td>
                                            <td><center>
                                                <button type="button" @click="addNew('inventory',100)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
                                            </center></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            
                                          </tr>
                                    </tbody>
                                </table>

                            </div>


                            <div v-if="machines.length>0" style="margin-top: 20px !important" style="overflow-x: scroll;" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                    <thead>
                                    <tr>
                                      <th> @lang('layout.Machine') </th>
                                      <th> @lang('layout.Employee') </th>
                                      <th> @lang('layout.Description') </th>
                                      <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(machine,index) in machines">
                                        <td>
                                            <v-select label="name" @input="addNew('machine',index)" :options="machinlist" placeholder="@lang('layout.Machine')" v-model="machine.machine" ></v-select>
                                            <input type="hidden" :name="'machine_id['+index+']'" :value="(!machine.machine)?null:machine.machine.id">
                                        </td>
                                        <td>
                                            <v-select label="name" v-model="machine.selected_employee" :options="employee_list" placeholder="@lang('layout.Employee')" @search="onEmployeeSearch"></v-select>
                                            <input type="hidden" :name="'employee_id['+index+']'" :value="(!machine.selected_employee)?null:machine.selected_employee.id">
                                        </td>
                                        <td>
                                            <input type="text" placeholder="@lang('layout.Description')" name="Odescription[]" class="form-control">
                                        </td>
                                        <td>
                                            <span v-if="index > 0" v-on:click="deleteItem('machine',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>
                                        
                                    </tr>
    
                                </tbody>
                                </table>
                            </div>


                        </div>
                    </div>       
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        <a href="{{route('recipe.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}

            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 

@endsection 
@push('scripts')
 <script type="text/javascript">
     Vue.component('v-select', VueSelect.VueSelect);
     var machinlist = {!! json_encode($machin) !!};
     var v = new Vue({
        el: '#app',
        data: {
            customer_list:[],
            selected_customer:null,
            inventories:[{item:null}],
            temp_items:[],
            machines:[{machine:null}],
            selected_machin:null,
            machinlist:machinlist,
            employee_list:[],
            selected_employee:[],
            length:null,
            width:null,
            height:null,
            quantity:null
        },
        methods:{
            onCustomer_search:_.debounce((search,loading) =>{
              loading(true);
              axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:"getCustomers",
                  keyword:search,
                }
              })
              .then(function(response){
                v.customer_list = [];
                if(response.data.length >0)
                {
                  v.customer_list = response.data;
                }
                loading(false);
              })
              .catch(function(error){
                console.log(error);
              })
           },getDebounceTime()),

            onItemSearch:_.debounce((search,loading) =>{
              loading(true);
              axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:"itemSearchPurchase",
                  keyword:search,
                }
              })
              .then(function(response){
                v.temp_items = [];
                if(response.data.length >0)
                {
                  console.log('ttttt',response.data);
                  v.temp_items = response.data;
                }
                loading(false);
              })
              .catch(function(error){
                console.log(error);
              })
           },getDebounceTime()),

            onEmployeeSearch:_.debounce((search,loading) =>{
              loading(true);
              axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:"getEmloyies",
                  keyword:search,
                }
              })
              .then(function(response){
                v.employee_list = [];
                if(response.data.length >0)
                {
                  v.employee_list = response.data;
                }
                loading(false);
              })
              .catch(function(error){
                console.log(error);
              })
           },getDebounceTime()),

            addNew(type=null,index)
               {
                  this.temp_items=[];
                  if(type !=null)
                  {
                     if(type=='inventory')
                     {
                        if(this.inventories[index+1]==undefined)
                        {
                          this.temp_items=[];
                          this.inventories.push({item:null,item_category:null});
                        }
                     }
                     if(type=='machine')
                     {
                        console.log(type);
                        this.employee_list=[];
                        if(this.machines[index+1]==undefined)
                        {
                            
                            this.machines.push({
                            machine: null,
                        });
                        }
                     }
                  }
                  
               },


               deleteItem(type=null,index)
               {
                 if(type !=null)
                 {
                     console.log(type);
                     if(type=='inventory')
                     {
                        this.inventories.splice(index, 1);
                     }
                      if(type=='machine')
                     {
                        this.machines.splice(index, 1);
                     }
                 }
                  
               },
        }
     })
 </script>

@endpush
 