@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }
   
</style>
@stop
@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.RecieveDetials')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class=""></i> @lang('layout.ReferenceNumber') 
                        </th> 
                        <th>
                            <i class="fa  fa-user"></i> @lang('layout.Name') 
                        </th>
                         <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.OverdueDate')
                        </th>
                        <th class="">
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                        </th>
                        <th> 
                            <i class="fa  "></i> @lang('layout.Amount') 
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.RecieveCurrency')
                        </th> 
                        <th>
                            <i class="fa  "></i> @lang('layout.Rate')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Discount') 
                        </th>
                        <th>
                            <i class="fa fa-tumblr"></i> @lang('layout.Type')
                        </th> 
                        <th>
                            <i class="fa fa-tumblr"></i> @lang('layout.Contract')
                        </th> 
                        @if(systemConfig()[5] != 0 )
                        <th>
                            <i class="fa  "></i> @lang('layout.Status')
                        </th> 
                        @endif 
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class=""> {{ $receive->ref_Number}}  </td>
                        <td class=""> {{ $receive->name}}  </td>
                        <td class=""> {{ convertDate($receive->Date) }} </td>
                        <td class=""> {{ $receive->hour }} </td>
                        <td class=""> {{ convertDate($receive->overdue_date) }} </td>
                        <td class=""> {{$receive->Account}} </td> 
                        <td class=""> {{ myRound($receive->amount)}}  </td>
                        <td class=""> {{$receive->runit}}  </td>
                        <td class=""> {{ $receive->exchange_rate}}  </td>
                        <td class=""> {{ $receive->discount }}  </td>
                        <td class=""> {{ $receive->type }}  </td>     
                        @if(systemConfig()[20] == 1)
                        <td class=""> {{ $receive->Contract }}  </td>
                        @endif
                        @if(systemConfig()[5] != 0 )
                        <td class=""> @if($receive->status){{__('type.'.$receive->status)}} @endif </td>
                        @endif
                    </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th width="">
                            <i class=" fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                        <th width=" ">
                            <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ $receive->description}}  </td>
                        <td class=" "> {{ $receive->memo}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
@if($receive->runit!=$receive->currency)
        <h4>@lang('layout.ExchangedAmount')</h4>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        
                        <th> 
                            <i class="fa  "></i> @lang('layout.Amount') 
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Currency')
                        </th> 
                        <th>
                            <i class="fa  "></i> @lang('layout.Rate')
                        </th> 
                        
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class=""> {{$receive->Examount}}  </td>
                        <td class="">{{$receive->currency}}  </td>
                        <td class=""> {{$receive->Excurrency}} </td>

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
@endif
    </div>
 


    <div class="row">
         <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                
                <li class="active">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
            
             <div class="tab-pane active" id="tab2"> 
                    <div class="tab-pane" id="tab2"> 
                    <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                    </div>
                </div>
                <div class="portlet-body">
                       <div class="portlet light bordered">
                            <div class="portlet-body">

                                <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="redirect_route" value="receive.show">
                                    <input type="hidden" name="foreign_data_id" value="{{$receive->id}}">
                                    <input type="hidden" name="path" value="uploads/Receive">
                                    <input type="hidden" name="table_name" value="receivable_payments">

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-7">
                                              <div class="form-group">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                        <img src="" alt=""> </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                    <div>
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                            
                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                               
                                    <div class="margiv-top-10">
                                        <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                        <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                    </div>
                            </form>
                            </div>
                    </div>
                    <table class="table table-striped table-bordered table-hover" id="attachment">
                        <thead>
                        <tr>  
                        <th>@lang('layout.AttachmentTitle')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Action')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
    </div>
            </div>
        </div>


    </div>
</div>
@endsection

@push('scripts')

<script>
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
          $('#attachment').DataTable({
                ajax:{
                    url:'{{route("receive.show",$receive->id)}}',
                    data:{type:'attachment'}
                  },
                
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    { data: 'title', name: 'attachments.title'},
                    { data: 'description', name: 'attachments.description'},
                    { data: 'actions',         name: 'actions', orderable:false,searchable:false},
            ]
        });



    });
</script>
@endpush

 
