@extends('layouts.factor-master')
@section('style')

<style>
    .st {
        font-size: 16px;
        font-weight: bold;
    }
</style>
@stop
@section('content')
<h4 class="bold uppercase" style="text-align: center; font-size: 20px;">@lang('layout.ReceiveVouchar')(RV)</h4>

<table class="main-table" style="width: 100%;" cellpadding="8px">
    <tr class="bg">
        <td colspan="2" style="width: 20%;">
            <span class="st"> @lang('layout.ReceiveNumber'): </span>
            <span class="st">{{$receive->rvNumber}}</span>
        </td>
        <td style="width: 20%;">
            <span class="st">@lang('layout.Code'):</span>
            <span class="st">{{$receive->code}}</span>
        </td>
    </tr>
    <tr class="bg">
        <td style="width: 30%;">
            <span class="st">@lang('layout.Date'): </span>
            <BDO DIR="LTR"> <span class="st">{{convertDate($receive->Date)}}</span> </BDO>
        </td>
        <td style="width: 20%;">
            <span class="st">@lang('layout.Hour'): </span>
            <BDO DIR="LTR"> <span class="st">
                    <?php echo Date('h:i A' , strtotime($receive->DateTime)); ?>
                </span> </BDO>
        </td>
        <td rowspan="2"  style="width: 50%;">
            <span class="st">@lang('layout.Description'):</span>
            <span class="st">
            {{$receive->description}}
            </span>
        </td>
    </tr>
    <tr class="bg">
        <td>
            <span class="st">@lang('layout.Payer'):</span>
            <span class="st">{{$receive->member}}</span>
        </td>
        <td>
            <span class="st">@lang('layout.ReceivedBy'):</span>
            <span class="st">{{$user}}</span>
          </td>
    </tr>

</table>
<table class="main-table" style="width: 100%; " cellpadding="8px">

    <tr>
      <td>
        <span class="st">@lang('layout.Amount') @lang('currency.'.($receive->currency ))</span>
      </td>    
      <td>
        <span class="st">@lang('layout.Rate')</span>
      </td> 
      <td>
        <span class="st">@lang('currency.'.(getHomeCurrency()['code']))</span>
      </td>    
      <td>
        <span class="st">@lang('layout.Remained')
          
        </span>
      </td>
    </tr>  
    <tr>
      <td>
        <span class="st">{{myRound($receive->Amount)}} {{$receive->currency}}</span>
      </td>    
      <td>
        <span class="st">{{$receive->Rate}}</span>
      </td>
      <td>
        @if(systemConfig()[30] == 1)
        <span class="st">{{myRound($receive->Amount/ $receive->static_rate * $receive->Rate)}} {{getHomeCurrency()['code']}}</span>
        @else 
        <span class="st">{{myRound($receive->Amount/$receive->Rate)}} {{getHomeCurrency()['code']}}</span>
        @endif
      </td>
  
      @if(getHesabSabeqa() =='true')
     <td>
       <span class="st">{{myRound(ABS($balance))}} {{getHomeCurrency()['code']}}
        @if($balance<0)
            (@lang('layout.Payable'))
          @else
            (@lang('layout.Receivable'))
          @endif
      </span>
      </td>
     @endif
  
    </tr>
  </table>







@if(company()['receiver_message'])
<table width="100%">
    <tr>
        <td style="font-size: 14px;">{!!company()['receiver_message']!!}</td>
    </tr>

    <tr>
        <td></td>
        <td></td>
    </tr>


</table>
@endif
<br>
<table width="100%">
    <tr>
        <td style="width: 70%;font-size: 14px;"></td>
        <td style="width: 40%;" class="st">@lang('layout.MohrAndSignature')</td>
    </tr>

    <tr>
        <td></td>
        <td></td>
    </tr>


</table>


@endsection