@extends('layouts.factor-master')

@section('content')
<h4 class="bold uppercase" style="text-align: center; font-size: 20px;">@lang('layout.ReceiveVouchar')(RV)</h4>

<table style="width: 100%; margin-bottom: 10px;">
  <tr>
    <td>
      <span style="font-size: 14px"> @lang('layout.ReceiveNumber'): </span>
      <span style="font-size: 14px"><b>{{$receive->rvNumber}}</b></span>
    </td>
    <td>
      <span style="font-size: 14px">@lang('layout.Date'): </span>
      <BDO DIR="LTR"> <span style="font-size: 14px">{{convertDate($receive->Date)}}</span> </BDO>
    </td>
    <td>
      <span style="font-size: 14px">@lang('layout.Hour'): </span>
      <BDO DIR="LTR"> <span style="font-size: 14px">
          <?php echo Date('h:i A' , strtotime($receive->DateTime)); ?>
        </span> </BDO>
    </td>

    <td>
      <span>@lang('layout.Payer'):</span>
      <span><b>{{$receive->member}}</b></span>
    </td>
    <td>
      <span style="font-size: 14px">@lang('layout.Code'):</span>
      <span style="font-size: 14px">{{$receive->code}}</span>
    </td>
  </tr>
</table>

<table class="main-table">
  <thead>
    <tr>
      <th> @lang('layout.Currency') </th>
      <th>@lang('layout.HesabSabiqa')</th>
      <th>@lang('layout.AlBagi')</th>
      <th>@lang('layout.Payable')</th>

    </tr>
  </thead>
  <tbody>
    @foreach(getStatement($receive->member_id) as $value )
    <tr>
      <td>
        {{$value['currency']}}
      </td>
      <td>
        <?php
                   $sabiqa = 0;
                   if ($value['currency'] == $receive->rec_currencty) {
                     if ($value['invoice'] > 0) {
                      if(systemConfig()[30] == 1){
                        $sabiqa = simpleRound(((double)$value['invoice'] + (((double)$receive->Amount/ $receive->static_rate * $receive->Rate)* $receive->static_rate)/ $receive->rec_rate));
                      }
                      else{
                        $sabiqa = simpleRound((double)$value['invoice'] + (((double)$receive->Amount/$receive->Rate)*$receive->rec_rate));
                      }
                      }elseif ($value['payment'] > 0) {
                        if(systemConfig()[30] == 1){
                        $sabiqa = simpleRound((double)$value['payment'] - ((((double)$receive->Amount/$receive->static_rate * $receive->Rate)* $receive->static_rate) / $receive->rec_rate));
                      }else {
                          $sabiqa = simpleRound((double)$value['payment'] - (((double)$receive->Amount/$receive->Rate)*$receive->rec_rate));
                        }
                      }else{
                        if(systemConfig()[30] == 1){
                        $sabiqa = simpleRound((((double)$receive->Amount/ $receive->static_rate * $receive->Rate)* $receive->static_rate) / $receive->rec_rate);
                      }else{
                          $sabiqa = simpleRound(((double)$receive->Amount/$receive->Rate)*$receive->rec_rate);
                        }
                      }
                   }
                   ?>
        {{$sabiqa}}
      </td>
      <td>
        {{$value['invoice']}}
      </td>
      <td>
        {{$value['payment']}}
      </td>
    </tr>
    @endforeach

  </tbody>
</table>

<br>

<table class="main-table">

  <tr>
    <td>
      <span>@lang('layout.Amount'):</span>
      <span><b>{{simpleRound($receive->Amount)}} {{$receive->currency}}</b></span>
      |
      <span>@lang('layout.Rate'):</span>
      <span>{{$receive->Rate}} </span>

      @if($receive->currency != $receive->rec_currencty)
      <br>
      <span>@lang('layout.Amount'):</span>
      @if(systemConfig()[30] == 1)
      <span><b>{{simpleRound(((((double)$receive->Amount/ $receive->static_rate * $receive->Rate))* $receive->static_rate)/ $receive->rec_rate)}}
        @else 
        <span><b>{{simpleRound(((double)$receive->Amount/$receive->Rate)*$receive->rec_rate)}}
      @endif
          {{$receive->rec_currencty}}</b></span>
      @endif
    </td>
    <td>
      <span>@lang('layout.Discount'):</span>
      <span>{{$receive->Discount}}{{$receive->currency}}</span>
    </td>
    <td>
      <span style="font-size: 14px">@lang('layout.ReceivedBy')/@lang('layout.Accountant'):</span>
      <span style="font-size: 14px"><b>{{$user}}</b></span>
    </td>

    <td>
      <span>@lang('layout.Address'):</span>
      <span>{{$receive->member_address}}</span>
    </td>
    <td>
      <span>@lang('layout.Details'):</span>
      <span>{{$receive->description}}</span>
    </td>

  </tr>

</table>

<table style=" width: 100%;font-size:14px;">

  <tr>
    <td style="width: 80%;font-size: 14px;">
      <span>
          @lang('layout.Address'): 
        {!!company()['country']!!},{!!company()['city']!!},{!!company()['streetAddress']!!}
      </span>
    </td>
    <td style="width: 20%;font-size: 14px;">@lang('layout.ReceiverSignature'):</td>
  </tr>
  <tr>
    <td>
      <span>
        @lang('layout.Phone'): {!!company()['phone']!!}
      </span>
    </td>
    <td></td>
  </tr>
</table>



@endsection