@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditReceive')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($receive, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['receive.updateBankCheckReceive',$receive->id]]) !!}
                <div class="form-body" v-cloak>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <v-select @input="getSummary" class="vue-select2" v-model="selectedMember"
                                              label="name"
                                              :options="{{ json_encode($member) }}" disabled>
                                    </v-select>
                                    <input type="hidden" name="member_id" v-model="selectedMember.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" step="any" min="0"
                                           value="{{$receive->receiveNumber}}" disabled> 
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" @input="checkRefNo()"
                                           v-model='ref_no' disabled>
                                    <span v-if="isError ==true" class="input-has-error"
                                          style="color: red">@{{msg}}</span>
                                </div>

                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type" v-model="selectedType">
                                        <option>@lang('layout.SelectType')</option>
                                        <option value="invoice">@lang('layout.Invoice')</option>
                                        <option value="bill">@lang('layout.Bill')</option>
                                        <option value="salary">@lang('layout.Salary')</option>
                                        <option value="loan">@lang('layout.Loan')</option>
                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                        <option value="Receive">@lang('layout.Receive')</option>
                                        <option value="project">@lang('layout.Project')</option>
                                        <option value="bankCheck">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                               
                            </div>
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.RecieveCurrency')</label>
                                        <select class="form-control" v-model="selectedCurrency"
                                                v-on:change="setSize(selectedCurrency.code)" :readonly="(old_payment_type=='bank_check' && payment_type=='')" disabled>
                                            <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()['code']}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate" class="form-control"
                                                       type="number" step="any" min="0" disabled>
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Account')</label>

                                    <div class="input-group">
                                        <select class="form-control" name="account_id" v-model="defaultAccount"
                                                v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                Account.name }}
                                            </option>
                                        </select>
                                        <!--  <span class="input-group-addon">@{{ Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount)) }}</span> -->

                                        <span class="input-group-addon" v-if="selectedBank">@{{ format_number( Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))) }}</span>
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                    <div :class="pcurrency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <select class="form-control" v-model="paymentCurrency"
                                                v-on:change="setPaymentSize(paymentCurrency.code)" disabled>
                                            <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="paymentCurrency"
                                               v-bind:value="paymentCurrency.code"/>
                                    </div>
                                    <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate1" class="form-control"
                                                       type="number" min="0" step="any"
                                                       disabled>
                                                <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="rate" :value="selected_rate1">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    <div class="input-group">

                                        <input type="hidden" v-model="amount" class="form-control"
                                               type="number" min="0" step="any" name="amount" v-validate="'required'"
                                               data-vv-as="@lang('layout.Amount')">
                                        <br>
                                        @{{amount}}
                                        <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                    </div>
                                    <span class="required">@{{ errors.first('amount') }}</span>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6" style="padding:0px;">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        <div class="input-group">
                                            <input type="number"
                                                   :value="checkExchange"
                                                   class="form-control" min="0" step="any" readonly>
                                            <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>

                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Discount')</label>
                                        <input type="number" v-model="discount" name="discount" class="form-control" readonly>
                                    </div>

                                </div>
                                <div class="col-md-6">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        {{Form::text('date',$receive->Date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}

                                    </div>
                                </div>


                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.PaymentType')</label>
                                    <select class="form-control" name="payment_type" v-model="payment_type" disabled>
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="bank_check">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                                <div class="col-md-3" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckNumber')</label>
                                    <input type="text" name="check_number" value="{{$receive->check_number}}"
                                           class="form-control" placeholder="00020" disabled>
                                </div>
                                <div class="col-md-6" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckDate')</label>
                                    <input type="text" name="check_date" value="{{$receive->check_date}}"
                                           class="form-control date" autocomplete="off"
                                           placeholder="@lang('layout.CheckDate')" disabled>
                                </div>
                                <?php
                                $r_description = $receive->description;
                                $d_discription = '(مبلغ ' . $receive->discount . 'تخفیف)';
                                // dd($r_description);
                                // dd(strlen($d_discription));
                                //dd(substr($r_description,0, -strlen($d_discription)));
                                // dd(substr($r_description, strpos($r_description,$d_discription )));

                                if (substr($r_description, strpos($r_description, $d_discription)) == $d_discription) {
                                    $description = (substr($r_description, 0, -strlen($d_discription)));
                                } else {
                                    $description = $r_description;
                                }
                                ?>

                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('description',$description,['class'=>'form-control','rows'=>'4'])}}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="panel panel-default"
                                 style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                <div class="panel-body">
                                    <table class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Currency') </th>
                                            <th>@lang('layout.Payable')</th>
                                            <th>@lang('layout.Receivable')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                                <span v-if="selectedMember">
                                                   <tr v-for="summ in summary">
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                      <td>
                                                          @{{ format_number(Number(summ.invoice)) }}
                                                      </td>
                                                    </tr>
                                                </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-10">
                    <div class="row">
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <button v-if="isError ==false" type="button" class="btn green"
                                    @click="handleSubmit($event)">@lang('layout.Submit')</button>
                            <a href="{{route('receive.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        
        Vue.component('v-select', VueSelect.VueSelect)
        var Banks ={!! $bank!!}
        var Currency ={!! $currency!!}
        var Currency1 ={!! $currency!!}
        var project_id = {!!$receive->project_id!!};
        var one ={!! json_encode(Currency()->getCurrency()) !!}
        var two ={!! json_encode(Currency()->getCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";
        let vu = new Vue({
            el: '#app',
            data: {
                selectedCurrency: one,
                selectedCurrencyTemp: null,
                paymentCurrency: two,
                summary: [],
                selectedCurrency2: null,
                currency:{!! json_encode(getCurrencies()) !!},
                currency1:{!! json_encode(getCurrencies()) !!},

                project_id: project_id,
                bankes: {!! $banks !!},
                selectedBank: null,
                selected_rate:{!!$receive->payRate!!},
                selected_rate1:{!!$receive->Excurrency!!},
                defaultAccount: "{{ $receive->Account_id }}",
                listAccounts: [],
                selectedMember:null,
                newAmount: null,
                amount:{!!$receive->amount!!},
                Examount:{!!$receive->Examount!!},
                discount:{!!$receive->discount!!},
                selectedProject: null,
                project_list: [],
                currencyList: Currency,
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                selectedType: "{!! $receive->type !!}",
                defaultValue: 0,
                defaultAmount:{!!$receive->amount!!},
                firstAccount: "{{ $receive->Account_id }}",
                ref_no: "{{$receive->ref_Number}}",
                msg: '',
                isError: false,
                payment_type: "{{$receive->payment_type}}",
                receive:{!! $receive !!},
                member:{!! $member !!},
                old_payment_type:"{{$receive->payment_type}}",
                checkExchange: null,

            },
            mounted: function (){
                

                @if(systemConfig()[30] == 1)
                // this.checkExchagePayment = ((this.amount-this.discount)*this.selected_rate1/(this.selected_rate)).toFixed(3);
                this.checkExchange = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
                @else 
                this.checkExchange = (this.amount*this.selected_rate1/(this.selected_rate)).toFixed(2);
                @endif
            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })

                    this.defaultValue = test[0].id;

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.firstAccount != -1) {
                                if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.firstAccount;
                                    this.firstAccount = -1;
                                    break;
                                }
                            }
                            else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                break;
                            }
                        }

                    }

                    return test;
                },

            },
            created() {
                this.checkSelected();
                if(this.receive)
                {
                    this.selectedMember=_.find(this.member,(v)=>v.id==this.receive.member_id);
                }
                defaultValue = "{{ $receive->Account_id }}";
            },
            methods: {
                checkRefNo() {

                    //console.log(vm.ref_no)

                    var chack = 'false';
                    var ref_no = vu.ref_no;
                    if (ref_no != null) {


                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    ref_no: vu.ref_no,
                                    method_name: 'Search_ref_no',
                                    table_name: 'loans'
                                },
                            })
                            .then(function (response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    vu.msg = "@lang('layout.DuplicateData')";
                                    vu.isError = true;
                                }
                                else {
                                    vu.msg = 'no';
                                    vu.isError = false;

                                }


                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }

                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                getSummary() {
                    if (this.selectedMember) {

                        this.project_list = [];
                        this.selectedProject = null;
                        this.getSummaryRecor(this.selectedMember.id, this);
                        this.take_project_data(this);

                    }

                },
                take_project_data(vm) {

                    axios.get("{{route('member.project')}}", {
                        params: {
                            member_id: this.selectedMember.id
                        },
                    }).then(function (response) {
                        vm.project_list = response.data;
                        // console.log('llll',vm.project_list);

                        for (var j = 0; j < vm.project_list.length; j++) {
                            if (this.project_id != null && vm.project_list[j].id == this.project_id) {
                                vm.selectedProject = vm.project_list[j];
                                // console.log('ppppsss',vm.selectedProject);
                            }
                        }


                    })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                getSummaryRecor(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },

                checkSelected() {
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for (var x in allCarrencies) {
                        for (z in allCarrencies[x]) {
                            if (allCarrencies[x][z] == "{!! $receive->runit !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.currency_len = 'col-md-6';
                                    this.rate_len = 'col-md-6';
                                }
                                this.selectedCurrency = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }
                            if (allCarrencies[x][z] == "{!! $receive->currency !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.pcurrency_len = 'col-md-6';
                                    this.prate_len = 'col-md-6';
                                }
                                this.paymentCurrency = allCarrencies[x];
                                // this.selected_rate1   = this.paymentCurrency.exchange_rate;

                            }
                        }
                    }

                },
                setSize(selected_code) {
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    this.selected_rate = selectedCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
                },
                setPaymentSize(selected_code) {
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },
                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selected_rate;
                    }

                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                break;
                            }
                        }
                    }
                },
            }
        });
    </script>


@endpush
 