@extends('layouts.app')
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('content')
@include("layouts.Cmodal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    @if($duplicate)
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewReceive')</span>
                    @else 
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditReceive')</span>
                    @endif
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                @if($duplicate)
                {!! Form::model($receive, ['method' => 'post','class'=>'form-horizontal','route' => ['receive.storeNew',$receive->id]]) !!}
                @else
                {!! Form::model($receive, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['receive.update',$receive->id]]) !!}
                @endif
                <div class="form-body" v-cloak>
                    <div class="row" style="margin-bottom: 0px; padding: 10px;">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;">
                            <div class="row" style="padding: 0px 10px;">
                                <div v-show="showWhat('member_class')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="">
                                        <label class="control-label">@lang('layout.MemberClass') </label>
                                        <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                        <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <div class="input-group">
                                            <v-select @input="getSummary" class="vue-select2" v-model="selectedMember"
                                            @search="MemberSearch" label="name" :options="member">
                                            </v-select>
                                            <input type="hidden" name="member_id" v-model="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                            <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                <i class="fa fa-plus" style="color: white"></i>
                                            </span>
                                        </div>
                                        <span class="required">@{{ errors.first('member_id') }}</span>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input class="form-control date" id="range-from-example" name="date" autocomplete="off" value="{{$receive->Date}}"
                                        @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                        <span class="required">@{{ errors.first('date') }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-md-4">
                                    <div class="">
                                        <label class="control-label">@lang('layout.Hour')</label>
                                        <div class="input-group">
                                            @if(getHourType() == 24)
                                            <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$receive->hour}}">
                                            @else
                                            <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$receive->hour}}" >
                                            @endif
                                            <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type" v-model="selectedType">
                                        <option>@lang('layout.SelectType')</option>
                                        <option value="invoice">@lang('layout.Invoice')</option>
                                        <option value="bill">@lang('layout.Bill')</option>
                                        <option value="salary">@lang('layout.Salary')</option>
                                        <option value="loan">@lang('layout.Loan')</option>
                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                        <option value="Receive">@lang('layout.Receive')</option>
                                        <option value="project">@lang('layout.Project')</option>
                                        <option value="bankCheck">@lang('layout.BankCheck')</option>
                                        <option value="branchTransfer">@lang('layout.BranchTransfer')</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.PaymentType')</label>
                                    <select class="form-control" name="payment_type" v-model="payment_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="bank_check">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-md-6" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckNumber')</label>
                                    <input type="text" name="check_number" value="{{$receive->check_number}}" class="form-control" placeholder="00020">
                                </div>
                                <div class="col-md-6" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckDate')</label>
                                    <input type="text" name="check_date" value="{{$receive->check_date}}" class="form-control date" autocomplete="off" placeholder="@lang('layout.CheckDate')">
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                {{-- <div class="col-md-3" style="padding: 0px !important;"> --}}
                                    <div class="col-md-2" style="padding: 0px !important;">
                                        <div :class="pcurrency_len" style="width: 100%;">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <select class="form-control" v-model="paymentCurrency"
                                                    v-on:change="setPaymentSize(paymentCurrency.code), get_exchange()" :readonly="(old_payment_type=='bank_check' && payment_type=='')">
                                                <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="paymentCurrency"
                                                   v-bind:value="paymentCurrency.code"/>
                                        </div>
                                        <div :class="prate_len" style="width: 100%;" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                                <div class="input-group">
                                                    <input v-model="selected_rate1" class="form-control"
                                                           type="number" min="0" step="any" @input="get_exchange()"
                                                           :readonly="selectedCurrency.code==paymentCurrency.code">
                                                    <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="rate" :value="selected_rate1">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        <div class="input-group">
                                            <vue-numeric
                                                :readonly="(old_payment_type=='bank_check' && payment_type=='')"
                                                class="form-control"
                                                v-model="amount"
                                                :max="99999999999999"
                                                :currency="selectedCurrency.code"
                                                :precision="precision()"
                                                @input="get_exchange()"
                                                >
                                            </vue-numeric>
                                            <input v-model="amount" class="form-control" type="hidden" min="0" step="any" name="amount" v-validate="'required'" data-vv-as="@lang('layout.Amount')" >
                                            <span class="input-group-addon" style="color: white;background: rgb(80, 129, 141);">@{{selectedCurrency.symbol}}</span>
                                        </div>
                                        <span class="required">@{{ errors.first('amount') }}</span>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <div class="input-group">
                                            <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                    Account.name }}
                                                </option>
                                            </select>
                                            <!--  <span class="input-group-addon">@{{ Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount)) }}</span> -->
                                            <span class="input-group-addon" style="color: white;" v-if="selectedBank">@{{ (selectedBank)?format_number( Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount)+Number(first_discount)-Number(discount))):0 }}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-4" style="padding: 0px !important;">
                                        <div :class="currency_len" style="width: 50%;">
                                            <label class="control-label">@lang('layout.RecieveCurrency')</label>
                                            <select class="form-control" style="width: 100%;" v-model="selectedCurrency" v-on:change="setSize(selectedCurrency.code), get_exchange()" :readonly="(old_payment_type=='bank_check' && payment_type=='')">
                                                <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                        </div>
                                        <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input v-model="selected_rate" class="form-control" @input="check_code(paymentCurrency.code) , get_exchange()"
                                                           type="number" step="any" min="0">
                                                    <span class="input-group-addon" style="color: white; background: rgb(80, 129, 141);">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="currency_rate" :value="selected_rate">
                                            </div>
                                        </div> 
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        <div class="input-group">
                                            <vue-numeric
                                                :readonly="(old_payment_type=='bank_check' && payment_type=='')"
                                                class="form-control"
                                                v-model="exchange_amount"
                                                :max="99999999999999"
                                                currency=""
                                                :precision="precision()"
                                                @input="set_rate()"
                                                >
                                            </vue-numeric>
											<input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(4)" >
                                            <span class="input-group-addon" style="color: white; background: rgb(80, 129, 141);">@{{paymentCurrency.symbol}}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.Discount')</label>
                                        <input type="number" v-model="discount" name="discount" class="form-control">
                                    </div>
                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                        <div class="">
                                            <div class="">
                                                <label class="control-label">@lang('layout.OverdueDate')</label>
                                                {{Form::text('overdue_date',$receive->overdue_date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    </div>
                                {{-- </div> --}}
                                <div class="col-md-4" style="padding: 0px !important;">
                                    @if($duplicate)
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" name="number" class="form-control" step="any" min="0" value="{{$numberDuplicate}}">
                                    </div>
                                    @else
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" name="number" class="form-control" step="any" min="0" value="{{$receive->receiveNumber}}">
                                    </div>
                                    @endif
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" name="ref_no" class="form-control" @input="checkRefNo()" v-model='ref_no'>
                                        <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                @if(systemConfig()[5] != 0 )
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.Project')</label>
                                        <v-select class="vue-select2" label="name"
                                            :options="project_list" v-model="selectedProject">
                                        </v-select>
                                        <input type="hidden" name="project_id"
                                            v-model.number="(!selectedProject)?null:selectedProject.id">
                                    </div>
                                @endif
                                @if(systemConfig()[7] != 0 )
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('menu.ToRentVehicle')</label>
                                        <v-select class="vue-select2" label="name" :options="vehicle_rent_list" v-model="selectedVehicleRent"></v-select>
                                        <input type="hidden" name="vehicle_rent_id" v-model.number="(!selectedVehicleRent)?null:selectedVehicleRent.id">
                                    </div>
                                @endif
                                @if(systemConfig()[16] != 0)
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.FarmerContract')</label>
                                        <v-select class="vue-select2" label="name" :options="farmer_contract_list" v-model="selectedFarmerContract"></v-select>
                                        <input type="hidden" name="contract_farmer_id" v-model.number="(!selectedFarmerContract)?null:selectedFarmerContract.id">
                                    </div>
                                @endif
                                @if(systemConfig()[20] == 1)
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.ContractName')</label>
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                v-model="selectedContract" label="company_name"
                                                :options="{{$contract}}"> 
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                @endif 
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <?php
                                $r_description = $receive->description;
                                $d_discription = '(مبلغ ' . $receive->discount . 'تخفیف)';
                                // dd($r_description);
                                // dd(strlen($d_discription));
                                //dd(substr($r_description,0, -strlen($d_discription)));
                                // dd(substr($r_description, strpos($r_description,$d_discription )));
                                if (substr($r_description, strpos($r_description, $d_discription)) == $d_discription) {
                                    $description = (substr($r_description, 0, -strlen($d_discription)));
                                } else {
                                    $description = $r_description;
                                }
                                ?>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('description',$description,['class'=>'form-control','rows'=>'1'])}}
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Memo')</label>
                                            <textarea name="memo" class="form-control" rows="1">{{$receive->memo}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="panel panel-default" style="margin-top: 15px;border: none;">
                               <div class="panel-body">
                                   <table class="table table-bordered">
                                       <thead>
                                       <tr>
                                           <th>@lang('layout.Currency') </th>
                                           <th>@lang('layout.Payable')</th>
                                           <th>@lang('layout.Receivable')</th>
                                           <th>@lang('layout.AverageRate')</th>
                                       </tr>
                                       </thead>
                                       <tbody>
                                               <span v-if="selectedMember">
                                                  <tr v-for="summ in summary">
                                                     <td class="highlight text-center">
                                                        @{{ summ.currency }}
                                                     </td>
                                                     <td class="text-center"> 
                                                        @{{ format_number(Number(summ.payment)) }}
                                                    </td>
                                                    <td class="text-center">
                                                        @{{ format_number(Number(summ.invoice)) }}
                                                    </td>
                                                    <td class="text-center">
                                                        @{{format_number(Number(summ.rate))}}
                                                    </td>
                                                   </tr>
                                               </span>
                                       </tbody>
                                   </table>
                               </div>
                           </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                            <button v-if="isError ==false" type="button" class="btn green"
                                    @click="handleSubmit($event)">@lang('layout.Submit')</button>
                            <a href="{{route('receive.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                        <cmodal :show='showModal' @close="showModal=false">

                        </cmodal>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);
        //begin new member
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            mounted() {
                setTimeout(() => {
                    this.getMemberCode();
                }, 500);
               
            },
            methods: {
                onSubmit() {
                    vu.showModal = false;
                    var datas = $("#modalForm").serializeArray();
                    let vmc = this;
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': "{{csrf_token()}}"
                        },
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            "code": datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function(response) {
                        if (response) {
                            vu.selectedMember = response.customer;
                            vmc.getMemberCode();
                        }

                    }).fail(function(error) {
                        console.log('error', error);
                    });
                },
                getMemberCode() {
                    let vmc = this;
                    axios.get('{{route("customer.create")}}').then(
                    response => {
                        vmc.types = response.data.types;
                        if (vmc.types) {
                            for (var i = 0; i < vmc.types.length; i++) {
                                if (vmc.types[i].type == "Customer") {
                                    vmc.selectType = vmc.types[i];
                                }
                            }
                        }
                        vmc.receivables = response.data.receivable;
                        vmc.payables = response.data.payable;
                        vmc.code = response.data.code;
                        vmc.classes = response.data.member_class;
                        if(vmc.receivables.length>0)
                        {
                            vmc.selectReceive=vmc.receivables[0];
                        }
                        if(vmc.payables.length>0)
                        {
                            vmc.selectPay=vmc.payables[0];
                        }

                    }).catch(error => console.log(error));
                }
            }
        });
        var Banks ={!! $bank!!}
        var Currency ={!! $currency!!}
        var Currency1 ={!! $currency!!}
        var project_id = {!!$receive->project_id!!};
        var vehicle_m_id       = {!!$receive->vehicle_m_id!!};
        var contract_farmer_id = {!!$receive->contract_farmer_id!!};
        var one ={!! json_encode(Currency()->getCurrency()) !!}
        var two ={!! json_encode(Currency()->getCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";
        var memberClass = {!! $memberClass !!};
        var contract = {!! $contract !!};
        let vu = new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedCurrency: one,
                selectedCurrencyTemp: null,
                paymentCurrency: two,
                summary: [], 
                selectedCurrency2: null,
                currency:{!! json_encode(getCurrencies()) !!},
                currency1:{!! json_encode(getCurrencies()) !!},

                project_id: project_id,
                vehicle_m_id: vehicle_m_id,
                bankes: {!! $banks !!},
                selectedBank: null,
                selected_rate:{!!$receive->payRate!!},
                selected_rate1:{!!$receive->Excurrency!!},
                defaultAccount: "{{ $receive->Account_id }}",
                listAccounts: [],
                member: [],
                selectedMember:{!!$selectedMember!!},
                newAmount: null,
                amount:{!!$receive->amount!!},
                Examount:{!!$receive->Examount!!},
                discount:{!!$receive->discount!!},
                first_discount:{!!$receive->discount!!},
                selectedProject: null,
                exchange_amount: null,
                project_list: [],
				selectedVehicleRent: null,
                vehicle_rent_list: [],
                currencyList: Currency,
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                selectedType: "{!! $receive->type !!}",
                defaultValue: 0,
                defaultAmount:{!!$receive->amount!!},
                firstAccount: "{{ $receive->Account_id }}",
                ref_no: "@if($duplicate) {{$refNum}} @else {{$receive->ref_Number}} @endif",
                msg: '',
                isError: false,
                payment_type: "{{$receive->payment_type}}",
                receive:{!! $receive !!},
                old_payment_type:"{{$receive->payment_type}}",
                memberClass: memberClass,
                selected_class: null,
                farmer_contract_list:[],
                selectedFarmerContract:null,
                contract_farmer_id: contract_farmer_id,
                contract: contract,
                selectedContract: null,

            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0) {
                    this.defaultValue = test[0].id;

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.firstAccount != -1) {
                                if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.firstAccount;
                                    this.firstAccount = -1;
                                    break;
                                }
                            }
                            else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                break;
                            }
                        }

                    }
                    }else{
                        this.selectedBank = null;
                    }

                    return test;
                },

            },
            created() {
                this.checkSelected();
                if(this.receive)
                {
                    // this.selectedMember=_.find(this.member,(v)=>v.id==this.receive.member_id);
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.receive.class_id);
                }
                defaultValue = "{{ $receive->Account_id }}";
				
				if(this.selected_rate > 0){
						// this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate);
                        @if(systemConfig()[30] == 1)
                        this.exchange_amount = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
                        @else 
                            this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate);
                        @endif
					}
                @if($receive->contract_id != null)    
                this.selectedContract = _.find(this.contract, (e) => e.id == {{$receive->contract_id}});
                @endif
            },
            methods: {
                memberClassChange() {
                    if (vu.selected_class) {
                        vu.member = [];
                        // vu.selectedMember = null;
                        let class_id = vu.selected_class.id;
                    
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember',
                                class_id: class_id
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                vu.member = [];
                                vu.member = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                    }
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.member = [];
                            vu.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                checkRefNo() {

                    //console.log(vu.ref_no)

                    var chack = 'false';
                    var ref_no = vu.ref_no;
                    if (ref_no != null) {


                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    ref_no: vu.ref_no,
                                    method_name: 'Search_ref_no',
                                    table_name: 'loans'
                                },
                            })
                            .then(function (response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    vu.msg = "@lang('layout.DuplicateData')";
                                    vu.isError = true;
                                }
                                else {
                                    vu.msg = 'no';
                                    vu.isError = false;

                                }


                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }

                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                getSummary() {
                    if (this.selectedMember) {

                        this.project_list = [];
                        this.selectedProject = null;
						this.vehicle_rent_list = [];
                        this.selectedVehicleRent = null;
                        this.farmer_contract_list = [];
                        this.selectedFarmerContract = null;
                        this.getSummaryRecor(this.selectedMember.id, this);
                        this.take_project_data(this);
                        this.take_vehicle_rent_data(this);
                        this.take_farmer_contract_data(this);

                    }

                },
				// get_exchange() {
                //     let vu = this;
				// 	if(vu.selected_rate > 0){
				// 		vu.exchange_amount = myRound((vu.amount* vu.selected_rate1)/vu.selected_rate);
				// 	}
				// },
				// set_rate() {
                //     let vu = this;
				// 	if(vu.exchange_amount > 0){
				// 		vu.selected_rate1 = Number.parseFloat((vu.exchange_amount)/ (vu.amount / vu.selected_rate)).toFixed(10);
				// 	}
				// },
 
                get_exchange() {
                    let vu = this;
					if(vu.selected_rate > 0){ 
                        @if(systemConfig()[30] == 1)
                        if (vu.paymentCurrency && vu.selectedCurrency) { 
                            vu.exchange_amount = myRound(((vu.amount / vu.selectedCurrency.static_rate * vu.selected_rate) * vu.paymentCurrency.static_rate) / vu.selected_rate1);
                        }
                        @else 
                            vu.exchange_amount = myRound((vu.amount * vu.selected_rate1) / vu.selected_rate);
                        @endif 
                    }
				},
				set_rate() {
                    let vu = this;
					if(vu.exchange_amount > 0){
                        @if(systemConfig()[30] == 1)
                        vu.selected_rate1 = Number.parseFloat(((vu.amount / vu.selectedCurrency.static_rate * vu.selected_rate) / vu.exchange_amount) * vu.paymentCurrency.static_rate).toFixed(7);
                        @else 
						vu.selected_rate1 = Number.parseFloat((vu.exchange_amount)/ (vu.amount / vu.selected_rate)).toFixed(10);
                        @endif					
                    }
				},


                take_farmer_contract_data(vm) {

                    axios.get("{{route('member.farmerContract')}}", {
                        params: {
                            member_id: this.selectedMember.id
                        },
                    }).then(function (response) {
                        vm.farmer_contract_list = response.data;

                        for (var j = 0; j < vm.farmer_contract_list.length; j++) {
                            if (this.contract_farmer_id != null && vm.farmer_contract_list[j].id == this.contract_farmer_id) {
                                vm.selectedFarmerContract = vm.farmer_contract_list[j];
                                // console.log('ppppsss',vm.selectedProject);
                            }
                        }

                    })
                        .catch(function (error) {
                            console.log(error);
                        });
                    },  


                take_project_data(vm) {
                        // console.log('llll',vm);

                    axios.get("{{route('member.project')}}", {
                        params: {
                            member_id: this.selectedMember.id
                        },
                    }).then(function (response) {
                        vm.project_list = response.data;

                        for (var j = 0; j < vm.project_list.length; j++) {
                            if (this.project_id != null && vm.project_list[j].id == this.project_id) {
                                vm.selectedProject = vm.project_list[j];
                                // console.log('ppppsss',vm.selectedProject);
                            }
                        }

                    })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
				take_vehicle_rent_data(vm) {
                            // console.log('ve',this.selectedMember.id, this.vehicle_m_id);

                    axios.get("{{route('member.vehicleRent')}}", {
                        params: {
                            member_id: this.selectedMember.id
                        },
                    }).then(function (response) {
                        vm.vehicle_rent_list = response.data;
						
                        for (var j = 0; j < vm.vehicle_rent_list.length; j++) {
                            if (this.vehicle_m_id != null && vm.vehicle_rent_list[j].id == this.vehicle_m_id) {
                                vm.selectedVehicleRent = vm.vehicle_rent_list[j];
                                // console.log('ppppsss',vm.selectedVehicleRent);
                            }
                        }
						
                    })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                getSummaryRecor(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            }
                             else{
                                vm.summary=[];
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },

                checkSelected() {
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for (var x in allCarrencies) {
                        for (z in allCarrencies[x]) {
                            if (allCarrencies[x][z] == "{!! $receive->runit !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.currency_len = 'col-md-6';
                                    this.rate_len = 'col-md-6';
                                }
                                this.selectedCurrency = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }
                            if (allCarrencies[x][z] == "{!! $receive->currency !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.pcurrency_len = 'col-md-6';
                                    this.prate_len = 'col-md-6';
                                }
                                this.paymentCurrency = allCarrencies[x];
                                // this.selected_rate1   = this.paymentCurrency.exchange_rate;

                            }
                        }
                    }

                },
                setSize(selected_code) {
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    this.selected_rate = this.selectedCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
                },
                setPaymentSize(selected_code) {
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },
                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selected_rate;
                    }

                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                break;
                            }
                        }
                    }
                },
            }
        });
    </script>


@endpush
 