@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewReceive') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM--> 
                {{Form::open(['route' => 'receive.store','method' => 'POST','class' => 'form-horizontal','id'=>'receive-submit'])}}
                <div class="form-body" v-cloak>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                      <div v-show="showWhat('member_class')=='yes'"
                                     class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                            <label class="control-label">@lang('layout.MemberClass') </label>

                                            <v-select label="name" :options="memberClass"
                                                      v-model="selected_class"
                                                      @input="memberClassChange()"></v-select>
                                            <input type="hidden" name="class_id"
                                                   :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                            </div>
                            <div class="row">

                             


                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <v-select @input="getSummary" class="vue-select2" v-model="selectedMember"
                                              label="name"
                                              :options="member">
                                    </v-select>
                                    <input type="hidden" name="member_id"
                                           v-model.number="(!selectedMember)?null:selectedMember.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>

                                <!-- :class="employess.length>0 ? 'btn btn-info' : 'btn btn-primary'" -->
                                <!-- :class="showWhat('member_class')=='yes'?'col-md-4':'col-md-2'" -->
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" step="any" min="0" @input="checkNo()"
                                           v-validate="'required'" data-vv-as="@lang('layout.Number')" v-model="number">
                                    <span class="required">@{{ errors.first('number') }}</span>
                                    <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" @input="checkRefNo()"
                                           v-model='ref_no'>
                                    <span v-if="isError ==true" class="input-has-error"
                                          style="color: red">@{{msg}}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type">
                                        <option disabled>@lang('layout.SelectType')</option>
                                        <option value="invoice">@lang('layout.Invoice')</option>
                                        <option value="bill">@lang('layout.Bill')</option>
                                        <option value="salary">@lang('layout.Salary')</option>
                                        <option value="loan">@lang('layout.Loan')</option>
                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                        @if(systemConfig()[5] != 0 )
                                            <option value="project">@lang('layout.Project')</option>
                                        @endif
                                        <option value="bankCheck">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                            </div>

                                <div class="row">
                                @if(systemConfig()[5] != 0 )

                                        <div class="col-md-4">
                                            <label class="control-label">@lang('layout.Project')</label>
                                            <v-select class="vue-select2" label="name"
                                                      :options="project_list" v-model="selectedProject">
                                            </v-select>
                                            <input type="hidden" name="project_id"
                                                   v-model.number="(!selectedProject)?null:selectedProject.id">
                                        </div>
                                @endif
                                @if(systemConfig()[7] != 0 )
                                        <div class="col-md-4">
                                            <label class="control-label">@lang('menu.ToRentVehicle')</label>
                                            <v-select class="vue-select2" label="name"
                                                      :options="vehicle_rent_list" v-model="selectedVehicleRent">
                                            </v-select>
                                            <input type="hidden" name="vehicle_rent_id"
                                                   v-model.number="(!selectedVehicleRent)?null:selectedVehicleRent.id">
                                        </div>
                                @endif
                                </div>


                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.RecieveCurrency')</label>
                                        <select class="form-control" v-model="selectedCurrency"
                                                v-on:change="setSize(selectedCurrency.code), get_exchange()">
                                            <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate" class="form-control"
                                                       type="number" step="any" min="0"
                                                       @keyup="check_code(paymentCurrency.code), get_exchange()">
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <div class="input-group">
                                        <select class="form-control" name="account_id" v-model="defaultAccount"
                                                v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                Account.name }}
                                            </option>
                                        </select>
                                        <!--  <span class="input-group-addon">@{{ Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount)) }}</span> -->

                                        <span class="input-group-addon">@{{ format_number( Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount)-Number(discount))) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                    <div :class="pcurrency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <select class="form-control" v-model="paymentCurrency"
                                                v-on:change="setPaymentSize(paymentCurrency.code), get_exchange()">
                                            <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                        </select>
                                        <input type="hidden" name="paymentCurrency"
                                               v-bind:value="paymentCurrency.code"/>
                                    </div>
                                    <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                            <div class="input-group">
                                                <input v-model="selected_rate1" class="form-control"
                                                       type="number" min="0" step="any" @input="get_exchange()"
                                                       :readonly="selectedCurrency.code==paymentCurrency.code">
                                                <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            </div>
                                            <input type="hidden" name="rate" :value="selected_rate1">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    <div class="input-group">
                                        <input type="number" name="amount" class="form-control" v-model="amount"
                                               step="any" min="0" v-validate="'required'"  @input="get_exchange()"
                                               data-vv-as="@lang('layout.Amount')">
                                        <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                    </div>
                                    <span class="required">@{{ errors.first('amount') }}</span>
                                </div>


                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <div class="input-group">
										<input type="number" v-model="exchange_amount" @input="set_rate()"
                                               class="form-control" min="0" step="any">
                                        <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(4)" >
										
                                        <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>

                                    </div>

                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Discount')</label>
                                    <input type="number" step="any" v-model="discount" class="form-control"
                                           name="discount">
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Date') </label>
                                    <div>
                                        <input class="form-control date" id="range-from-example" name="date"
                                               autocomplete="off">
                                    </div>
                                </div>


                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.PaymentType')</label>
                                    <select class="form-control" name="payment_type" v-model="payment_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="bank_check">@lang('layout.BankCheck')</option>
                                    </select>
                                </div>
                                <div class="col-md-3" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckNumber')</label>
                                    <input type="text" name="check_number" class="form-control" placeholder="00020">
                                </div>
                                <div class="col-md-6" v-show="payment_type !=''">
                                    <label class="control-label">@lang('layout.CheckDate')</label>
                                    <input type="text" name="check_date" class="form-control date" autocomplete="off"
                                           placeholder="@lang('layout.CheckDate')">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {{Form::textarea('description',null,['class'=>'form-control','rows'=>'3'])}}
                                </div>
                            </div>
                            <div class="row">
                            @if(getWhatsApp() =='true')                 
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox"  name="whatsapp" value="2" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="panel panel-default"
                                 style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                <div class="panel-body">
                                    <table class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Currency') </th>
                                            <th>@lang('layout.Payable')</th>
                                            <th>@lang('layout.Receivable')</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                               <span v-if="selectedMember">
                                               <tr v-for="summ in summary">
                                                  <td class="highlight">
                                                     @{{ summ.currency }}
                                                  </td>
                                                  <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                  <td>
                                                      @{{format_number(Number(summ.invoice)) }}
                                                  </td>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-10">
                    <div class="row">
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <button v-if="((isError == false) && (number_Error == false))" type="button" @click="handleSubmit($event)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <button v-if="((isError == false) && (number_Error == false))" type="button" class="btn blue"
                            :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                            <a href="{{route('receive.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>

        <!-- <input type="text" id="f2" name=""> -->

    </div>
@endsection
@push('scripts')

    <script>

        // var input = document.getElementById('f2');
        // input.addEventListener('keyup', function (e) {
        // input.value = format_number(this.value);
        // });


        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);
        var Banks ={!! $bank!!}
        var Member ={!!$member!!}
        var Currency ={!! $currency!!}
        var Currency1 ={!! $currency!!}
        var one = defaultCurrency();
        var two ={!! json_encode(Currency()->getCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";

        var memberClass = {!! $memberClass !!};


        var vm = new Vue({
            el: '#app',
            data: {
                selectedCurrency: one,
                selectedCurrencyTemp: null,
                paymentCurrency: two,
                selectedCurrency2: null,
                currency:{!! json_encode(getCurrencies()) !!},
                currency1:{!! json_encode(getCurrencies()) !!},

                bankes: {!! $banks !!},
                number: "{{$number}}",
                old_number: "{{$number}}",
                number_msg: '',
                number_Error: false,
                disabled: false,
                selectedBank: null,
                defuilt_banks: null,
                selectedProject: null,
                project_list: [],
                selectedVehicleRent: null,
                vehicle_rent_list: [],
                defaultValue: 0,
                summary: [],
                defaultAmount: 0,
                defaultAccount: 0,
                discount: 0,
                selected_rate: 0,
                selected_rate1: 0,
                listAccounts: [],
                selectedMember: null,
                newAmount: null,
                amount: null,
                exchange_amount: null,
                currencyList: Currency,
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                lastAmount: null,
                ref_no: '',
                msg: '',
                isError: false,
                payment_type: '',
                memberClass: memberClass,
                selected_class: null,
                member: Member,
                all_member: Member

            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    
                    if (this.defuilt_banks) {
                        this.defaultValue = this.defuilt_banks.id;
                        this.defuilt_banks = null;
                    }else{
                        if (test.length > 0) {
                        this.defaultValue = test[0].id;
                        }
                    }

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue) {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                break;
                            }
                        }

                    }
                    return test;
                },
            },
            mounted: function () {
                var selected_banks=_.find(this.bankes,(v)=>v.id=={!! getDropdown('receive', 'bank') !!});
                if(selected_banks){
                    this.defaultAccount = selected_banks.id;
                    var selected_currency=_.find(this.currency,(v)=>v.code==selected_banks.code);
                    // currency
                    this.selectedCurrency = selected_currency;
                    this.defuilt_banks = selected_banks;
                    this.setSize(selected_currency.code)
                }

                // console.log(123, selected_banks, selected_currency);
            },
            methods: {
                memberClassChange() {
                    vm.member = vm.all_member;
                    console.log(vm.all_member);
                    if (vm.selected_class) {
                        console.log('test22', vm.selected_class);
                        vm.member = vm.all_member.filter((m) => {
                            return vm.selected_class.id == m.class_id;
                        });
                    }
                },
                checkNo() {
                    var chack = 'false';
                    var number = vm.number;
                    if (number != null) {
                        axios.get("{{route('callMethod.search')}}", {

                                params: {
                                    number: vm.number,
                                    method_name: 'Search_number',
                                    table_name: 'receivable_payments'
                                },
                            })
                            .then(function(response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    // console.log(response.data.result);
                                    // vm.temp_items=response.data;
                                    vm.number_msg = "@lang('layout.DuplicateData')";
                                    vm.number_Error = true;
                                } else {
                                    vm.number_msg = 'no';
                                    vm.number_Error = false;

                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });

                    }
                },
                checkRefNo() {

                    //console.log(vm.ref_no)

                    var chack = 'false';
                    var ref_no = vm.ref_no;
                    if (ref_no != null) {


                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    ref_no: vm.ref_no,
                                    method_name: 'Search_ref_no',
                                    table_name: 'receivable_payments'
                                },
                            })
                            .then(function (response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    vm.msg = "@lang('layout.DuplicateData')";
                                    vm.isError = true;
                                }
                                else {
                                    vm.msg = 'no';
                                    vm.isError = false;

                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }
                },


                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
				get_exchange() {
						if(vm.selected_rate > 0){
							vm.exchange_amount = myRound((vm.amount* vm.selected_rate1)/vm.selected_rate);
						}
					},
					set_rate() {
						if(vm.exchange_amount > 0){
							vm.selected_rate1 = myRound((vm.exchange_amount)/ (vm.amount / vm.selected_rate));
						}
				},
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {
                                vm.disabled = true;
                                var url = "{{route('receive.store')}}";
                                form_id = 'receive-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vm.number = Number(vm.old_number) + 1;
                                            vm.old_number = Number(vm.old_number) + 1;
                                            vm.amount = null;
                                            vm.ref_no = null;

                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            vm.disabled = false;
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        vm.disabled = false;
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },

                getSummary() {
                    if (this.selectedMember) {
                        this.project_list = [];
                        this.selectedProject = null;
						this.vehicle_rent_list = [];
                        this.selectedVehicleRent = null;
                        this.getSummaryRecor(this.selectedMember.id, this);
                        this.take_project_data(this);
                        this.take_vehicle_rent_data(this);

                    }

                },
                take_project_data(vm) {

                    axios.get("{{route('member.project')}}", {
                        params: {
                            member_id: this.selectedMember.id
                        },
                    }).then(function (response) {
                        vm.project_list = response.data;
                    })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                take_vehicle_rent_data(vm) {

                    axios.get("{{route('member.vehicleRent')}}", {
                        params: {
                            member_id: this.selectedMember.id
                        },
                    }).then(function (response) {
                            // console.log('ve',response.data);
                        vm.vehicle_rent_list = response.data;
                    })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                getSummaryRecor(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        } 
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            }
                            else{
                                vm.summary=[];
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },

                setSize(selected_code) {
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
                },
                setPaymentSize(selected_code) {
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },
                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selected_rate;
                    }

                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount) {
                                this.selectedBank = this.bankes[x];
                                break;
                            }
                        }

                    }

                },


            }
        });
    </script>


@endpush
 