@extends('layouts.factor-master')
@section('content')
<h4 class="bold uppercase" style="text-align: center; font-size: 20px;">@lang('layout.ReceiveVouchar') (RV)</h4>
<table style="width: 100%; margin-bottom: 10px;">
  <tr class="myclass">
    <td>
      <span style="text-align: right; font-size: 18px">@lang('layout.ReceiveNumber'): </span>
      <span style="text-align: right; font-size: 18px">{{$receiveByFactor->number}}</span>
    </td>
    <td>
      <span style="text-align: right; font-size: 18px">@lang('layout.ReferenceNumber'): </span>
      <span style="text-align: right; font-size: 18px">{{$receiveByFactor->ref_no}}</span>
    </td>
    <td>

      <span style="text-align: right; font-size: 18px">@lang('layout.Date'): </span>
      <BDO DIR="LTR"> <span
          style="text-align: right; font-size: 18px">{{$receiveByFactor->date}}</span></BDO>
    </td>

    <td>
      <span style="text-align: right; font-size: 18px">@lang('layout.Payer'): </span>
      <span style="text-align: right; font-size: 18px">{{$receiveByFactor->member_name}}</span>
    </td>
  </tr>
</table>



<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr>
      <th> @lang('layout.Currency') </th>
      <th> @lang('layout.Receivable')</th>
      <th> @lang('layout.Payable') </th>
    </tr>
  </thead>
  <tbody>
    @foreach(getStatement($receiveByFactor->member_id) as $value )
    <tr style="text-align: center;">
      <td class="center">
        {{$value['currency']}}
      </td>
      <td class="center">
        {{$value['invoice']}}
      </td>
      <td class="center">
        {{simpleRound($value['payment'])}}
      </td>
    </tr>
    @endforeach
  </tbody>
</table>



<table style="width: 100%; margin-bottom: 10px;" class=" main-table">
  <thead>
    <tr>
      <th style="font-size: 18px"> @lang('layout.Amount')</th>
      <th> @lang('layout.Accountant') </th>
      <th> @lang('layout.Description')</th>
      {{-- <th> @lang('layout.Memo')</th> --}}
      <th> @lang('layout.PayerSignature')</th>
    </tr>
  </thead>
    <tr>
      <td  class="center" style="font-size: 18px;height:70px">{{simpleRound($receiveByFactor->amount)}} {{$receiveByFactor->currency}}</td>
      <td  class="center">{{$user}}</td>
      <td  class="center">
        {!! wordwrap($receiveByFactor->description,40,"<br/>\n",false) !!}
      </td>
      {{-- <td  class="center">
        {!! wordwrap($receiveByFactor->memo,40,"<br/>\n",false) !!}
      </td> --}}
      <td class="center"></td>
    </tr>
</table>
@if(company()['pay_message'])
<table width="100%">
  <tr>
    <td style="font-size: 14px;">{!!company()['pay_message']!!}</td>
  </tr>

  <tr>
    <td></td>
    <td></td>
  </tr>


</table>
@endif


@endsection