@extends('layouts.app')

@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    }
</style>
@stop
@section('content')
    <div class="portlet" >
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.RecieveDetials')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th> 
                        <th>@lang('layout.ReferenceNumber')</th> 
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Amount')</th>  
                        <th>@lang('layout.Currency')</th>  
                        <th>@lang('layout.Rate')</th>  
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        @if($receiveByFactor->description)<th>@lang('layout.Description')</th>@endif
                        @if($receiveByFactor->memo)<th>@lang('layout.Memo')</th>@endif 
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td> {{ $receiveByFactor->number}}  </td>
                        <td> {{ $receiveByFactor->ref_no}}  </td>
                        <td> {{ $receiveByFactor->member_name}}  </td>
                        <td style="font-weight: bold;font-size:18px"> {{myRound($receiveByFactor->amount)}}  </td>
                        <td> {{ $receiveByFactor->currency }}  </td>
                        <td> {{ $receiveByFactor->rate }}  </td>
                        <td> {{ $receiveByFactor->date}} </td>
                        <td> {{ $receiveByFactor->hour}} </td>
                        @if($receiveByFactor->description)<td> {{ $receiveByFactor->description }}</td>@endif
                        @if($receiveByFactor->memo)<td> {{ $receiveByFactor->memo }}</td>@endif

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

        <!--Begin Payment Data-->
        <div class="row" v-if="paymentData" id="app" v-cloak>
            <div class="col-md-6 col-sm-12" v-for="(item,index) in paymentData">
                <div class="portlet green-meadow box">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-tasks"></i> &nbsp; @{{++index}}
                        </div>
                
                    </div>

                    <div class="portlet-body">
                        <div class="row static-info">
                            <div class="col-md-12 value">

                                <table class="table" v-if="item.factor.bill_info">
                                    <thead>
                                        <tr class="active">
                                            <th>@lang('layout.BillNumber')</th>
                                            <th>@lang('layout.Currency')</th>
                                            <th>@lang('layout.Rate')</th>
                                            <th>@lang('layout.Amount')</th>
                                            <th>@lang('layout.Remain')</th>
                                            <th>@lang('layout.GainOrLoss')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="active">
                                            <td>
                                                <h4 style="font-weight: bold">@{{(!item.factor)?null:item.factor.bill_info}}</h4>
                                                
                                            </td>
                                            <td>
                                                @{{(!item.factor)?null:item.factor.currency}}
                                                
                                            </td>
                                            <td>
                                                @{{(!item.factor)?null:item.factor.rate}}
                                                    
                                            </td>
                                            <td>
                                                @{{(!item.factor)?null:item.factor.amount}}
                                                
                                            </td>
                                            <td>
                                                @{{(!item.factor)?null:myRound(item.factor.remain_amount)}}
                                                
                                            </td>
                                                <td>
                                                <span v-if="item.factor">
                                                    <span v-if="item.factor.gain_or_Loss>0" style="color: red">
                                                        {{getHomeCurrency()["code"]}}
                                                        @{{(!item.factor)?null:Math.abs(myRound(item.factor.gain_or_Loss))}}
                                                        @lang('layout.Loss')
                                                    </span>
                                                    <span v-if="item.factor.gain_or_Loss<0" style="color: green">
                                                        {{getHomeCurrency()["code"]}}
                                                        @{{(!item.factor)?null:Math.abs(myRound(item.factor.gain_or_Loss))}}
                                                        @lang('layout.Gain')
                                                    </span>
                                                </span>
                                                
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <br>

                                <div  v-if="item.payments">
                                    <table class="table table-bordered" >
                                        <thead>
                                            <tr>
                                                <td style="color: white;">@lang('layout.ReceiveNumber')</td>
                                                <td style="color: white;">@lang('layout.ReferenceNumber')</td>
                                                <td style="color: white;">@lang('layout.Bank')</td>
                                                <td style="color: white;">@lang('layout.ReceiveCurrency')</td>
                                                <td style="color: white;">@lang('layout.Rate')</td>
                                                <td style="color: white;">@lang('layout.Discount') </td>
                                                <td style="color: white;">@lang('layout.Amount') </td>
                                                
                                            </tr>
                                        </thead> 
                                        <tbody>
                                            <tr v-for="(pay,p_index) in item.payments">

                                                <td @click="addNew('payment',index,p_index)">
                                                    @{{pay.receiveNumber}}
                                                </td>
                                                <td @click="addNew('payment',index,p_index)">
                                                    @{{pay.ref_no}}
                                                </td>
                                                <td @click="addNew('payment',index,p_index)">
                                                    @{{pay.item.name}}
                                                    
                                                </td>
                                                <td @click="addNew('payment',index,p_index)">
                                                    @{{(pay.currency==null)?null:pay.currency.code}}
                                                </td>
                                                <td @click="addNew('payment',index,p_index)">
                                                    @{{(!pay.currency)?null:pay.currency.rate}}
                                                    
                                                </td>
                                                <td @click="addNew('payment',index,p_index)">
                                                    @{{myRound(pay.item.discount)}}
                                                </td>
                                                <td @click="addNew('payment',index,p_index)">
                                                    @{{myRound(pay.item.amount)}}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                </div>
                            
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--End Payment Data-->


        <!-- end payment data -->
         <div class="row">
         <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                
                <li class="active">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
            
             <div class="tab-pane active" id="tab2"> 
                    <div class="tab-pane" id="tab2"> 
                    <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                    </div>
                </div>
                <div class="portlet-body">
                       <div class="portlet light bordered">
                            <div class="portlet-body">

                                <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="redirect_route" value="receiveByFactor.show">
                                    <input type="hidden" name="foreign_data_id" value="{{$receiveByFactor->id}}">
                                    <input type="hidden" name="path" value="uploads/ReceiveByFactor">
                                    <input type="hidden" name="table_name" value="receive_by_factors">

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control" rows="1"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                              <div class="form-group">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <div class="fileinput-new thumbnail" style="width: 140px; height: 70px;">
                                                        <img src="" alt=""> </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                    <div>
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                            
                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                               
                                    <div class="margiv-top-10">
                                        <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                        <a href="{{route('receiveByFactor.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                    </div>
                            </form>
                            </div>
                    </div>
                    <table class="table table-striped table-bordered table-hover" id="attachment">
                        <thead>
                        <tr>  
                            <th>@lang('layout.AttachmentTitle')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Action')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
    </div>
            </div>
        </div>


    </div>
</div>
@endsection

@push('scripts')

<script>

    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
          $('#attachment').DataTable({
                ajax:{
                    url:'{{route("receiveByFactor.show",$receiveByFactor->id)}}',
                    data:{type:'attachment'}
                  },
                
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    { data: 'title', name: 'attachments.title'},
                    { data: 'description', name: 'attachments.description'},
                    { data: 'actions',name: 'actions', orderable:false,searchable:false},
            ]
        });

    });

    Vue.component("v-select", VueSelect.VueSelect);

    var currency ={!! $currency !!};
    var homeCurrency = {!! json_encode(getHomeCurrency()) !!};
    var code = '{!! getHomeCurrency()['code'] !!}';
    var banks ={!! $banks !!};

    var vm = new Vue({
        el:'#app',
        data:{
            memberClass:{!! $memberClass  !!},
            selected_class:null,
            member:{!! $member !!},
            selectedMember: null,
            currency:currency,
            summary: [],
            isError: false,
            paymentData:[],
            temp_items: [],
            receive_by_factor:{!! $receiveByFactor !!},
            selected_data:{!! $selectedData !!}


        },
        computed:{
            
        },
        created:function(){
            
        },
        mounted:function(){
            if(this.receive_by_factor)
            {
                this.selectedMember=_.find(this.member,(m)=>m.id==this.receive_by_factor.member_id);
                if(this.selected_data)
                {   
                    for(var i=0;i<this.selected_data.length;i++)
                    {
                        let loopData=this.selected_data[i][0];
                        let loopDataSale=this.selected_data[i][0].sale;
                        let loopDataPayment=this.selected_data[i][0].payments;
                       
                        var p_t= new Object();

                        
                        let pay_t=[];
                        // check payment array


                        // payment


                        
                       
                        //end payment
                        if(loopData.payments)
                        {

                            for(var m=0;m<loopData.payments.length;m++)
                            {
                                 let tc={!! $currency !!}
                        
                                let seted_currency=_.find(tc,(c)=> c.code==loopData.payments[m].runit);
                                seted_currency.rate=loopData.payments[m].payRate;
                                let seted_bank=[];
                                
                                let b={!! $banks !!};
                                for(var w=0;w<b.length;w++)
                                {
                                    if(b[w].code==loopData.payments[m].runit)
                                    {
                                        seted_bank.push(b[w]);
                                    }
                                }

                                var selected_bank=_.find(seted_bank,(b)=> b.id==loopData.payments[m].Account_id);
                             
                                selected_bank.amount=loopData.payments[m].real_amount;
                                selected_bank.discount=loopData.payments[m].discount;

                                pay_t.push({items: seted_bank,
                                item: selected_bank,
                                currency_list:tc,
                                currency:seted_currency,
                                ref_no:loopData.payments[m].ref_Number,
                                receiveNumber:loopData.payments[m].receiveNumber});
                            }
                        }
                        // console.log(3333,pay_t);
                        this.paymentData.push({factor:loopDataSale,payments:pay_t});
                        
                    }

                    // empty 
                    if(this.selected_data.length<1)
                    {
                        vm.paymentData=[
                                        {factor:null,
                                        payments:[
                                        ]}
                                        ];
                    }
                }
            }

        },
        methods:{
            onFactorSelect(index=null)
            {
                if(this.paymentData[index] != undefined)
                {
                    if(this.paymentData[index].factor)
                    {   
                        this.paymentData[index].payments=[];
                        let tc={!! $currency !!}
                        let unit=this.paymentData[index].factor.currency;
                       
                        let seted_currency=_.find(tc,(c)=> c.code==unit);

                        let seted_bank=[];
                        
                        let b={!! $banks !!};
                        for(var i=0;i<b.length;i++)
                        {
                            if(b[i].code==unit)
                            {
                                seted_bank.push(b[i]);
                            }
                        }
                        
                        let selected_bank=null;
                        if(seted_bank.length)
                        {
                            selected_bank=seted_bank[0];
                        }
                      

                        this.paymentData[index].payments.push({items: seted_bank,
                            item: selected_bank,
                            currency_list:tc,
                            currency:seted_currency,
                            ref_no:null});
                    }
                }
            },
            memberClassChange()
            {
                vm.member = vm.all_member;
                console.log(vm.all_member);
                if (vm.selected_class) {
                    vm.member = vm.all_member.filter((m) => {
                        return vm.selected_class.id == m.class_id;
                    });

                }
            },
        
            getSummary()
            {
                if (this.selectedMember) {


                    this.getSummaryRecor(this.selectedMember.id, this);

                    // get member bills,factor
                    let member_id=this.selectedMember.id;
                    
                    if(this.selectedMember.id !=this.receive_by_factor.member_id)
                    {
                        vm.paymentData=[
                                    {factor:null,
                                    payments:[
                                    ]}
                                    ];
                    }

                    axios.get("{{route('payByFactor.getMemberFactor')}}", {
                        params: {
                            member_id:member_id ,
                        }
                    })
                    .then(function (response) {
                        vm.temp_items = [];
                        if (response.data.length > 0) {
                            vm.temp_items = response.data;
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                        
                    })
                    // end of bill,factor

                }

            },
            getSummaryRecor(id, vm)
            {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'memberStatment',
                        member_id: id,
                    }
                })
                .then(function (response) {

                    if (response.data.length > 0) {
                        vm.summary = response.data;
                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            checkRefPaymentByFactor(e)
            {
                var ref=e.target.value;
              
                axios.get("{{route('callMethod.search')}}",
                {

                    params: {
                        id:this.receive_by_factor.id,
                        ref_no: ref,
                        method_name: 'Search_ref_no',
                        table_name: 'receive_by_factors'
                    },
                })
                .then(function (response) {
                    // console.log(response.data.result);
                    if (response.data.result != null) {
                        console.log(response.data.result);
                        // v.temp_items=response.data;
                        let msg = "@lang('layout.DuplicateData')";
                        $('#ref_msg').html(msg);
                    }
                    else {
                        vm.msg = 'no';
                        $('#ref_msg').html('');

                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            // check ref
            checkRef(e,index,payment_index)
            {
                var ref=e.target.value;
              
                axios.get("{{route('callMethod.search')}}",
                {

                    params: {
                        ref_no: ref,
                        method_name: 'Search_ref_no',
                        table_name: 'payments'
                    },
                })
                .then(function (response) {
                    // console.log(response.data.result);
                    if (response.data.result != null) {
                        console.log(response.data.result);
                        // v.temp_items=response.data;
                        let msg = "@lang('layout.DuplicateData')";
                        $('#pay_'+index+payment_index).html(msg);
                    }
                    else {
                        vm.msg = 'no';
                        $('#pay_'+index+payment_index).html('');

                    }
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
            //  get factors
            onFactorSearch: _.debounce((search, loading) => {

                if(vm.selectedMember)
                {
                    let member_id=vm.selectedMember.id
                    loading(true);

                    axios.get("{{route('payByFactor.getMemberFactor')}}", {
                        params: {
                            member_id:member_id,
                            search_keyword:search
                        }
                    })
                    .then(function (response) {
                        vm.temp_items = [];
                        console.log('test222',response.data);
                        if (response.data.length > 0) {
                            vm.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                        loading(false);
                    })
                }
                else
                {
                    alert("{{__('layout.SelectMember')}}");
                }
            }, getDebounceTime()),

            approperiatBank(index,payment_index)
            {
                if(this.paymentData[index].payments[payment_index].currency)
                {
                    let unit=this.paymentData[index].payments[payment_index].currency.code;
                       
                    let seted_bank=[];
                    
                    let b={!! $banks !!};
                    for(var i=0;i<b.length;i++)
                    {
                        if(b[i].code==unit)
                        {
                            seted_bank.push(b[i]);
                        }
                    }
                    
                    let selected_bank=null;
                    if(seted_bank.length)
                    {
                        selected_bank=seted_bank[0];
                    }
                  
                    this.paymentData[index].payments[payment_index].items=seted_bank;
                    this.paymentData[index].payments[payment_index].item=selected_bank; 
                }
                
            },
            // generic function for adding item to list
            addNew(type = null, index,payment_index=null)
            {
                return false;
                //this.temp_items = [];
                if (type != null) {
                    
                    if (type == 'payment') {
                        if (this.paymentData[index].payments[payment_index + 1] == undefined) {
                            let b={!! $banks !!};
                             let tc={!! $currency !!}
                            this.paymentData[index].payments.push({
                                items: b,
                                item: null,
                                currency:null,
                                currency_list:tc,
                                ref_no:null
                            });

                        }
                    }
                    if (type == 'factor') {
                        let len=this.paymentData.length;
                        if (this.paymentData[index] == undefined) {
                            
                            this.paymentData.push({
                                factor:null,
                                payments:[
                                ]});

                        }
                    }
                } 
            },

            // delete item from list
            deleteItem(type = null, index,payment_index) {
                if (type != null) {
                  
                    if (type == 'payment') {
                        this.paymentData[index].payments.splice(payment_index, 1);
                    }
                }

            },


            // save or new

            saveAndNew(e,type=null) 
            {
                
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {

                            var url = "{{route('payByFactor.update',$receiveByFactor->id)}}";
                            
                            var data = $('#payByFactor-form').serialize();

                            axios.post(url, data)
                                .then(function (response) {
                                   
                                    if (response.data.result == 1) {
                                        $('#payByFactor-form').trigger('reset');
                                        toastr.success('', response.data.message);
                                        if(type==null)
                                        {
                                            window.location.href="{{route('receiveByFactor.index')}}"
                                        }
                                        else
                                        {
                                            vm.paymentData=[
                                            {factor:null,
                                            payments:[
                                            ]}
                                            ];
                                            vm.temp_items= [];
                                            vm.selectedMember=null;
                                        }
                                       
                                    }
                                    else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }

                                    
                                    
                                })
                                .catch(function (error) {
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },

        }

    });
</script>

@endpush
 
