@extends('layouts.factor-master')
@section('style')
<style>
  .bhead{
    height: 35px;
    font-size: 18px;
  }

</style>
@endsection
@section('content')
<?php
$report = customeReport('payment_by_factor');
$_description=in_array('description', $report);
$_test=true;

?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.ReceiveByFactorReport')</h3>

<!-- begin loop root -->
@foreach($data AS $record)


<!-- if root -->
@if(isset($record['detail']) && isset($record['info']))

<table class="report-table">
	<thead>
	<tr>
		<th>@lang('layout.Number')</th> 
		<th>@lang('layout.ReferenceNumber')</th> 
    <th>@lang('layout.Date')</th>
    <th>@lang('layout.Hour')</th>
		<th>@lang('layout.Description')</th>
		<th>@lang('layout.Name')</th>
		<th>@lang('layout.Amount')</th>  
		<th>@lang('layout.Currency')</th>  
		<th>@lang('layout.Rate')</th>  
		<th>@lang('layout.User')</th>
	</tr>
	</thead>
	<tbody>
	<tr>  
		<td class="center"> {{ $record['info']->number}}  </td>
		<td class="center"> {{ $record['info']->ref_no}}  </td>
    <td class="center"> {{ convertDate($record['info']->date)}}  </td>
    <td  class="center">
      @if(getHourType() == 24)
      {{ (($record['info']->hour != null)?(date_format(date_create($record['info']->hour), 'H:i')):'') }}
      @else
      {{ (($record['info']->hour != null)?(date_format(date_create($record['info']->hour), 'h:i:a')):'') }}
      @endif
      </td>
		<td class="center"> {{ $record['info']->description}}  </td>
		<td class="center"> {{ $record['info']->member_name}}  </td>
		<td class="center"> {{ $record['info']->amount}}  </td>
		<td class="center"> {{ $record['info']->currency}}  </td>
		<td class="center"> {{ $record['info']->rate}}  </td>
		<td class="center"> {{ $record['info']->user}}  </td>

	</tr>
	</tbody>
</table>
<br/>

<table class="report-table">
  

 <?php
 $count = 0;
 ?>
 @foreach($record['detail'] AS $detail)
  <!-- loop check detail of each payment -->
  
  @if(isset($detail[0]['sale']) && isset($detail[0]['payments']))
  <?php
  $saleData=$detail[0]['sale'];
  if($saleData){
  ?>

<tr style="background-color: rgb(183, 225, 244); ">
  <td class="bhead">
    @lang('layout.InvoiceNumber'):
      {{$saleData->number}}
  </td>
  <td class="bhead">
    @lang('layout.Currency'):
      {{$saleData->currency}}
  </td>
  <td class="bhead">
    @lang('layout.Rate'):
      {{$saleData->rate}}
  </td>
  <td class="bhead">
    @lang('layout.Amount'):
    {{$saleData->amount}}
  </td>
  <td class="bhead">
    @lang('layout.Remain'):
      {{$saleData->remain_amount}}
  </td>  
  <td class="bhead">
    @if($saleData->gain_or_Loss>0)
      {{myRound(ABS($saleData->gain_or_Loss))}} {{getHomeCurrency()['code']}}
      @lang('layout.Loss')
      
    @else
    {{myRound(ABS($saleData->gain_or_Loss))}}{{getHomeCurrency()['code']}}
      @lang('layout.Gain')
    @endif
  </td>
</tr>

  <?php } ?>
  <tr class="bg">

   @if($_test)<td class="center"> @lang('layout.ReferenceNumber')</td>@endif
   @if($_test)<td class="center"> @lang('layout.ReceiveCurrency')</td>@endif
   @if($_test)<td class="center"> @lang('layout.Rate')</td>@endif
   @if($_test)<td class="center"> @lang('layout.Bank')</td>@endif
   @if($_test)<td class="center"> @lang('layout.Discount')</td>@endif
   @if($_test)<td class="center"> @lang('layout.Amount')</td>@endif
 </tr>

  @foreach($detail[0]['payments'] AS $pay)
  <?php if ($pay) { ?>
  <tr>
     @if($_test)<td class="center">{{$pay->ref_no}}</td>@endif
     @if($_test)<td class="center">{{$pay->runit}}</td>@endif
     @if($_test)<td class="center">{{$pay->payRate}}</td>@endif
     @if($_test)<td class="center">{{$pay->Account}}</td>@endif
     @if($_test)<td class="center">{{$pay->discount}}</td>@endif
     @if($_test)<td class="center">{{$pay->real_amount}}</td>@endif
  </tr>
  <?php }?>

  @endforeach
  @endif
  <!-- end loop check detail of each payment -->

  @endforeach   
</table>

<br/>
<br/>

@endif
<!-- end if root -->
@endforeach
<!-- end loop root -->


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection