@extends('layouts.app')
@section('style')
<style>
    .modal-container{
        width: 60% !important;
    }
</style>
@endsection
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'all_receive_by_factor'"  @closed="closeModal">

            <div slot=body>

                <div class="row">
                    <div class="form-group">

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.MemberClass') </label>
                            <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                      :options="classlist">
                            </v-select>
                            <input type="hidden" name="class_id"
                                   v-model.number="(!selectedClass)?null:selectedClass.id">
                        </div>

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.ReferenceNumber') </label>
                            
                            <input type="texts" name="ref_no" class="form-control">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" autocomplete="off"
                                           name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" autocomplete="off"
                                           name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>



    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.ReceiveByFactor')</span>
                    </div>
                </div>
                <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12" style="display: flex; justify-content: center;" id="date_part">
                    <div class="form-group">
                        <div class="input-group">
                            <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                            <span class="input-group-addon btn" style="background: #36c6d3;color: white;"  @Click="getData()"> @lang('layout.Search') </span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                    <div class="pull-right">
                        @permission('receive-list')
                        <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                        </span>
                        @endpermission
                        @permission('receive-list')
                        <a href="{{route('receiveByFactor.create')}}">
                            <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                            <button id="sample_editable_1_new" class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button>
                        </a>
                        @endpermission
                    </div>
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="pay">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <iframe id="payframe" style="display: none;"></iframe>


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);
      
        function printVoucher(id) {
            var a = document.createElement('a');
            a.href = "{{url('printReceiveByFactor')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
       
        var data_table =0;
        
        $(document).ready(function () {
            getRecord();
        });
        function getRecord() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            if (data_table != 0) {
                data_table.destroy();
            }

            data_table = $('#pay').DataTable({
                ajax: {
                    ajax: '{{route("receiveByFactor.index")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'receive_by_factors.number'},
                    {data: 'ref_no', name: 'receive_by_factors.ref_no'},
                    {data: 'member_name', name: 'member_name'},
                    {data: 'amount', name: 'receive_by_factors.amount'},
                    {data: 'currency', name: 'receive_by_factors.currency'},
                    {data: 'rate', name: 'receive_by_factors.rate'},
                    {data: 'date', name: 'receive_by_factors.date'},
                    {data: 'hour', name: 'receive_by_factors.hour', searchable: false},
                    {data: 'description', name: 'receive_by_factors.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},

                ]
            });
        }
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
        // function printVoucher(id){
        //     document.getElementById("payframe").src ="{{url('printPayment')}}/"+id;
        // }
        // for new modal
        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    getRecord();
                }
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('receiveByFactor.report') !!}',
                excelRoute: '{!! route('receiveByFactor.report') !!}',

                selectedMember: null,
                memberlist: [],
                classlist: [],
                selectedClass: null,

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                  //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'members',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });


        // /for new modal

    </script>
@endpush
