@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('payment_by_factor');
$_description=in_array('description', $report);
$_test=true;

?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.ReceiveByFactorReport')</h3>

<!-- begin loop root -->
@foreach($data AS $record)


<!-- if root -->
@if(isset($record['detail']) && isset($record['info']))


<p>
  @lang('layout.Number'):
  {{$record['info']->number}}

  @lang('layout.ReferenceNumber'):
  {{$record['info']->ref_no}}

  @lang('layout.MemberName'):
  {{$record['info']->member_name}}

  @lang('layout.Date'):
  {{convertDate($record['info']->date)}}

   @lang('layout.Description'):
  {{$record['info']->description}}

</p>

<table class="report-table">
  

 <?php
 $count = 0;
 ?>
 @foreach($record['detail'] AS $detail)
  <!-- loop check detail of each payment -->
  
  @if(isset($detail[0]['sale']) && isset($detail[0]['payments']))
  <?php
  $saleData=$detail[0]['sale'];
  ?>
  <tr>
    <td colspan="5">
      
      @lang('layout.InvoiceNumber'):
      {{$saleData->number}}

      @lang('layout.Currency'):
      {{$saleData->currency}}

      @lang('layout.Rate'):
      {{$saleData->rate}}

      @lang('layout.Amount'):
      {{$saleData->amount}}
      @lang('layout.Remain'):
      {{$saleData->remain_amount}}

    </td>
  </tr>
  <tr class="bg">

   @if($_test)<td><div class="center"> @lang('layout.ReferenceNumber')</div></td>@endif
   @if($_test)<td><div class="center"> @lang('layout.ReceiveCurrency')</div></td>@endif
   @if($_test)<td><div class="center"> @lang('layout.Rate')</div></td>@endif
   @if($_test)<td><div class="center"> @lang('layout.Bank')</div></td>@endif
   @if($_test)<td><div class="center"> @lang('layout.Amount')</div></td>@endif
 </tr>

  @foreach($detail[0]['payments'] AS $pay)
  {
  <tr>
     @if($_test)<td class="center">{{$pay->ref_Number}}</td>@endif
     @if($_test)<td class="center">{{$pay->runit}}</td>@endif
     @if($_test)<td class="center">{{$pay->payRate}}</td>@endif
     @if($_test)<td class="center">{{$pay->Account}}</td>@endif
     @if($_test)<td class="center">{{$pay->amount}}</td>@endif
  </tr>

  @endforeach
  @endif
  <!-- end loop check detail of each payment -->

  @endforeach   
</table>

@endif
<!-- end if root -->
@endforeach
<!-- end loop root -->


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection