@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'Purchase_Details'" @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="id" value="{{$purchase->p_id}}"/>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                                    @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                <div class="portlet light bordered"></div>
                            </div> 
                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="purchase_show">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        <!-- <label> @{{ row.Name }}</label>
                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                        <label class="switch">
                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn" >
                                                            <span class="slider round"></span>
                                                        </label> -->
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </report-modal>
    </div>
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PurchaseInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr> 
                            <th class="">
                                <i class="fa fa-bars"></i> @lang('layout.PurchaseNumber') 
                            </th> 
                            <th class="">
                                <i class="fa fa-bars"></i> @lang('layout.ReferenceNumber') 
                            </th>
                            <th class="">
                                <i class="fa fa-user"></i> @lang('layout.Vendor')   
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Account') 
                            </th> 
                            <th>
                                <i class="fa fa-text-width"></i> @lang('layout.Type') 
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Amount') 
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Discount') 
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Currency') 
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.PaymentType') 
                            </th> 
                            <th>
                                <i class="fa  "></i> @lang('layout.Rate') 
                            </th> 
                        </tr>
                    </thead>
                    <tbody>
                        <tr>  
                            <td class=""> {{ $purchase->number }}  </td>
                            <td class=""> {{ $purchase->ref_Number }}  </td>
                            <td class=""> {{ $purchase->vendor}}  </td>
                            <td class=""> {{ $purchase->account}}  </td>
                            <td class=""> {{ $purchase->type}}  </td>
                            <td class=""> {{ $purchase->date}}  </td>
                            <td class=""> {{ $purchase->hour}}  </td>
                            <td class=""> {{ myRound($purchase->amount) }}  </td>
                            <td class=""> {{ $purchase->discount }}  </td>
                            <td class=""> {{ $purchase->currency }}  </td>
                            @if($purchase->payment_type == 'On')
                            <td class=""> @lang('layout.Paid')  </td>
                            @else
                            <td class=""> @lang('layout.NoPaid')  </td>
                            @endif
                            <td class=""> {{ $purchase->rate }}  </td>
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.Description')
                            </th>
                            <th width=" ">
                                <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class=" "> {{ $purchase->description}}  </td>
                            <td class=" "> {{ $purchase->memo}}  </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="">
                <div class="tabbable-line tabbable-custom-profile">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab_1-1" data-toggle="tab" id="Purch-table">
                                <b> @lang('layout.PurchaseDetails') </b>
                            </a>
                        </li>
                        <li class="">
                            <a href="#tab_4-4" data-toggle="tab" id="Purch-table">
                                <b> @lang('layout.Attachments') </b>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="tab-content">
                <div id="tab_1-1" class="tab-pane active">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.PurchaseDetails') </span>
                            </div>
                            <div class="tools"></div>
                            <div class="actions">
                                <span id="anchore-modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                    <i class="fa fa-print"></i>
                                </a>
                                </span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <table class="table table-striped table-bordered table-hover" id="purchases">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.ItemCode') </th>
                                        <th>@lang('layout.ItemName') </th>
                                        @if(showLocation()=="true")
                                        <th>@lang('layout.Location')</th>
                                        @endif
                                        @if(getSaleDescription()=="true") 
                                        <th>@lang('layout.Model')</th>
                                        <th>@lang('layout.Color')</th>
                                        @endif
                                        @if(getOtherMeasure()=="true")
                                        <th>@lang('layout.OMeasureValue1')</th>
                                        @endif
                                        @if(getOtherMeasure2()=="true")
                                        <th>@lang('layout.OMeasureValue2')</th>
                                        @endif

                                        @if(getShowCBM()=="true")
                                        <th style="min-width: 100px">@lang('layout.CBM')</th>
                                        @endif

                                        <th>@lang('layout.Quantity') </th>
                                        <th>@lang('layout.Measure') </th>
                                        <th>@lang('layout.PurchaseCost') </th>
                                        <th>@lang('layout.Expense') </th>
                                        <th>@lang('layout.CostOfGoodSold') </th>
                                        <th>@lang('layout.TotalPurchaseCost') </th>
                                        <th>@lang('layout.TotalCostOfGoodSold') </th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
                <div id="tab_4-4" class="tab-pane">
                    <div class="portlet light bordered">
                        <div class="portlet-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 20px;">
                                        <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data" style="padding: 0.5% 1%;">
                                            @csrf
                                            <input type="hidden" name="redirect_route" value="purchase.show">
                                            <input type="hidden" name="foreign_data_id" value="{{$purchase->p_id}}">
                                            <input type="hidden" name="path" value="uploads/purchase">
                                            <input type="hidden" name="table_name" value="purchases">
                                            <div class="row">
                                                <div class="col-lg-12">
                                                    <div class="form-group">
                                                        <label class="control-label"><i class="icon-settings font-dark"></i> @lang('layout.AttachmentTitle')</label>
                                                        <input type="text" name="title" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.Description')</label>
                                                        <textarea name="description" class="form-control" rows="8" style="resize: none;"></textarea>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                            <div>
                                                                <span class="btn default btn-file">
                                                                    <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                    <input type="hidden" value="" name=""><input type="file" name="photo"> 
                                                                </span>
                                                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                            </div>
                                                            <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                                                <img src="" alt=""> 
                                                            </div>
                                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 165px; line-height: 10px;"> 
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margin-top-0 text-center">
                                                <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                            </div>
                                        </form>
                                    </div>
                                    <table class="table table-striped table-bordered table-hover" id="attachment">
                                        <thead>
                                            <tr>  
                                                <th>@lang('layout.AttachmentTitle')</th>
                                                <th>@lang('layout.Description')</th>
                                                <th>@lang('layout.Action')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@include('print.modal')
@push('scripts')
<script>
    $(document).ready(function () {
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#attachment').DataTable({
                ajax:{
                    url:'{{route("purchase.show",$purchase->p_id)}}',
                    data:{type:'attachment'}
                },
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    { data: 'title', name: 'attachments.title'},
                    { data: 'description', name: 'attachments.description'},
                    { data: 'actions',         name: 'actions', orderable:false,searchable:false},
                ]
            });
        });
    });
var cust_rep = {!!customeReportNewData('purchase_show')!!};
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#purchases').DataTable({
            ajax:'{{route("purchase.show",$purchase->p_id)}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [   
                { data: 'Number', name: 'items.number' },
                { data: 'items', name: 'items.name' },
                @if(showLocation()=="true")
                { data: 'location', name: 'stocks.location' },
                @endif
                @if(getSaleDescription()=="true") 
                { data: 'model',      name: 'model',searchable:false },
                { data: 'color',      name: 'color',searchable:false },
                @endif
                @if(getOtherMeasure()=="true")
                { data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
                @endif
                @if(getOtherMeasure2()=="true")
                { data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
                @endif
                @if(getShowCBM()=="true")
                { data: 'cbm', name: 'cbm',orderable:false,searchable:false},
                @endif
                { data: 'qty', name: 'qty',orderable:false,searchable:false},
                { data: 'purchaseMeasure', name: 'purchaseMeasure',orderable:false,searchable:false },
                { data: 'Amount', name: 'Amount',orderable:false,searchable:false },
                { data: 'expense_cost', name: 'expense_cost',orderable:false,searchable:false },
                { data: 'CostOfGoodSold', name: 'CostOfGoodSold', orderable:false,searchable:false},
                { data: 'Total', name: 'Total', orderable:false,searchable:false},
                { data: 'total_cost_of_good_sold', name: 'total_cost_of_good_sold', orderable:false,searchable:false}, 
            ]
        });
    });
    var vm =new Vue({
        el: '#print-modal',
        data:{
            is_show: false,
            pdfRoute: '{!!route('export.PDFAny') !!}',
            excelRoute: '{!! route('export.exportCsv') !!}',
            customReportData:
            [ 
                {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                {Name: '@lang("layout.PurchaseCost")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                {Name: '@lang("layout.Expense")', column_name: 'expense',checkedColumn:(cust_rep.expense)?'checked':'',column_percentage:(cust_rep.expense___percent)?cust_rep.expense___percent:''},
                {Name: '@lang("layout.UnitCost")', column_name: 'UnitCost',checkedColumn:(cust_rep.UnitCost)?'checked':'',column_percentage:(cust_rep.UnitCost___percent)?cust_rep.UnitCost___percent:''},
                {Name: '@lang("layout.TotalPurchaseCost")', column_name: 'total_purchase_cost',checkedColumn:(cust_rep.total_purchase_cost)?'checked':'',column_percentage:(cust_rep.total_purchase_cost___percent)?cust_rep.total_purchase_cost___percent:''},               
                {Name: '@lang("layout.TotalCostOfGoodSold")', column_name: 'total_costOfGood_sold',checkedColumn:(cust_rep.total_costOfGood_sold)?'checked':'',column_percentage:(cust_rep.total_costOfGood_sold___percent)?cust_rep.total_costOfGood_sold___percent:''},
                @if(showLocation()=="true")
                {Name: '@lang("layout.Location")', column_name: 'location',checkedColumn:(cust_rep.location)?'checked':'',column_percentage:(cust_rep.location___percent)?cust_rep.location___percent:''},
                @endif
                @if(getSaleDescription()=="true")
                {Name: '@lang("layout.Model")', column_name: 'model',checkedColumn:(cust_rep.model)?'checked':'',column_percentage:(cust_rep.model___percent)?cust_rep.model___percent:''},
                {Name: '@lang("layout.Color")', column_name: 'color',checkedColumn:(cust_rep.color)?'checked':'',column_percentage:(cust_rep.color___percent)?cust_rep.color___percent:''},
                @endif
                {Name: '@lang("layout.OMeasureValue1")', column_name: 'other_measure',checkedColumn:(cust_rep.other_measure)?'checked':'',column_percentage:(cust_rep.other_measure___percent)?cust_rep.other_measure___percent:''},
                {Name: '@lang("layout.OMeasureValue2")', column_name: 'other_measure_two',checkedColumn:(cust_rep.other_measure_two)?'checked':'',column_percentage:(cust_rep.other_measure_two___percent)?cust_rep.other_measure_two___percent:''},
            
            ],
            cust_rep:cust_rep
        },
        methods:{
            closeModal: function(){
                this.is_show = !this.is_show;
            }
        }
    });
    new Vue({
        el:'#anchore-modal',
        methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });
</script>
@endpush