@extends('layouts.app')
@section('style')
    <style>
     .hide_btn{
        display: none; 
    }
    </style>
@endsection
@section('content')
    <!-- new modal for print-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'purchaselist'" @closed="closeModal">
            <div slot=body>
                <input type="hidden" name="type" value="purchaselist"/>
                <input type="hidden" name="type_name" value="Vendor"/>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                     <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                                @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                             <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.MemberClass') </label>
                                                    <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                                              :options="classlist">
                                                    </v-select>
                                                    <input type="hidden" name="class_id"
                                                           v-model.number="(!selectedClass)?null:selectedClass.id">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.SelectMember') </label>
                                                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                                              :options="memberlist">
                                                    </v-select>
                                                    <input type="hidden" name="member_id"
                                                           v-model.number="(!selectedMember)?null:selectedMember.id">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.Bank') </label>
                                                    <v-select class="vue-select2"
                                                            v-model="selected_bank"
                                                            label="name"
                                                            :options="bank"
                                                            @search="searchAccount"
                                                            >
                                                    </v-select>
                                                    <input type="hidden" name="bank_id" :value="(!selected_bank)?null:selected_bank.id">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label ">@lang('layout.Date')</label>
                                                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                        <option value="CustomDates">@lang('type.CustomDates')</option>
                                                        <option value="Today">@lang('type.Today')</option>
                                                        <option value="Yesterday">@lang('type.Yesterday')</option>
                                                        <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                        <option value="LastWeek">@lang('type.LastWeek')</option>
                                                        <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                        <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                        <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                        <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                        <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                        <option value="ThisYear">@lang('type.ThisYear')</option>
                                                        <option value="YearToDate">@lang('type.YearToDate')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-12" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" name="from_date" v-model="from_date"
                                                                   autocomplete="off">

                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" name="to_date" v-model="to_date"
                                                                   autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </div> 
                            <div class="tab-pane" id="tab2"> 
                               <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="purchase_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                         <!-- <label> @{{ row.Name }}</label>

                                                          <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                         <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                              <span class="slider round"></span>
                                                        </label> -->

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                    </form>
                                    </div>
                            </div>
                    </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->


            </div>
        </report-modal>
    </div>
    <!-- /new modal for print -->
    {{-- custom modal part start  --}}
    <div id="settingModal" v-cloak>
        <setting-modal :pdf-route="route" v-if="is_show" :value-type="'purchase'" @closed="closeModal">
            <div slot="header" class="text-center">
                <h4 style="font-weight: bold;">@lang('layout.CustomForms')</h4>
            </div>
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 10px;" v-for="(row,itemIndex) in customReportData">
                            <div class="form-group">
                                <table class="table table-striped table-bordered table-advance">
                                    <tr style="background-color: rgba(227, 227, 227, 0.757)">
                                        <th style="text-align: center;">@{{ row.Name }}</th>
                                    </tr>
                                    <tr>
                                        <td style="text-align: center;">
                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                            <label class="switch">
                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                :checked="row.checkedColumn" >
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </setting-modal>
    </div>
    {{-- custom modal part end  --}}
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="col-md-2 col-sm-2">
                <span class="caption-subject bold uppercase" style="font-size: 20px;">@lang('layout.Writecheck')</span>
            </div>
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Search') </span>
                    </div>
                </div>
            </div>
            <div class="col-md-2 col-sm-4" id="date_parttwo">
                <div class="form-group">
                {{Form::open(['route' => 'purchase.changeFactor','method' => 'POST','class' => 'form-horizontal', 'id'=>'purchase-form'])}}
                {{ csrf_field() }}
                    <div class="form-group  hidden-print">
                        <div class="input-group"> 
                            <input name="part_number" class="form-control" ref="part_number" placeholder="@lang('layout.DeActiveOldsFactor')"  type="number" />
                            <span class="input-group-addon btn" style="padding: 0px;" > <button type="button" @click="submitFormDatePart($event)" style="padding: 0px 8px; color:red;" > @lang('layout.Disable') </button> </span>
                        </div>
                    </div>
                {!! Form::close() !!}
                </div>
            </div> 
            <div class="portlet-title">
                <div class="caption font-dark">
                    <!-- <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Writecheck') </span> -->
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <span id="setting-modal">
                        <button type="submit" @click.prevent="showModal" class="btn" style="background-color: rgb(80, 129, 141);color: white;">
                            <i class="fa fa-wrench"></i>
                        </button>
                    </span>
                    @permission('purchase-export')
                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @endpermission
                    @permission('purchase-create')
                    <a href="{{route('purchase.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                <!-- <button class="btn btn-success" id="addNewReturnww">
                                <i class="fa fa-mail-reply"></i> @lang('menu.Return')
                        </button> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="purchase">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number') </th>
                            @if(getCustomeForm('purchase','referenceNumber'))
                            <th>@lang('layout.ReferenceNumber') </th>
                            @endif
                            <th>@lang('layout.Vendor') </th>
                            <th>@lang('layout.Account') </th>
                            @if(getCustomeForm('purchase','date'))
                            <th>@lang('layout.Date') </th>
                            @endif
                            @if(getCustomeForm('purchase','hour'))
                            <th>@lang('layout.Hour') </th>
                            @endif
                            <th>@lang('layout.Amount') </th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            @if(getCustomeForm('purchase','user'))
                            <th>@lang('layout.User')</th>
                            @endif
                            @if(getCustomeForm('purchase','description'))
                            <th>@lang('layout.Description')</th>
                            @endif
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@include('layouts.setting_model')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('purchase_index')!!};
        function factorPrint(id, type=null, sendWhatsapp = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            var a = document.createElement('a');
            a.href = "{{url('billFactorPrint')}}/" + id + "/" + type + "/" + sendWhatsapp;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        let data_table;
        function getRecord() {
            // console.log(234, vtr.from_date, vtr.to_date);
            data_table = $('#purchase').DataTable({
                ajax: {
                    ajax: '{{route("purchase.index")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                },
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                serverSide: true,
                destroy: true,
                order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'number', width: "10%"},
                    @if(getCustomeForm('purchase','referenceNumber'))
                    {data: 'ref_no', name: 'purchases.ref_no'},
                    @endif
                    {data: 'vendor', name: 'members.name'},
                    {data: 'account', name: 'accounts.name'},
                    @if(getCustomeForm('purchase','date'))
                    {data: 'date', name: 'purchases.date', searchable: false},
                    @endif
                    @if(getCustomeForm('purchase','hour'))
                    {data: 'hour', name: 'purchases.hour', searchable: false},
                    @endif
                    {data: 'amount', name: 'transactions.amount', width: "10%" @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'Currency', name: 'transactions.unit', width: "10%"},
                    {data: 'rate', name: 'rate', width: "10%", orderable: false, searchable: false},
                    @if(getCustomeForm('purchase','user'))
                    {data: 'username', name: 'users.name', width: "10%"},
                    @endif
                    @if(getCustomeForm('purchase','description'))
                    {data: 'description', name: 'description' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    {
                        data: 'actions',
                        name: 'actions',
                        width: "25%",
                        class: 'acctions',
                        orderable: false,
                        searchable: false
                    },
                ],
            });
        }
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            getRecord();
        });
        Vue.component('v-select', VueSelect.VueSelect)
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start app
        var v = new Vue({
            el: '#date_parttwo',
            methods: {
                // submit the form
                submitFormDatePart(e) {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                        text: "",
                        icon: "info",
                        InfoMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("purchase-form").submit()
                        } else {
                            
                        }
                    });
                },
                // submit the form
            }
        });
        // for new modal
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                memberlist: [],
				classlist: [],
                selectedClass: null,
                selected_bank:null,
                bank:[],
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.PurchaseNumber")', column_name: 'purchase_number',checkedColumn:(cust_rep.purchase_number)?'checked':'',column_percentage:(cust_rep.purchase_number___percent)?cust_rep.purchase_number___percent:''},
                 {Name: '@lang("layout.Vendor")', column_name: 'vendor',checkedColumn:(cust_rep.vendor)?'checked':'',column_percentage:(cust_rep.vendor___percent)?cust_rep.vendor___percent:''},
                 {Name: '@lang("layout.Class")', column_name: 'class',checkedColumn:(cust_rep.class)?'checked':'',column_percentage:(cust_rep.class___percent)?cust_rep.class___percent:''},
                 {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_rep.item)?'checked':'',column_percentage:(cust_rep.item___percent)?cust_rep.item___percent:''},
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.DiscountType")', column_name: 'discount_type',checkedColumn:(cust_rep.discount_type)?'checked':'',column_percentage:(cust_rep.discount_type___percent)?cust_rep.discount_type___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(cust_rep.discount)?'checked':'',column_percentage:(cust_rep.discount___percent)?cust_rep.discount___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                //ajax call to get items
                searchAccount(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'accounts',
                            filterColumn: 'type',
                            filterValue: 'bank',
                        }
                    })
                    .then(function (response) {
                        this.bank = [];
                        if (response.data.length > 0) {
                            vm.bank = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Vendor',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                            console.log('data', vm.memberlist);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
				onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                }, 
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',
                        }
                    })
                    .then(function (response) {
                        this.classlist = [];
                        if (response.data.length > 0) {
                            vm.classlist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        // end for new modal
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    getRecord();
                }
            }
        });
        // custom part start
        var cust_form = {!!customeForm('purchase')!!};
        var sm = new Vue({
            el: '#settingModal',
            data: {
                is_show: false,
                route: '{!!route("customForm.store") !!}',
                customReportData:
                [    
                    {Name: '@lang("layout.ContractName")', column_name: 'contractName',checkedColumn:(cust_form.contractName)?'checked':''},
                    {Name: '@lang("layout.ReferenceNumber")', column_name: 'referenceNumber',checkedColumn:(cust_form.referenceNumber)?'checked':''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_form.date)?'checked':''},
                    {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_form.hour)?'checked':''},
                    {Name: '@lang("layout.SalePrice")', column_name: 'salePrice',checkedColumn:(cust_form.salePrice)?'checked':''},
                    @if(getWhatsApp() =='true') 
                    {Name: '@lang("layout.Whatsapp")', column_name: 'whatsapp',checkedColumn:(cust_form.whatsapp)?'checked':''},
                    @endif
                    {Name: '@lang("layout.Precision")', column_name: 'precision',checkedColumn:(cust_form.precision)?'checked':''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_form.description)?'checked':''},
                    {Name: '@lang("layout.EditDescription")', column_name: 'editDescription',checkedColumn:(cust_form.editDescription)?'checked':''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_form.user)?'checked':''},  
                ],
                cust_form:cust_form
            },
            watch: {
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#setting-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    sm.$data.is_show = true
                }
            }
        });
        // custom part end 
    </script>

@endpush
















