@extends('layouts.app')
@section('content')
    @include('sales.modal')
    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->





    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.SalesOrderList')</span>
                </div>
                <div class="tools">
                    
                 </div>
                <div class="pull-right">
    
                </div>
            </div>
            <div class="row">
                    <?php foreach ($saleOrderAll as $so): ?> 
                <div class="col-md-6 col-sm-12">
                    <div class="portlet green-meadow box">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class="icon-user"></i> {{$so['name']}}
                            </div>
                      
                        </div>

                        <div class="portlet-body">
                            <div class="row static-info">
                                <div class="col-md-12 value">@lang('layout.Number'):<?php echo $so['number']; ?>
                                    <br> @lang('layout.Date'):<?php echo convertDate($so['date']); ?>
                                    <br> @lang('layout.Description'):<?php echo $so['description'];
                                    ?>
                                    <br> @lang('layout.Currency'):<?php echo $so['currency'];
                                    ?>
                                    <br> @lang('layout.Rate'):<?php echo $so['rate'];
                                    ?>

                                    <div >
                                        <table class="table table-bordered" >
                                            <thead>
                                                <tr>
                                                   <th>@lang('layout.ItemName')</th>
                                                   <th>@lang('layout.Quantity')</th>
                                                   <th>@lang('layout.Delivered')</th>
                                                   <th>@lang('layout.Remain')</th>
                                                   <th>@lang('layout.Measure')</th>
                                                   <th>@lang('layout.OnHand')</th>
                                                   <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($so['items']))
                                                @foreach ($so['items'] as $item)
                                                <tr>
                                                    <td>{{$item['item']}}</td>
                                                    <td>{{round(($item['item_quantity']*$item['item_unit'])/$item['sale_order_unit'],3)}}</td>
                                                    <td>{{($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']}}</td>
                                                    <td>{{($item['qty']*$item['item_unit'])/$item['sale_order_unit']}}</td>
                                                    <td>{{$item['sale_order_measur']}}</td>
                                                    <td>{{inventoryItem($item['inventory_id'])*$item['item_unit']/$item['sale_order_unit']}}</td>
                                                    <td> 
                                                        {{inventoryItem($item['inventory_id'])-$item['qty']*$item['item_unit']/$item['sale_order_unit']}}
                                                        @if($item['qty']== 0)
                                                       <span class="fa fa-times" style="color:red"></span>
                                                        @endif
                                                       @if($item['qty']>0)
                                                        <span class="fa fa-check" style="color:blue"></span>
                                                       @endif
                                                    </td>
                                                 </tr>
                                               @endforeach
                                               @endif
                                            </tbody>
                                        </table>

                                    </div>
                                
                                     
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                    <?php endforeach ?>
        


            </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>




    <!-- END CONTENT BODY -->


@stop

@push('scripts')


@endpush
