@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('style')
    <style>
    </style>
@stop
@section('content')
    @include("layouts.Cmodal")
    @include("bills.modal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    @if($duplicate)
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.WriteChecks') </span>
                    @else 
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateWriteChecks') </span>
                    @endif
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN Margin And Markup  Modal--> 
                    @if(getMarginAndMarkup()=="true")
                        <modal v-if="showMarginMarkupModal" @close="showMarginMarkupModal = false">
                                <div slot="body">
                                    <div class="row">
                                    <table class="table table-striped table-bordered table-hover" cellspacing="0"
                                        width="100%">
                                        <thead>
                                        <tr>
                                            <th style="text-align: center;">@lang('layout.Item')</th>
                                            <th style="text-align: center;">@lang('layout.CurrentCost')</th>
                                            <th style="text-align: center;">@lang('layout.CurrentSalePrice')</th>
                                            <th style="text-align: center;">@lang('layout.CurrentMarkup')</th>
                                            <!-- <th style="text-align: center;">@lang('layout.CurrentMargin')</th> -->

                                            <th style="text-align: center;">@lang('layout.NewSalePrice')</th>

                                            <th style="text-align: center;">@lang('layout.NewMarkup')</th>
                                            <!-- <th style="text-align: center;">@lang('layout.NewMargin')</th> -->
                                        </tr>
                                        </thead>
                                        <tr>
                                            <td style="text-align: center;">@{{item_name}} </td>
                                            <td style="text-align: center;">@{{myRound(current_cost)}} @{{selected_currency.symbol}}</td>
                                            <td style="text-align: center;">@{{myRound(current_rate)}} @{{selected_currency.symbol}}</td>
                                            <td style="text-align: center;">@{{myRound(markup_c)}} %</td>
                                            <!-- <td style="text-align: center;">@{{myRound(margin_c)}} %</td> -->

                                            <td style="text-align: center;">@{{myRound(sale_rate_new)}} @{{selected_currency.symbol}}</td>

                                            <td style="text-align: center;">@{{myRound(markup_new)}} %</td>
                                            <!-- <td style="text-align: center;">@{{myRound(margin_new)}} %</td> -->
                                        </tr>
                                    </table>
                                        <div class="col-md-12 form-group">
                                                    <label class=" control-label" style="font-weight: bold; color:red">@lang('message.MarginMarkupMsg')</label>
                                                    <div>
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox" @click="chacge_sale_price(selected_index)" name="change_sale_price" value="ok" >
                                                        <span></span>
                                                        </label>
                                                    </div>
                                            </div>

                                        

                                    </div>

                                </div>
                                <!-- <h3 slot="header">
                                    <div class="col-md-4">
                                        <h3>
                                            @lang('layout.MarginAndMarkup')
                                        </h3>
                                        <p>@lang('layout.Item'): @{{item_name}}</p>
                                        
                                    </div>
                                </h3> -->
                                <div slot="footer">
                                    <button type=button class="modal-default-button"
                                    v-on:click="showMarginMarkupModal = false">
                                    @lang('layout.Close')
                                </button> 
                                <!-- <button type=button class="btn blue"
                                    v-on:click="showMarginMarkupModal = false ,measure = null , type=null">
                                    @lang('layout.Submit')
                                </button> -->
                            </div>
                        </modal>
                    @endif
                <!-- End Margin And Markup  Modal--> 
                <!-- BEGIN FORM-->
                @if($duplicate)
                {{Form::open(['route' => ['purchase.store',$purchase->id],'method' => 'post','class' => 'form-horizontal','id'=>'purchase-form'])}}
                @else 
                {{Form::open(['route' => ['purchase.update',$purchase->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'purchase-form'])}}
                @endif
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="showWhat('member_class')=='yes'">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.MemberClass')</label>
                                            <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                            <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <div class="input-group">
                                                <v-select label="name" @input="memberChange()" :options="vendor" @search="MemberSearch"  v-model="selected_vendor"></v-select>
                                                <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                                               
                                                <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class=" form-group">
                                        <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                        <div>
                                            <input type="text" name="other_member_name"  value="{{$purchase->other_member_name}}"  class="form-control">
                                        </div>
                                    </div>
                               </div>
                               <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        @if($duplicate)
                                        <div class="">
                                            <label class="control-label">@lang('layout.BillNumber')</label>
                                            <input type="number" name="number" value="{{$numberDuplicate}}"  class="form-control">
                                        </div> 
                                        @else 
                                        <div class="">
                                            <label class="control-label">@lang('layout.BillNumber')</label>
                                            <input type="number" name="number" value="{{$purchase->number}}"  class="form-control">
                                        </div>
                                        @endif
                                    </div>
                                </div>
                                
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select label="code" @input="selectedRate" :options="currency" @keyup.native="editKey = true" @click.native="editKey = true" v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" :value="selected_currency.code">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Rate')</label>
                                            <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate"
                                            class="form-control" :class="{'has-error':rate<=0}" :readonly="averageRate" >
                                        </div>
                                        <input type="hidden" name="currency_rate_hq" :value="selected_currency.hq_rate" v-if="selected_currency">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Discount')</label>
                                            <div class="input-group">
                                                <input v-model="discountFiled" class="form-control" type="number" min="0">
                                                <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                    <input type="hidden" class="input-group-addon" name="discount_type"  value="currency">
                                                </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                    <input type="hidden" name="discount_type" value="percent">
                                                </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @if(systemConfig()[20] == 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','contractName')) displayNone @endif">
                                        <div class="form-group">
                                            <div class="">
                                                <label class="control-label">@lang('layout.ContractName')</label>
                                                <v-select v-model="selected_contract" label="Contract_Name" :options="contract"></v-select>
                                                <input type="hidden" name="contract_id"  :value="(this.selected_contract==null)?null:selected_contract.id">
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','referenceNumber')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                            <input type="text" name="ref_no" v-model="ref_no" class="form-control"  @input="checkRefNo()">
                                            <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 20px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <v-select label="name" :options="approperiateBank" v-model="selected_banks" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?set_avg_rate_bank(selected_banks):''" ></v-select>
                                            <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','date')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" value="{{$purchaseInfo->date}}" name="date" class="form-control date" autocomplete="off"
                                            @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                            <span class="required">@{{ errors.first('date') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12 @if(!getCustomeForm('purchase','hour')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Hour')</label>
                                            <div class="input-group">
                                                @if(getHourType() == 24)
                                                <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$purchase->hour}}">
                                                @else
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$purchase->hour}}" >
                                                @endif
                                                <span class="input-group-btn">
                                                    <button class="btn default" type="button">
                                                        <i class="fa fa-clock-o"></i>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-1 col-md-1 col-sm-2 col-xs-12 @if(!getCustomeForm('purchase','precision')) displayNone @endif" >
                                    <label class="mt-checkbox mt-checkbox-outline">@lang('layout.Precision')
                                        <input type="checkbox"  v-model="p_total" >
                                        <span></span>
                                    </label>
                                </div>
                                <div class="col-lg-10 col-md-12 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','description')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1">{{$purchase->description}}</textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','editDescription')) displayNone @endif">
                                    <label class="control-label">@lang('layout.EditDescription')</label>
                                    <div class="col-md-12 mt-checkbox">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="edit_des" value="yes" >
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <!-- begin total -->
                                <div class="well " style="padding:10px; margin-bottom: 5px;">
                                    <table class="dashboard-tabel" width="100%"> 
                                        <tr>
                                            <td>
                                                <small style="font-weight: bolder;font-size:20px">@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800" style="font-weight: bolder;font-size:20px">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds ))}}</span>
                                                <small class="font-green-sharp" style="font-weight: bolder;font-size:20px">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Discount'): (@{{
                                                    Number.parseFloat(discount).toFixed(precision()) }}%)
                                                </small>
                                            </td>
                                            <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Sub-Total'):</small>
                                            </td>
                                            <td class="text-right">
                                                <span class="text-right" data-counter="counterup"data-value="7800">@{{ format_number( Number(subtotal))}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <!-- end total -->
                            </div>
                        </div>
                        <div class="col-lg-9 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <label class="control-label">@lang('layout.ItemName')</label> -->
                                    <v-select label="name" ref="barcode_search" @input="loadItemGeneral()"  v-model="selected_inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.ItemName')" ></v-select>
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <label class="control-label">@lang('layout.Site')</label> -->
                                    <v-select label="site_name" v-model="selected_iventory_site" :options="inventory_sites1" placeholder="@lang('layout.Site')"></v-select>
                                </div>
                                <p v-if="selected_itemes && selected_iventory_site" >
                                    @{{(selected_itemes && selected_iventory_site)?(Number.parseFloat(selected_iventory_site.OnHand * selected_itemes.measure_unit / selected_itemes.measure.measure_unit).toFixed(2)):''}} @{{(selected_itemes)?selected_itemes.measure.measure_name:''}}
                                </p>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <div class="col-md-12"> -->
                                        <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                        <input type="number" v-model.number="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                    <!-- </div> -->
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <div class="col-md-12"> -->
                                        <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                        <select v-model="(selected_itemes == null)?null:selected_itemes.measure" class="form-control" >
                                            <option value="null">@lang('layout.Select')</option>
                                            <span v-if="(selected_itemes ==null)?false:true">
                                                <option v-for="measure in (selected_itemes==null)?null:selected_itemes.measure_list" :value="measure">
                                                    @{{measure.measure_name}}
                                                </option>
                                            </span>
                                        </select>
                                    <!-- </div> -->
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" >
                                <div class="form-group">
                                    <!-- <div class="col-md-12"> -->
                                        <!-- <label class="control-label">@lang('layout.Price')</label> -->
                                        <input type="number" v-model.number="selected_price" class="form-control input-style input-number" placeholder="@lang('layout.Price')">
                                    <!-- </div> -->
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  style="padding: 0px !important; display: flex; justify-content: center; gap: 5px;" >
                                <button type="button" @click="addData()" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                <button type="button" @click="resetData()" class="btn btn-danger"><i class="fa fa-times"></i></button>
                            </div>
                        </div>
                        <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: auto;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                @if(getSerailNumber() =="true")
                                    <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                @endif
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                @if(showLocation()=="true")
                                <th style="min-width: 100px"> @lang('layout.Location') </th>
                                @endif
                                <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Description1') </th>
                                <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Model') </th>
                                <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Color') </th>
                                <th v-show="showWhat('expire_date')=='yes'" style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue2')
                                </th>
                                @if(getShowCBM()=="true")
                                <th style="min-width: 100px">@lang('layout.CBM')</th>
                                @endif
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.Cost') </th>
                                @if(getM2()!="")	
                                    <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                @endif
                                <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td v-show="showWhat('inventory_brand')=='yes'">
                                    <v-select label="name" v-model="item.item_brand" :options="brandItem" @Click.native="itemBrandChange(index)" @input="itemBrandChange(index)"></v-select>
                                    <input type="hidden" name="inventory_brand_id[]" :value="(!item.item_brand)?null:item.item_brand.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" @input="(editKey)?onItemload(index):''" @keyup.native="editKey = true" @Click.native="editKey = true" v-model="item.inventory"
                                              :options="temp_items" @search="onItemSearch"></v-select>
                                    <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                    <input type="hidden" name=" stock_id[]" :value="(item==null)?null:item.stock_id">
                                    <input type="hidden" name="purchase_order_detail_id[]" :value="(!item.item)?null:item.item.purchase_order_detail_id">
                                </td>
                                @if(getSerailNumber() =="true")
                                    <td>
                                        @{{(!item.item)?null:item.item.number}}
                                    </td>
                                @endif
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>

                                    <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">

                                    @if(showLocation()=="true")
                                    <td>
                                        <input name="location[]" v-model="(item.item==null)?null:item.item.location" type="text" class="form-control" placeholder="@lang('layout.Location')">
                                    </td>
                                    @endif
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" v-model="(item.item==null)?null:item.item.description"
                                           placeholder="@lang('layout.Description1')" name="inventory_description[]"
                                           oninput = "autowidths(event)"
                                           class="form-control chan_length" />
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Model')" v-model="(item.item==null)?null:item.item.model"
                                    oninput = "autowidths(event)" name="model[]" class="form-control chan_length">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input type="text" placeholder="@lang('layout.Color')" v-model="(item.item==null)?null:item.item.color"
                                    oninput = "autowidths(event)" name="color[]" class="form-control chan_length">
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
									<date_picker :name="'expire_date['+index+']'" v-model="(item.item==null)?null:item.item.expire_date" placeholder="@lang('layout.ExpireDate')" ></date_picker>
                                </td>
                                <td>
                                    <input type="number" name="quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.Quantity')">
                                </td>

                                <td>
                                    @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity,item.item.old_quantity))}}
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           v-model.number="(item.item==null)?null:item.item.other_measure"
                                           oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                           v-model.number="(item.item==null)?null:item.item.other_measure2"
                                           oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                @if(getShowCBM()=="true")
                                <td>
                                    <input type="number" name="cbm[]" v-model.number="(item.item==null)?null:item.item.cbm" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.CBM')">
                                </td>
                                @endif
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <vue-numeric v-if="item.item"
                                        class="form-control chan_length"
                                        oninput = "autowidths(event)"
                                        v-model="item.item.cost"
                                        :max="99999999999999"
                                        currency=""
                                        :precision="((p_total)?7:precision())"
                                        @input="setNewRate(index)"
                                        @change="showMarginMarkup(index)"
                                        >
                                    </vue-numeric>
                                    <input type="hidden" name="inventory_price[]" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate,((p_total)?7:precision()),  selected_currency.static_rate)" >
                                    <input type="hidden" name="sale_rate_new[]" :value="(item.item==null)?null:item.new_sale_price" class="form-control" >
                                </td>
                                @if(getM2()!="")	  
                                    <td>
                                        <div class="input-group">
                                            <select class="form-control" v-model="(item.item==null)?null:item.item.measure1">
                                                <option value="null">@lang('layout.Select')</option>
                                                <span v-if="(item.item ==null)?false:true">
                                                    <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                    @{{measure.measure_name}}
                                                </option> 
                                                </span>
                                            </select>
                                            @if(getSaleAmountSecondMeasure()=="true")	
                                            <span class="input-group-addon">
                                                @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                            </span>
                                            @endif
                                            <input type="hidden" name="measure1[]" :value="(item.item==null)?null:((item.item.measure1==null)?null:item.item.measure1.measure_id)">
                                        </div>
                                    </td>
                                @endif
                                <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               oninput = "autowidths(event)"
                                               class="form-control chan_length">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                        @{{selected_currency.symbol}}
                                      </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                        %
                                      </span>
                                    </div>

                                </td>
                                <td>
                                    <input type="number" :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount, null, null, null, selected_currency.static_rate).result" ref="total" @input="setQuantityByTotal(index)"  class="form-control">
                                    
                                    {{-- <div>
                                        <div class="input-group">
                                            <input type="number" class="form-control inner_input chan_length"
                                                   :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount).result"
                                                   oninput = "autowidths(event)"
                                                   placeholder="@lang('layout.Total')" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                        </div>
                                    </div> --}}
                                </td>
                                <td>
                                    @if($edit_sale != 'yes')
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                    class="paddint-both glyphicon glyphicon-trash"></i></span>
                                    @endif
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',1000)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>

                    </div>
                    
                    @if(getInvoiceTotal() == 'true') 
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

                        <!-- begin total -->
                        <div class="dashboard-stat2 ">
                            <table class="dashboard-tabel" width="100%">
                                
                                <tr>
                                    <td>
                                        <small>@lang('layout.Sub-Total'):</small>
                                    </td>
                                    <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                            data-value="7800">@{{ format_number( Number(subtotal))}}</span>
                                        <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                    </td>
                                    <td>
                                        <small>@lang('layout.Discount'): (@{{
                                            Number.parseFloat(discount).toFixed(precision()) }}%)
                                        </small>
                                    </td>
                                    <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                            data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                        <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                    </td>

                                    <td>
                                        <small>@lang('layout.Total') :</small>
                                    </td>
                                    <td class="text-right"><span data-counter="counterup"
                                                                data-value="7800">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds ))}}</span>
                                        <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                    </td>
                                  
                                </tr>


                            </table>

                        </div>

                    <!-- end total -->
                    </div>
                    @endif 
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Memo')</label>
                                    <textarea name="memo" class="form-control" rows="2">{{$purchase->memo}}</textarea>
                                </div>
                            </div>
                        </div>
                    </div> 
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="isError1 ==false" v-if="!isError" @click="submitForm" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                    @if(!$duplicate)
                    <button type="button" v-if="isError1 ==false" v-if="!isError" :disabled="disabled" class="btn blue" @click="saveAndNew($event)">@lang('layout.Check') / @lang('layout.Update')</button>
                    @endif
                    <a href="{{route('purchase.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script type="text/javascript">

        @if(App::getLocale())
            Vue.use(VeeValidate, {
                locale: '{{App::getLocale()}}',
            });
            @else
            Vue.use(VeeValidate, {
                locale: 'en',
            });
            @endif
        Vue.component('v-select', VueSelect.VueSelect);

        Vue.use(VueInputAutowidth);
        Vue.use(VueNumeric.default)

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],
            created() {
                console.log('rrrrr');
            }

        }); 

        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null, 
                    classes: [],
                    selectedClass: null,

                }
            },
            created() { 
                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }
                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_vendor = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });
 
        var selectedVendor ={!! $selectedVendor !!};
        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var purchase ={!! $purchase !!};
        var purchaseInfo = {!! $purchaseInfo !!};
        var purchaseContract ={!! $purchaseContract !!};
        var inventory_category = {!! $inventory_category !!};
        var memberClass = {!! $memberClass !!};
        var inventoryBrand = {!! $inventoryBrand !!};

        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                vendor: [],
                all_vendor: [],
                selected_vendor: selectedVendor,
                contract: [],
                selected_contract: null,
                editKey: false,
                banks: banks,
                selected_banks: null,
                currency:{!! $currency !!},
                selected_currency:{!! $selectedCurrency !!},
                selected_item:{!! $selectedItem !!},
                purchase: purchase,
                purchase_info: purchaseInfo,
                brandItem: inventoryBrand,
                selected_iventory_brand: null,
                rate: 0,
                discountFiled: 0,
                discountFiledRow: 0,
                discountIsAmount: false,
                disabled: false,
                averageRate: false,
                editKey: false,
                p_total: true,
                counter_check: 0,
                counter_check1: 1,
                counter_check2: -1,
                temp_items: [],
                inventory_category: inventory_category,
                selected_category: null,
                selected_index: 0,
                totalAmountes: [],
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [],
                payments: [],
                memberClass: memberClass,
                selected_class: null,
                ref_no: "{{$purchaseInfo->ref_Number}}",
                msg: '',
                isError1: false, 
                item_name:null,
                markup_c:null,
                margin_c:null,
                margin_new:null,
                markup_new:null,
                current_cost:null,
                current_rate:null,
                sale_rate_new:null,
                change_sale_price:false,
                showMarginMarkupModal: false, 
                selected_inventory: null,
                selected_inventory1: null,
                inventory_sites1: [],
                selected_iventory_site: null,
                selected_itemes: null,
                selected_quantity: null,
                selected_price: null, 
            }, 
            computed: {
                selectedRate() {
                    if(this.selected_currency){
                        this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                        for (var i = 0; i < this.inventories.length; i++) {
                            if (this.inventories[i].item && this.inventories[i].item != null) {
                                if (this.inventories[i].item.new_rate) {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif 
                                }
                            }
                        }
                    }
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                // subtotal: function () {
                    // var sum = 0;
                    // for (var i = 0; i < this.inventories.length; i++) {
                        // if (this.inventories[i].item && this.inventories[i].item != null) {
                            // var quantity = this.inventories[i]['item']['quantity'];
                            // var rate = this.inventories[i]['item']['rate'];
                            // var new_rate = this.inventories[i]['item']['new_rate'];
                            // var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            // var measure_unit = this.inventories[i]['item']['measure_unit'];
                            // if (new_rate && quantity > 0) {
                                // sum += new_rate * quantity * this.selected_currency.rate;
                            // }
                            // else {
                                // sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            // }

                        // }

                    // }
                    // // for (var i = 0; i < this.services.length; i++) {
                    // //     if (this.services[i].item)
                    // //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // // }
                    // return sum;
                // },
				
				
				// calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var sum_discount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var discount = this.inventories[i]['item']['discount'];
                            if (new_rate != rate && quantity > 0) {

                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif

								
								if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {

									if (discount > 0) {

                                    @if(systemConfig()[30] == 1)
                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                    @else 
                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                    @endif

									}
								}
								
								
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) *  this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
								
								if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {

									if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                        @else 
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                        @endif
                                    }
								}
                            }


                        }
                        // this.totalAmountes=sum;

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
					
					
					
					this.discountFiledRow = sum_discount;
					
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) { 
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] * this.selected_currency.static_rate / this.selected_currency.rate) / this.payments[i]['item']['rate']);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif
                            
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                @if(getAddItemWithZeroRate() != 'true')
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }
                                @endif
                            }
                        }
                    }
                    if (this.inventories.length == 0 || this.selected_vendor == undefined || this.selected_vendor == null || !this.selected_banks || this.selected_banks == null || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                // initialize the selected item
                for (var i = 0; i < this.selected_item.length; i++) {
                    // console.log('item', this.selected_item);
                    this.inventories.push({
                        inventory: this.selected_item[i],
                        item: this.selected_item[i],
                        item_category: this.selected_item[i].item_category,
                        item_brand: this.selected_item[i].inventoryBrand,
                        new_sale_price:this.selected_item[i].sale_price,
                        stock_id:this.selected_item[i].stock_id
                    });
                }
                // for (var m = 4; m > this.selected_item.length; m--) {
                    this.inventories.push({inventory: null,  item_category: null, item_brand: null, item: null,new_sale_price:null,stock_id:null});
                // }
                // initialize payments

                for (var j = 0; j < this.banks.length; j++) {
                    if (this.banks[j].id == this.purchase_info.Account_id) {
                        this.selected_banks = this.banks[j];
                    }
                }

                // end payment

                if (this.purchase) {
                    
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.purchase.class_id);
                    this.discountFiled = this.purchase.discount;
                    if (this.purchase.discount_type) {
                        if (this.purchase.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
                }
            },
            methods:
                {

                    set_avg_rate_bank(defaultAccount) {
                        // console.log(21);
                        let vv = this;
                        this.averageRate = false;
                        @if(getAverageRate() =="true")
                        if (defaultAccount) {
                            if (defaultAccount.avg_rate) {
                                setTimeout(() => {
                                    vv.averageRate = true;
                                    vv.selected_currency.rate = defaultAccount.avg_rate;
                                }, 300);
                            }
                        }
                        @endif
                    },
                    checkRefNo() {

                        //console.log(vm.ref_no)

                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'purchases'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },
                    
                    memberClassChange() {
                        if (v.selected_class) {
                            v.vendor = [];
                            let class_id = v.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Vendor'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.vendor = [];
                                    v.vendor = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Vendor'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.vendor = [];
                                v.vendor = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    showMarginMarkup(index) {
						if (v.inventories[index].item != null) {
                            v.selected_index = index;
						v.showMarginMarkupModal = true;

						v.SNumber = v.inventories[index]['item']['number'];
						v.item_name = v.inventories[index]['item']['name'];

                        var rate=v.inventories[index]['item']['sale_price'];
                        var cost=v.inventories[index]['item']['new_rate'];
                        var cost_old=v.inventories[index]['item']['rate'];

                        
                        
                        // var resultm = 0;
                        // var result1 = (100*rate)/cost;
                        // var markup = result1-100;
                        // resultm = myRound((markup*cost)/rate);

                        
                        // var resultMarkup  = (100*rate)/cost;
                        // resultMarkup = myRound(resultMarkup-100);

                        var resultCurrentMargin = (100*rate)/cost_old;
                        var markupCurrent = resultCurrentMargin-100;
                        resultCurrentMargin = myRound((markupCurrent*cost_old)/rate);

                        var resultCurrentMarkup  = (100*rate)/cost_old;
                        resultCurrentMarkup = myRound(resultCurrentMarkup-100);

                        var resultNewSalePrice = 0;
                        var total =Number.parseFloat(resultCurrentMarkup)+100;
                        resultNewSalePrice = (cost*total)/100;


                        var res_cu_markup  = (100*rate)/cost;
                        res_cu_markup = myRound(res_cu_markup-100);


						v.markup_c = res_cu_markup;
						v.margin_c = resultCurrentMargin;
                        
						@if(systemConfig()[30] == 1)
                        v.current_cost = v.inventories[index]['item']['rate']* v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
                        v.current_cost = v.inventories[index]['item']['rate']* v.selected_currency.rate;
                        @endif

                        @if(systemConfig()[30] == 1)
                        v.current_rate = v.inventories[index]['item']['sale_price']* v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
                        v.current_rate = v.inventories[index]['item']['sale_price']* v.selected_currency.rate;
                        @endif

                        @if(systemConfig()[30] == 1)
						v.sale_rate_new = resultNewSalePrice* v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
						v.sale_rate_new = resultNewSalePrice* v.selected_currency.rate;
                        @endif

                        @if(systemConfig()[30] == 1)
                        var new_s_rate = v.sale_rate_new/v.selected_currency.static_rate * v.selected_currency.rate;
                        @else 
                        var new_s_rate = v.sale_rate_new/v.selected_currency.rate;
                        @endif


                        var resultMarkup  = (100*new_s_rate)/cost;
                        resultMarkup = myRound(resultMarkup-100);

						v.markup_new = resultMarkup;


                        var resultm = 0;
                        var result1 = (100*rate)/cost;
                        var markup = result1-100;
                        resultm = myRound((markup*cost)/rate);

                        v.margin_new = (resultMarkup*cost)/v.sale_rate_new;

               
                
						}
                    },
                    chacge_sale_price(index)
                    {
                        if (v.change_sale_price == false) {
                                v.change_sale_price = true;
                                v.inventories[index]['new_sale_price'] = v.sale_rate_new;
                                // console.log('ffffbbbbbbbb',index,v.inventories[index]['new_sale_price'],v.change_sale_price);
                                v.change_sale_price = false;  
                            }else{
                                v.change_sale_price = false;
                            } 
                    },
                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_vendor) {
                            // get member contract
                            this.contractSearch(this.selected_vendor.id, this);
                        }
                    },
                    // set new price
                    setNewRate(index) {
                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
                            @endif
                        }
                        // if (this.inventories[index].item) {
                        //     this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        // }
                    },

                    setQuantityByTotal(index) {
                        if (v.counter_check == 0) {
                            v.counter_check = 1;
                            setTimeout((function () {
                                v.counter_check1 = v.$refs.total[index].value;
                                v.setQuantityByT(index);
                            }), 2e2)
                        }  
                    },
                    setQuantityByT(index) {
                        setTimeout((function () {
                            v.counter_check2 = v.$refs.total[index].value;
                            v.setQuantityByTotals(index);
                        }), 2e3)
                    },
                    setQuantityByTotals(index) {
                        if (v.counter_check1 != v.counter_check2) {
                            v.counter_check1 = v.$refs.total[index].value;
                            v.setQuantityByT(index);
                        }else{
                            v.p_total = true;
                            if (v.$refs.total[index].value) {
                                if (v.inventories[index].item) {
                                    if (v.inventories[index]['item']['quantity']) {
                                        var quantity = v.inventories[index]['item']['quantity']; 
                                        @if(systemConfig()[30] == 1)
                                        v.inventories[index].item.new_rate = (v.$refs.total[index].value / quantity) / v.selected_currency.static_rate * v.selected_currency.rate;
                                        @else 
                                        v.inventories[index].item.new_rate = (v.$refs.total[index].value / quantity) / v.selected_currency.rate;
                                        @endif 
                                        v.inventories[index].item.cost = v.$refs.total[index].value / quantity;
                                    }
                                }
                            }
                            v.counter_check = 0; 
                        }
                    },

                    secoundMeasurQuantity(item = null, quantity = null) {
						if (item != null) {
							var result = 0;
							if (item.site) {
								// console.log(3838399,item.measure_list, item.measure1);
								if(item.measure_list && item.measure1){
                                    for (var i in item.measure_list) {
								// console.log(3838,item.measure_list[i],item.measure_unit,item.measure.measure_unit);
									if (item.measure_list[i].measure_id == item.measure1.measure_id) {
										result = (quantity * item.measure.measure_unit) / (item.measure_unit);
										result = (result * item.measure_unit) / (item.measure_list[i].measure_unit);
									}
								}
                                }
							}
							return result;
						}
					},
                    
                    // begin item search

                    onItemSearch: _.debounce((search, loading) => {

                        loading(true);

                        // console.log('klk',v.inventories[v.selected_index]['item_category']);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index]['item_category']);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let inventory_brand_id = (v.inventories[index]['item_brand'] != undefined) ? v.inventories[index]['item_brand'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchPurchase',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    inventory_brand_id: inventory_brand_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    loadItemGeneral() {
                        if (v.selected_inventory != undefined) {
                            this.editKey = false;
                            var inventory_id = v.selected_inventory.id;
                        
                            // console.log(888, number);
                            let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                            let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        member_id: v.member_id,
                                        method_name: 'itemSearchPurchase',
                                        inventory_id: inventory_id,
                                        inventory_category_id: inventory_category_id,
                                    }
                                })
                                .then(function(response) {

                                    var rate = 0;
                                    var static_rate = 0;
                                    if (v.selected_currency.rate > 0) {
                                        rate = v.selected_currency.rate;
                                        static_rate = v.selected_currency.static_rate;
                                    }

                                    if (response.data.length > 0) {
                                        v.selected_itemes = null;
                                        v.selected_iventory_site = null;
                                        v.selected_itemes = response.data[0];

                                        @if(systemConfig()[30] == 1)
                                        v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(static_rate) / Number.parseFloat(rate));
                                        @else 
                                        v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(rate));
                                        @endif
 
                                        v.inventory_sites1 = response.data[0].site_list;  
                                        v.last_item_sale = response.data[0].last_item_sale;  
                                        // console.log(123, response.data[0]);

                                    }else{
                                        // $('#success-sound')[0].play();
                                        // $('#error-sound')[0].play();
                                        v.item_not_found = true;
                                        setTimeout((function () {
                                            v.item_not_found = false;
                                            v.$refs.barcode_search.$refs.search.focus();
                                        }), 2e3)
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })

                        }
                    },

                    addData() {
                        if (v.selected_itemes) {
                            var che = null;
                            for (var i = 0; i < v.inventories.length; i++) {
                                if (v.inventories[i].item && v.inventories[i].item != null) {
                                    che = 'ok';
                                } else {
                                    v.inventories.splice(i, 1);
                                }
                            }
                            if(!che){
                                v.inventories = [];
                            }

                            let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';
                            if (inventory_site_id) {
                                for (var i = 0; i < v.selected_itemes.site_list.length; i++) {
                                    if (v.selected_itemes.site_list[i].site_id == inventory_site_id) {
                                        v.selected_itemes.site = v.selected_itemes.site_list[i];
                                    }
                                }
                            }

                            var rate = 0;
                            if (v.selected_currency.rate > 0) {
                                rate = v.selected_currency.rate;
                            }

                            v.selected_itemes.quantity = (v.selected_quantity > 0)?v.selected_quantity:1;
                            v.selected_itemes.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(rate)):1;
                                
                            v.inventories.unshift({
                                inventory: v.selected_itemes,
                                item: v.selected_itemes,
                                item_category: v.selected_itemes.item_category,
                                item_brand: v.selected_itemes.inventory_brand
                            });

                            v.selected_inventory = null;
                            v.selected_inventory1 = null;
                            v.counter_check = 0;
                            v.temp_items = [];
                            // v.selectSaleNumber(0);
                            @if(getShwoPriceLevel()=="general_percent")
                            setTimeout((function () {
                                v.change_sale_rate_by_price_level_general();
                            }), 400);
                            @endif

                            // const inp = v.$refs.barcode_search.$refs.search;
                            // console.log(v.$refs.barcode_search.$refs.search.value);
                            v.$refs.barcode_search.$refs.search.focus();
                            // v.$refs.barcode_search.$refs.search = null;
                            // v.$refs.barcode_search.focus();

                            v.selected_itemes = null;
                            v.selected_price = 0;
                            v.selected_quantity = 0;
                            
                        }
                    },
                    
                    resetData() {
                        v.selected_inventory = null;
                        v.selected_itemes = null;
                        v.selected_iventory_site = null;
                        v.selected_price = 0;
                        v.selected_quantity = 0;
                        v.$refs.barcode_search.$refs.search.focus();
                    },

                    setIndex(e) {
                        // v.temp_items=[];
                        this.selected_index = e;
                        // console.log('uuu', this.selected_index);
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    },

                    itemBrandChange(index) {
                        v.setIndex(index);

                        v.selected_iventory_brand = this.inventories[index]['item_brand'];
                        if (this.inventories[index]['item_brand'] != null) {
                        
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let inventory_brand_id = this.inventories[index]['item_brand'].id;
                            
                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemesSearchSale',
                                        inventory_category_id: inventory_category_id,
                                        inventory_brand_id: inventory_brand_id
                                    }
                                })
                                .then(function(response) {
                                    // if (v.purchase_orders) {
                                    // } else {
                                    //     v.inventories[index]['item'] = null;
                                    //     v.inventories[index]['inventory'] = null;
                                    // }
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });
                        
                        }

                    },

                    // end item search

                    // contract search


                    contractSearch(id, vm) {
                        vm.contract = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'member_contract',
                                member_id: id
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    vm.contract = response.data;
                                    if (vm.contract) {
                                        for (var m = 0; m < v.contract.length; m++) {

                                            if (v.contract[m].id == purchaseContract.contract_id) {
                                                v.selected_contract = v.contract[m];
                                            }
                                        }
                                    }
                                }
                                // loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {

                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({inventory: null, item: null, item_category: null, item_brand: null, stock_id: null});
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                swal({
                                    title: "@lang('layout.AreYouSure?')",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                                    text: "",
                                    icon: "info",
                                    dangerMode: true,
                                }).then((willDelete) => {
                                    if (willDelete) {
                                        this.inventories.splice(index, 1);
                                    }
                                    else {
                                        
                                    }
                                });
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {
                        this.$validator.validate().then(valid => {
                    if (valid) {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        v.disabled = true;
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("purchase-form").submit()
                            } else {
                                v.disabled = false;
                            }
                        });
                    } 
                });

                    },
                    saveAndNew() {
                        this.$validator.validate().then(valid => {
                    if (valid) {
                        if (!this.isError) {
                            v.disabled = true;
                            var url = "{{route('purchase.update',$purchase->id)}}";
                            form_id = 'purchase-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    // console.log('sss11', response.data);
                                    if (response.data.result == 1) {

                                        var a = document.createElement('a');
                                        a.href = "{{route('purchase.index')}}";
                                        document.body.appendChild(a);
                                        a.click();
                                        document.body.removeChild(a);

                                        // location.reload("{{route('purchase.index')}}");
                                    } else {
                                        v.disabled = false;
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                        // toastr.warning('', response.data[1]);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    v.disabled = false;
                                    // console.log(error,v.disabled);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        } else {
                            alert('there is no item');
                            return false;
                        }
                    } 
                });
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush