@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('style')
    <style>
    </style>
@stop
@section('content')
    @include("layouts.Cmodal")   
    @include("layouts.Invmodal")
	@include("bills.modal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.WriteChecks') </span>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
			<div id="measure">
                <modal v-if="showInfoModal" @close="showInfoModal = false">
                    <div slot="body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row col-md-12">
                                    <h4 class=" col-md-3">
                                    @lang('menu.InventoryBrand') :</h4>
                                    <h4 class="col-md-8">
                                    @{{ brand }}
                                    </h4>
                                </div>
                                <div class="row col-md-12">
                                    <h4 class=" col-md-3">
                                    @lang('layout.Location') :</h4>
                                    <h4 class="col-md-8">
                                    @{{ location }}
                                    </h4>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row col-md-12">
                                    <h4 class=" col-md-3">
                                    @lang('layout.SerialNum') :</h4>
                                    <h4 class="col-md-8">
                                    @{{ SNumber }}
                                    </h4>
                                </div>
                            </div>

                        </div>

                    </div>
                    <h3 slot="header">
                        <div class="col-md-4">
                            <h3>
                                @lang('layout.OtherInformations') @lang('layout.Item')
                            </h3>
                        </div>
                    </h3>
                    <div slot="footer">
                        <button type=button class="modal-default-button"
                        v-on:click="showInfoModal = false ,measure = null , type=null">
                        @lang('layout.Cancel')
                    </button>
                </div>
                </modal>
                </div>
                <!-- BEGIN Margin And Markup  Modal--> 
                @if(getMarginAndMarkup()=="true")
                <modal v-if="showMarginMarkupModal" @close="showMarginMarkupModal = false">
                        <div slot="body">
                            <div class="row">
                            <table class="table table-striped table-bordered table-hover" cellspacing="0"
                                width="100%">
                                <thead>
                                <tr>
                                    <th style="text-align: center;">@lang('layout.Item')</th>
                                    <th style="text-align: center;">@lang('layout.CurrentCost')</th>
                                    <th style="text-align: center;">@lang('layout.CurrentSalePrice')</th>
                                    <th style="text-align: center;">@lang('layout.CurrentMarkup')</th>
                                    <!-- <th style="text-align: center;">@lang('layout.CurrentMargin')</th> -->

                                    <th style="text-align: center;">@lang('layout.NewSalePrice')</th>

                                    <th style="text-align: center;">@lang('layout.NewMarkup')</th>
                                    <!-- <th style="text-align: center;">@lang('layout.NewMargin')</th> -->
                                </tr>
                                </thead>
                                <tr>
                                    <td style="text-align: center;">@{{item_name}} </td>
                                    <td style="text-align: center;">@{{myRound(current_cost)}} @{{selected_currency.symbol}}</td>
                                    <td style="text-align: center;">@{{myRound(current_rate)}} @{{selected_currency.symbol}}</td>
                                    <td style="text-align: center;">@{{myRound(markup_c)}} %</td>
                                    <!-- <td style="text-align: center;">@{{myRound(margin_c)}} %</td> -->

                                    <td style="text-align: center;">@{{myRound(sale_rate_new)}} @{{selected_currency.symbol}}</td>

                                    <td style="text-align: center;">@{{myRound(markup_new)}} %</td>
                                    <!-- <td style="text-align: center;">@{{myRound(margin_new)}} %</td> -->
                                </tr>
                            </table>
                                <div class="col-md-12 form-group">
                                            <label class=" control-label" style="font-weight: bold; color:red">@lang('message.MarginMarkupMsg')</label>
                                            <div>
                                                <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" @click="chacge_sale_price(selected_index)" name="change_sale_price" value="ok" >
                                                <span></span>
                                                </label>
                                            </div>
                                    </div>

                                

                            </div>

                        </div>
                        <!-- <h3 slot="header">
                            <div class="col-md-4">
                                <h3>
                                    @lang('layout.MarginAndMarkup')
                                </h3>
                                <p>@lang('layout.Item'): @{{item_name}}</p>
                                
                            </div>
                        </h3> -->
                        <div slot="footer">
                            <button type=button class="modal-default-button"
                            v-on:click="showMarginMarkupModal = false">
                            @lang('layout.Close')
                        </button> 
                        <!-- <button type=button class="btn blue"
                            v-on:click="showMarginMarkupModal = false ,measure = null , type=null">
                            @lang('layout.Submit')
                        </button> -->
                    </div>
                </modal>
                @endif
                <!-- End Margin And Markup  Modal--> 
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'purchase.store','method' => 'POST','class' => 'form-horizontal','id'=>'purchase-form'])}}
                {{ csrf_field() }}
                <!-- begin sale order modal -->
                <div id="salOrderApp" v-cloak>
                <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
                    <input type="hidden" name="type" value="invoicelist"/>
                    <!-- use the modal component, pass in the prop -->
                    <modal v-if="showModalPurchaseOrder" @close="showModalPurchaseOrder = false">
                        <div slot="body">
                            <div class="row">
                                <div class="form-group">

                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Select') </label>
                                        <select class="form-control" style="border: 1px solid black !important"
                                                v-model="selected_purchase_order" @input="">
                                            <option v-for="order in purchaseOrderList" :value="order">
                                              <span>
                                               @{{order.type+':'+order.number+' '+order.description}}
                                             </span>
                                            </option>
                                        </select>
                                    </div>


                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group">

                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Currency') </label>
                                        <input type="text" name=""
                                               :value="(!selected_purchase_order)?null:selected_purchase_order.currency"
                                               class="form-control" disabled="disabled">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Rate') </label>
                                        <input type="text" name=""
                                               :value="(!selected_purchase_order)?null:selected_purchase_order.rate"
                                               class="form-control" disabled="disabled">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">

                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Date') </label>
                                        <input type="text" name=""
                                               :value="(!selected_purchase_order)?null:selected_purchase_order.date"
                                               class="form-control" disabled="disabled">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.DeliveryDate') </label>
                                        <input type="text" name=""
                                               :value="(!selected_purchase_order)?null:selected_purchase_order.delivery_date"
                                               class="form-control" disabled="disabled">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">
                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Category') </label>
                                        <input type="text" name=""
                                               :value="(!selected_purchase_order)?null:selected_purchase_order.category"
                                               class="form-control" disabled="disabled">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Description') </label>
                                        <input type="text" name=""
                                               :value="(!selected_purchase_order)?null:selected_purchase_order.description"
                                               class="form-control" disabled="disabled">
                                    </div>

                                </div>
                            </div>
                            <br>
                            <p style="color: red">@lang('layout.SOmsg')

                        </div>

                        <div slot="footer">
                            <button type="button" v-if="selected_purchase_order" @click="getPurchaseOrders"
                                    class="btn btn-success">
                                @lang('layout.Submit')
                            </button>
                            <button type="button" class="btn btn-danger" v-on:click="showModalPurchaseOrder=false">
                                @lang('layout.Cancel')
                            </button>
                        </div>
                    </modal>
                <!-- {{Form::close()}} -->
                </div>
                <!-- end sale order modal -->
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <div class="input-group">
                                                <v-select label="name" @input="memberChange()" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                                <input type="hidden" name="vendor" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Vendor')" :value="!selected_vendor?null:selected_vendor.id" required>
                                             
                                                   <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true">
                                                    <i class="fa fa-plus" style="color: white"></i>
                                                </span> 
                                            </div>
                                            <span class="required">@{{ errors.first('vendor') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12 ">
                                            <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                            <div>
                                                <input type="text" name="other_member_name" class="form-control">
                                            </div>
                                        </div>
                                    </div>   
                                </div>
                                <div v-show="showWhat('member_class')=='yes'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.MemberClass')</label>
                                            <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                            <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.BillNumber')</label>
                                            <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.BillNumber')" v-model="number" @input="checkNo()" class="form-control">
                                            <span class="required">@{{ errors.first('number') }}</span>
                                            <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-2 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                            <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')"  :value="selected_currency.code">
                                            <span class="required">@{{ errors.first('currency') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Rate')</label>
                                            <input type="number" name="currency_rate" v-validate="'required'"
                                                   data-vv-as="@lang('layout.Rate')"  :readonly="averageRate"
                                                   v-model="!selected_currency?0:selected_currency.rate"
                                                   class="form-control" :class="{'has-error':rate<=0}">
                                            <span class="required">@{{ errors.first('currency_rate') }}</span>
                                            <input type="hidden" name="currency_rate_hq" :value="selected_currency.hq_rate" v-if="selected_currency">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Discount')</label>
                                            <div class="input-group">
                                                <!--input v-if="showWhat('sale_discount')=='yes'" v-model="discountFiled" class="form-control" type="number" min="0" readonly -->
                                                <input v-model="discountFiled" class="form-control" type="number" min="0">
                                                <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                </span>
                                                <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                  <input type="hidden" name="discount_type" value="percent">
                                                </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @if(systemConfig()[20] == 1)
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','contractName')) displayNone @endif">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ContractName')</label>
                                                <v-select label="Contract_Name" :options="contract" v-model="selected_contract"></v-select>
                                                <input type="hidden" name="contract_id" :value="(this.selected_contract==null)?null:selected_contract.id">
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','referenceNumber')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                            <input type="text" name="ref_no" v-model="ref_no" class="form-control"  @input="checkRefNo()">
                                            <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0px 10px;">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <v-select label="name" :options="approperiateBank" v-model="selected_banks" @input="set_avg_rate_bank(selected_banks)"></v-select>
                                            <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','date')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" name="date" class="form-control date" autocomplete="off"  @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                            <span class="required">@{{ errors.first('date') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','hour')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Hour')</label>
                                            <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                @if(getHourType() == 24)
                                                <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                @else
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                @endif
                                                <span class="input-group-btn">
                                                    <button class="btn default" type="button">
                                                        <i class="fa fa-clock-o"></i>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12 @if(!getCustomeForm('purchase','salePrice')) displayNone @endif">
                                    <table class="table table-striped table-bordered table-advance ">
                                        <tr>
                                            <td class="t_body">
                                                <div>
                                                    <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SalePrice')
                                                        <input type="checkbox" name="check_sale_price" v-model="sale_price">
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')                    
                                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12 @if(!getCustomeForm('purchase','whatsapp')) displayNone @endif">
                                        <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox"  name="whatsapp" value="5" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                @endif
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 @if(!getCustomeForm('purchase','description')) displayNone @endif">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="well " style="padding: 10px; margin-bottom: 5px;margin-top: 5px;">
                                    <table class="dashboard-tabel">
                                        <tr>
                                            <td>
                                                <small style="font-weight: bolder;font-size:20px">@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800" style="font-weight: bolder;font-size:20px">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds ))}}</span>
                                                <small class="font-green-sharp" style="font-weight: bolder;font-size:20px">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Discount'): (@{{
                                                    Number.parseFloat(discount).toFixed(precision()) }}%)
                                                </small>
                                            </td>
                                            <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Sub-Total'):</small>
                                            </td>
                                            <td class="text-right">
                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number( Number(subtotal))}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12"  style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                            {{-- <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                <div class="form-group"> --}}
                                    {{-- <label class="control-label">@lang('layout.SerialNum')</label> --}}
                                    {{-- <input type="text" v-model="selected_inventory1" ref="barcode_search1" placeholder="@lang('layout.SerialNum')" class="form-control" @input="callOnItemloadGeneral(), editKey = false" >
                                    --}}
                                    
                                    <div class="col-lg-2 col-md-6 col-sm-12 col-xs-12">  
                                        <div class="input-group">
                                            <input type="text"  v-model="selected_inventory1"  placeholder="@lang('layout.SerialNum')"  ref="barcode_search1" class="form-control" @input="(!check_with_key)?callOnItemloadGeneral():''" >
                                            {{-- <input type="number" v-model="exchange_amount" @input="set_rate(), getTranslateToWordExchange()" class="form-control" min="0" step="any"> --}}
                                            <span class="input-group-addon">
                                                <input type="checkbox" v-model="check_with_key" title="{{ __('layout.SearchItemsWithSpecificKey') }}">
                                                <span></span>
                                            </span>
                                        </div>
                                        <span v-if="item_not_found" class="required">@lang('layout.ItemNotFound')</span> 
                                    </div> 

                                {{-- </div>
                            </div> --}}
                            <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <label class="control-label">@lang('layout.ItemName')</label> -->
                                    <div class="input-group">
                                        <v-select label="name" ref="barcode_search" @input="loadItemGeneral()"  v-model="selected_inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.ItemName')" ></v-select>
                                        <span class="btn btn-success input-group-addon " title="@lang('layout.AddNewItem')" @click="showInvModal = true">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <label class="control-label">@lang('layout.Site')</label> -->
                                    <v-select label="site_name" v-model="selected_iventory_site" :options="inventory_sites1" placeholder="@lang('layout.Site')"></v-select>
                                </div>
                                <p v-if="selected_item && selected_iventory_site" >
                                    @{{(selected_item && selected_iventory_site)?(Number.parseFloat(selected_iventory_site.OnHand * selected_item.measure_unit / selected_item.measure.measure_unit).toFixed(2)):''}} @{{(selected_item)?selected_item.measure.measure_name:''}}
                                </p>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                <div class="form-group"> 
                                    <input type="number" v-model.number="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <div class="col-md-12"> -->
                                        <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                        <select v-model="(selected_item == null)?null:selected_item.measure" @input="changeMesurss()" class="form-control" >
                                            <option value="null">@lang('layout.Select')</option>
                                            <span v-if="(selected_item ==null)?false:true">
                                                <option v-for="measure in (selected_item==null)?null:selected_item.measure_list" :value="measure">
                                                    @{{measure.measure_name}}
                                                </option>
                                            </span>
                                        </select>
                                    <!-- </div> -->
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" >
                                <div class="form-group">
                                    <!-- <div class="col-md-12"> -->
                                        <!-- <label class="control-label">@lang('layout.Price')</label> -->
                                        <input type="number" v-model.number="selected_price" class="form-control input-style input-number" placeholder="@lang('layout.Price')">
                                    <!-- </div> -->
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;display: flex; justify-content: center; gap: 2px;" >
                                <button type="button" @click="addData()" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                <button type="button" @click="resetData()" class="btn btn-danger"><i class="fa fa-times"></i></button>
                            </div>
                        </div>
                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                    <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                    <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                    @if(getSerailNumber() =="true")
                                        <th style="min-width: 80px">@lang('layout.SerialNum') </th>
                                    @endif
                                    <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                    @if(showLocation()=="true")
                                    <th style="min-width: 100px"> @lang('layout.Location') </th>
                                    @endif
                                    <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Description1') </th>
                                    <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Model') </th>
                                    <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Color') </th>
                                    <th v-show="showWhat('expire_date')=='yes'"
                                        style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                    <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                    <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                    <th v-show="showWhat('other_measure')=='yes'"
                                        style="min-width: 100px">@lang('layout.OMeasureValue1')
                                    </th>
                                    <th v-show="showWhat('other_measure2')=='yes'"
                                        style="min-width: 100px">@lang('layout.OMeasureValue2')
                                    </th>
                                    @if(getShowCBM()=="true")
                                    <th style="min-width: 100px">@lang('layout.CBM')</th>
                                    @endif

                                    <th style="min-width: 100px">@lang('layout.Measure') </th>
                                    <th style="min-width: 100px">@lang('layout.Cost') ({{getHomeCurrency()['code']}})</th>
                                    <th style="min-width: 100px">@lang('layout.Cost') (@{{selected_currency.code}}) </th>
                                    @if(getM2()!="")	
                                        <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                    @endif
                                    <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                    <th v-show="sale_price" style="min-width: 100px">@lang('layout.SalePrice') </th>
                                    <th style="min-width: 100px">@lang('layout.Total') </th>

                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(item,index) in inventories">
                                    <td>@{{index+1}}</td>
                                    <td v-show="showWhat('sale_category')=='yes'">
                                        <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                                @input="itemCategoryChange(index)"></v-select>
                                        <input type="hidden" name="inventory_category_id[]"
                                            :value="(!item.item_category)?null:item.item_category.id">
                                    </td>
                                    <td v-show="showWhat('inventory_brand')=='yes'">
                                        <v-select label="name" v-model="item.item_brand" :options="brandItem" @Click.native="itemBrandChange(index)" @input="itemBrandChange(index)"></v-select>
                                        <input type="hidden" name="inventory_brand_id[]" :value="(!item.item_brand)?null:item.item_brand.id">
                                    </td>
                                    <td class="highlight">
                                    <div class="input-group">
                                        <v-select label="name" @input="(editKey)?onItemload(index):''" @keyup.native="editKey = true" @Click.native="editKey = true" v-model="item.inventory"
                                                :options="temp_items" @search="onItemSearch"></v-select>
                                        <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'"
                                            data-vv-as="@lang('layout.ItemName')"
                                            :value="(!item.item)?null:item.item.id">
                                        <input type="hidden" name="purchase_order_detail_id[]"
                                            :value="(!item.item)?null:item.item.purchase_order_detail_id">
                                        <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                        <span class="btn btn-success input-group-addon" @click="showInfo(index)">
                                                                <i class="fa fa-info"></i></span>	
                                    </div>
                                    </td>
                                    @if(getSerailNumber() =="true")
                                        <td>
                                            @{{(!item.item)?null:item.item.number}}
                                        </td>
                                    @endif
                                    <td class="highlight">
                                        <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                            <option value="null">@lang('layout.Select')</option>
                                            <span v-if="(item.item != null)">
                                            <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                    :value="site">
                                                @{{site.site_name}}
                                            </option> 
                                            </span>
                                        </select>
                                        <input type="hidden" name="inventory_site[]"
                                            :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                    </td>
                                    @if(showLocation()=="true")
                                    <td>
                                        <input name="location[]" type="text" v-model="(item.item==null)?null:item.item.location" class="form-control" placeholder="@lang('layout.Location')">
                                    </td>
                                    @endif
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Description1')" oninput = "autowidths(event)" name="inventory_description[]" v-model="(item.item==null)?null:item.item.inventory_description" class="form-control chan_length">
                                    </td>
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Model')"
                                        oninput = "autowidths(event)" name="model[]" v-model="(item.item==null)?null:item.item.model" class="form-control chan_length">
                                    </td>
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Color')"
                                        oninput = "autowidths(event)" name="color[]" v-model="(item.item==null)?null:item.item.color" class="form-control chan_length">
                                    </td>
                                    <td v-show="showWhat('expire_date')=='yes'">
                                        <date_picker :name="'expire_date['+index+']'" v-model="(item.item==null)?null:item.item.expire_date" placeholder="@lang('layout.ExpireDate')" ></date_picker>
                                    </td>
                                    <td>
                                        <input type="number" :name="'quantity['+index+']'" v-validate="'required'"
                                            data-vv-as="@lang('layout.Quantity')"
                                            v-model.number="(item.item==null)?null:item.item.quantity"
                                            oninput = "autowidths(event)"
                                            class="form-control input-style input-number chan_length"
                                            placeholder="@lang('layout.Quantity')">
                                        <span class="required">@{{ errors.first('quantity['+index+']') }}</span>
                                    </td>

                                    <td>
                                    <!--    <input type="text" :value="(item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                        @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                    </td>
                                    <td v-show="showWhat('other_measure')=='yes'">
                                        <input type="number" name="other_measure_amount[]" v-model.number="(item.item==null)?null:item.item.other_measure_amount" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')">
                                    </td>
                                    <td v-show="showWhat('other_measure2')=='yes'">
                                        <input type="number" name="other_measure_amount2[]" v-model.number="(item.item==null)?null:item.item.other_measure_amount2" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                                    </td>
                                    @if(getShowCBM()=="true")
                                    <td>
                                        <input type="number" name="cbm[]" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.CBM')">
                                    </td>
                                    @endif
                                    <td class="highlight">
                                        <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                                @change="measureChange(index)">
                                            <option value="null">@lang('layout.Select')</option>
                                            <span v-if="(item.item ==null)?false:true">
                                                <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                        :value="measure">
                                                @{{measure.measure_name}}
                                                </option> 
                                            </span> 
                                        </select>

                                        <input type="hidden" name="measure[]"
                                            :value="(item.item==null)?null:item.item.measure.measure_id">
                                    </td>
                                    <td>
                                        @{{(item.item==null)?null: Number.parseFloat(item.item.new_rate).toFixed(precision())}}
                                    </td>
                                    <td>
                                        <vue-numeric v-if="item.item"
                                            class="form-control chan_length"
                                            oninput = "autowidths(event)"
                                            v-model="item.item.cost"
                                            :max="99999999999999"
                                            currency=""
                                            :precision="((p_total)?7:precision())"
                                            @input="setNewRate(index)"
                                            @change="showMarginMarkup(index)">
                                        </vue-numeric>
                                        <input type="hidden" name="inventory_price[]" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate,((p_total)?7:precision()), selected_currency.static_rate)" >
                                        <input type="hidden" name="sale_rate_new[]" :value="(item.item==null)?null:item.new_sale_price" class="form-control" >
                                    </td>

                                    @if(getM2()!="")	  
                                        <td>
                                            <div class="input-group">
                                                <select  name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1">
                                                    <option value="null">@lang('layout.Select')</option>
                                                    <span v-if="(item.item ==null)?false:true">
                                                        <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                        @{{measure.measure_name}}
                                                    </option> 
                                                    </span>
                                                </select>
                                                @if(getSaleAmountSecondMeasure()=="true")	
                                                <span class="input-group-addon">
                                                    @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                                </span>
                                                @endif
                                            </div>
                                        </td>
                                    @endif
                                    <td v-show="showWhat('sale_discount')=='yes'">
                                        <div class="input-group">
                                            <input type="number" name="inventory_discount[]"
                                                placeholder="@lang('layout.Discount')"
                                                v-model.number="(item.item==null)?null:item.item.discount"
                                                oninput = "autowidths(event)"
                                                class="form-control chan_length">
                                            <span class="input-group-addon" v-if="discountIsAmount">
                                            @{{selected_currency.symbol}}
                                        </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                            %
                                        </span>
                                        </div>
                                    </td>
                                    <td v-show="sale_price">
                                        <input type="number" name="sale_price[]"
                                        placeholder="@lang('layout.SalePrice')"  @input="setNewRate(index)"
                                        v-model.number="(item.item==null)?null:item.item.sale_price"
                                        oninput = "autowidths(event)" class="form-control chan_length">
                                    </td>

                                    <td>
                                        <input type="number" :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate,null, null, selected_currency.static_rate).result" ref="total" @input="setQuantityByTotal(index)"  class="form-control">
                                
                                        {{-- @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate).result }}
                                        <b>@{{selected_currency.symbol}}</b> --}}
                                    </td>

                                    <td>
                                        <span v-if="index > 0" v-on:click="deleteItem('inventory',index)"><i
                                                    class="paddint-both glyphicon glyphicon-trash"></i></span>
                                    </td>
                                </tr>
                                <tr style="background-color: #ffffff;">
                                    <td></td>
                                    <td>
                                        <center>
                                            <button type="button" @click="addNew('inventory',1000)" class="btn btn-success">
                                                <i class="fa fa-plus"></i></button>
                                        </center>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                        <hr>
                    </div>

                    @if(getInvoiceTotal() == 'true') 
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                        <span class="text-right" data-counter="counterup"
                                                data-value="7800">@{{ format_number( Number(subtotal))}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{
                                                Number.parseFloat(discount).toFixed(precision()) }}%)
                                            </small>
                                        </td>
                                        <td class="text-right">
                                        <span class="text-right" data-counter="counterup"
                                                data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right">
                                            <span data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds ))}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <!-- end total -->
                        </div>
                    @endif    

                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Memo')</label>
                                    <textarea name="memo" class="form-control" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>                  
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" @click="handleSubmit($event)"
                    :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                    <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" class="btn blue"
                    :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> 
                    <a href="{{route('purchase.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">
                </cmodal>
                <invmodal :show='showInvModal' @close="showInvModal=false">
                </invmodal>
                <modal v-if="showMeasureModal" @close="showMeasureModal = false">
                    <div slot="body">
                        <div class="row">
                            <div class="col-md-3">
                                <h4>@lang('layout.MetricType')</h4>
                                <span v-for="metric in metricList">
                                    <div class="mt-radio-list">
                                        <label class="mt-radio"> @{{ metric.name }} 
                                            <input name="metric" type="radio" v-bind:value="metric"
                                            v-model="selectedMetric" v-on:change="selectedMeasure = {}"> 
                                            <span></span>
                                        </label>
                                    </div>
                                </span>
                            </div>
                            <div class="col-md-3">
                                <h4>@lang('layout.Measure') </h4>
                                <span v-for="measure1 in selectedMetric.measure">
                                    <div class="mt-radio-list">
                                        <label class="mt-radio">
                                        <b v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </b>
                                        <b v-if="measure1.text !='Other'">@{{ measure1.text }} </b>
                                            <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                            <span></span>
                                        </label>
                                    </div>
                                </span>
                            </div>
                            <div class="col-md-6">
                                <span v-if="selectedMeasure.text == 'Other'">
                                    <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                    <div>
                                        <div class="form-group">
                                            <label class="control-label col-md-5">
                                            @lang('layout.MeasureName')</label>
                                            <div class="col-md-7">
                                                <input type="text" class="form-control"
                                                placeholder="@lang('layout.EnterMeasureName')"
                                                v-model.trim="selectedMeasure.name">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="control-label col-md-5">
                                                @lang('layout.MeasureAmount')
                                            </label>
                                            <div class="col-md-7">
                                                <input type="number" class="form-control"
                                                placeholder="@lang('layout.EnterMeasureuint')"
                                                v-model.number="selectedMeasure.unit">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>
                                        <div class="form-group ">
                                            <label class="control-label col-md-5">
                                                @lang('layout.MeasureSymbol')
                                            </label>
                                            <div class="col-md-7">
                                                <input type="text" class="form-control"
                                                placeholder="@lang('layout.EnterMeasureSymbol')"
                                                v-model.trim="selectedMeasure.symbol">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>
                                    </div>

                                </span>
                            </div>

                        </div>

                    </div>
                    <h3 slot="header">
                        <div class="col-md-4">
                            <h3>
                                @lang('layout.AddNewMeasure')
                            </h3>
                        </div>
                        <div class="col-md-4">
                            <div v-if="fieldErrors.length > 0">
                                <p class="text-danger" fieldErrors>
                                    <spna v-text="fieldErrors"></spna>
                                </p>
                            </div>
                        </div>
                    </h3>
                    <div slot="footer">
                        <button type=button class="modal-default-button" v-on:click="addMeasure">
                            @lang('layout.OK')
                        </button>
                        <button type=button class="modal-default-button"
                        v-on:click="showMeasureModal = false, showInvModal = true ,measure = null , type=null">
                        @lang('layout.Cancel')
                    </button>
                    </div>
                </modal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif 

		Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],

        }); 

        Vue.use(VueInputAutowidth);
        Vue.use(VueNumeric.default); 
        Vue.component('v-select', VueSelect.VueSelect); 
        document.onkeydown = function (e) { 
        // save invoice by shif && enter
        if (e.ctrlKey && e.which == 13) {
            v.callOnItemloadGeneral();
        }
    }
  
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                    classes: [],
                    selectedClass: null,
                  
                }
            },
            created() { 
                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    var datas = $("#modalForm").serializeArray();

                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_vendor = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        /// inventory model
        var invm = null;
        Vue.component("invmodal", {
            template: '#invmodal-template',

            props: ['show'],
            data() {
                return {
                    measureList: [],
                    categories: [],
                    income: [],
                    cost: [],
                    asset: [],
                    rate: 0,
                    description: null,
                    number: null,
                    category: null,
                    selectMeasure: null,
                    incomeAccount: null,
                    costAccount: null,
                    assetAccount: null,
                }
            },
            created() {

                axios.get('{{route("inventory.create")}}', {
                        params: {
                            add_item: 'on'
                        }
                    }).then(
                    response => {
                        this.measureList = response.data.measure;
                        this.categories = response.data.category;
                        this.number = response.data.number;
                        this.income = response.data.income;
                        this.cost = response.data.cost;
                        this.asset = response.data.asset;
                        if(this.measureList.length>0)
                        {
                            this.selectMeasure=this.measureList[0];
                        }
                        if(this.income.length>0)
                        {
                            this.incomeAccount=this.income[0];
                        }
                        if(this.cost.length>0)
                        {
                            this.costAccount=this.cost[0];
                        }
                        if(this.asset.length>0)
                        {
                            this.assetAccount=this.asset[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                showMeasureModal() {
                    invm = this;
                    v.showMeasureModal = true;
                    v.showInvModal = false;
                },

                onSubmit() {
                    var ivn = this;
                    v.showInvModal = false;
                    var datas = $("#modalFormInv").serializeArray();
                    // console.log(123,datas);
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("inventory.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'type': datas[1]['value'],
                            'number': datas[2]['value'],
                            'gauge': datas[3]['value'],
                            'rate': datas[4]['value'],
                            'description': datas[5]['value'],
                            'asset_account': this.assetAccount.id,
                            'um_id': this.selectMeasure.id,
                            'income_account': this.incomeAccount.id,
                            'cost_account': this.costAccount.id,
                            'cost': 1,
                            'category': (this.category) ? this.category.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        // console.log(123, response);
                        if (response) {
                            v.selected_inventory = null;
                            v.selected_inventory = response.item;
                        }
                        axios.get('{{route("inventory.create")}}', {
                            params: {
                                saveAndNew: 'on'
                            }
                        }).then(response => {
                            // console.log(1239, response);
                            ivn.number = response.data;
                            document.getElementById("modalFormInv").reset();
                        }).catch(error => console.log(error));

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });
        /// inventory model

        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var inventory_category = {!! $inventory_category !!};
        var memberClass = {!! $memberClass !!};

        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
        let inventoryBrand = {!! $inventoryBrand !!};

        var v = new Vue({
            el: '#app',
            data: {
                dynamic_time:'',
                number: "{{$number}}",
                old_number: "{{$number}}",
                number_msg: '',
                number_Error: false,
                showModal: false,
				showInfoModal: false,
				showInvModal: false,
				disabled: false,
				averageRate: false,
				editKey: false,
				sale_price: false,
                brand: null,
                location: null,
                SNumber: null,
                vendor: [],
                all_vendor: [], 
                selected_vendor: null,
                contract: [],
                selected_contract: null,
                brandItem: inventoryBrand,
                selected_iventory_brand: null,
                banks: banks,
                selected_banks: null,
                defuilt_banks: null,
                currency: currency,
                selected_currency: {!!json_encode(getHomeCurrency()) !!},
                rate: 0,
                temp_items: [],
                totalAmountes: [],
                inventory_category: inventory_category,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,
                newCost: [
                    null,
                    null,
                    null,
                    null
                ],
                inventories: [
                    {inventory: null, item: null, item_category: null}
                ],
                payments: [
                    {
                        items: banks,
                        item: null,
                    }
                ],
                showModalPurchaseOrder: false,
                purchase_orders: false,
                purchaseOrderList: [],
                selected_purchase_order: null,
                discountFiled: 0,
                discountFiledRow: 0,
                discountIsAmount: false,
                memberClass: memberClass,
                selected_class: null,
                ref_no: '',
                msg: '',
                isError1: false,
                 //begin Margin and markup vars
                item_name:null,
                markup_c:null,
                margin_c:null,
                margin_new:null,
                markup_new:null,
                current_cost:null,
                current_rate:null,
                sale_rate_new:null,
                change_sale_price:false,
                showMarginMarkupModal: false,

                p_total: false,
                item_not_found: false,
                counter_check: 0,
                counter_check1: 1,
                counter_check2: -1,
                selected_inventory: null,
                selected_inventory1: null,
                inventory_sites1: [],
                selected_iventory_site: null,
                selected_item: null,
                selected_quantity: null,
                selected_price: null,

                showMeasureModal: false,
                fieldErrors: [],
                selectedMetric: {},
                senddata: {},
                selectedMeasure: {},
                metricList:{!!json_encode(getMeasures())!!},
                check_with_key: false,

            },
            computed: {
                setRates(){ 
                    // console.log('GoodNews');
                    let rates = [];
                    this.currency.forEach((b)=>{
                        ratesFetched.forEach((a)=>{ 
                            if(a.currency_id == b.id){
                                rates.push({
                                    name: a.name,
                                    code:a.code,
                                    symbol: a.symbol,
                                    static_rate: a.static_rate,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null? Number.parseFloat(a.hq_rate) : 1,
                                    currency:b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a)=>{
                        let found = false;
                        rates.forEach((b)=>{
                            if(a.id == b.id){
                                found = true;
                                return;
                            }
                        });

                        if(!found){
                            rates.push({
                                name: a.name,
                                code:a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency:a.id,
                                id: a.id
                            })
                        }
                    });
                    return rates;

                },
                selectedRate() {
                    if(this.selected_currency){
                        var newrate = (this.selected_currency) ? this.selected_currency.rate : 0;
                        if (this.discountIsAmount && this.discountFiled && this.rate > 0 && newrate > 0) {
                            // @if(systemConfig()[30] == 1)
                            this.discountFiled = ((this.discountFiled / this.rate) * newrate);
                            // @else 
                            // this.discountFiled = ((this.discountFiled / this.rate) * newrate);
                            // @endif   
                        }
                        this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                        for (var i = 0; i < this.inventories.length; i++) {
                            if (this.inventories[i].item && this.inventories[i].item != null) {
                                if (this.inventories[i].item.new_rate) {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif     
                                }
                                if (this.inventories[i].item.sale_price_new) {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.sale_price = this.inventories[i].item.sale_price_new * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.sale_price = this.inventories[i].item.sale_price_new * this.selected_currency.rate;
                                    @endif
                                }
                            }
                        }
                    }
                },
                discount() {
					// console.log('new discount',this.discountIsAmount,this.discountFiled,this.subtotal);
                    
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }
                    

                },


                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var sum_discount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var discount = this.inventories[i]['item']['discount'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1) 
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif 
								if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else { 
									if (discount > 0) {
                                    @if(systemConfig()[30] == 1)
									 sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                    @else 
									 sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                    @endif 
                                    }
								}  	
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate); 
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate); 
                                @endif 
								if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else { 
									if (discount > 0) { 
                                        @if(systemConfig()[30] == 1)
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
									    @else 
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                        @endif 
                                    }
								}
                            } 
                        }
                        // this.totalAmountes=sum;

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
					
					
					
					this.discountFiledRow = sum_discount;
					
                    return sum;
                }, 

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    // for (var i = 0; i < this.payments.length; i++) {

                    //     if (this.payments[i].item != null && this.payments[i].item) {
                    //         if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                    //             //
                    //             console.log('Good');

                    //             sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
 
                    //         }
                    //     }
                    // }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                @if(getAddItemWithZeroRate() != 'true')
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }
                                @endif
                            }
                        }
                    }
                    if (this.inventories.length == 0 || this.selected_vendor == undefined || this.selected_vendor == null || !this.selected_banks || this.selected_banks == null || flag == false) {
                        isError = true;
                    }

                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        if (this.defuilt_banks) {
                            this.selected_banks = this.defuilt_banks;
                            this.defuilt_banks = null;
                        }else{
                            this.selected_banks = tempBank[0];
                        }
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                var selected_banks=_.find(this.banks,(v)=>v.id=={!! getDropdown('purchase', 'account') !!});
                if(selected_banks){
                    var selected_currency=_.find(this.setRates,(v)=>v.code==selected_banks.code);
                    // currency
                    this.selected_currency = selected_currency;
                    this.defuilt_banks = selected_banks;
                }
                this.dynamicTime()
                // console.log(123, selected_banks, selected_currency, this.inventory_sites);
            },
            methods:
                {
                    //BEGIN - Used for dynamic input time
                    dynamicTime()
                        {
                            this.time_interval = setInterval(() => {
                                const now = new Date()
                                @if(getHourType() == 24)
                                    const hours = now.getHours().toString().padStart(2,'0')
                                    const minutes = now.getMinutes().toString().padStart(2,'0') 
                                    // const seconds = now.getSeconds().toString().padStart(2,'0')
                                    this.dynamic_time = `${hours}:${minutes}`
                                @else
                                    const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                                    this.dynamic_time = `${timeString}`
                                @endif
                                
                            },1000);
                        },
                        stopDynamicTime()
                        {
                            clearInterval(v.time_interval)
                        },
                        changeTime()
                        {
                            v.dynamic_time = v.$refs.time_input.value
                        },
                    //END - Used for dynamic input time
                    set_avg_rate_bank(defaultAccount) {
                        let vv = this;
                        this.averageRate = false;
                        @if(getAverageRate() =="true")
                        if (defaultAccount) {
                            if (defaultAccount.avg_rate) {
                                setTimeout(() => {
                                    vv.averageRate = true;
                                    vv.selected_currency.rate = defaultAccount.avg_rate;
                                }, 300);
                            }
                        }
                        @endif
                    },
                    checkRefNo() {

                        //console.log(vm.ref_no)

                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'purchases'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },
                    checkNo() {
                        var chack = 'false';
                        var number = v.number;
                        if (number != null) {
                            axios.get("{{route('callMethod.search')}}", {

                                    params: {
                                        number: v.number,
                                        method_name: 'Search_number',
                                        table_name: 'purchases'
                                    },
                                })
                                .then(function(response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        // console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.number_msg = "@lang('layout.DuplicateData')";
                                        v.number_Error = true;
                                    } else {
                                        v.number_msg = 'no';
                                        v.number_Error = false;

                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });

                        }
                    },
                    secoundMeasurQuantity(item = null, quantity = null) {
						if (item != null) {
							var result = 0;
							if (item.site) {
								// console.log(3838399,item.measure_list, item.measure1);
								if(item.measure_list && item.measure1){
                                    for (var i in item.measure_list) {
								// console.log(3838,item.measure_list[i],item.measure_unit,item.measure.measure_unit);
									if (item.measure_list[i].measure_id == item.measure1) {
										result = (quantity * item.measure.measure_unit) / (item.measure_unit);
										result = (result * item.measure_unit) / (item.measure_list[i].measure_unit);
									}
								}
                                }
							}
							return result;
						}
					},

                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.disabled = true;
                                v.submitForm(e.target);
                            }
                        });
                    },
					
					showInfo(index) {
						if (v.inventories[index].item != null) {
						v.showInfoModal = true;
						v.brand =    v.inventories[index]['item']['brand'];
						v.location = v.inventories[index]['item']['location'];
						v.SNumber = v.inventories[index]['item']['number'];
						// console.log('ffff',v.inventories[index]);
						}
                    },
                    showMarginMarkup(index) {
						if (v.inventories[index].item != null) {
                            v.selected_index = index;
						v.showMarginMarkupModal = true;

						v.SNumber = v.inventories[index]['item']['number'];
						v.item_name = v.inventories[index]['item']['name'];

                        var rate=v.inventories[index]['item']['sale_price'];
                        var cost=v.inventories[index]['item']['new_rate'];
                        var cost_old=v.inventories[index]['item']['rate'];

                        
                        
                        // var resultm = 0;
                        // var result1 = (100*rate)/cost;
                        // var markup = result1-100;
                        // resultm = myRound((markup*cost)/rate);

                        
                        // var resultMarkup  = (100*rate)/cost;
                        // resultMarkup = myRound(resultMarkup-100);

                        var resultCurrentMargin = (100*rate)/cost_old;
                        var markupCurrent = resultCurrentMargin-100;
                        resultCurrentMargin = myRound((markupCurrent*cost_old)/rate);

                        var resultCurrentMarkup  = (100*rate)/cost_old;
                        resultCurrentMarkup = myRound(resultCurrentMarkup-100);

                        var resultNewSalePrice = 0;
                        var total =Number.parseFloat(resultCurrentMarkup)+100;
                        resultNewSalePrice = (cost*total)/100;


                        var res_cu_markup  = (100*rate)/cost;
                        res_cu_markup = myRound(res_cu_markup-100);


						v.markup_c = res_cu_markup;
						v.margin_c = resultCurrentMargin;
                        
						@if(systemConfig()[30] == 1)
                        v.current_cost = v.inventories[index]['item']['rate'] * v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
                        v.current_cost = v.inventories[index]['item']['rate'] * v.selected_currency.rate;
                        @endif

                        @if(systemConfig()[30] == 1)
                        v.current_rate = v.inventories[index]['item']['sale_price'] * v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
                        v.current_rate = v.inventories[index]['item']['sale_price'] * v.selected_currency.rate;
                        @endif

						@if(systemConfig()[30] == 1)
                        v.sale_rate_new = resultNewSalePrice * v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
                        v.sale_rate_new = resultNewSalePrice * v.selected_currency.rate;
                        @endif
 
                        @if(systemConfig()[30] == 1)
                        var new_s_rate = v.sale_rate_new / v.selected_currency.static_rate * v.selected_currency.rate;
                        @else 
                        var new_s_rate = v.sale_rate_new / v.selected_currency.rate;
                        @endif
                          
                        var resultMarkup  = (100*new_s_rate)/cost;

                        resultMarkup = myRound(resultMarkup-100);
						v.markup_new = resultMarkup;


                        var resultm = 0;
                        var result1 = (100*rate)/cost;
                        var markup = result1-100;
                        resultm = myRound((markup*cost)/rate);

                        v.margin_new = (resultMarkup*cost)/v.sale_rate_new;

               
                
						}
                    },
                    chacge_sale_price(index)
                    {
                        if (v.change_sale_price == false) {
                                v.change_sale_price = true;
                                v.inventories[index]['new_sale_price'] = v.sale_rate_new;
                                // console.log('ffffbbbbbbbb',index,v.inventories[index]['new_sale_price'],v.change_sale_price);
                                v.change_sale_price = false;  
                            }else{
                                v.change_sale_price = false;
                            } 
                    },

                    addMeasure: function () {
                        let senddata = _.clone(this.selectedMetric);
                        senddata.measure = _.clone(this.selectedMeasure);

                        var req = axios.post("{{route('measure.store')}}",senddata)
                        .then(function (response) {
                            if (response) {
                                if (response.data) {
                                    // var measure_id = response.data.me.id;
                                    invm.selectMeasure = response.data.me;
                                    // console.log(444, response, measure_id);
                                }
                            }
                            v.showMeasureModal = false;
                            v.fieldErrors = [];
                            v.selectedMetric = {};
                            v.selectedMeasure = {};

                            axios.get("{{route('inventory.create')}}").then(function (response) {
                                invm.measureList = response.data;
                                v.showInvModal = true;
                            });
                        })
                        .catch(function (error) {
                            axios.get("{{route('inventory.create')}}").then(function (response) {
                                invm.measureList = response.data;
                                v.showInvModal = true;
                            });

                            v.fieldErrors = error.response.data

                        });

                    },
                    
                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_vendor) {
                            // get member contract
                            // get member contract
                            this.contract = [];
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'member_contract',
                                    member_id: this.selected_vendor.id
                                }
                            })
                                .then(function (response) {
                                    if (response.data.length > 0) {
                                        v.contract = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                            this.purchaseOrderSearch(this.selected_vendor.id)
                        }
                    },

                    selectMemeber(id = null) {
                        if (id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    id: id,
                                    type: 'Vendor'
                                }
                            })
                            .then(function(response) {
                                if (response.data) {
                                    // console.log(response.data);
                                    v.selected_vendor = null;
                                    v.selected_vendor = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    memberClassChange() {
                        if (v.selected_class) {
                            v.vendor = [];
                            let class_id = v.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Vendor'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.vendor = [];
                                    v.vendor = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Vendor'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.vendor = [];
                                v.vendor = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    // begin purchase order search
                    purchaseOrderSearch(member_id = null) {
                        this.purchaseOrderList = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberPurchaseOrder',
                                member_id: member_id,
                            }
                        })
                            .then(function (response) {

                                if (response.data.length > 0) {
                                    v.showModalPurchaseOrder = true;
                                    v.purchaseOrderList = response.data;
									console.log('qweqwew', response.data);

                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    },
                    // end purchase order search
                    // get selected sale order
                    getPurchaseOrders() {
                        this.showModalPurchaseOrder = false;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'purchaseOrderItems',
                                purchase_order_id: this.selected_purchase_order.id,
                                type: ''
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    v.inventories = [];
                                    for (var r = 0; r < response.data.length; r++) {
                                        v.inventories.push({
                                            inventory: response.data[r],
                                            item: response.data[r],
                                            item_category: response.data[r].item_category,
                                            item_brand: null,
											driver_type: 'OwnDriver',
                                            vehicle: null, 
                                            location: null, 
                                            inventory_description: null, 
                                            model: null, 
                                            color: null, 
                                            expire_date: null, 
                                            other_measure_amount: null, 
                                            other_measure_amount2: null, 
											tanker: null, 
											driver: null,
											sub_price: null,
											currency_list:currency, 
											currency: homeCurrency
                                        });
                                    }
                                    v.inventories.push({inventory: null, item: null, item_category: null, item_brand: null,location: null, inventory_description: null, model: null, color: null, expire_date: null, other_measure_amount: null, other_measure_amount2: null, driver_type: 'OwnDriver', vehicle: null, tanker: null, driver: null, sub_price: null,currency_list:currency, currency: homeCurrency});
                                    v.purchase_orders = true;
                                    console.log('test check', v.selected_purchase_order);
                                    v.invoiceDescription = v.selected_purchase_order.description;

                                    // if (v.selected_purchase_order.discount_type == 'currency' && v.selected_purchase_order.discount) {
                                    //     v.discountFiled = (Number.parseFloat(v.selected_purchase_order.discount) / ((v.selected_purchase_order.rate)?Number.parseFloat(v.selected_purchase_order.rate):1));
                                    // }else{
                                    // }
                                    
                                        v.discountFiled = v.selected_purchase_order.discount;
                                    if (v.selected_purchase_order.discount_type) {
                                        if (v.selected_purchase_order.discount_type == 'currency') {
                                            v.discountIsAmount = true;
                                        } else {
                                            v.discountIsAmount = false;
                                        }
                                    }
                                    for (var a = 0; a < this.currency.length; a++) {
                                        if (v.currency[a].code == v.selected_purchase_order.currency) {
                                            v.selected_currency = v.currency[a];
                                            v.selected_currency.rate = v.selected_purchase_order.rate;
                                            v.rate = v.selected_purchase_order.rate;
                                        }
                                    }

                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    // set new price
                    setNewRate(index) {

                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
                            @endif
                        }

                        if (this.inventories[index].item) {
                            if (this.inventories[index].item.sale_price) {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.sale_price_new = this.inventories[index].item.sale_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.sale_price_new = this.inventories[index].item.sale_price / this.selected_currency.rate;
                                @endif
                            }
                        }

                        // if (this.inventories[index].item) {
                        //     this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        //     this.inventories[index].item.cost = this.$refs.in[index].value / this.selected_currency.rate;
                        // }
                    },

                    setQuantityByTotal(index) {
                        if (v.counter_check == 0) {
                            v.counter_check = 1;
                            setTimeout((function () {
                                v.counter_check1 = v.$refs.total[index].value;
                                v.setQuantityByT(index);
                            }), 2e2)
                        }  
                    },
                    setQuantityByT(index) {
                        setTimeout((function () {
                            v.counter_check2 = v.$refs.total[index].value;
                            v.setQuantityByTotals(index);
                        }), 2e3)
                    },
                    setQuantityByTotals(index) {
                        if (v.counter_check1 != v.counter_check2) {
                            v.counter_check1 = v.$refs.total[index].value;
                            v.setQuantityByT(index);
                        }else{
                            v.p_total = true;
                            if (v.$refs.total[index].value) {
                                if (v.inventories[index].item) {
                                    if (v.inventories[index]['item']['quantity']) {
                                        var quantity = v.inventories[index]['item']['quantity'];
                                        

                                        @if(systemConfig()[30] == 1)
                                        v.inventories[index].item.new_rate = (v.$refs.total[index].value / quantity) / v.selected_currency.static_rate * v.selected_currency.rate;
                                        @else 
                                        v.inventories[index].item.new_rate = (v.$refs.total[index].value / quantity) / v.selected_currency.rate;
                                        @endif


                                        v.inventories[index].item.cost = v.$refs.total[index].value / quantity;
                                    }
                                }
                            }
                            v.counter_check = 0;
                        }
                    },

                    // begin item search

                    onItemSearch: _.debounce((search, loading) => {

                        loading(true);

                        // console.log('klk',v.inventories[v.selected_index]['item_category']);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index]['item_category']);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let inventory_brand_id = (v.inventories[index]['item_brand'] != undefined) ? v.inventories[index]['item_brand'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchPurchase',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    inventory_brand_id: inventory_brand_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
										
                                        @if(getDefaultSite() > 0)
                                        var sites_id = {{ getDefaultSite() }}
                                        for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
                                            if (v.inventories[index].item.site_list[i].site_id == sites_id) {
                                                v.inventories[index].item.site = v.inventories[index].item.site_list[i];
                                            }
                                        }
                                        @else
                                            var sites_id = {{ getDropdown('purchase', 'site') }}
                                            for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
                                                if (v.inventories[index].item.site_list[i].site_id == sites_id) {
                                                    v.inventories[index].item.site = v.inventories[index].item.site_list[i];
                                                }
                                            }
                                        @endif
                                        
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    loadItemGeneral() {
                        if (v.selected_inventory != undefined) {
                            this.editKey = false;
                            var inventory_id = v.selected_inventory.id;
                        
                            // console.log(888, number);
                            let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                            let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        member_id: v.member_id,
                                        method_name: 'itemSearchPurchase',
                                        inventory_id: inventory_id,
                                        inventory_category_id: inventory_category_id,
                                    }
                                })
                                .then(function(response) {

                                    var rate = 0;
                                    var static_rate = 0;
                                    if (v.selected_currency.rate > 0) {
                                        rate = v.selected_currency.rate;
                                        static_rate = v.selected_currency.static_rate;
                                    }

                                    if (response.data.length > 0) {
                                        v.selected_item = null;
                                        v.selected_iventory_site = null;
                                        v.selected_item = response.data[0];
                                        @if(systemConfig()[30] == 1)
                                        v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(static_rate) / Number.parseFloat(rate));
                                        @else 
                                        v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(rate));
                                        @endif
                                        v.inventory_sites1 = response.data[0].site_list;  
                                        v.last_item_sale = response.data[0].last_item_sale;  
                                        // console.log(123, response.data[0]);

                                    }else{
                                        // $('#success-sound')[0].play();
                                        // $('#error-sound')[0].play();
                                        v.item_not_found = true;
                                        setTimeout((function () {
                                            v.item_not_found = false;
                                            v.$refs.barcode_search.$refs.search.focus();
                                        }), 2e3)
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })

                        }
                    },

                    callOnItemloadGeneral() {
                        v.editKey = false;
                        if (v.counter_check == 0) {
                            v.counter_check = 1;
                            @if(getBarcodeType()=="true")
                            setTimeout((function () {
                                v.counter_check1 = v.selected_inventory1;
                                v.call2();
                                // console.log(12);
                            }), 1e1)
                            @else
                            setTimeout((function () {
                                v.counter_check1 = v.selected_inventory1;
                                v.call2();
                                // console.log(12);
                            }), 2e2)
                            @endif
                        }
                    },
                    call2() {
                        @if(getBarcodeType()=="true")
                        setTimeout((function () {
                            v.counter_check2 = v.selected_inventory1;
                            v.onItemloadGeneral();
                            // console.log(13);
                        }), 1e1)
                        @else
                        setTimeout((function () {
                            v.counter_check2 = v.selected_inventory1;
                            v.onItemloadGeneral();
                            // console.log(13);
                        }), 2e2)
                        @endif
                    },
                    onItemloadGeneral(id = null) {
                        if (v.counter_check1 != v.counter_check2) {
                            v.counter_check1 = v.selected_inventory1;
                            v.call2();
                        }else{
                            if (v.selected_inventory != undefined || id || v.selected_inventory1) {
                                this.editKey = false;
                                var inventory_id = id;
                                if (v.selected_inventory != undefined) {
                                    inventory_id = v.selected_inventory.id;
                                }

                                let number = v.selected_inventory1;

                                // console.log(888, number);
                                let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                                let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                                axios.get("{{route('callMethod.search')}}", {
                                        params: {
                                            method_name: 'itemSearchPurchase',
                                            inventory_id: inventory_id,
                                            inventory_category_id: inventory_category_id,
                                            inventory_site_id: inventory_site_id,
                                            number: number,
                                        }
                                    })
                                    .then(function(response) {
                                        if (response.data.length > 0) {
                                            var che = null;
                                            var checkD = true;

                                            var rate = 0;
                                            var static_rate = 0;
                                            if (v.selected_currency.rate > 0) {
                                                rate = v.selected_currency.rate;
                                                static_rate = v.selected_currency.static_rate;
                                            }

                                            @if(NotDuplicateItem() =="true")
                                            if (v.inventories != null && response.data[0].id) {
                                                for (var i = 0; i < v.inventories.length; i++) {
                                                    if (v.inventories[i].item && v.inventories[i].item != null) {
                                                        if (v.inventories[i].item.id == response.data[0].id) {
                                                            v.inventories[i].item.quantity = ( Number.parseFloat(v.inventories[i].item.quantity) + 1);
                                                            checkD = false;
                                                        }
                                                    }
                                                }
                                            }
                                            @endif

                                            if (checkD) {
                                                for (var i = 0; i < v.inventories.length; i++) {
                                                    if (v.inventories[i].item && v.inventories[i].item != null) {
                                                        che = 'ok';
                                                    } else {
                                                        v.inventories.splice(i, 1);
                                                    }
                                                }
                                                if(!che){
                                                    v.inventories = [];
                                                }
                                                // console.log(response.data[0]);
                                                if (inventory_site_id) {
                                                    for (var i = 0; i < response.data[0].site_list.length; i++) {
                                                        if (response.data[0].site_list[i].site_id == inventory_site_id) {
                                                            response.data[0].site = response.data[0].site_list[i];
                                                        }
                                                    }
                                                }
                                                response.data[0].quantity = (v.selected_quantity > 0)?v.selected_quantity:1;

                                                if (v.selected_price > 0) {
                                                    response.data[0].cost = Number.parseFloat(v.selected_price);
                                                    @if(systemConfig()[30] == 1)
                                                    response.data[0].new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(static_rate) * Number.parseFloat(rate)):1;
                                                    @else 
                                                    response.data[0].new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(rate)):1;
                                                    @endif
                                                }
                                                
                                                v.inventories.unshift({
                                                    inventory: response.data[0],
                                                    item: response.data[0],
                                                    location: null,
                                                    item_category: response.data[0].item_category,
                                                    item_brand: response.data[0].inventory_brand
                                                });

                                                v.selected_inventory = null;
                                                v.selected_inventory1 = null;
                                                v.counter_check = 0;
                                                v.temp_items = [];
                                                
                                                // const inp = v.$refs.barcode_search.$refs.search;
                                                // console.log(v.$refs.barcode_search.$refs.search.value);
                                                // v.$refs.barcode_search.$refs.search.focus();
                                                // v.$refs.barcode_search.$refs.search = null;
                                                v.$refs.barcode_search1.focus();

                                            }else{
                                                setTimeout((function () {
                                                    v.selected_inventory = null;
                                                    v.selected_inventory1 = null;
                                                    v.counter_check = 0;
                                                    v.$refs.barcode_search1.focus();
                                                }), 2e2)
                                            }
                                            
                                        }else{
                                            // $('#success-sound')[0].play();
                                            // $('#error-sound')[0].play();
                                            v.item_not_found = true;
                                            setTimeout((function () {
                                                v.item_not_found = false;
                                                v.selected_inventory = null;
                                                v.selected_inventory1 = null;
                                                v.counter_check = 0;
                                                v.$refs.barcode_search1.focus();
                                                // console.log(12);
                                            }), 2e3)
                                        }
                                    })
                                    .catch(function(error) {
                                        console.log(error);
                                    })

                            }
                        }
                    },

                    changeMesurss() {
                        setTimeout(() => {
                            if (v.selected_item) {
                                if (v.selected_item.measure && v.selected_item.measure_unit && v.selected_currency) {
                                    var rate = v.selected_currency.rate;
                                    var static_rate = v.selected_currency.static_rate; 
                                    @if(systemConfig()[30] == 1)
                                    v.selected_price = (((Number.parseFloat(v.selected_item.rate) / Number.parseFloat(v.selected_item.measure_unit)) * Number.parseFloat(v.selected_item.measure.measure_unit)) * Number.parseFloat(static_rate) / Number.parseFloat(rate)).toFixed(precision());
                                    @else 
                                    v.selected_price = (((Number.parseFloat(v.selected_item.rate) / Number.parseFloat(v.selected_item.measure_unit)) * Number.parseFloat(v.selected_item.measure.measure_unit)) * Number.parseFloat(rate)).toFixed(precision());
                                    @endif 
                                }
                            } 
                        }, 300);
                    },

                    addData() {
                        if (v.selected_item) {
                            var che = null;
                            for (var i = 0; i < v.inventories.length; i++) {
                                if (v.inventories[i].item && v.inventories[i].item != null) {
                                    che = 'ok';
                                } else {
                                    v.inventories.splice(i, 1);
                                }
                            }
                            if(!che){
                                v.inventories = [];
                            }

                            let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';
                            if (inventory_site_id) {
                                for (var i = 0; i < v.selected_item.site_list.length; i++) {
                                    if (v.selected_item.site_list[i].site_id == inventory_site_id) {
                                        v.selected_item.site = v.selected_item.site_list[i];
                                    }
                                }
                            }

                            var rate = 0;
                            var static_rate = 0;
                            if (v.selected_currency.rate > 0) {
                                rate = v.selected_currency.rate;
                                static_rate = v.selected_currency.static_rate;
                            } 

                            v.selected_item.quantity = (v.selected_quantity > 0)?v.selected_quantity:1;
                            @if(systemConfig()[30] == 1)
                            v.selected_item.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(static_rate) * Number.parseFloat(rate)):1;
                            @else 
                            v.selected_item.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(rate)):1;
                            @endif    
 
                            v.inventories.unshift({
                                inventory: v.selected_item,
                                item: v.selected_item,
                                item_category: v.selected_item.item_category,
                                item_brand: v.selected_item.inventory_brand
                            });

                            v.selected_inventory = null;
                            v.selected_inventory1 = null;
                            v.counter_check = 0;
                            v.temp_items = [];
                            // v.selectSaleNumber(0);
                            @if(getShwoPriceLevel()=="general_percent")
                            setTimeout((function () {
                                v.change_sale_rate_by_price_level_general();
                            }), 400);
                            @endif

                            // const inp = v.$refs.barcode_search.$refs.search;
                            // console.log(v.$refs.barcode_search.$refs.search.value);
                            v.$refs.barcode_search.$refs.search.focus();
                            // v.$refs.barcode_search.$refs.search = null;
                            // v.$refs.barcode_search.focus();

                            v.selected_item = null;
                            v.selected_price = 0;
                            v.selected_quantity = 0;
                            
                        }
                    },
                    
                    resetData() {
                        v.selected_inventory = null;
                        v.selected_item = null;
                        v.selected_iventory_site = null;
                        v.selected_price = 0;
                        v.selected_quantity = 0;
                        v.$refs.barcode_search.$refs.search.focus();
                    },

                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {

                            let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                            let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id,
                                    inventory_brand_id: inventory_brand_id
                                }
                            })
                                .then(function (response) {
                                    if (v.purchase_orders) {
                                    } else {
                                        v.inventories[v.selected_index]['item'] = null;
                                        v.inventories[v.selected_index]['inventory'] = null;
                                    }
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },

                    itemBrandChange(index) {
                        v.setIndex(index);

                        v.selected_iventory_brand = this.inventories[index]['item_brand'];
                        if (this.inventories[index]['item_brand'] != null) {
                        // if (!v.selected_contract) {
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let inventory_brand_id = this.inventories[index]['item_brand'].id;
                            
                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemesSearchSale',
                                        inventory_category_id: inventory_category_id,
                                        inventory_brand_id: inventory_brand_id
                                    }
                                })
                                .then(function(response) {
                                    if (v.purchase_orders) {
                                    } else {
                                        v.inventories[index]['item'] = null;
                                        v.inventories[index]['inventory'] = null;
                                    }
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });
                        // }else{
                        //     loading(false);
                        //     v.temp_items = [];
                        //     v.temp_items = v.contract_items 
						// }
                        }

                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (v.inventories[index] != undefined) {
                            v.selected_iventory_category = this.inventories[index]['item_category'];
                            v.selected_iventory_brand = this.inventories[index]['item_brand'];
                        }
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({
                                        inventory: null,
                                        item: null,
                                        location: null,
                                        inventory_description: null,
                                        model: null,
                                        color: null,
                                        expire_date: null,
                                        other_measure_amount: null,
                                        other_measure_amount2: null,
                                        item_brand: this.selected_iventory_brand,
                                        item_category: this.selected_iventory_category
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        this.editKey = false;
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        v.disabled = true;
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("purchase-form").submit()

                            }
                            else {
                                v.disabled = false;
                            }
                        });

                    },

                    defaultValue() {
                        this.selected_vendor = null;
                        this.selected_contract = null;

                        this.inventories = [
                            {inventory: null, item: null, item_category: this.selected_iventory_category},
                        ];

                        this.payments = [
                            {
                                items: banks,
                                item: null,
                            }
                        ];

                        this.selected_purchase_order = null;
                        this.discountFiled = 0;
                        this.temp_items = [];
                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {
                                    v.disabled = true;
                                    var url = "{{route('purchase.store')}}";
                                    form_id = 'purchase-form';
                                    var data = $('#' + form_id).serialize();
                                    toggleBlock(true);
                                    axios.post(url, data)
                                        .then(function (response) {
                                            toggleBlock(0);
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                //$('#success-sound')[0].play();
                                                toastr.success('', response.data.message);
                                                v.number = Number(v.old_number) + 1;
                                                v.old_number = Number(v.old_number) + 1;
                                                v.ref_no = null;

                                                // v.defaultValue();
                                                location.reload();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                v.disabled = false;
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            toggleBlock(0);
                                            v.disabled = false;
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                },

        });

    </script>


@endpush