@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.PurchaseInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th class="">
                            <i class="fa fa-user"></i> @lang('layout.Vendor')   
                        </th>
                       
                       
                        <th>
                            <i class="fa fa-text-width"></i> @lang('layout.Type') 
                        </th>
                       
                        <th>
                            <i class="fa fa-money"></i> @lang('layout.Currency') 
                        </th> 
                        <th>
                            <i class=""></i> @lang('layout.Code') 
                        </th> 
                        <th>
                            <i class="fa fa"></i> @lang('layout.Description') 
                        </th> 
                         
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class=""> {{ $purchaseOrder->vendor}}  </td>
                        <td class=""> {{ $purchaseOrder->orderNumber}}  </td>
                        <td class=""> {{ $purchaseOrder->type}}  </td>
                        <td class=""> {{ $purchaseOrder->currency }}  </td>
                        <td class=""> {{ $purchaseOrder->description }}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
      <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.PurchaseDetails') </span>
                    </div>
                    <div class="tools"></div>
                    <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Purchase_Order_Details"/>
                           <input type="hidden" name="id" value="{{$purchaseOrder->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Purchase_Order_Details"/>
                           <input type="hidden" name="id" value="{{$purchaseOrder->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="purchases">
                        <thead>
                        <tr>
                            <th>@lang('layout.ItemCode') </th>
                            <th>@lang('layout.ItemName') </th>
                            <th>@lang('layout.Quantity') </th>
                            <th>@lang('layout.Price') </th>
                            <th>@lang('layout.Code') </th>
                            <th>@lang('layout.Measure') </th>
                            <th>@lang('layout.Total') </th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>

@endsection
@push('scripts')

<script>

    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#purchases').DataTable({
            ajax:'{{route("purchaseOrderRoll.show",$purchaseOrder->id)}}',
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [  
                { data: 'item_number', name: 'items.number' },
                { data: 'item_name', name: 'items.name' },
                { data: 'quantity', name: 'quantity',orderable:false,searchable:false},
                { data: 'cost', name: 'cost',orderable:false,searchable:false},
                { data: 'code', name: 'code',orderable:false,searchable:false},
                { data: 'measure', name: 'measure',orderable:false,searchable:false },
                { data: 'total', name: 'total', orderable:false,searchable:false},
        ]
        });
    });


</script>


@endpush
