@extends('layouts.app')

@section('content')
    @include('purchases.modal')

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="purchaseorderlist"/> 
        <input type="hidden" name="type_name" value="Vendor"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Category') </label>
                            <v-select class="vue-select2" v-model="selectedCategory" label="name"
                                      :options="inventoryCategory">
                            </v-select>
                            <input type="hidden" name="category_id"
                                   v-model.number="(!selectedCategory)?null:selectedCategory.id">
                        </div>

                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>


                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-12" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off" v-model="from_date">
                                   
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off" v-model="to_date">
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h3> <label class="control-label"> @lang('layout.Details') <input name="details" type="checkbox" value="true"> </label> </h3>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="purchaseorderlist"/>
         <input type="hidden" name="type_name" value="Vendor"/>

        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                    <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Category') </label>
                            <v-select class="vue-select2" v-model="selectedCategory" label="name"
                                      :options="inventoryCategory">
                            </v-select>
                            <input type="hidden" name="category_id"
                                   v-model.number="(!selectedCategory)?null:selectedCategory.id">
                        </div>

                        <div  class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>

                    </div>
                </div>

                <div class="row">
                <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label ">@lang('layout.Date')</label>
                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                    <option value="Today">@lang('type.Today')</option>
                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                </select>
                            </div>
                            <div class="col-md-12" v-show="period == 'CustomDates'">
								<label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example2" autocomplete="off" name="from_date" v-model="from_date">
                                
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example2" autocomplete="off" name="to_date" v-model="to_date">
                                
                            </div>
                    </div>
                </div>
            </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h3> <label class="control-label"> @lang('layout.Details') <input name="details" type="checkbox" value="true"> </label> </h3>
                             </div>
                        </div>
                    </div>
                </div>

            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ContractList') </span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
					<a href="{{route('purchaseOrderRoll.graphicalshow')}}"><button class="btn btn-success">@lang('layout.GraphicalPresintation')</button></a>
                    @permission('purchaseOrder-export')
                    <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    <button type="button" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>

                    @endpermission
                    @permission('purchaseOrder-create')
                        <a href="{{route('purchaseOrderRoll.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew') 
                            </button></a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="purchaseOrder">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number') </th>
                        <th>@lang('layout.Code') </th>
                        <th>@lang('layout.Vendor') </th>
                        <th>@lang('layout.Type') </th>
                        <th>@lang('layout.Date') </th>
                        <th>@lang('layout.Amount') </th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('groupCompanyFilter.select')
@push('scripts')

<script>
     @if(Session('sale_id') && getFactorPrint()== "automatic")
    //factorPrint("{{Session('sale_id')}}")
    @endif

    function orderPrint(id) {
        var a=document.createElement('a');
        a.href="{{url('purchaseOrderFactorPrintRoll')}}/"+id;
        a.target="_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

    $(document).ready(function() {

        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#purchaseOrder').DataTable( {
            ajax:           '{{route("purchaseOrderRoll.index")}}',
            scrollCollapse: true,
            serverSide: true,
            order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            paging: true,
            columns: [
                { data: 'number', name: 'purchase_orders.number' },
                { data: 'orderNumber', name: 'orderNumber' },
                { data: 'vendor', name: 'members.name' },
                { data: 'type', name: 'purchase_orders.type', orderable:false,searchable:false },
                { data: 'date', name: 'purchase_orders.date', searchable:false },
                { data: 'amount', name: 'amount',orderable:false,searchable:false },
                { data: 'currency', name: 'purchase_orders.currency',width: "10%" @if(getGeneralSearch()) , searchable: false @endif},
                { data: 'user', name: 'users.name' @if(getGeneralSearch()) , searchable: false @endif },
                { data: 'actions', name: 'actions',width: "25%",class:'acctions', orderable:false,searchable:false},


            ],

        } );
    } );

    Vue.component('v-select', VueSelect.VueSelect);

    var inventoryCategory = {!! json_encode($inventoryCategory) !!}
    var Modal=Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });
    // start app
    var app = new Vue({
        el: '#app',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            showModal: false,
            selectedMember:null,
            member: [],
            inventoryCategory:inventoryCategory,
            selectedCategory:null
        },
        methods:{
            ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){
                //Your other code that launches the modal
                this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                    $(".date").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Vendor'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        app.member = [];
                        app.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                app.getDate(app.period);
                    // console.log(12);
                }), 2e2);
            },
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    app.from_date = null;
                    app.to_date = null;
                    if (response.data) {
                        app.from_date = response.data.start;
                        app.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    app.period = 'CustomDates';
                    app.from_date = null;
                    app.to_date = null;
                    })
                } else {
                    app.from_date = null;
                    app.to_date = null;
                }
                }
            },
        },
    });
    $('#print_pdf_all').on('click',function(e){
        $('#show-modal').click();
        e.preventDefault();
    });


    var app2 = new Vue({
        el: '#app2',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            showModal: false,
            selectedMember:null,
            member: [],
            inventoryCategory:inventoryCategory,
            selectedCategory:null
        },
        methods:{
            ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample2 : function(){
                //Your other code that launches the modal
                this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                     $(".date").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Vendor'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        app2.member = [];
                        app2.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                app2.getDate(app2.period);
                    // console.log(12);
                }), 2e2);
            },
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    app2.from_date = null;
                    app2.to_date = null;
                    if (response.data) {
                        app2.from_date = response.data.start;
                        app2.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    app2.period = 'CustomDates';
                    app2.from_date = null;
                    app2.to_date = null;
                    })
                } else {
                    app2.from_date = null;
                    app2.to_date = null;
                }
                }
            },
        },
    });
    $('#excell_all').on('click',function(e){
        $('#show-modal2').click();
        e.preventDefault();
    })

     new Vue({
         el: '#company_all',
         methods: {
             setCompany: function (event) {
                 window.location.reload();
             }
         }
     });

</script>


@endpush
















