@extends('layouts.report')
<?php 
$reportTitle = __('layout.ContractList');
?>
@section('content')
    <!-- END PAGE HEADER-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <h3 style="text-alin:center;">@lang('layout.ContractList')</h3>
            <div class="row">
                    <?php foreach ($data as $so): ?> 
                <div style=" margin-bottom: 10px; padding-left: 10px; float:left;">
                    <div class="portlet green-meadow box" style=" border: 1px solid #2ae0bb;">
                        <div class="portlet-title" style=" background-color: #1BBC9B">
                            <div class="caption">
                                <i class="icon-user"></i> {{$so['name']}}
                            </div>
                      
                        </div>

                        <div class="portlet-body">
                            <div class="row static-info">
                                <div class="col-md-12 value">@lang('layout.Number') : <?php echo $so['number']; ?>  &nbsp; -- &nbsp; @lang('layout.Code') : <?php echo $so['orderNumber']; ?>
                                    <br> @lang('layout.Date') : <?php echo convertDate($so['date']); ?>
                                    <br> @lang('layout.Description') : <?php echo $so['description'];
                                    ?>
                                    <br> @lang('layout.Currency') : <?php echo $so['currency']; ?> &nbsp; -- &nbsp; @lang('layout.Rate') : <?php echo $so['rate']; ?>
                                    <br> @lang('layout.Code') @lang('layout.Prepaid') : <?php echo $so['prepaid_code']; ?>

                                    <div >
                                        <table class="main-table" >
                                            <thead>
                                                <tr class="bg">
                                                   <th>@lang('layout.ItemName')</th>
                                                   <th>@lang('layout.Inventory')</th>
                                                   <th>@lang('layout.Category')</th>
                                                   <th>@lang('layout.Quantity')</th>
                                                   <th>@lang('layout.Delivered')</th>
                                                   <th>@lang('layout.Remain')</th>
                                                   <th>@lang('layout.Measure')</th>
                                                   <th style="text-align: center;">@lang('layout.Price')</th>
                                                   <th style="text-align: center;">@lang('layout.Cost') {{getHomeCurrency()[getCurrencyType()]}}</th>
                                                   <th style="text-align: center;">@lang('layout.TotalPrice')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($so['items']))
                                                <?php $totalSome = 0; ?>

                                                @foreach ($so['items'] as $item)
                                                <?php 
                                                $totalSome += ($item['quantity'] - $item['qut_out'])*$item['cost'];
                                                 if ($item['sale_order_unit'] > 0) { ?>
                                                <tr>
                                                    <td>{{$item['item']}}</td>
                                                    <td>{{$item['site_name']}}</td>
                                                    <td>{{$item['cat_name']}}</td>
                                                    <td>{{myRound($item['quantity'])}}</td>
                                                    <td>{{($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']}}</td>
                                                    <td>{{myRound($item['quantity'] - (($item['qut_out']*$item['item_unit'])/$item['sale_order_unit']))}}</td>
                                                    <td>{{$item['sale_order_measur']}}</td>
                                                    <td style="text-align: center;">{{$item['cost']}}</td> 
                                                    @if(systemConfig()[30] == 1)
                                                    <td style="text-align: center;">{{myRound($item['cost'] / $item['static_rate'] * $item['rate'])}}</td> 
                                                    @else 
                                                    <td style="text-align: center;">{{myRound($item['cost'] / $item['rate'])}}</td> 
                                                    @endif
                                                    <td style="text-align: center;">{{myRound(($item['quantity'] - $item['qut_out'])*$item['cost'])}}</td> 

                                                 </tr>
                                                <?php } ?>
                                               @endforeach
                                               <tr>
                                                    <td class="text-center" colspan="9" style="text-align: center;">@lang('layout.TotalPcs')</td>
                                                    <td class="text-center" style="text-align: center;">{{myRound($totalSome)}}</td>
                                                </tr>
                                               @endif
                                            </tbody>
                                        </table>

                                    </div>
                                
                                     
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                    <?php endforeach ?>
        


            </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>




    <!-- END CONTENT BODY -->


@stop

