@extends('layouts.factor-master')

@section('content')

  <h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseOrder')</h3>
<table style="width: 100%; margin-top: 25px;">
  <tr>
   <td style="text-align: left; width:30%">
    <table class="main-table">
     <tr>
      <td align="center" colspan="2">
        @lang('layout.VBillTo')
      </td>

    </tr>
    <tr>
      <td align="right">@lang('layout.Name')</td><td align="right">{{$member->name}}</td>   
    </tr>
     <tr>
      <td align="right">@lang('layout.Code')</td><td align="right">{{$member->code}}</td>   
    </tr>
  </table>
</td>

   <td style="text-align: left; width:20%">
    <table class="main-table">
     <tr>
      <td align="center" colspan="2">
        @lang('layout.PurchaseOrder')
      </td>

    </tr>
    <tr>
      <td align="right">@lang('layout.ContractCode')</td><td align="right">{{$purchaseOrder->orderNumber}}</td>   
    </tr>
     <tr>
      <td align="right">@lang('layout.Date')</td><td align="right">{{$date}}</td>   
    </tr>
  </table>
</td>


<td style="text-align: right; width:30%">
  <table class="main-table">
    <tr>
      <td align="center" colspan="2">@lang('layout.VShipTo')</td>
    </tr>
    <tr>
      <td width="25%" align="right">@lang('layout.Address')</td><td align="right">{{$address.' '.$city}}</td>
    </tr>
      <tr>
      <td align="right">@lang('layout.Phone')</td><td align="right">{{$phone}}</td>
    </tr>
  </table>
</td>
</tr>
</table>



<table class="main-table" style="margin-top: 20px;" cellpadding="5px">
	<tbody>
  <tr style="font-weight: bold; font-size: 17px">
   <td class="mt"><div class="center">@lang('layout.Number')</div></td>
   <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
   <td class="mt"><div class="center">@lang('layout.Item')</div></td>
   <td class="mt"><div class="center">@lang('layout.Site')</div></td>
   <td class="mt"><div class="center">@lang('layout.Quantity')</div></td>
   <td class="mt"><div class="center">@lang('layout.Unit/M')</div></td>
   <td class="mt"><div class="center">@lang('layout.Rate')</div></td>
   <td class="mt"><div class="center">@lang('layout.Total')</div></td>

 </tr>
 <?php
 $count=0;
 $empty=0;
 $fullCount=count($data);
 if($fullCount<15)
 {
    $empty=15-$fullCount;
 }
 ?>
 @foreach($data AS $record)
 <?php
 ?>
<tr>

<td class="center">{{++$count}}</td>
<!--<td class="center">{{$record['number']}}</td>-->
<td class="center">{{$record['name']}}</td>
<td class="center">{{$record['siteName']}}</td>
<td class="center">{{$record['qty']}}</td>
<td class="center">{{$record['symbol']}}</td>
<td class="center">{{simpleRound($record['price'])}}</td>
<td class="center">{{ simpleRound($record['price']*$record['qty'])}} {{ $purchaseOrder->currency }}</td>
</tr>
@endforeach
 @for($i=0;$i<$empty;$i++)
 <?php
 ?>
<tr>

<td class="center">{{++$count}}</td>
<td class="center"></td>
<td class="center"></td>
<td class="center"></td>
<td class="center"></td>
<td class="center"></td>
<td class="center"></td>
</tr>
@endfor

<tr>
  <td colspan="2"><div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')</b></div></td>
  <td colspan="2"><div class="center" style="font-size: bold;"><b>{{notowo(round(abs($total)),'fa')}} </b></div></td>
  <td colspan="2"><div class="center" style="font-size: bold;"><b>@lang('layout.Total') </b></div></td>
  <td colspan="1"><div class="center" style="font-size: bold;"><b>{{simpleRound($total)}}  {{ $purchaseOrder->currency }}</b></div></td>

</tr>
<tr>
  <td style="border:none !important;" colspan="3"><div class="center">{{$purchaseOrder->description}}</div></td>
  <td><div class="center">@lang('layout.Discount')</div></td>
  <td><div class="center">
    <span>
      @if($purchaseOrder->discount_type=="currency")
        {{simpleRound($discountToShow)}} {{ $purchaseOrder->currency }}
       @else
      {{number_format($discountToShow, 2)}}
      <span>%</span>
      @endif
    </span>
    
  </div></td>
   <td><div class="center">@lang('layout.Recipt')</div></td>
  <td><div class="center">{{simpleRound($paid)}} {{ $purchaseOrder->currency }}</div></td>
</tr>

<tr>
  <td style="border:none !important;" colspan="3"><div class="center"></div></td>
  <td><div class="center">@lang('layout.AmountPayable')</div></td>
  <td colspan="3"><div class="center">{{simpleRound($payable)}} {{ $purchaseOrder->currency }}</div></td>
  
</tr>


</tbody>
</table>


<script type="text/javascript">
  window.print();
</script>
@endsection


